// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sesv2_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sesv2"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// Cancel export job
// Cancels the export job with ID ef28cf62-9d8e-4b60-9283-b09816c99a99
func ExampleSESV2_CancelExportJob_shared00() {
	svc := sesv2.New(session.New())
	input := &sesv2.CancelExportJobInput{
		JobId: aws.String("ef28cf62-9d8e-4b60-9283-b09816c99a99"),
	}

	result, err := svc.CancelExportJob(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case sesv2.ErrCodeNotFoundException:
				fmt.Println(sesv2.ErrCodeNotFoundException, aerr.Error())
			case sesv2.ErrCodeBadRequestException:
				fmt.Println(sesv2.ErrCodeBadRequestException, aerr.Error())
			case sesv2.ErrCodeTooManyRequestsException:
				fmt.Println(sesv2.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create Metrics export job
// Creates a new export job for Metrics data
func ExampleSESV2_CreateExportJob_shared00() {
	svc := sesv2.New(session.New())
	input := &sesv2.CreateExportJobInput{
		ExportDataSource: &sesv2.ExportDataSource{
			MetricsDataSource: &sesv2.MetricsDataSource{
				Dimensions: map[string][]*string{
					"ISP": {
						aws.String("*"),
					},
				},
				EndDate: parseTime("2006-01-02T15:04:05.999999999Z", "2023-07-02T00:00:00"),
				Metrics: []*sesv2.ExportMetric{
					{
						Aggregation: aws.String("VOLUME"),
						Name:        aws.String("SEND"),
					},
					{
						Aggregation: aws.String("VOLUME"),
						Name:        aws.String("COMPLAINT"),
					},
					{
						Aggregation: aws.String("RATE"),
						Name:        aws.String("COMPLAINT"),
					},
				},
				Namespace: aws.String("VDM"),
				StartDate: parseTime("2006-01-02T15:04:05.999999999Z", "2023-07-01T00:00:00"),
			},
		},
		ExportDestination: &sesv2.ExportDestination{
			DataFormat: aws.String("CSV"),
		},
	}

	result, err := svc.CreateExportJob(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case sesv2.ErrCodeBadRequestException:
				fmt.Println(sesv2.ErrCodeBadRequestException, aerr.Error())
			case sesv2.ErrCodeTooManyRequestsException:
				fmt.Println(sesv2.ErrCodeTooManyRequestsException, aerr.Error())
			case sesv2.ErrCodeNotFoundException:
				fmt.Println(sesv2.ErrCodeNotFoundException, aerr.Error())
			case sesv2.ErrCodeLimitExceededException:
				fmt.Println(sesv2.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create Message Insights export job
// Creates a new export job for Message Insights data
func ExampleSESV2_CreateExportJob_shared01() {
	svc := sesv2.New(session.New())
	input := &sesv2.CreateExportJobInput{
		ExportDataSource: &sesv2.ExportDataSource{
			MessageInsightsDataSource: &sesv2.MessageInsightsDataSource{
				EndDate: parseTime("2006-01-02T15:04:05.999999999Z", "2023-07-02T00:00:00"),
				Exclude: &sesv2.MessageInsightsFilters{
					FromEmailAddress: []*string{
						aws.String("hello@example.com"),
					},
				},
				Include: &sesv2.MessageInsightsFilters{
					Subject: []*string{
						aws.String("Hello"),
					},
				},
				StartDate: parseTime("2006-01-02T15:04:05.999999999Z", "2023-07-01T00:00:00"),
			},
		},
		ExportDestination: &sesv2.ExportDestination{
			DataFormat: aws.String("CSV"),
		},
	}

	result, err := svc.CreateExportJob(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case sesv2.ErrCodeBadRequestException:
				fmt.Println(sesv2.ErrCodeBadRequestException, aerr.Error())
			case sesv2.ErrCodeTooManyRequestsException:
				fmt.Println(sesv2.ErrCodeTooManyRequestsException, aerr.Error())
			case sesv2.ErrCodeNotFoundException:
				fmt.Println(sesv2.ErrCodeNotFoundException, aerr.Error())
			case sesv2.ErrCodeLimitExceededException:
				fmt.Println(sesv2.ErrCodeLimitExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Get export job
// Gets the export job with ID ef28cf62-9d8e-4b60-9283-b09816c99a99
func ExampleSESV2_GetExportJob_shared00() {
	svc := sesv2.New(session.New())
	input := &sesv2.GetExportJobInput{
		JobId: aws.String("ef28cf62-9d8e-4b60-9283-b09816c99a99"),
	}

	result, err := svc.GetExportJob(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case sesv2.ErrCodeBadRequestException:
				fmt.Println(sesv2.ErrCodeBadRequestException, aerr.Error())
			case sesv2.ErrCodeNotFoundException:
				fmt.Println(sesv2.ErrCodeNotFoundException, aerr.Error())
			case sesv2.ErrCodeTooManyRequestsException:
				fmt.Println(sesv2.ErrCodeTooManyRequestsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Get Message Insights
// Provides information about a specific message.
func ExampleSESV2_GetMessageInsights_shared00() {
	svc := sesv2.New(session.New())
	input := &sesv2.GetMessageInsightsInput{
		MessageId: aws.String("000000000000ab00-0a000aa0-1234-0a0a-1234-0a0aaa0aa00a-000000"),
	}

	result, err := svc.GetMessageInsights(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case sesv2.ErrCodeNotFoundException:
				fmt.Println(sesv2.ErrCodeNotFoundException, aerr.Error())
			case sesv2.ErrCodeTooManyRequestsException:
				fmt.Println(sesv2.ErrCodeTooManyRequestsException, aerr.Error())
			case sesv2.ErrCodeBadRequestException:
				fmt.Println(sesv2.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// List export jobs
// Lists export jobs of type METRICS_DATA and status PROCESSING
func ExampleSESV2_ListExportJobs_shared00() {
	svc := sesv2.New(session.New())
	input := &sesv2.ListExportJobsInput{
		ExportSourceType: aws.String("METRICS_DATA"),
		JobStatus:        aws.String("PROCESSING"),
		PageSize:         aws.Int64(25),
	}

	result, err := svc.ListExportJobs(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case sesv2.ErrCodeTooManyRequestsException:
				fmt.Println(sesv2.ErrCodeTooManyRequestsException, aerr.Error())
			case sesv2.ErrCodeBadRequestException:
				fmt.Println(sesv2.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Used to convert a dedicated IP pool to a different scaling mode.
// This example converts a dedicated IP pool from STANDARD to MANAGED.
func ExampleSESV2_PutDedicatedIpPoolScalingAttributes_shared00() {
	svc := sesv2.New(session.New())
	input := &sesv2.PutDedicatedIpPoolScalingAttributesInput{
		PoolName:    aws.String("sample-ses-pool"),
		ScalingMode: aws.String("MANAGED"),
	}

	result, err := svc.PutDedicatedIpPoolScalingAttributes(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case sesv2.ErrCodeNotFoundException:
				fmt.Println(sesv2.ErrCodeNotFoundException, aerr.Error())
			case sesv2.ErrCodeConcurrentModificationException:
				fmt.Println(sesv2.ErrCodeConcurrentModificationException, aerr.Error())
			case sesv2.ErrCodeTooManyRequestsException:
				fmt.Println(sesv2.ErrCodeTooManyRequestsException, aerr.Error())
			case sesv2.ErrCodeBadRequestException:
				fmt.Println(sesv2.ErrCodeBadRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
