package preload

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/network"
)

// EventRuleSetUpdated upsert. Currently, it is only emitted when a rule set
// added.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#event-ruleSetUpdated
type EventRuleSetUpdated struct {
	RuleSet *RuleSet `json:"ruleSet"`
}

// EventRuleSetRemoved [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#event-ruleSetRemoved
type EventRuleSetRemoved struct {
	ID RuleSetID `json:"id"`
}

// EventPreloadEnabledStateUpdated fired when a preload enabled state is
// updated.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#event-preloadEnabledStateUpdated
type EventPreloadEnabledStateUpdated struct {
	DisabledByPreference                        bool `json:"disabledByPreference"`
	DisabledByDataSaver                         bool `json:"disabledByDataSaver"`
	DisabledByBatterySaver                      bool `json:"disabledByBatterySaver"`
	DisabledByHoldbackPrefetchSpeculationRules  bool `json:"disabledByHoldbackPrefetchSpeculationRules"`
	DisabledByHoldbackPrerenderSpeculationRules bool `json:"disabledByHoldbackPrerenderSpeculationRules"`
}

// EventPrefetchStatusUpdated fired when a prefetch attempt is updated.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#event-prefetchStatusUpdated
type EventPrefetchStatusUpdated struct {
	Key               *IngAttemptKey    `json:"key"`
	PipelineID        PipelineID        `json:"pipelineId"`
	InitiatingFrameID cdp.FrameID       `json:"initiatingFrameId"` // The frame id of the frame initiating prefetch.
	PrefetchURL       string            `json:"prefetchUrl"`
	Status            IngStatus         `json:"status"`
	PrefetchStatus    PrefetchStatus    `json:"prefetchStatus"`
	RequestID         network.RequestID `json:"requestId"`
}

// EventPrerenderStatusUpdated fired when a prerender attempt is updated.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#event-prerenderStatusUpdated
type EventPrerenderStatusUpdated struct {
	Key                     *IngAttemptKey                `json:"key"`
	PipelineID              PipelineID                    `json:"pipelineId"`
	Status                  IngStatus                     `json:"status"`
	PrerenderStatus         PrerenderFinalStatus          `json:"prerenderStatus,omitempty,omitzero"`
	DisallowedMojoInterface string                        `json:"disallowedMojoInterface,omitempty,omitzero"` // This is used to give users more information about the name of Mojo interface that is incompatible with prerender and has caused the cancellation of the attempt.
	MismatchedHeaders       []*PrerenderMismatchedHeaders `json:"mismatchedHeaders,omitempty,omitzero"`
}

// EventPreloadingAttemptSourcesUpdated send a list of sources for all
// preloading attempts in a document.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Preload#event-preloadingAttemptSourcesUpdated
type EventPreloadingAttemptSourcesUpdated struct {
	LoaderID                 cdp.LoaderID        `json:"loaderId"`
	PreloadingAttemptSources []*IngAttemptSource `json:"preloadingAttemptSources"`
}
