/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.debugger.remote.vfs;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.python.pro.debugger.remote.vfs.PyRemoteFileEditorPanel;
import com.intellij.python.pro.debugger.remote.vfs.PyStubVirtualFile;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.remote.vfs.PyRemoteDebugVirtualFile;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteFileStubEditor
extends UserDataHolderBase
implements FileEditor,
TextEditor {
    private final Project myProject;
    private final PyRemoteFileEditorPanel myEditorPanel;
    @NotNull
    private final PyRemoteDebugVirtualFile myFile;
    private TextEditor myEditor;
    private final PyDebugProcess myRemoteDebugProcess;

    public PyRemoteFileStubEditor(@NotNull Project project, @NotNull PyRemoteDebugVirtualFile vFile) {
        if (project == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(0);
        }
        if (vFile == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRemoteDebugProcess = vFile.getFileSystem().getDebugProcess();
        this.myEditorPanel = new PyRemoteFileEditorPanel(project, vFile.getPathMapper(), vFile.getRemotePath(), this);
        if (this.myRemoteDebugProcess.isDownloadSources()) {
            this.myEditorPanel.downloadContent();
        }
        this.myEditor = PyRemoteFileStubEditor.createEditor(this.myProject, "");
        this.myFile = vFile;
        this.addProcessListener(this.myRemoteDebugProcess);
    }

    @NotNull
    public PyRemoteDebugVirtualFile getFile() {
        PyRemoteDebugVirtualFile pyRemoteDebugVirtualFile = this.myFile;
        if (pyRemoteDebugVirtualFile == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(2);
        }
        return pyRemoteDebugVirtualFile;
    }

    private void addProcessListener(PyDebugProcess remoteDebugProcess) {
        remoteDebugProcess.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> PyRemoteFileStubEditor.this.close());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/python/pro/debugger/remote/vfs/PyRemoteFileStubEditor$1", "processTerminated"));
            }
        });
    }

    public void close() {
        FileEditorManager.getInstance((Project)this.myProject).closeFile((VirtualFile)this.myFile);
    }

    public void showExecutionPoint() {
        this.myRemoteDebugProcess.getSession().showExecutionPoint();
    }

    public void setSource(String source) {
        this.myEditor = PyRemoteFileStubEditor.createEditor(this.myProject, source);
    }

    @Nullable
    private static TextEditor createEditor(@NotNull Project project, @NotNull String source) {
        if (project == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(3);
        }
        if (source == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(4);
        }
        PyStubVirtualFile file = new PyStubVirtualFile(source);
        List providers = FileEditorProviderManager.getInstance().getProviderList(project, (VirtualFile)file);
        FileEditorProvider prov = (FileEditorProvider)providers.get(0);
        FileEditor editor = prov.createEditor(project, (VirtualFile)file);
        if (editor instanceof TextEditor) {
            return (TextEditor)editor;
        }
        return null;
    }

    public PyDebugProcess getRemoteDebugProcess() {
        return this.myRemoteDebugProcess;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myEditorPanel.getPanel();
        if (jPanel == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditorPanel.getPanel();
    }

    @NotNull
    public String getName() {
        return "";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(6);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(7);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(8);
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEditor);
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor.getEditor();
        if (editor == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(9);
        }
        return editor;
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(10);
        }
        return true;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            PyRemoteFileStubEditor.$$$reportNull$$$0(11);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/debugger/remote/vfs/PyRemoteFileStubEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/debugger/remote/vfs/PyRemoteFileStubEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 9 -> new IllegalStateException(string);
        };
    }
}

