/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter.add;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.python.remoteInterpreter.add.RemoteSdkCreationUtilKt;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ui.RemoteSdkUpdatedCallback;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.text.UniqueNameGenerator;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.sdk.SdksKt;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FileSystemException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001aH\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001aH\u0010\u0010\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0018\u0010\u001b\u001a\u00020\u00152\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\u0017\u001a*\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u000f\u001a\u0018\u0010$\u001a\u00020\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010%\u001a\u00020\u0012\u001a\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0012H\u0000\"\u0010\u0010#\u001a\u00020\r8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"createSdkFromExistingServerConfiguration", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "existingWebServerConfig", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "existingSdks", "", "interpreterPath", "", "runAsRootViaSudo", "", "createSdkFromNewServerConfiguration", "newSshUiData", "Lcom/intellij/ssh/ui/unified/SshUiData;", "newWebServerConfig", "setWebDeploymentCredentials", "", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalData;", "webServerConfig", "remoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "initializeHelpersPath", "sdkData", "createSshUiData", "Lcom/jetbrains/plugins/webDeployment/config/RemoteCredentialsVerifiableHolder;", "isProjectLevel", "credentials", "Lcom/intellij/credentialStore/Credentials;", "saveCredentialsInPermanentStore", "NOT_EMPTY_URL", "createSftpWebServerConfig", "sshUiData", "getRemoteCredentialsWithAuth", "uiData", "intellij.python.remoteInterpreter"})
@SourceDebugExtension(value={"SMAP\nSshSdkCreationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshSdkCreationUtil.kt\ncom/intellij/python/remoteInterpreter/add/SshSdkCreationUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1625#2:157\n1869#2:158\n1870#2:160\n1626#2:161\n1#3:159\n1#3:162\n*S KotlinDebug\n*F\n+ 1 SshSdkCreationUtil.kt\ncom/intellij/python/remoteInterpreter/add/SshSdkCreationUtilKt\n*L\n133#1:157\n133#1:158\n133#1:160\n133#1:161\n133#1:159\n*E\n"})
public final class SshSdkCreationUtilKt {
    @NonNls
    @NotNull
    private static final String NOT_EMPTY_URL = "http:///";

    @NotNull
    public static final Sdk createSdkFromExistingServerConfiguration(@Nullable Project project, @Nullable Module module, @NotNull SshConfig existingSshConfig, @NotNull WebServerConfig existingWebServerConfig, @NotNull List<? extends Sdk> existingSdks, @NotNull String interpreterPath, boolean runAsRootViaSudo) {
        Intrinsics.checkNotNullParameter((Object)existingSshConfig, (String)"existingSshConfig");
        Intrinsics.checkNotNullParameter((Object)existingWebServerConfig, (String)"existingWebServerConfig");
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)interpreterPath, (String)"interpreterPath");
        PyRemoteSdkAdditionalData data = new PyRemoteSdkAdditionalData(interpreterPath, runAsRootViaSudo);
        SshSdkCreationUtilKt.setWebDeploymentCredentials(data, existingWebServerConfig, (RemoteCredentials)new SshUiData(existingSshConfig));
        SshSdkCreationUtilKt.initializeHelpersPath(project, data);
        Sdk sdk = RemoteSdkCreationUtilKt.createAndInitRemoteSdk$default(project, data, existingSdks, null, 8, null);
        if (existingSshConfig.isProjectLevel() && module != null) {
            SdksKt.setAssociationToModuleAsync((Sdk)sdk, (Module)module);
        }
        return sdk;
    }

    @NotNull
    public static final Sdk createSdkFromNewServerConfiguration(@Nullable Project project, @Nullable Module module, @NotNull SshUiData newSshUiData, @NotNull WebServerConfig newWebServerConfig, @NotNull List<? extends Sdk> existingSdks, @NotNull String interpreterPath, boolean runAsRootViaSudo) {
        Intrinsics.checkNotNullParameter((Object)newSshUiData, (String)"newSshUiData");
        Intrinsics.checkNotNullParameter((Object)newWebServerConfig, (String)"newWebServerConfig");
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)interpreterPath, (String)"interpreterPath");
        PyRemoteSdkAdditionalData data = new PyRemoteSdkAdditionalData(interpreterPath, runAsRootViaSudo);
        SshUiData sshUiData = SshConfigManager.getInstance((Project)project).register(newSshUiData);
        Intrinsics.checkNotNullExpressionValue((Object)sshUiData, (String)"register(...)");
        SshUiData sshUiData2 = sshUiData;
        newWebServerConfig.getFileTransferConfig().setSshConfig(sshUiData2.getConfig());
        SshSdkCreationUtilKt.setWebDeploymentCredentials(data, newWebServerConfig, (RemoteCredentials)sshUiData2);
        GroupedServersConfigManager.getInstance((Project)project).addServer(newWebServerConfig);
        SshSdkCreationUtilKt.initializeHelpersPath(project, data);
        Sdk sdk = RemoteSdkCreationUtilKt.createAndInitRemoteSdk$default(project, data, existingSdks, null, 8, null);
        if (sshUiData2.getConfig().isProjectLevel() && module != null) {
            SdksKt.setAssociationToModuleAsync((Sdk)sdk, (Module)module);
        }
        return sdk;
    }

    private static final void setWebDeploymentCredentials(PyRemoteSdkAdditionalData data, WebServerConfig webServerConfig, RemoteCredentials remoteCredentials) {
        String string = webServerConfig.getId();
        if (string == null) {
            throw new IllegalStateException();
        }
        String webServerConfigId = string;
        WebDeploymentCredentialsHolder webDeploymentCredentialsHolder = new WebDeploymentCredentialsHolder(webServerConfigId, webServerConfig.getName(), remoteCredentials);
        data.setCredentials(WebDeploymentCredentialsType.Companion.getInstance().getCredentialsKey(), (Object)webDeploymentCredentialsHolder);
    }

    public static final void initializeHelpersPath(@Nullable Project project, @NotNull PyRemoteSdkAdditionalData sdkData) throws FileSystemException, RemoteCancelledException {
        Intrinsics.checkNotNullParameter((Object)sdkData, (String)"sdkData");
        RemoteCredentials credentials = sdkData.getRemoteCredentials(project, true);
        RemoteSdkUpdatedCallback callback = SshSdkCreationUtilKt::initializeHelpersPath$lambda$0;
        String string = PythonRemoteInterpreterBundle.message("python.add.sdk.ssh.creation.creating.helpers.directory", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        RemoteSdkUtil.testConnectionAndCreateHelpersPath((Project)project, (RemoteCredentials)credentials, (RemoteSdkProperties)((RemoteSdkProperties)sdkData), (String)title, (RemoteSdkUpdatedCallback)callback);
    }

    @NotNull
    public static final SshUiData createSshUiData(@NotNull RemoteCredentialsVerifiableHolder remoteCredentials, boolean isProjectLevel, @Nullable Credentials credentials, boolean saveCredentialsInPermanentStore) {
        Intrinsics.checkNotNullParameter((Object)remoteCredentials, (String)"remoteCredentials");
        SshUiData data = new SshUiData(new SshConfig(true), false);
        data.loadFromCredentials((RemoteCredentials)remoteCredentials);
        data.setCredentials(credentials, saveCredentialsInPermanentStore, false);
        data.getConfig().setProjectLevel(isProjectLevel);
        return data;
    }

    public static /* synthetic */ SshUiData createSshUiData$default(RemoteCredentialsVerifiableHolder remoteCredentialsVerifiableHolder, boolean bl, Credentials credentials, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return SshSdkCreationUtilKt.createSshUiData(remoteCredentialsVerifiableHolder, bl, credentials, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final WebServerConfig createSftpWebServerConfig(@Nullable Project project, @NotNull SshUiData sshUiData) {
        void it;
        SshUiData destination$iv;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)sshUiData, (String)"sshUiData");
        WebServerConfig webServerConfig = new WebServerConfig(WebServerConfig.getNextId());
        webServerConfig.setIsProjectLevel(sshUiData.getConfig().isProjectLevel());
        WebServerConfig webServerConfig2 = webServerConfig;
        boolean bl = false;
        List list = GroupedServersConfigManager.getInstance((Project)project).getFlattenedServers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFlattenedServers(...)");
        Iterable iterable = list;
        Collection collection = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            WebServerConfig p0 = (WebServerConfig)element$iv;
            boolean bl3 = false;
            if (p0.getName() == null) continue;
            boolean bl4 = false;
            destination$iv.add(it$iv);
        }
        HashSet allNames = (HashSet)destination$iv;
        destination$iv = sshUiData;
        String string = "";
        boolean bl5 = false;
        webServerConfig2.setName(UniqueNameGenerator.generateUniqueName((String)string, (String)(it.getUserName() + "@" + it.getHost() + ":" + it.getPort()), (String)"", (String)" (", (String)")", arg_0 -> SshSdkCreationUtilKt.createSftpWebServerConfig$lambda$0$1(allNames, arg_0)));
        webServerConfig.setUrl(NOT_EMPTY_URL);
        webServerConfig.getFileTransferConfig().setSshConfig(sshUiData.getConfig());
        return webServerConfig;
    }

    @NotNull
    public static final RemoteCredentials getRemoteCredentialsWithAuth(@NotNull SshUiData uiData) {
        Intrinsics.checkNotNullParameter((Object)uiData, (String)"uiData");
        SshUiData sshUiData = uiData.clone();
        Intrinsics.checkNotNullExpressionValue((Object)sshUiData, (String)"clone(...)");
        return (RemoteCredentials)sshUiData;
    }

    private static final void initializeHelpersPath$lambda$0(RemoteSdkProperties it) {
    }

    private static final boolean createSftpWebServerConfig$lambda$0$1(HashSet $allNames, String it) {
        return !$allNames.contains(it);
    }
}

