/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.intellij.util.Function;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.model.TemplateParametersEvaluator;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoAppTemplateLoader;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoFileSystemTemplateLoader;
import com.jetbrains.django.model.viewManagemenet.ViewManagementFacade;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.django.util.DjangoStringUtil;
import com.jetbrains.django.util.PythonDataflowUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPathEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoTemplateManager {
    private static final PsiCacheKey<Boolean, PyStringLiteralExpression> IS_TEMPLATE_REFERENCE_EXPECTED = PsiCacheKey.create((String)(DjangoTemplateManager.class.getName() + "tempRefExpected"), (Function)new TemplateReferenceExpectedChecker());
    @NotNull
    private final PsiCacheKey<Collection<? extends NavigatablePsiElement>, PyFunction> myTemplateReferences;
    @NotNull
    private final Module myModule;

    public DjangoTemplateManager(@NotNull Module module) {
        if (module == null) {
            DjangoTemplateManager.$$$reportNull$$$0(0);
        }
        this.myTemplateReferences = PsiCacheKey.create((String)(DjangoTemplateManager.class.getName() + "tempRef"), (Function)new TemplateReferencesObtainer());
        this.myModule = module;
    }

    @NotNull
    public List<PsiFile> getAllTemplates() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myModule.getProject());
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        for (VirtualFile templatesFolder : this.getTemplatesFolderList(false, null, false)) {
            List templates = VfsUtil.collectChildrenRecursively((VirtualFile)templatesFolder);
            for (VirtualFile entryInTemplateFolder : templates) {
                PsiFile templateFile = psiManager.findFile(entryInTemplateFolder);
                if (templateFile == null) continue;
                result.add(templateFile);
            }
        }
        ArrayList<PsiFile> arrayList = result;
        if (arrayList == null) {
            DjangoTemplateManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public PsiFile getTemplate(@NotNull String name) {
        if (name == null) {
            DjangoTemplateManager.$$$reportNull$$$0(2);
        }
        List<VirtualFile> templatesFolderList = this.getTemplatesFolderList(false, null, false);
        for (VirtualFile templatesFolder : templatesFolderList) {
            VirtualFile template = templatesFolder.findFileByRelativePath(name);
            if (template == null) continue;
            return PsiManager.getInstance((Project)this.myModule.getProject()).findFile(template);
        }
        return null;
    }

    @NotNull
    public List<VirtualFile> getTemplatesFolderList(boolean inProjectRootOnly, @Nullable PsiElement anchorToSort, boolean removeReadOnly) {
        PsiFile file;
        ArrayList result = new ArrayList();
        DjangoModelApi modelApi = (DjangoModelApi)DjangoModelApi.create(this.myModule).getSuccessOrNull();
        if (modelApi != null) {
            VirtualFile projectRoot;
            Object djangoFacet = DjangoFacet.getInstance(this.myModule);
            if (djangoFacet == null) {
                List<VirtualFile> list = Collections.emptyList();
                if (list == null) {
                    DjangoTemplateManager.$$$reportNull$$$0(3);
                }
                return list;
            }
            result.addAll(modelApi.getTemplateFolders());
            if (inProjectRootOnly && (projectRoot = ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile()) != null) {
                DjangoTemplateManager.removeFoldersOutsideOfProjectRoot(result, projectRoot);
            }
        }
        for (VirtualFile forcedFolder : this.getConfigurationTemplatesFolders()) {
            result.add(Pair.create((Object)forcedFolder, null));
        }
        if (anchorToSort != null && (file = anchorToSort.getContainingFile()) != null) {
            result.sort(new TemplateFolderComparator(file.getVirtualFile()));
        }
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)this.myModule.getProject());
        List<VirtualFile> list = result.stream().map(input -> (VirtualFile)input.first).filter(o -> o != null).filter(o -> !removeReadOnly || !index.isExcluded(o) && !index.isInLibrary(o)).distinct().toList();
        if (list == null) {
            DjangoTemplateManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isStaticFilesDirUnresolved() {
        CachedValuesManager cache = CachedValuesManager.getManager((Project)this.myModule.getProject());
        return (Boolean)cache.getCachedValue((UserDataHolder)this.myModule, () -> new CachedValueProvider.Result((Object)this.getStaticfilesDirs(true).contains(null), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static void removeFoldersOutsideOfProjectRoot(@NotNull Collection<Pair<VirtualFile, Class<?>>> folderList, @NotNull VirtualFile projectRoot) {
        if (folderList == null) {
            DjangoTemplateManager.$$$reportNull$$$0(5);
        }
        if (projectRoot == null) {
            DjangoTemplateManager.$$$reportNull$$$0(6);
        }
        Iterator<Pair<VirtualFile, Class<?>>> iterator = folderList.iterator();
        while (iterator.hasNext()) {
            VirtualFile templateFolder = (VirtualFile)iterator.next().first;
            if (VfsUtilCore.isAncestor((VirtualFile)projectRoot, (VirtualFile)templateFolder, (boolean)true)) continue;
            iterator.remove();
        }
    }

    @NotNull
    public List<VirtualFile> getStaticFolderList() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.getStaticfilesDirs(false));
        VirtualFile staticRoot = this.getStaticRoot();
        if (staticRoot != null) {
            result.add(staticRoot);
        }
        result.addAll(this.getAppStaticFolders());
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            DjangoTemplateManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public List<VirtualFile> getMediaFolderList() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile root = this.getMediaRoot();
        if (root != null) {
            result.add(root);
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            DjangoTemplateManager.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public List<VirtualFile> getConfigurationTemplatesFolders() {
        List<VirtualFile> list = TemplatesService.getInstance(this.myModule).getTemplateFolders();
        if (list == null) {
            DjangoTemplateManager.$$$reportNull$$$0(9);
        }
        return list;
    }

    public Collection<VirtualFile> getStaticfilesDirs(boolean unresolvedAsNulls) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (PyExpression dir : DjangoSettingsPy.getStaticfilesDirs(this.myModule)) {
            Object vf;
            if (dir instanceof PyParenthesizedExpression) {
                List exprs = PyUtil.flattenedParensAndTuples((PyExpression[])new PyExpression[]{dir});
                if (exprs.size() == 2 && exprs.get(0) instanceof PyStringLiteralExpression) {
                    String name = DjangoStringUtil.getStringValue((PsiElement)exprs.get(0));
                    vf = this.resolveVirtualFile(PyPathEvaluator.evaluatePath((PyExpression)((PyExpression)exprs.get(1))), (PsiElement)dir);
                    if (vf instanceof VirtualFileSystemEntry) {
                        vf = new PrefixedVirtualDirectory((VirtualFileSystemEntry)vf, name, (PyStringLiteralExpression)exprs.get(0));
                    }
                } else {
                    vf = null;
                }
            } else {
                VirtualFile staticPathRelativeToDjangoRoot;
                VirtualFile djangoRoot;
                String path2 = PyPathEvaluator.evaluatePath((PyExpression)dir);
                DjangoFacet facet = DjangoFacet.getInstance(this.myModule);
                if (facet != null && path2 != null && (djangoRoot = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile()) != null && (staticPathRelativeToDjangoRoot = djangoRoot.findFileByRelativePath(path2)) != null) {
                    result.add(staticPathRelativeToDjangoRoot);
                }
                vf = this.resolveVirtualFile(path2, (PsiElement)dir);
            }
            if (!unresolvedAsNulls && vf == null) continue;
            result.add((VirtualFile)vf);
        }
        return result;
    }

    @Nullable
    public VirtualFile getStaticRoot() {
        return this.resolveVirtualFile(DjangoSettingsPy.getStaticRoot(this.myModule), (PsiElement)DjangoSettingsPy.findSettingsFile(this.myModule));
    }

    @Nullable
    public VirtualFile getMediaRoot() {
        return this.resolveVirtualFile(DjangoSettingsPy.getMediaRoot(this.myModule), (PsiElement)DjangoSettingsPy.findSettingsFile(this.myModule));
    }

    @Nullable
    public String getMediaUrl() {
        return DjangoSettingsPy.getMediaUrl(this.myModule);
    }

    @Nullable
    public VirtualFile resolveVirtualFile(String dir, PsiElement element) {
        LocalFileSystem vfs;
        if (StringUtil.isEmpty((String)dir)) {
            return null;
        }
        try {
            vfs = element.getContainingFile().getVirtualFile().getFileSystem();
        }
        catch (Exception e) {
            vfs = LocalFileSystem.getInstance();
        }
        VirtualFile vf = vfs.findFileByPath(dir);
        if (vf == null) {
            ArrayList<VirtualFile> baseDirs = new ArrayList<VirtualFile>();
            VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)this.myModule.getProject());
            if (projectDir != null) {
                baseDirs.add(projectDir);
            }
            PyFile settingsPy = DjangoSettingsPy.getSettingsFile(this.myModule);
            if (!StringUtil.isEmpty((String)dir) && settingsPy != null && settingsPy.getVirtualFile() != null) {
                baseDirs.add(settingsPy.getVirtualFile().getParent());
            }
            for (VirtualFile base : baseDirs) {
                VirtualFile f = base.findFileByRelativePath(dir);
                if (f == null) continue;
                return f;
            }
        }
        return vf;
    }

    public static DjangoTemplateManager getInstance(@NotNull Module module) {
        if (module == null) {
            DjangoTemplateManager.$$$reportNull$$$0(10);
        }
        return (DjangoTemplateManager)module.getService(DjangoTemplateManager.class);
    }

    @NotNull
    public static Collection<? extends NavigatablePsiElement> getTemplateReferences(@NotNull PyFunction func) {
        Module module;
        if (func == null) {
            DjangoTemplateManager.$$$reportNull$$$0(11);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)func)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                DjangoTemplateManager.$$$reportNull$$$0(12);
            }
            return list;
        }
        Collection collection = (Collection)DjangoTemplateManager.getInstance((Module)module).myTemplateReferences.getValue((PsiElement)func);
        if (collection == null) {
            DjangoTemplateManager.$$$reportNull$$$0(13);
        }
        return collection;
    }

    public static boolean isTemplateReference(PyStringLiteralExpression strLiteral) {
        String name = strLiteral.getStringValue();
        return DjangoCoreUtil.hasDjangoTemplateExtension(name) && DjangoTemplateManager.isTemplateReferenceExpected(strLiteral);
    }

    public static boolean isTemplateReferenceExpected(PyStringLiteralExpression strLiteral) {
        return (Boolean)IS_TEMPLATE_REFERENCE_EXPECTED.getValue((PsiElement)strLiteral);
    }

    private Set<NavigatablePsiElement> getViewToTemplateReferences(@Nullable String templateName, @Nullable Class<?> stopAtFirstClass, @NotNull TypeEvalContext context) {
        if (context == null) {
            DjangoTemplateManager.$$$reportNull$$$0(14);
        }
        if (templateName == null) {
            return Collections.emptySet();
        }
        HashSet<NavigatablePsiElement> result = new HashSet<NavigatablePsiElement>();
        Set<PyFile> references = this.getFilesWithTemplateReferences(context);
        ViewManagementFacade facade = new ViewManagementFacade(this.myModule);
        for (PyFile file : references) {
            result.addAll(facade.getTemplateReferences((PyElement)file, templateName, stopAtFirstClass, context).get((Object)templateName));
            if (stopAtFirstClass == null || result.isEmpty()) continue;
            return result;
        }
        return result;
    }

    private Set<PyFile> getFilesWithTemplateReferences(@NotNull TypeEvalContext context) {
        DjangoModelApi api;
        if (context == null) {
            DjangoTemplateManager.$$$reportNull$$$0(15);
        }
        if ((api = (DjangoModelApi)DjangoModelApi.create(this.myModule).getSuccessOrNull()) == null) {
            return Collections.emptySet();
        }
        HashSet<PyFile> result = new HashSet<PyFile>();
        for (DjangoApplicationModel applicationModel : api.getApplications()) {
            PsiDirectory appFolder = applicationModel.getApplicationRootFolder();
            PyFile viewsFile = (PyFile)PyUtil.as((Object)appFolder.findFile("views.py"), PyFile.class);
            if (viewsFile != null) {
                result.add(viewsFile);
                continue;
            }
            PsiDirectory viewDirectory = appFolder.findSubdirectory("views");
            if (viewDirectory == null) continue;
            for (PsiFile file : viewDirectory.getFiles()) {
                if (!(file instanceof PyFile)) continue;
                result.add((PyFile)file);
            }
        }
        api.collectAllUrlsFromCache(result);
        return result;
    }

    public static Set<NavigatablePsiElement> getTemplateReferences(@NotNull PsiFile template, @Nullable Class<?> stopAtFirstClass, @NotNull TypeEvalContext context) {
        Module module;
        if (template == null) {
            DjangoTemplateManager.$$$reportNull$$$0(16);
        }
        if (context == null) {
            DjangoTemplateManager.$$$reportNull$$$0(17);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)template)) == null) {
            return Collections.emptySet();
        }
        String relativeName = DjangoTemplateManager.getRelativeName(module, template);
        if (relativeName != null) {
            return DjangoTemplateManager.getInstance(module).getViewToTemplateReferences(relativeName, stopAtFirstClass, context);
        }
        return Collections.emptySet();
    }

    @Nullable
    public static String getRelativeName(@NotNull Module module, @NotNull PsiFile template) {
        List<VirtualFile> folders;
        VirtualFile folder;
        if (module == null) {
            DjangoTemplateManager.$$$reportNull$$$0(18);
        }
        if (template == null) {
            DjangoTemplateManager.$$$reportNull$$$0(19);
        }
        if ((folder = DjangoTemplateManager.selectLongest(folders = DjangoTemplateManager.getInstance(module).getTemplatesFolderList(false, null, false), template)) != null) {
            return VirtualFileUtil.getRelativePath(folder, template.getVirtualFile());
        }
        VirtualFile virtualFile = template.getVirtualFile();
        if (virtualFile != null) {
            return virtualFile.getPath();
        }
        return null;
    }

    @Nullable
    private static VirtualFile selectLongest(List<VirtualFile> folders, PsiFile template) {
        int len = -1;
        VirtualFile res = null;
        VirtualFile vFile = template.getVirtualFile();
        assert (vFile != null);
        for (VirtualFile folder : folders) {
            Object path2 = folder.getPath();
            if (!((String)path2).endsWith("/")) {
                path2 = (String)path2 + "/";
            }
            if (!vFile.getPath().startsWith((String)path2) || ((String)path2).length() <= len) continue;
            len = ((String)path2).length();
            res = folder;
        }
        return res;
    }

    @NotNull
    public List<VirtualFile> getAppStaticFolders() {
        return this.getAppFolders("static");
    }

    @NotNull
    private List<VirtualFile> getAppFolders(@NotNull String folderName) {
        DjangoModelApi api;
        if (folderName == null) {
            DjangoTemplateManager.$$$reportNull$$$0(20);
        }
        if ((api = (DjangoModelApi)DjangoModelApi.create(this.myModule).getSuccessOrNull()) != null) {
            List<VirtualFile> list = DjangoApplicationModel.getFoldersUnderEachApp(folderName, api);
            if (list == null) {
                DjangoTemplateManager.$$$reportNull$$$0(21);
            }
            return list;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            DjangoTemplateManager.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 7, 8, 9, 12, 13, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/DjangoTemplateManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoot";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/DjangoTemplateManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTemplates";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatesFolderList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticFolderList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMediaFolderList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationTemplatesFolders";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateReferences";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 21: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeFoldersOutsideOfProjectRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 11: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateReferences";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getViewToTemplateReferences";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithTemplateReferences";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAppFolders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 7, 8, 9, 12, 13, 21, 22 -> new IllegalStateException(string);
        };
    }

    private static class TemplateReferencesObtainer
    implements Function<PyFunction, Collection<? extends NavigatablePsiElement>> {
        private TemplateReferencesObtainer() {
        }

        public Collection<? extends NavigatablePsiElement> fun(PyFunction function) {
            TypeEvalContext context = TypeEvalContext.codeAnalysis((Project)function.getProject(), (PsiFile)function.getContainingFile());
            return new ViewManagementFacade((PyElement)function).getTemplateReferences((PyElement)function, null, null, context).values();
        }
    }

    private static class TemplateFolderComparator
    implements Comparator<Pair<VirtualFile, Class<?>>> {
        @NotNull
        private static final List<Class<?>> LOADERS_ORDER = Arrays.asList(DjangoFileSystemTemplateLoader.class, DjangoAppTemplateLoader.class);
        @NotNull
        private final VirtualFile myAhcnor;

        TemplateFolderComparator(@NotNull VirtualFile anchor) {
            if (anchor == null) {
                TemplateFolderComparator.$$$reportNull$$$0(0);
            }
            this.myAhcnor = anchor;
        }

        @Override
        public int compare(Pair<VirtualFile, Class<?>> leftPair, Pair<VirtualFile, Class<?>> rightPair) {
            VirtualFile rightCommonAncestor;
            int rightClassWeight;
            Integer leftClassWeight = LOADERS_ORDER.indexOf(leftPair.second);
            if (!leftClassWeight.equals(rightClassWeight = LOADERS_ORDER.indexOf(rightPair.second))) {
                return leftClassWeight.compareTo(rightClassWeight) * -1;
            }
            VirtualFile leftFile = (VirtualFile)leftPair.first;
            VirtualFile rightFile = (VirtualFile)rightPair.first;
            VirtualFile leftCommonAncestor = leftFile != null ? VfsUtilCore.getCommonAncestor((VirtualFile)leftFile, (VirtualFile)this.myAhcnor) : null;
            VirtualFile virtualFile = rightCommonAncestor = rightFile != null ? VfsUtilCore.getCommonAncestor((VirtualFile)rightFile, (VirtualFile)this.myAhcnor) : null;
            if (leftCommonAncestor == null && rightCommonAncestor == null) {
                return 0;
            }
            if (leftCommonAncestor == null) {
                return 1;
            }
            if (rightCommonAncestor == null) {
                return -1;
            }
            Integer leftWeight = leftCommonAncestor.getPath().length();
            int nearnessWeight = leftWeight.compareTo(rightCommonAncestor.getPath().length()) * -1;
            if (nearnessWeight != 0) {
                return nearnessWeight;
            }
            return StringUtil.compare((String)leftCommonAncestor.getPath(), (String)rightCommonAncestor.getPath(), (boolean)true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/django/model/DjangoTemplateManager$TemplateFolderComparator", "<init>"));
        }
    }

    public static class PrefixedVirtualDirectory
    extends StubVirtualFile {
        private final VirtualFile myVirtualFile;
        private final String myPrefix;
        private final PyStringLiteralExpression myPrefixElement;

        public PrefixedVirtualDirectory(VirtualFileSystemEntry virtualFile, String prefix, PyStringLiteralExpression prefixElement) {
            this.myVirtualFile = virtualFile;
            this.myPrefix = prefix;
            this.myPrefixElement = prefixElement;
        }

        public VirtualFile getVirtualFile() {
            return this.myVirtualFile;
        }

        public String getPrefix() {
            return this.myPrefix;
        }

        public PyStringLiteralExpression getPrefixElement() {
            return this.myPrefixElement;
        }
    }

    private static class TemplateReferenceExpectedChecker
    implements Function<PyStringLiteralExpression, Boolean> {
        private TemplateReferenceExpectedChecker() {
        }

        public Boolean fun(PyStringLiteralExpression strLiteral) {
            String text = strLiteral.getText();
            if (text != null && text.contains("{")) {
                return false;
            }
            if (TemplateParametersEvaluator.isTemplateValueInRenderDecorated(strLiteral) || TemplateParametersEvaluator.isTemplateNameArg(strLiteral) || TemplateParametersEvaluator.isTemplateNameInViewClass((NavigatablePsiElement)strLiteral)) {
                return true;
            }
            Module[] modules = ModuleManager.getInstance((Project)strLiteral.getProject()).getModules();
            TemplatesService templatesService = modules.length == 0 ? null : TemplatesService.getInstance(modules[0]);
            for (PyCallExpression call : PythonDataflowUtil.getCalls((PyExpression)strLiteral)) {
                String name;
                int index = PyPsiUtils.findArgumentIndex((PyCallExpression)call, (PsiElement)strLiteral);
                PyExpression callee = call.getCallee();
                if (callee == null || (name = callee.getName()) == null || index >= 2 || !TemplateParametersEvaluator.isTemplateMethod(name, index) && !TemplateParametersEvaluator.isRenderDecorator(call)) continue;
                return true;
            }
            return false;
        }
    }
}

