/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.vertica;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.vertica.VertDdlParsing;
import com.intellij.sql.dialects.vertica.VertDialect;
import com.intellij.sql.dialects.vertica.VertDmlParsing;
import com.intellij.sql.dialects.vertica.VertElementTypes;
import com.intellij.sql.dialects.vertica.VertExpressionParsing;
import com.intellij.sql.dialects.vertica.VertGeneratedParser;
import com.intellij.sql.dialects.vertica.VertOtherParsing;
import com.intellij.sql.dialects.vertica.VertTypes;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTokens;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class VertParser
extends SqlParser {
    private boolean myPsqlSameLine;

    public VertParser() {
        super((SqlLanguageDialectEx)VertDialect.INSTANCE);
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return VertGeneratedParser.parse_root_(root, builder, level);
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = VertExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, VertExpressionParsing::evaluable_expression);
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        if (SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)PG_PSQL_BACKSLASH) && (this.myPsqlSameLine || SqlParserUtil.endsWithNewLine((PsiBuilder)builder))) {
            return this.parsePsqlMetaCommand(builder, level);
        }
        if (SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SqlTokens.SQL_RAW_INPUT)) {
            return this.parseCopyCommandInput(builder, level);
        }
        return VertGeneratedParser.statement(builder, level);
    }

    private boolean parseCopyCommandInput(PsiBuilder builder, int level) {
        if (!SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SqlTokens.SQL_RAW_INPUT)) {
            return false;
        }
        PsiBuilder.Marker mark = builder.mark();
        PsiBuilder.Marker mark2 = builder.mark();
        builder.advanceLexer();
        mark2.done((IElementType)SqlCompositeElementTypes.SQL_INJECTABLE_RAW_INPUT);
        mark.done((IElementType)VertElementTypes.Misc.VERT_PSQL_META_COMMAND);
        SqlParserUtil.consumeToken((PsiBuilder)builder, (IElementType)SqlCommonTokens.PG_COPY_TERMINATOR);
        this.statementSeparatorParsed(builder);
        return true;
    }

    private boolean parsePsqlMetaCommand(PsiBuilder builder, int level) {
        if (!SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)PG_PSQL_BACKSLASH)) {
            return false;
        }
        this.myPsqlSameLine = false;
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        if (builder.rawLookup(0) == PG_PSQL_BACKSLASH) {
            builder.advanceLexer();
        } else {
            SqlGeneratedParserUtil.parseAsTree((PsiBuilder)builder, (int)level, (IElementType)SqlCompositeElementTypes.SQL_GENERIC_ELEMENT, (boolean)true, (GeneratedParserUtilBase.Parser)GeneratedParserUtilBase.TOKEN_ADVANCER, (GeneratedParserUtilBase.Parser)new GeneratedParserUtilBase.Parser(){

                public boolean parse(PsiBuilder builder, int level) {
                    VertParser.this.myPsqlSameLine = SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SqlCommonTokens.PG_PSQL_BACKSLASH);
                    return !VertParser.this.myPsqlSameLine && !SqlParserUtil.endsWithNewLine((PsiBuilder)builder);
                }
            });
        }
        mark.done((IElementType)VertElementTypes.Misc.VERT_PSQL_META_COMMAND);
        this.statementSeparatorParsed(builder);
        return true;
    }

    protected TokenSet[] getExtendsTokenSets() {
        return VertGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return VertDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? VertOtherParsing.type_element_ext(builder, level) : VertDdlParsing.type_element(builder, level);
    }

    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result = SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_CUSTOM_LQUOTE) ? this.parseStringLiteralInner(builder) : super.consumeCustomParameterReference(builder);
        return result;
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, VertExpressionParsing::parenthesized_values_expr, VertDmlParsing::top_query_expression, VertParser::parseTopQueryExpressionTail, VertExpressionParsing::row_element_list, (b, l) -> VertExpressionParsing.root_expr_0(b, l, -1) && VertExpressionParsing.row_element_list_separator(b, l) && VertExpressionParsing.row_element_list(b, l));
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, VertDmlParsing::parenthesized_aliased_join_expression, VertDmlParsing::top_query_expression, VertParser::parseTopQueryExpressionTail, (b, l) -> VertDmlParsing.join_expression(b, l, -1), (b, l) -> VertDmlParsing.join_expression_0(b, l, -1));
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        if (VertGeneratedParser.within_group_clause(builder, level) | VertGeneratedParser.analytic_clause(builder, level)) {
            IElementType type;
            LighterASTNode ref = SqlGeneratedParserUtil.getExposedFunctionRef((PsiBuilder)builder);
            IElementType iElementType = type = ref == null ? null : ref.getTokenType();
            if (type == SQL_REFERENCE || type == SQL_ANY_CALLABLE_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)ref).remapTokenType((IElementType)SQL_FUNCTION_REFERENCE);
            }
        }
        return true;
    }

    public boolean parseFunctionParametersEnd(PsiBuilder builder, int level, BuiltinFunction definition) {
        VertDmlParsing.order_by_clause(builder, level);
        VertGeneratedParser.using_parameters_clause(builder, level);
        return true;
    }

    protected boolean parseTypedReference(PsiBuilder builder, SqlReferenceElementType refType) {
        boolean result = super.parseTypedReference(builder, refType);
        if (!result && SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_STRING_TOKEN)) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done((IElementType)SQL_STRING_LITERAL);
            result = true;
        }
        if (result && SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)SQL_DOUBLE_COLON)) {
            PsiBuilder.Marker marker = Objects.requireNonNull((PsiBuilder.Marker)builder.getLatestDoneMarker());
            VertDdlParsing.type_element(builder, 0);
            marker.precede().done((IElementType)SQL_BINARY_EXPRESSION);
        }
        return result;
    }

    public boolean argumentListRecover(PsiBuilder builder, int level) {
        return GeneratedParserUtilBase.nextTokenIsSmart((PsiBuilder)builder, (IElementType[])new IElementType[]{VertTypes.VERT_ORDER, VertTypes.VERT_USING});
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first2) {
        boolean result;
        IElementType type = builder.getTokenType();
        boolean bl = result = type == SQL_STRING_TOKEN || SqlGeneratedParserUtil.isExternalParameterFirst((IElementType)type) || this.getVariableType(builder) == SQL_PARAMETER_REFERENCE;
        if (result && !first2) {
            result = false;
            int i = -1;
            while (true) {
                IElementType token;
                if ((token = builder.rawLookup(i)) == null || SqlTokens.COMMENT_TOKENS.contains(token)) {
                    return false;
                }
                if (!SqlTokens.WS_TOKENS.contains(token)) break;
                if (StringUtil.contains((CharSequence)builder.getOriginalText(), (int)builder.rawTokenTypeStart(i), (int)builder.rawTokenTypeStart(i + 1), (char)'\n')) {
                    result = true;
                }
                --i;
            }
        }
        return result;
    }

    public boolean parseFunctionParametersStart(PsiBuilder builder, int level, BuiltinFunction definition) {
        boolean ignored = SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)SqlCommonKeywords.SQL_ALL) || SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)SqlCommonKeywords.SQL_DISTINCT);
        return true;
    }

    public boolean consumeUnderscoreAndCharSpec(PsiBuilder builder) {
        return false;
    }

    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return true;
    }

    protected boolean parseExternalParameterImpl(PsiBuilder builder, boolean checkStart, boolean checkEnd) {
        if (this.getVariableType(builder) == SQL_PARAMETER_REFERENCE) {
            return this.parseParameterReferenceInner(builder, (IElementType)SQL_PARAMETER_REFERENCE);
        }
        return super.parseExternalParameterImpl(builder, checkStart, checkEnd);
    }

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return VertGeneratedParser.table_opt_column_list(builder, level);
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        VertDmlParsing.query_expression_0(builder, level, -1);
        return VertDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

