/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.outputs.util.DisposingKt;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.EmptyComponent;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.JupyterWebOutputInfo;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.JupyterAppBasedApi;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.jcef.JupyterCefDisplayHandler;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.jcef.JupyterCefDownloadHandler;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.jcef.JupyterCefJSDialogHandler;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.jcef.JupyterCefRequestHandler;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookOffScreenManager;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.messages.JupyterKernelToFrontEndApi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.jcef.JBCefClient;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDownloadHandler;
import org.cef.handler.CefJSDialogHandler;
import org.cef.handler.CefRequestHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H$J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001e\u001a\u00020\u0011J\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010 \u001a\u00020\u0011H$J\b\u0010!\u001a\u00020\nH&J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0011H\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputApi;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "_outputs", "", "", "Ljavax/swing/JComponent;", "outputs", "", "getOutputs", "()Ljava/util/Map;", "offScreenManager", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffScreenManager;", "getOffScreenManager", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffScreenManager;", "createOffscreenComponentImpl", "Lkotlin/Pair;", "output", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputInfo;", "dispose", "", "frontEndApi", "Lcom/intellij/jupyter/core/jupyter/messages/JupyterKernelToFrontEndApi;", "getFrontEndApi", "()Lcom/intellij/jupyter/core/jupyter/messages/JupyterKernelToFrontEndApi;", "initOffscreenManager", "createComponent", "createOffscreenManager", "createOutputId", "initHandlers", "manager", "disposeApi", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterWebOutputApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterWebOutputApi.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputApi\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n*L\n1#1,137:1\n68#2,6:138\n*S KotlinDebug\n*F\n+ 1 JupyterWebOutputApi.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputApi\n*L\n77#1:138,6\n*E\n"})
public abstract class JupyterWebOutputApi
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Map<String, JComponent> _outputs;
    @NotNull
    private static final Key<NotebookOffScreenManager> OFFSCREEN_MANAGER_KEY = new Key("NotebookOffscreenManager");
    @NotNull
    private static final Key<JupyterWebOutputApi> JUPYTER_WEB_OUTPUT_API_KEY = new Key("JupyterWebOutputApi");

    public JupyterWebOutputApi(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this._outputs = new LinkedHashMap();
    }

    @NotNull
    protected final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Map<String, JComponent> getOutputs() {
        return this._outputs;
    }

    @NotNull
    public final NotebookOffScreenManager getOffScreenManager() {
        NotebookOffScreenManager notebookOffScreenManager = (NotebookOffScreenManager)this.editor.getUserData(OFFSCREEN_MANAGER_KEY);
        if (notebookOffScreenManager == null) {
            throw new IllegalStateException("Call createOffscreenComponent first".toString());
        }
        return notebookOffScreenManager;
    }

    @Nullable
    protected abstract Pair<JComponent, Disposable> createOffscreenComponentImpl(@NotNull JupyterWebOutputInfo var1);

    public void dispose() {
    }

    @Nullable
    public abstract JupyterKernelToFrontEndApi getFrontEndApi();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NotebookOffScreenManager initOffscreenManager() {
        void $this$getOrCreateUserDataUnsafe$iv;
        UserDataHolder userDataHolder = (UserDataHolder)this.editor;
        Key<NotebookOffScreenManager> key$iv = OFFSCREEN_MANAGER_KEY;
        boolean $i$f$getOrCreateUserDataUnsafe = false;
        Object existing$iv = $this$getOrCreateUserDataUnsafe$iv.getUserData(key$iv);
        Object object = existing$iv;
        if (object == null) {
            NotebookOffScreenManager notebookOffScreenManager;
            boolean bl = false;
            NotebookOffScreenManager $this$initOffscreenManager_u24lambda_u240_u240 = notebookOffScreenManager = this.createOffscreenManager();
            boolean bl2 = false;
            Disposer.register((Disposable)this, (Disposable)$this$initOffscreenManager_u24lambda_u240_u240);
            this.initHandlers($this$initOffscreenManager_u24lambda_u240_u240);
            NotebookOffScreenManager value$iv = notebookOffScreenManager;
            $this$getOrCreateUserDataUnsafe$iv.putUserData(key$iv, (Object)value$iv);
            object = value$iv;
        }
        return (NotebookOffScreenManager)object;
    }

    @NotNull
    public final Pair<JComponent, Disposable> createComponent(@NotNull JupyterWebOutputInfo output) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.initOffscreenManager();
        Pair createdComponent = this.createOffscreenComponentImpl(output);
        if (createdComponent != null) {
            this._outputs.put(output.getId(), (JComponent)createdComponent.getFirst());
            Disposer.register((Disposable)((Disposable)createdComponent.getSecond()), () -> JupyterWebOutputApi.createComponent$lambda$0(this, output));
        }
        if ((pair = createdComponent) == null) {
            pair = new Pair((Object)new EmptyComponent(), (Object)Disposer.newDisposable());
        }
        return pair;
    }

    @NotNull
    protected abstract NotebookOffScreenManager createOffscreenManager();

    @NotNull
    public abstract String createOutputId();

    private final void initHandlers(NotebookOffScreenManager manager) {
        Project project = this.editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        CefBrowser cefBrowser = manager.getBrowser$intellij_jupyter_core().getCefBrowser();
        Intrinsics.checkNotNullExpressionValue((Object)cefBrowser, (String)"getCefBrowser(...)");
        CefBrowser cefBrowser2 = cefBrowser;
        JBCefClient jBCefClient = manager.getBrowser$intellij_jupyter_core().getJBCefClient();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefClient, (String)"getJBCefClient(...)");
        JBCefClient cefClient = jBCefClient;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull(this.editor);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        JupyterCefRequestHandler requestHandler = new JupyterCefRequestHandler(notebookFile.getNotebook());
        cefClient.addRequestHandler((CefRequestHandler)requestHandler, cefBrowser2);
        JupyterCefDisplayHandler displayHandler = new JupyterCefDisplayHandler();
        cefClient.addDisplayHandler((CefDisplayHandler)displayHandler, cefBrowser2);
        JupyterCefDownloadHandler downloadHandler = new JupyterCefDownloadHandler(project2);
        cefClient.addDownloadHandler((CefDownloadHandler)downloadHandler, cefBrowser2);
        JupyterCefJSDialogHandler dialogHandler = new JupyterCefJSDialogHandler();
        cefClient.addJSDialogHandler((CefJSDialogHandler)dialogHandler, cefBrowser2);
        Disposer.register((Disposable)manager, () -> JupyterWebOutputApi.initHandlers$lambda$0(cefClient, requestHandler, cefBrowser2, displayHandler, downloadHandler, dialogHandler));
    }

    public void disposeApi(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        DisposingKt.removeAndDisposeUserData((UserDataHolder)editor, OFFSCREEN_MANAGER_KEY);
    }

    private static final void createComponent$lambda$0(JupyterWebOutputApi this$0, JupyterWebOutputInfo $output) {
        this$0._outputs.remove($output.getId());
    }

    private static final void initHandlers$lambda$0(JBCefClient $cefClient, JupyterCefRequestHandler $requestHandler, CefBrowser $cefBrowser, JupyterCefDisplayHandler $displayHandler, JupyterCefDownloadHandler $downloadHandler, JupyterCefJSDialogHandler $dialogHandler) {
        $cefClient.removeRequestHandler((CefRequestHandler)$requestHandler, $cefBrowser);
        $cefClient.removeDisplayHandler((CefDisplayHandler)$displayHandler, $cefBrowser);
        $cefClient.removeDownloadHandle((CefDownloadHandler)$downloadHandler, $cefBrowser);
        $cefClient.removeJSDialogHandler((CefJSDialogHandler)$dialogHandler, $cefBrowser);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputApi$Companion;", "", "<init>", "()V", "OFFSCREEN_MANAGER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffScreenManager;", "getOFFSCREEN_MANAGER_KEY", "()Lcom/intellij/openapi/util/Key;", "JUPYTER_WEB_OUTPUT_API_KEY", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/JupyterWebOutputApi;", "reinstall", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "install", "get", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<NotebookOffScreenManager> getOFFSCREEN_MANAGER_KEY() {
            return OFFSCREEN_MANAGER_KEY;
        }

        public final void reinstall(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            JupyterWebOutputApi jupyterWebOutputApi = (JupyterWebOutputApi)editor.getUserData(JUPYTER_WEB_OUTPUT_API_KEY);
            if (jupyterWebOutputApi == null) {
                return;
            }
            JupyterWebOutputApi oldApi = jupyterWebOutputApi;
            oldApi.disposeApi((Editor)editor);
            Disposer.dispose((Disposable)oldApi);
            this.install(editor);
        }

        public final void install(@NotNull EditorImpl editor) {
            JupyterAppBasedApi jupyterAppBasedApi;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            JupyterAppBasedApi $this$install_u24lambda_u240 = jupyterAppBasedApi = new JupyterAppBasedApi((Editor)editor);
            boolean bl = false;
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)$this$install_u24lambda_u240);
            JupyterAppBasedApi api = jupyterAppBasedApi;
            editor.putUserData(JUPYTER_WEB_OUTPUT_API_KEY, (Object)api);
        }

        @NotNull
        public final JupyterWebOutputApi get(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Object object = editor.getUserData(JUPYTER_WEB_OUTPUT_API_KEY);
            Intrinsics.checkNotNull((Object)object);
            return (JupyterWebOutputApi)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

