/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.providers.local;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.models.WidgetEntryPoint;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.providers.common.BaseIPyWidgetScriptManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.providers.local.ScriptUriConverter;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterScriptUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0094@\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0014J\n\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\tH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/local/LocalIPyWidgetScriptManager;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/common/BaseIPyWidgetScriptManager;", "session", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;)V", "getSession", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "cachedNbExtensionsParentPath", "", "dispose", "", "onKernelRestarted", "getWidgetEntryPoints", "", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/models/WidgetEntryPoint;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getWidgetScriptSource", "uri", "getBaseUrl", "getNbExtensionsParentPath", "getNbExtensionsParentPathImpl", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nLocalIPyWidgetScriptManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalIPyWidgetScriptManager.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/local/LocalIPyWidgetScriptManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n23#2:70\n1563#3:71\n1634#3,3:72\n1#4:75\n*S KotlinDebug\n*F\n+ 1 LocalIPyWidgetScriptManager.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/scriptLoader/providers/local/LocalIPyWidgetScriptManager\n*L\n40#1:70\n41#1:71\n41#1:72,3\n*E\n"})
public final class LocalIPyWidgetScriptManager
extends BaseIPyWidgetScriptManager {
    @NotNull
    private final JupyterNotebookSession session;
    @Nullable
    private String cachedNbExtensionsParentPath;

    public LocalIPyWidgetScriptManager(@NotNull JupyterNotebookSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session);
        this.session = session;
    }

    @Override
    @NotNull
    protected JupyterNotebookSession getSession() {
        return this.session;
    }

    public void dispose() {
    }

    @Override
    public void onKernelRestarted() {
        this.cachedNbExtensionsParentPath = null;
        super.onKernelRestarted();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected Object getWidgetEntryPoints(@NotNull Continuation<? super List<WidgetEntryPoint>> $completion) {
        void $this$mapTo$iv$iv;
        String string = this.getNbExtensionsParentPath();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String nbExtensionsParentPath = string;
        Path path = Paths.get(nbExtensionsParentPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path nbExtensionsFolder = path.resolve("nbextensions");
        List extensions = new ArrayList();
        FileUtil.collectMatchedFiles((File)nbExtensionsFolder.toFile(), (Pattern)Pattern.compile(".*extension.js"), (List)extensions);
        LocalIPyWidgetScriptManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(LocalIPyWidgetScriptManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Found the next widget points: " + CollectionsKt.joinToString$default((Iterable)extensions, null, null, null, (int)0, null, LocalIPyWidgetScriptManager::getWidgetEntryPoints$lambda$0, (int)31, null), null);
        Iterable $this$map$iv = extensions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            collection.add(new WidgetEntryPoint(string2, nbExtensionsParentPath));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    protected String getWidgetScriptSource(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return FilesKt.readText$default((File)new File(uri), null, (int)1, null);
    }

    @Override
    @Nullable
    public String getBaseUrl() {
        String nbExtensionsParentPath;
        block1: {
            String string = this.getNbExtensionsParentPath();
            if (string == null) {
                return null;
            }
            nbExtensionsParentPath = string;
            BackedNotebookVirtualFile backedNotebookVirtualFile = this.getSession().getVirtualFile();
            if (backedNotebookVirtualFile == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getFile()) == null) break block1;
            Key<Path> key = ScriptUriConverter.Companion.getBASE_EXTENSION_PATH_KEY();
            Path path = Paths.get(nbExtensionsParentPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            backedNotebookVirtualFile.putUserData(key, path);
        }
        return nbExtensionsParentPath;
    }

    @Override
    @Nullable
    protected String getNbExtensionsParentPath() {
        if (this.cachedNbExtensionsParentPath == null) {
            this.cachedNbExtensionsParentPath = this.getNbExtensionsParentPathImpl();
        }
        return this.cachedNbExtensionsParentPath;
    }

    private final String getNbExtensionsParentPathImpl() {
        Path path;
        String string = JupyterScriptUtilsKt.getSdkHomePath(this.getSession());
        if (string == null) {
            return null;
        }
        String homePath = string;
        Path path2 = Paths.get(homePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path path3 = path2.getParent();
        if (path3 == null || (path3 = path3.getParent()) == null) {
            return null;
        }
        Path sdkPath = path3;
        Path it = path = sdkPath.resolve("share/jupyter");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        Path path4 = Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
        if (path4 == null) {
            return null;
        }
        Path jupyterPath = path4;
        return NioPathUtil.toCanonicalPath((Path)jupyterPath);
    }

    private static final CharSequence getWidgetEntryPoints$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getParent();
        return string != null ? (CharSequence)string : (CharSequence)"";
    }
}

