/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details.volume;

import com.intellij.docker.agent.util.UtilsKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerContainerRuntime;
import com.intellij.docker.runtimes.DockerVolumeRuntime;
import com.intellij.docker.ui.scaffold.Scaffold;
import com.intellij.docker.ui.scaffold.ScaffoldCellRenderer;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.view.details.DockerAbstractDashboardTab;
import com.intellij.docker.view.details.DockerTabManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0014J\b\u0010\u0015\u001a\u00020\u0013H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/view/details/volume/DockerVolumeDashboardTab;", "Lcom/intellij/docker/view/details/DockerAbstractDashboardTab;", "Lcom/intellij/docker/runtimes/DockerVolumeRuntime;", "tabManager", "Lcom/intellij/docker/view/details/DockerTabManager;", "runtime", "<init>", "(Lcom/intellij/docker/view/details/DockerTabManager;Lcom/intellij/docker/runtimes/DockerVolumeRuntime;)V", "myContainersModel", "Ljavax/swing/DefaultListModel;", "Lcom/intellij/docker/runtimes/DockerContainerRuntime;", "myLabelsModel", "Lkotlin/Pair;", "", "myIsInitialized", "", "createScaffold", "Lcom/intellij/docker/ui/scaffold/Scaffold;", "onRefreshTab", "", "selected", "refreshAttachedToContainer", "intellij.clouds.docker"})
public final class DockerVolumeDashboardTab
extends DockerAbstractDashboardTab<DockerVolumeRuntime> {
    @NotNull
    private final DefaultListModel<DockerContainerRuntime> myContainersModel;
    @NotNull
    private final DefaultListModel<Pair<String, String>> myLabelsModel;
    private volatile boolean myIsInitialized;

    public DockerVolumeDashboardTab(@NotNull DockerTabManager tabManager, @NotNull DockerVolumeRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)tabManager, (String)"tabManager");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        super(tabManager, runtime, null, 4, null);
        this.myContainersModel = new DefaultListModel();
        this.myLabelsModel = new DefaultListModel();
    }

    @Override
    @NotNull
    protected Scaffold createScaffold() {
        return new Scaffold(arg_0 -> DockerVolumeDashboardTab.createScaffold$lambda$0(this, arg_0));
    }

    @Override
    protected void onRefreshTab(boolean selected) {
        if (!this.myIsInitialized) {
            this.myIsInitialized = true;
            Object object = ((DockerVolumeRuntime)this.getRuntime()).getVolume().getLabels();
            this.myLabelsModel.addAll(object != null && (object = MapsKt.toList((Map)object)) != null ? (Collection)object : (Collection)CollectionsKt.emptyList());
        }
        this.refreshAttachedToContainer();
    }

    private final void refreshAttachedToContainer() {
        List attachedToNow = UtilsKt.nullize(((DockerVolumeRuntime)this.getRuntime()).getAttachedContainers());
        if (attachedToNow == null) {
            this.myContainersModel.clear();
        } else if (!this.myContainersModel.contains(attachedToNow)) {
            this.myContainersModel.clear();
            this.myContainersModel.addAll(attachedToNow);
        }
    }

    private static final Unit createScaffold$lambda$0(DockerVolumeDashboardTab this$0, Scaffold $this$Scaffold) {
        Intrinsics.checkNotNullParameter((Object)$this$Scaffold, (String)"$this$Scaffold");
        $this$Scaffold.segment((ListModel)this$0.myContainersModel, DockerVolumeDashboardTab::createScaffold$lambda$0$0);
        $this$Scaffold.segment((ListModel)this$0.myLabelsModel, DockerVolumeDashboardTab::createScaffold$lambda$0$1);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$0$0(Scaffold.SegmentWithElements $this$segment) {
        Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
        $this$segment.textFragment(DockerVolumeDashboardTab::createScaffold$lambda$0$0$0);
        $this$segment.setCellRenderer(DockerVolumeDashboardTab::createScaffold$lambda$0$0$1);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$0$0$0(Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        $this$textFragment.append(DockerBundle.message((String)"DockerNetworkDetails.ContainersEditor.title", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$0$0$1(ScaffoldCellRenderer scaffoldCellRenderer, DockerContainerRuntime container) {
        Intrinsics.checkNotNullParameter((Object)scaffoldCellRenderer, (String)"<this>");
        scaffoldCellRenderer.setIcon(container.getStatus().getIcon());
        String string = container.getPresentableName();
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"LINK_PLAIN_ATTRIBUTES");
        scaffoldCellRenderer.append(string, simpleTextAttributes, () -> DockerVolumeDashboardTab.createScaffold$lambda$0$0$1$0(container));
        return Unit.INSTANCE;
    }

    private static final void createScaffold$lambda$0$0$1$0(DockerContainerRuntime $container) {
        Intrinsics.checkNotNull((Object)$container);
        DockerUiUtilsKt.select($container);
    }

    private static final Unit createScaffold$lambda$0$1(Scaffold.SegmentWithElements $this$segment) {
        Intrinsics.checkNotNullParameter((Object)$this$segment, (String)"$this$segment");
        $this$segment.textFragment(DockerVolumeDashboardTab::createScaffold$lambda$0$1$0);
        $this$segment.setCellRenderer(DockerVolumeDashboardTab::createScaffold$lambda$0$1$1);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$0$1$0(Scaffold.SimpleSegment.TextFragment $this$textFragment) {
        Intrinsics.checkNotNullParameter((Object)$this$textFragment, (String)"$this$textFragment");
        $this$textFragment.append(DockerBundle.message((String)"DockerRuntimeLabelsTab.tab.title", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final Unit createScaffold$lambda$0$1$1(ScaffoldCellRenderer scaffoldCellRenderer, Pair it) {
        Intrinsics.checkNotNullParameter((Object)scaffoldCellRenderer, (String)"<this>");
        scaffoldCellRenderer.append(DockerUiUtilsKt.asNlsSafe((String)it.getFirst()));
        scaffoldCellRenderer.append(" = ");
        String string = DockerUiUtilsKt.asNlsSafe((String)it.getSecond());
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_BOLD_ATTRIBUTES");
        scaffoldCellRenderer.append(string, simpleTextAttributes);
        return Unit.INSTANCE;
    }
}

