/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.AsyncHandlerRootNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

public class AsyncIteratorCloseNode
extends JavaScriptBaseNode {
    private static final HiddenKey PROMISE_ID = new HiddenKey("promise");
    private static final HiddenKey COMPLETION_ID = new HiddenKey("completion");
    @Node.Child
    private GetMethodNode getReturnNode;
    @Node.Child
    private JSFunctionCallNode methodCallNode;
    @Node.Child
    private PropertyGetNode getConstructorNode;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapabilityNode;
    @Node.Child
    private JSFunctionCallNode callNode;
    @Node.Child
    private PropertySetNode setPromiseNode;
    @Node.Child
    private PropertySetNode setCompletionNode;
    @Node.Child
    private PerformPromiseThenNode performPromiseThenNode;
    private final JSContext context;

    protected AsyncIteratorCloseNode(JSContext context) {
        this.context = context;
        this.getReturnNode = GetMethodNode.create(context, Strings.RETURN);
        this.getConstructorNode = PropertyGetNode.create(JSObject.CONSTRUCTOR, context);
        this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
        this.setCompletionNode = PropertySetNode.createSetHidden(COMPLETION_ID, context);
        this.setPromiseNode = PropertySetNode.createSetHidden(PROMISE_ID, context);
        this.callNode = JSFunctionCallNode.createCall();
        this.methodCallNode = JSFunctionCallNode.createCall();
        this.performPromiseThenNode = PerformPromiseThenNode.create(context);
    }

    public static AsyncIteratorCloseNode create(JSContext context) {
        return new AsyncIteratorCloseNode(context);
    }

    public final Object execute(Object iterator, Object outerResult) {
        Object returnMethod = this.getReturnNode.executeWithTarget(iterator);
        if (returnMethod != Undefined.instance) {
            Object innerResult = this.methodCallNode.executeCall(JSArguments.createZeroArg(iterator, returnMethod));
            JSPromiseObject promise = this.promiseResolve(innerResult);
            return this.performPromiseThenNode.execute(promise, this.createCloseFunction(promise, outerResult), Undefined.instance, this.newPromiseCapabilityNode.executeDefault());
        }
        return outerResult;
    }

    public final Object executeAbrupt(Object iterator, Object error) {
        try {
            Object returnMethod = this.getReturnNode.executeWithTarget(iterator);
            if (returnMethod != Undefined.instance) {
                Object innerResult = this.methodCallNode.executeCall(JSArguments.createZeroArg(iterator, returnMethod));
                JSPromiseObject promise = this.promiseResolve(innerResult);
                JSFunctionObject finallyFunction = this.createCloseAbruptFunction(promise, error);
                return this.performPromiseThenNode.execute(promise, finallyFunction, finallyFunction, this.newPromiseCapabilityNode.executeDefault());
            }
        }
        catch (AbstractTruffleException abstractTruffleException) {
            // empty catch block
        }
        return error;
    }

    private JSPromiseObject promiseResolve(Object promiseOrValue) {
        if (JSPromise.isJSPromise(promiseOrValue) && this.getConstructorNode.getValueOrDefault(promiseOrValue, Undefined.instance) == this.getRealm().getPromiseConstructor()) {
            return (JSPromiseObject)promiseOrValue;
        }
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapabilityNode.executeDefault();
        this.callNode.executeCall(JSArguments.createOneArg(promiseCapability.getPromise(), promiseCapability.getResolve(), promiseOrValue));
        return (JSPromiseObject)promiseCapability.getPromise();
    }

    public JSFunctionObject createCloseFunction(JSDynamicObject promise, Object completion) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncIteratorClose, AsyncIteratorCloseNode::createCloseFunctionImpl);
        JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
        this.setPromiseNode.setValue(function, promise);
        this.setCompletionNode.setValue(function, completion);
        return function;
    }

    public JSFunctionObject createCloseAbruptFunction(JSDynamicObject promise, Object completion) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncIteratorCloseAbrupt, AsyncIteratorCloseNode::createCloseAbruptFunctionImpl);
        JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
        this.setPromiseNode.setValue(function, promise);
        this.setCompletionNode.setValue(function, completion);
        return function;
    }

    private static JSFunctionData createCloseFunctionImpl(JSContext context) {
        return JSFunctionData.createCallOnly(context, new AsyncIteratorCloseRootNode(context, false).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    private static JSFunctionData createCloseAbruptFunctionImpl(JSContext context) {
        return JSFunctionData.createCallOnly(context, new AsyncIteratorCloseRootNode(context, true).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    public static class AsyncIteratorCloseRootNode
    extends JavaScriptRootNode
    implements AsyncHandlerRootNode {
        @Node.Child
        protected JavaScriptNode valueNode;
        @Node.Child
        private PropertyGetNode getCompletionNode;
        @Node.Child
        private IsObjectNode isObjectNode;
        private final boolean isAbrupt;

        AsyncIteratorCloseRootNode(JSContext context, boolean isAbrupt) {
            this.isAbrupt = isAbrupt;
            this.getCompletionNode = PropertyGetNode.createGetHidden(COMPLETION_ID, context);
            if (!isAbrupt) {
                this.valueNode = AccessIndexedArgumentNode.create(0);
                this.isObjectNode = IsObjectNode.create();
            }
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object completion = this.getCompletionNode.getValue(JSFrameUtil.getFunctionObject(frame));
            if (this.isAbrupt) {
                return completion;
            }
            Object innerResult = this.valueNode.execute(frame);
            if (!this.isObjectNode.executeBoolean(innerResult)) {
                throw Errors.createTypeErrorIterResultNotAnObject(innerResult, this);
            }
            return completion;
        }

        @Override
        public AsyncHandlerRootNode.AsyncStackTraceInfo getAsyncStackTraceInfo(JSFunctionObject handlerFunction) {
            assert (JSFunction.isJSFunction(handlerFunction) && ((RootCallTarget)JSFunction.getFunctionData(handlerFunction).getCallTarget()).getRootNode() == this);
            JSDynamicObject promise = (JSDynamicObject)JSObjectUtil.getHiddenProperty(handlerFunction, PROMISE_ID);
            return new AsyncHandlerRootNode.AsyncStackTraceInfo(promise, null);
        }
    }
}

