/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.transform;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.FunTransform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0010\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\r\u001a\u0004\u0018\u00010\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0017\u0010\u0017\u001a\u00020\u00162\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/LogTransform;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/FunTransform;", "base", "", "(D)V", "lowerLimTransformed", "getLowerLimTransformed", "()D", "lowerLimTransformed$delegate", "Lkotlin/Lazy;", "upperLimTransformed", "getUpperLimTransformed", "upperLimTransformed$delegate", "apply", "v", "(Ljava/lang/Double;)Ljava/lang/Double;", "applyInverse", "createApplicableDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "middle", "(Ljava/lang/Double;)Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "hasDomainLimits", "", "isInDomain", "(Ljava/lang/Double;)Z", "toApplicableDomain", "range", "Companion", "plot-base"})
public class LogTransform
extends FunTransform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double base;
    @NotNull
    private final Lazy lowerLimTransformed$delegate;
    @NotNull
    private final Lazy upperLimTransformed$delegate;
    public static final double UPPER_LIM_DOMAIN = 1.7976931348623158E303;
    public static final double LOWER_LIM_DOMAIN = 4.94066E-319;

    public LogTransform(final double base) {
        super((Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(){

            @NotNull
            public final Double invoke(double v) {
                return MathKt.log((double)v, (double)base);
            }
        }), (Function1<? super Double, Double>)((Function1)new Function1<Double, Double>(){

            @NotNull
            public final Double invoke(double v) {
                return Math.pow(base, v);
            }
        }));
        this.base = base;
        this.lowerLimTransformed$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ LogTransform this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Double invoke() {
                return LogTransform.Companion.calcLowerLimTransformed$plot_base(this.this$0.getTransformFun());
            }
        }));
        this.upperLimTransformed$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Double>(this){
            final /* synthetic */ LogTransform this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Double invoke() {
                return LogTransform.Companion.calcUpperLimTransformed$plot_base(this.this$0.getTransformFun());
            }
        }));
    }

    private final double getLowerLimTransformed() {
        Lazy lazy = this.lowerLimTransformed$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    private final double getUpperLimTransformed() {
        Lazy lazy = this.upperLimTransformed$delegate;
        return ((Number)lazy.getValue()).doubleValue();
    }

    @Override
    public boolean hasDomainLimits() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInDomain(@Nullable Double v) {
        if (!SeriesUtil.INSTANCE.isFinite(v)) return false;
        Double d = v;
        Intrinsics.checkNotNull((Object)d);
        if (!(d >= 4.94066E-319)) return false;
        if (!(v <= 1.7976931348623158E303)) return false;
        return true;
    }

    @Override
    @Nullable
    public Double apply(@Nullable Double v) {
        Double d;
        Double transformedValue = super.apply(v);
        if (transformedValue == null) {
            d = null;
        } else if (Double.isNaN(transformedValue)) {
            d = Double.NaN;
        } else {
            double d2 = this.getUpperLimTransformed();
            double d3 = transformedValue;
            double d4 = Math.max(this.getLowerLimTransformed(), d3);
            d = Math.min(d2, d4);
        }
        return d;
    }

    @Override
    @Nullable
    public Double applyInverse(@Nullable Double v) {
        Double d;
        Double d2 = v;
        if (d2 != null) {
            double d3 = Math.max(d2, this.getLowerLimTransformed());
            double d4 = this.getUpperLimTransformed();
            d = Math.min(d3, d4);
        } else {
            d = null;
        }
        Double v2 = d;
        return super.applyInverse(v2);
    }

    @Override
    @NotNull
    public DoubleSpan createApplicableDomain(@Nullable Double middle) {
        double middle2 = middle == null ? 1.0 : (this.isInDomain(middle) ? middle : (middle >= 0.0 && middle < 4.94066E-319 ? 4.94066E-319 : (middle > 1.7976931348623158E303 ? 1.7976931348623158E303 : 1.0)));
        double lower2 = middle2 < 1.0 ? middle2 / (double)2 : middle2 - 0.5;
        return new DoubleSpan(Math.max(lower2, 4.94066E-319), middle2 + 0.5);
    }

    @Override
    @NotNull
    public DoubleSpan toApplicableDomain(@NotNull DoubleSpan range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        double lower2 = Math.max(range.getLowerEnd(), 4.94066E-319);
        double upper2 = Math.max(range.getUpperEnd(), lower2);
        return new DoubleSpan(Math.min(lower2, 1.7976931348623158E303), Math.min(upper2, 1.7976931348623158E303));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0006\u001a\u00020\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bH\u0000\u00a2\u0006\u0002\b\tJ!\u0010\n\u001a\u00020\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bH\u0000\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/LogTransform$Companion;", "", "()V", "LOWER_LIM_DOMAIN", "", "UPPER_LIM_DOMAIN", "calcLowerLimTransformed", "transformFun", "Lkotlin/Function1;", "calcLowerLimTransformed$plot_base", "calcUpperLimTransformed", "calcUpperLimTransformed$plot_base", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public final double calcLowerLimTransformed$plot_base(@NotNull Function1<? super Double, Double> transformFun) {
            Intrinsics.checkNotNullParameter(transformFun, (String)"transformFun");
            return ((Number)transformFun.invoke((Object)4.94066E-319)).doubleValue();
        }

        public final double calcUpperLimTransformed$plot_base(@NotNull Function1<? super Double, Double> transformFun) {
            Intrinsics.checkNotNullParameter(transformFun, (String)"transformFun");
            return ((Number)transformFun.invoke((Object)1.7976931348623158E303)).doubleValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

