/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.MarginSide;
import org.jetbrains.letsPlot.core.plot.builder.MarginalLayerUtil;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tR\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "", "left", "", "top", "right", "bottom", "(DDDD)V", "toAxisOrigin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "geomInnerBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "axisOrientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "isPolarCoordinateSystem", "", "panelInset", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "toInnerBounds", "outer", "toInnerSize", "toOuterBounds", "inner", "toOuterSize", "Companion", "plot-builder"})
public final class GeomMarginsLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double left;
    private final double top;
    private final double right;
    private final double bottom;

    public GeomMarginsLayout(double left, double top, double right, double bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    @NotNull
    public final DoubleVector toInnerSize(@NotNull DoubleVector outer) {
        Intrinsics.checkNotNullParameter((Object)outer, (String)"outer");
        DoubleVector lt = new DoubleVector(outer.getX() * this.left, outer.getY() * this.top);
        DoubleVector rb = new DoubleVector(outer.getX() * this.right, outer.getY() * this.bottom);
        return outer.subtract(lt).subtract(rb);
    }

    @NotNull
    public final DoubleRectangle toInnerBounds(@NotNull DoubleRectangle outer) {
        Intrinsics.checkNotNullParameter((Object)outer, (String)"outer");
        DoubleVector lt = new DoubleVector(outer.getWidth() * this.left, outer.getHeight() * this.top);
        return new DoubleRectangle(outer.getOrigin().add(lt), this.toInnerSize(outer.getDimension()));
    }

    @NotNull
    public final DoubleVector toOuterSize(@NotNull DoubleVector inner) {
        Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
        double outerWidth = inner.getX() / (1.0 - (this.left + this.right));
        double outerHeight = inner.getY() / (1.0 - (this.top + this.bottom));
        return new DoubleVector(outerWidth, outerHeight);
    }

    @NotNull
    public final DoubleRectangle toOuterBounds(@NotNull DoubleRectangle inner) {
        Intrinsics.checkNotNullParameter((Object)inner, (String)"inner");
        DoubleVector outerSize = this.toOuterSize(inner.getDimension());
        DoubleVector lt = new DoubleVector(outerSize.getX() * this.left, outerSize.getY() * this.top);
        return new DoubleRectangle(inner.getOrigin().subtract(lt), outerSize);
    }

    @NotNull
    public final DoubleVector toAxisOrigin(@NotNull DoubleRectangle geomInnerBounds, @NotNull Orientation axisOrientation, boolean isPolarCoordinateSystem, @NotNull Thickness panelInset) {
        DoubleVector doubleVector;
        block12: {
            DoubleRectangle outerBounds;
            block11: {
                Intrinsics.checkNotNullParameter((Object)geomInnerBounds, (String)"geomInnerBounds");
                Intrinsics.checkNotNullParameter((Object)((Object)axisOrientation), (String)"axisOrientation");
                Intrinsics.checkNotNullParameter((Object)panelInset, (String)"panelInset");
                outerBounds = this.toOuterBounds(geomInnerBounds);
                if (!isPolarCoordinateSystem) break block11;
                switch (WhenMappings.$EnumSwitchMapping$0[axisOrientation.ordinal()]) {
                    case 1: {
                        doubleVector = new DoubleVector(outerBounds.getLeft(), geomInnerBounds.getTop() + panelInset.getTop());
                        break block12;
                    }
                    case 2: {
                        doubleVector = new DoubleVector(geomInnerBounds.getLeft(), geomInnerBounds.getTop());
                        break block12;
                    }
                    case 3: 
                    case 4: {
                        throw new IllegalStateException("Polar coordinate system does not support top and right axis orientation".toString());
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[axisOrientation.ordinal()]) {
                case 1: {
                    doubleVector = new DoubleVector(outerBounds.getLeft(), geomInnerBounds.getTop() + panelInset.getTop());
                    break;
                }
                case 3: {
                    doubleVector = geomInnerBounds.getOrigin().add(new DoubleVector(panelInset.getLeft(), 0.0));
                    break;
                }
                case 4: {
                    doubleVector = new DoubleVector(geomInnerBounds.getRight(), geomInnerBounds.getTop() + panelInset.getTop());
                    break;
                }
                case 2: {
                    doubleVector = new DoubleVector(geomInnerBounds.getLeft() + panelInset.getLeft(), outerBounds.getBottom());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return doubleVector;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout$Companion;", "", "()V", "create", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "marginalLayers", "", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nGeomMarginsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeomMarginsLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GeomMarginsLayout create(@NotNull List<? extends GeomLayer> marginalLayers) {
            Double d;
            Double d2;
            Double d3;
            Double d4;
            Intrinsics.checkNotNullParameter(marginalLayers, (String)"marginalLayers");
            Map<MarginSide, List<GeomLayer>> marginalLayersByMargin = MarginalLayerUtil.INSTANCE.marginalLayersByMargin(marginalLayers);
            List<GeomLayer> list2 = marginalLayersByMargin.get((Object)MarginSide.LEFT);
            if (list2 != null) {
                Iterator iterator2 = ((Iterable)list2).iterator();
                if (!iterator2.hasNext()) {
                    d4 = null;
                } else {
                    GeomLayer it = (GeomLayer)iterator2.next();
                    boolean bl = false;
                    double d5 = it.getMarginalSize();
                    while (iterator2.hasNext()) {
                        GeomLayer it2 = (GeomLayer)iterator2.next();
                        $i$a$-maxOfOrNull-GeomMarginsLayout$Companion$create$left$1 = false;
                        double d6 = it2.getMarginalSize();
                        d5 = Math.max(d5, d6);
                    }
                    d4 = d5;
                }
            } else {
                d4 = null;
            }
            Double left = d4;
            List<GeomLayer> list3 = marginalLayersByMargin.get((Object)MarginSide.TOP);
            if (list3 != null) {
                Iterator iterator3 = ((Iterable)list3).iterator();
                if (!iterator3.hasNext()) {
                    d3 = null;
                } else {
                    GeomLayer it = (GeomLayer)iterator3.next();
                    boolean bl = false;
                    double d7 = it.getMarginalSize();
                    while (iterator3.hasNext()) {
                        GeomLayer it3 = (GeomLayer)iterator3.next();
                        $i$a$-maxOfOrNull-GeomMarginsLayout$Companion$create$top$1 = false;
                        double d8 = it3.getMarginalSize();
                        d7 = Math.max(d7, d8);
                    }
                    d3 = d7;
                }
            } else {
                d3 = null;
            }
            Double top = d3;
            List<GeomLayer> list4 = marginalLayersByMargin.get((Object)MarginSide.RIGHT);
            if (list4 != null) {
                Iterator iterator4 = ((Iterable)list4).iterator();
                if (!iterator4.hasNext()) {
                    d2 = null;
                } else {
                    GeomLayer it = (GeomLayer)iterator4.next();
                    boolean bl = false;
                    double it2 = it.getMarginalSize();
                    while (iterator4.hasNext()) {
                        GeomLayer it4 = (GeomLayer)iterator4.next();
                        $i$a$-maxOfOrNull-GeomMarginsLayout$Companion$create$right$1 = false;
                        double d9 = it4.getMarginalSize();
                        it2 = Math.max(it2, d9);
                    }
                    d2 = it2;
                }
            } else {
                d2 = null;
            }
            Double right = d2;
            List<GeomLayer> list5 = marginalLayersByMargin.get((Object)MarginSide.BOTTOM);
            if (list5 != null) {
                Iterator iterator5 = ((Iterable)list5).iterator();
                if (!iterator5.hasNext()) {
                    d = null;
                } else {
                    GeomLayer it = (GeomLayer)iterator5.next();
                    boolean bl = false;
                    double d10 = it.getMarginalSize();
                    while (iterator5.hasNext()) {
                        GeomLayer it5 = (GeomLayer)iterator5.next();
                        $i$a$-maxOfOrNull-GeomMarginsLayout$Companion$create$bottom$1 = false;
                        double d11 = it5.getMarginalSize();
                        d10 = Math.max(d10, d11);
                    }
                    d = d10;
                }
            } else {
                d = null;
            }
            Double bottom = d;
            Double d12 = left;
            Double d13 = top;
            Double d14 = right;
            Double d15 = bottom;
            return new GeomMarginsLayout(d12 != null ? d12 : 0.0, d13 != null ? d13 : 0.0, d14 != null ? d14 : 0.0, d15 != null ? d15 : 0.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

