/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.nodejs.execution.NodeRunProgramRunner;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.nodejs.mocha.coverage.MochaCoverageRunState;
import com.jetbrains.nodejs.mocha.coverage.MochaCoverageRunner;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunProfileState;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

final class MochaCoverageProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    private static final Logger LOG = Logger.getInstance(MochaCoverageProgramRunner.class);
    private static final String COVERAGE_RUNNER_ID = MochaCoverageProgramRunner.class.getSimpleName();

    MochaCoverageProgramRunner() {
    }

    @NotNull
    public String getRunnerId() {
        String string = COVERAGE_RUNNER_ID;
        if (string == null) {
            MochaCoverageProgramRunner.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            MochaCoverageProgramRunner.$$$reportNull$$$0(1);
        }
        if (profile == null) {
            MochaCoverageProgramRunner.$$$reportNull$$$0(2);
        }
        return "Coverage".equals(executorId) && profile instanceof MochaRunConfiguration;
    }

    public RunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        if (settingsProvider == null) {
            MochaCoverageProgramRunner.$$$reportNull$$$0(3);
        }
        return new CoverageRunnerData();
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(final @NotNull ExecutionEnvironment environment, final @NotNull RunProfileState state) throws ExecutionException {
        if (environment == null) {
            MochaCoverageProgramRunner.$$$reportNull$$$0(4);
        }
        if (state == null) {
            MochaCoverageProgramRunner.$$$reportNull$$$0(5);
        }
        Promise promise = NodeRunProgramRunner.Companion.execute(state, environment).onSuccess(descriptor -> {
            if (descriptor != null) {
                final ProcessHandler processHandler = Objects.requireNonNull(descriptor.getProcessHandler());
                processHandler.addProcessListener(new ProcessListener(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().invokeLater(() -> MochaCoverageProgramRunner.updateCoverageView(environment, (MochaRunProfileState)state, NodeTargetRun.getTargetRun((ProcessHandler)processHandler)), environment.getProject().getDisposed());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/nodejs/mocha/coverage/MochaCoverageProgramRunner$1", "processTerminated"));
                    }
                });
            }
        });
        if (promise == null) {
            MochaCoverageProgramRunner.$$$reportNull$$$0(6);
        }
        return promise;
    }

    private static void updateCoverageView(@NotNull ExecutionEnvironment env, @NotNull MochaRunProfileState mochaState, @Nullable NodeTargetRun targetRun) {
        if (env == null) {
            MochaCoverageProgramRunner.$$$reportNull$$$0(7);
        }
        if (mochaState == null) {
            MochaCoverageProgramRunner.$$$reportNull$$$0(8);
        }
        RunConfigurationBase runConfiguration = (RunConfigurationBase)env.getRunProfile();
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        CoverageHelper.resetCoverageSuit((RunConfigurationBase)runConfiguration);
        String coverageFilePath = coverageEnabledConfiguration.getCoverageFilePath();
        if (coverageFilePath == null) {
            return;
        }
        MochaCoverageRunState coverageRunState = Objects.requireNonNull(mochaState.getCoverageRunState());
        File coverageDir = Objects.requireNonNull(coverageRunState.getCoverageDir());
        File lcovFile = new File(coverageDir, "lcov.info");
        if (!lcovFile.isFile()) {
            LOG.warn("Cannot find " + lcovFile.getAbsolutePath());
            return;
        }
        try {
            FileUtil.copy((File)lcovFile, (File)new File(coverageFilePath));
        }
        catch (IOException e) {
            LOG.error("Cannot copy " + lcovFile.getAbsolutePath() + " to " + coverageFilePath, (Throwable)e);
            return;
        }
        RunnerSettings runnerSettings = env.getRunnerSettings();
        if (runnerSettings != null) {
            MochaCoverageRunner coverageRunner = MochaCoverageRunner.getInstance();
            coverageRunner.setWorkingDirectory(mochaState.getRunSettings().getWorkingDir());
            coverageRunner.setTargetRun(targetRun);
            CoverageDataManager.getInstance((Project)env.getProject()).processGatheredCoverage(runConfiguration, runnerSettings);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/coverage/MochaCoverageProgramRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mochaState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/coverage/MochaCoverageProgramRunner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateCoverageView";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

