/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic.ui.server;

import com.intellij.ml.inline.completion.MLCompletionMessageBundle;
import com.intellij.ml.inline.completion.impl.diagnostic.ConnectionAddress;
import com.intellij.ml.inline.completion.impl.diagnostic.GrpcChannelState;
import com.intellij.ml.inline.completion.impl.diagnostic.NativeServerMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.NativeServerPayload;
import com.intellij.ml.inline.completion.impl.diagnostic.ProcessStarted;
import com.intellij.ml.inline.completion.impl.diagnostic.ProcessTerminated;
import com.intellij.ml.inline.completion.impl.id.NativeServerId;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/server/NativeServerDiagnostic;", "", "nativeServerId", "Lcom/intellij/ml/inline/completion/impl/id/NativeServerId;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/id/NativeServerId;)V", "getNativeServerId", "()Lcom/intellij/ml/inline/completion/impl/id/NativeServerId;", "title", "", "getTitle", "()Ljava/lang/String;", "processState", "Lcom/intellij/ui/SimpleColoredComponent;", "Lorg/jetbrains/annotations/NotNull;", "getProcessState", "()Lcom/intellij/ui/SimpleColoredComponent;", "grpcChannelState", "getGrpcChannelState", "address", "getAddress", "onMessage", "", "message", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NativeServerMessage;", "Companion", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\nNativeServerDiagnostic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeServerDiagnostic.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/ui/server/NativeServerDiagnostic\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class NativeServerDiagnostic {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private final NativeServerId nativeServerId;
    @NotNull
    private final String title;
    @NotNull
    private final SimpleColoredComponent processState;
    @NotNull
    private final SimpleColoredComponent grpcChannelState;
    @NotNull
    private final SimpleColoredComponent address;
    @Deprecated
    @NlsSafe
    @NotNull
    public static final String processStateLabel = "Process state: ";
    @NotNull
    private static final SimpleTextAttributes goodAttributes;
    @NotNull
    private static final SimpleTextAttributes badAttributes;

    public NativeServerDiagnostic(@NotNull NativeServerId nativeServerId) {
        Intrinsics.checkNotNullParameter((Object)nativeServerId, (String)"nativeServerId");
        this.nativeServerId = nativeServerId;
        this.title = "Native Server " + this.nativeServerId.getValue();
        Object[] objectArray = new Object[]{processStateLabel};
        SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent().append(MLCompletionMessageBundle.message("ml.completion.diagnostics.native.server.is.not.started", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent, (String)"append(...)");
        this.processState = simpleColoredComponent;
        this.grpcChannelState = new SimpleColoredComponent();
        this.address = new SimpleColoredComponent();
    }

    @NotNull
    public final NativeServerId getNativeServerId() {
        return this.nativeServerId;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final SimpleColoredComponent getProcessState() {
        return this.processState;
    }

    @NotNull
    public final SimpleColoredComponent getGrpcChannelState() {
        return this.grpcChannelState;
    }

    @NotNull
    public final SimpleColoredComponent getAddress() {
        return this.address;
    }

    public final void onMessage(@NotNull NativeServerMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        NativeServerPayload payload = message.getPayload();
        if (payload instanceof GrpcChannelState) {
            this.grpcChannelState.clear();
            Object[] objectArray = new Object[]{((GrpcChannelState)payload).getState()};
            SimpleColoredComponent simpleColoredComponent = this.grpcChannelState.append(MLCompletionMessageBundle.message("ml.completion.diagnostics.native.server.grpc.channel.state", objectArray));
            Intrinsics.checkNotNull((Object)simpleColoredComponent);
        } else if (payload instanceof ProcessStarted) {
            this.processState.clear();
            this.processState.append(processStateLabel);
            this.processState.append(MLCompletionMessageBundle.message("ml.completion.diagnostics.native.server.started", new Object[0]), goodAttributes);
        } else if (payload instanceof ProcessTerminated) {
            this.processState.clear();
            this.processState.append(processStateLabel);
            Object[] objectArray = new Object[]{((ProcessTerminated)payload).getExitCode()};
            this.processState.append(MLCompletionMessageBundle.message("ml.completion.diagnostics.native.server.terminated.with", objectArray), badAttributes);
        } else if (payload instanceof ConnectionAddress) {
            this.address.clear();
            Object[] objectArray = new Object[]{((ConnectionAddress)payload).getHostname(), String.valueOf(((ConnectionAddress)payload).getPort())};
            SimpleColoredComponent simpleColoredComponent = this.address.append(MLCompletionMessageBundle.message("ml.completion.diagnostics.native.server.address", objectArray));
            Intrinsics.checkNotNull((Object)simpleColoredComponent);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    static {
        TextAttributes textAttributes;
        Companion = new Companion(null);
        TextAttributes $this$goodAttributes_u24lambda_u240 = textAttributes = new TextAttributes();
        boolean bl = false;
        $this$goodAttributes_u24lambda_u240.setForegroundColor((Color)JBColor.GREEN);
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"fromTextAttributes(...)");
        goodAttributes = simpleTextAttributes;
        TextAttributes $this$badAttributes_u24lambda_u240 = textAttributes = new TextAttributes();
        boolean bl2 = false;
        $this$badAttributes_u24lambda_u240.setForegroundColor((Color)JBColor.RED);
        SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"fromTextAttributes(...)");
        badAttributes = simpleTextAttributes2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/ui/server/NativeServerDiagnostic$Companion;", "", "<init>", "()V", "processStateLabel", "", "goodAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "Lorg/jetbrains/annotations/NotNull;", "getGoodAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "badAttributes", "getBadAttributes", "intellij.fullLine.core.completion"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SimpleTextAttributes getGoodAttributes() {
            return goodAttributes;
        }

        @NotNull
        public final SimpleTextAttributes getBadAttributes() {
            return badAttributes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

