/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.impl.local.files;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.completion.full.line.LocalModelDescriptor;
import org.jetbrains.completion.full.line.LocalModelDescriptorKt;
import org.jetbrains.completion.full.line.impl.local.HostApi;
import org.jetbrains.completion.full.line.impl.local.files.LocalModelsFilesService;
import org.jetbrains.completion.full.line.local.ModelSchema;
import org.jetbrains.completion.full.line.local.ModelSchemaKt;
import org.jetbrains.completion.full.line.local.NativeServerSchema;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/completion/full/line/impl/local/files/LocalModelsBundleManager;", "", "<init>", "()V", "isBundled", "", "descriptor", "Lorg/jetbrains/completion/full/line/LocalModelDescriptor;", "unpackBundled", "Lorg/jetbrains/completion/full/line/local/ModelSchema;", "hasBundledServerWithSameVersion", "nativeSchema", "Lorg/jetbrains/completion/full/line/local/NativeServerSchema;", "unpackBundledServer", "Ljava/io/File;", "schema", "unpackBundledFromLib", "extractBundledNativeServer", "destination", "getBundledServerFile", "getFileFromZip", "", "zipFilePath", "name", "", "getFileURL", "Ljava/net/URL;", "tag", "version", "file", "Companion", "intellij.fullLine.core.impl"})
@SourceDebugExtension(value={"SMAP\nLocalModelsBundleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalModelsBundleManager.kt\norg/jetbrains/completion/full/line/impl/local/files/LocalModelsBundleManager\n+ 2 converter.kt\norg/jetbrains/completion/full/line/impl/local/ConverterKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,132:1\n13#2,2:133\n13#2,2:139\n1#3:135\n1869#4,2:136\n1869#4,2:141\n23#5:138\n127#6,2:143\n*S KotlinDebug\n*F\n+ 1 LocalModelsBundleManager.kt\norg/jetbrains/completion/full/line/impl/local/files/LocalModelsBundleManager\n*L\n34#1:133,2\n89#1:139,2\n49#1:136,2\n95#1:141,2\n70#1:138\n119#1:143,2\n*E\n"})
public final class LocalModelsBundleManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isBundled(@NotNull LocalModelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String tag = descriptor.tag();
        File file = PluginPathManager.getPluginResource(this.getClass(), (String)("full-line-model-" + tag + ".zip"));
        return file != null ? file.exists() : false;
    }

    @Nullable
    public final ModelSchema unpackBundled(@NotNull LocalModelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String tag = descriptor.tag();
        File file = PluginPathManager.getPluginResource(this.getClass(), (String)("full-line-model-" + tag + ".zip"));
        if (file == null) {
            return null;
        }
        File bundleModelFile = file;
        if (!bundleModelFile.exists()) {
            return null;
        }
        byte[] schemaContent = this.getFileFromZip(bundleModelFile, "model.xml");
        String xml$iv = StringsKt.decodeToString((byte[])schemaContent);
        boolean $i$f$decodeFromXml22 = false;
        Element element = JDOMUtil.load((CharSequence)xml$iv);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Object a$iv = element;
        ModelSchema schema = (ModelSchema)XmlSerializer.deserialize((Element)a$iv, ModelSchema.class);
        if (!Intrinsics.areEqual((Object)schema.getVersion(), (Object)LocalModelDescriptorKt.selectModelVersion(descriptor))) {
            return null;
        }
        Object[] $i$f$decodeFromXml22 = new String[]{"model.xml", schema.getBinary().getPath(), schema.getBpe().getPath(), schema.getConfig().getPath()};
        List filesToMoveFromModel = CollectionsKt.listOf((Object[])$i$f$decodeFromXml22);
        Object it = a$iv = FilesKt.resolve((File)LocalModelsFilesService.Companion.getInstance().getRoot(), (String)schema.uid());
        boolean bl = false;
        Files.createDirectories(((File)it).toPath(), new FileAttribute[0]);
        Object destination = a$iv;
        Iterable $this$forEach$iv = filesToMoveFromModel;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl2 = false;
            byte[] input = this.getFileFromZip(bundleModelFile, it2);
            FilesKt.writeBytes((File)FilesKt.resolve((File)destination, (String)it2), (byte[])input);
        }
        this.extractBundledNativeServer(schema, (File)destination);
        return schema;
    }

    public final boolean hasBundledServerWithSameVersion(@Nullable NativeServerSchema nativeSchema) {
        if (nativeSchema == null) {
            return false;
        }
        File file = this.getBundledServerFile();
        if (file == null) {
            return false;
        }
        File bundledServerFile = file;
        try {
            String version = StringsKt.decodeToString((byte[])this.getFileFromZip(bundledServerFile, ".version"));
            return StringsKt.endsWith$default((String)version, (String)nativeSchema.getVersion(), (boolean)false, (int)2, null);
        }
        catch (Throwable e) {
            LocalModelsBundleManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LocalModelsBundleManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Couldn't detect bundled server version for " + nativeSchema.getVersion() + " version (" + bundledServerFile + ").", e);
            boolean bl = false;
            return bl;
        }
    }

    @Nullable
    public final File unpackBundledServer(@NotNull ModelSchema schema) {
        File file;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        File it = file = FilesKt.resolve((File)LocalModelsFilesService.Companion.getInstance().getRoot(), (String)schema.uid());
        boolean bl = false;
        Files.createDirectories(it.toPath(), new FileAttribute[0]);
        File destination = file;
        return this.extractBundledNativeServer(schema, destination);
    }

    @TestOnly
    @Nullable
    public final ModelSchema unpackBundledFromLib(@NotNull LocalModelDescriptor descriptor) {
        String schemaContent;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        String string = descriptor.getCustomTag();
        if (string == null) {
            String string2 = descriptor.getLanguage().getID();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getID(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        }
        String tag = string;
        String version = LocalModelDescriptorKt.selectModelVersion(descriptor);
        URL uRL = this.getFileURL(tag, version, "model.xml");
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
        String xml$iv = schemaContent = new String(byArray, charset);
        boolean $i$f$decodeFromXml22 = false;
        Element element = JDOMUtil.load((CharSequence)xml$iv);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Object a$iv = element;
        ModelSchema schema = (ModelSchema)XmlSerializer.deserialize((Element)a$iv, ModelSchema.class);
        Object[] $i$f$decodeFromXml22 = new String[]{"model.xml", schema.getBinary().getPath(), schema.getBpe().getPath(), schema.getConfig().getPath()};
        List filesToMoveFromModel = CollectionsKt.listOf((Object[])$i$f$decodeFromXml22);
        Object it = a$iv = FilesKt.resolve((File)LocalModelsFilesService.Companion.getInstance().getRoot(), (String)schema.uid());
        boolean bl = false;
        Files.createDirectories(((File)it).toPath(), new FileAttribute[0]);
        Object destination = a$iv;
        Iterable $this$forEach$iv = filesToMoveFromModel;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl2 = false;
            InputStream input = this.getFileURL(tag, version, it2).openStream();
            File file = FilesKt.resolve((File)destination, (String)it2);
            Intrinsics.checkNotNull((Object)input);
            FilesKt.writeBytes((File)file, (byte[])ByteStreamsKt.readBytes((InputStream)input));
        }
        this.extractBundledNativeServer(schema, (File)destination);
        return schema;
    }

    private final File extractBundledNativeServer(ModelSchema schema, File destination) {
        NativeServerSchema nativeServerSchema = schema.getNative();
        if (nativeServerSchema == null) {
            throw new IllegalStateException(("Expected not-null 'native' field of " + schema).toString());
        }
        NativeServerSchema nativeSchema = nativeServerSchema;
        File file = this.getBundledServerFile();
        if (file == null) {
            return null;
        }
        File bundledServerFile = file;
        ZipUtil.extract((Path)bundledServerFile.toPath(), (Path)FilesKt.resolve((File)destination, (String)ModelSchemaKt.extractedName((NativeServerSchema)nativeSchema)).toPath(), null, (boolean)true);
        return destination;
    }

    private final File getBundledServerFile() {
        File file;
        File file2 = PluginPathManager.getPluginResource(this.getClass(), (String)("full-line-native-server-" + HostApi.Companion.getOs() + "-" + HostApi.Companion.getCpu() + ".zip"));
        if (file2 != null) {
            File file3;
            File it = file3 = file2;
            boolean bl = false;
            file = it.exists() ? file3 : null;
        } else {
            file = null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final byte[] getFileFromZip(File zipFilePath, String name) {
        byte[] byArray;
        Closeable closeable = new ZipFile(zipFilePath);
        Throwable throwable = null;
        try {
            Object element$iv2;
            ZipFile zip;
            block6: {
                void $this$first$iv;
                zip = (ZipFile)closeable;
                boolean bl = false;
                Enumeration<? extends ZipEntry> enumeration = zip.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    ZipEntry it = (ZipEntry)element$iv2;
                    boolean bl2 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)name, (boolean)false, (int)2, null)) continue;
                    break block6;
                }
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            ZipEntry it = (ZipEntry)element$iv2;
            boolean bl = false;
            InputStream inputStream = zip.getInputStream(it);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    private final URL getFileURL(String tag, String version, String file) {
        URL uRL = this.getClass().getClassLoader().getResource(tag + "-" + version + "/" + file);
        Intrinsics.checkNotNull((Object)uRL);
        return uRL;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/completion/full/line/impl/local/files/LocalModelsBundleManager$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/completion/full/line/impl/local/files/LocalModelsBundleManager;", "intellij.fullLine.core.impl"})
    @SourceDebugExtension(value={"SMAP\nLocalModelsBundleManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalModelsBundleManager.kt\norg/jetbrains/completion/full/line/impl/local/files/LocalModelsBundleManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,132:1\n42#2,3:133\n*S KotlinDebug\n*F\n+ 1 LocalModelsBundleManager.kt\norg/jetbrains/completion/full/line/impl/local/files/LocalModelsBundleManager$Companion\n*L\n129#1:133,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalModelsBundleManager getInstance() {
            boolean $i$f$service = false;
            Class<LocalModelsBundleManager> serviceClass$iv = LocalModelsBundleManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LocalModelsBundleManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

