/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.codeWithMe.ClientId;
import com.intellij.database.BasicModelRegistry;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvExtraTreeNode;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeFundamentLayer;
import com.intellij.database.view.structure.forest.DvRootFolder;
import com.intellij.openapi.application.ApplicationManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\fH\u0016J\u001a\u0010\u0014\u001a\f0\u0015\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u00172\u0006\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/view/structure/DvTreeRootLayer;", "Lcom/intellij/database/view/structure/DvTreeFundamentLayer;", "<init>", "()V", "root", "Lcom/intellij/database/view/structure/forest/DvRootFolder;", "getRoot", "()Lcom/intellij/database/view/structure/forest/DvRootFolder;", "listAllDataSources", "Lkotlin/sequences/Sequence;", "Lcom/intellij/database/view/DataSourceNode;", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "childrenOf", "countAllChildrenOf", "", "countRealChildrenOf", "isAlwaysLeaf", "", "presentableNameOf", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "clearAll", "", "GlobalRootFolder", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeRootLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeRootLayer.kt\ncom/intellij/database/view/structure/DvTreeRootLayer\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,59:1\n42#2,3:60\n*S KotlinDebug\n*F\n+ 1 DvTreeRootLayer.kt\ncom/intellij/database/view/structure/DvTreeRootLayer\n*L\n25#1:60,3\n*E\n"})
public final class DvTreeRootLayer
extends DvTreeFundamentLayer {
    @Override
    @NotNull
    public DvRootFolder getRoot() {
        return GlobalRootFolder.INSTANCE;
    }

    @NotNull
    public final Sequence<DataSourceNode> listAllDataSources() {
        boolean $i$f$service = false;
        Class<BasicModelRegistry> serviceClass$iv = BasicModelRegistry.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((BasicModelRegistry)object).listDataSourceNodesForProject(this.getContext().project);
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvRootFolder ? null : (node instanceof DvHostNode ? (BasicNode)((DvHostNode)node).host : (BasicNode)this.getRoot());
    }

    @Override
    @NotNull
    public Sequence<BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvRootFolder ? this.listAllDataSources() : SequencesKt.emptySequence();
    }

    @Override
    public int countAllChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvRootFolder ? SequencesKt.count(this.listAllDataSources()) : 0;
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.countAllChildrenOf(node);
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof DvExtraTreeNode ? ((DvExtraTreeNode)node).isAlwaysLeaf() : !(basicNode instanceof DvRootFolder) && !(basicNode instanceof DataSourceNode);
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        return string;
    }

    @Override
    public void clearAll() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/view/structure/DvTreeRootLayer$GlobalRootFolder;", "Lcom/intellij/database/view/structure/forest/DvRootFolder;", "<init>", "()V", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "getDisplayName", "", "Lcom/intellij/openapi/util/NlsSafe;", "toString", "intellij.database.core.impl"})
    public static final class GlobalRootFolder
    implements DvRootFolder {
        @NotNull
        public static final GlobalRootFolder INSTANCE = new GlobalRootFolder();

        private GlobalRootFolder() {
        }

        @Override
        @Nullable
        public BasicModel getModel() {
            return null;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return "Database";
        }

        @NotNull
        public String toString() {
            return "Global Root Folder";
        }
    }
}

