/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardCustomizationBuilder;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunDashboardCustomizerKt;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunType;
import com.intellij.httpClient.http.request.run.config.RequestPresentation;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\"\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/http/request/run/config/HttpRequestRunDashboardCustomizer;", "Lcom/intellij/execution/dashboard/RunDashboardCustomizer;", "<init>", "()V", "isApplicable", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "updatePresentation", "customizationBuilder", "Lcom/intellij/execution/dashboard/RunDashboardCustomizationBuilder;", "configurationSettings", "getPsiElement", "Lcom/intellij/psi/PsiElement;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpRequestRunDashboardCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestRunDashboardCustomizer.kt\ncom/intellij/httpClient/http/request/run/config/HttpRequestRunDashboardCustomizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class HttpRequestRunDashboardCustomizer
extends RunDashboardCustomizer {
    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getConfiguration() instanceof HttpRequestRunConfiguration;
    }

    public boolean updatePresentation(@NotNull RunDashboardCustomizationBuilder customizationBuilder, @NotNull RunnerAndConfigurationSettings configurationSettings, @Nullable RunContentDescriptor descriptor) {
        block8: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)customizationBuilder, (String)"customizationBuilder");
            Intrinsics.checkNotNullParameter((Object)configurationSettings, (String)"configurationSettings");
            RunConfiguration runConfiguration = configurationSettings.getConfiguration();
            HttpRequestRunConfiguration httpRequestRunConfiguration = runConfiguration instanceof HttpRequestRunConfiguration ? (HttpRequestRunConfiguration)runConfiguration : null;
            if (httpRequestRunConfiguration == null) {
                return false;
            }
            HttpRequestRunConfiguration configuration = httpRequestRunConfiguration;
            if (configuration.getSettings().getRunType() != HttpRequestRunType.SINGLE_REQUEST) {
                return true;
            }
            RequestPresentation requestName = HttpRequestRunDashboardCustomizerKt.access$getRequestPresentation(configuration);
            if (requestName != null) {
                RunContentDescriptor runContentDescriptor = descriptor;
                HttpRequestRunDashboardCustomizerKt.access$addRequestPresentationToNode(customizationBuilder, configurationSettings, (Content)(runContentDescriptor != null ? runContentDescriptor.getAttachedContent() : null), requestName);
            }
            RunContentDescriptor runContentDescriptor = descriptor;
            ProcessHandler processHandler = runContentDescriptor != null ? runContentDescriptor.getProcessHandler() : null;
            HttpClientRequestProcessHandler httpClientRequestProcessHandler = processHandler instanceof HttpClientRequestProcessHandler ? (HttpClientRequestProcessHandler)processHandler : null;
            if (httpClientRequestProcessHandler == null) {
                return true;
            }
            HttpClientRequestProcessHandler handler = httpClientRequestProcessHandler;
            if (!handler.isProcessTerminated()) {
                if (handler.isStartNotified()) {
                    AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
                    Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
                    customizationBuilder.setIcon((Icon)animatedIcon);
                }
                return true;
            }
            CommonClientResponse commonClientResponse = handler.getResponse();
            if (commonClientResponse == null) {
                return true;
            }
            CommonClientResponse response2 = commonClientResponse;
            Object it = object = response2.getStatusPresentation();
            boolean bl = false;
            Object object2 = !Intrinsics.areEqual((Object)it, (Object)"") ? object : null;
            if (object2 != null) {
                it = object2;
                boolean bl2 = false;
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
                customizationBuilder.addText(" ", simpleTextAttributes);
                Object[] objectArray = new Object[]{it};
                String string = RestClientBundle.message("http.request.run.dashboard.customization.status.label", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAYED_ATTRIBUTES");
                customizationBuilder.addText(string, simpleTextAttributes2);
            }
            it = object = response2.getExecutionTime();
            boolean bl3 = false;
            Object object3 = !Intrinsics.areEqual((Object)handler.getUserData(ProcessHandler.TERMINATION_REQUESTED), (Object)true) ? object : null;
            if (object3 == null) break block8;
            long it2 = ((Number)object3).longValue();
            boolean bl4 = false;
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            customizationBuilder.addText(" ", simpleTextAttributes);
            String string = "(" + NlsMessages.formatDuration((long)it2) + ")";
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"GRAYED_ATTRIBUTES");
            customizationBuilder.addText(string, simpleTextAttributes3);
        }
        return true;
    }

    @Nullable
    public PsiElement getPsiElement(@NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return (PsiElement)HttpRequestRunDashboardCustomizerKt.access$findRequest(configuration);
    }
}

