/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.requests;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchUtilsKt;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandlerKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.patches.FrontendRdPatchHandlerRegistry;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResultKt;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0013J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0013J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "initialPatch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "resetUndoHistoryToken", "Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rd/ide/model/RdPatch;Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "getResetUndoHistoryToken", "()Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;", "value", "patch", "getPatch", "()Lcom/jetbrains/rd/ide/model/RdPatch;", "conflictWith", "", "other", "undo", "", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "redo", "doRedo", "virtually", "undoInternal", "redoInternal", "updatePatchAfterRedo", "patchAfterRedo", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendAsyncRequestWithImmediateResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncRequestWithImmediateResult.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,186:1\n1563#2:187\n1634#2,3:188\n50#3,7:191\n57#3,2:203\n59#3,6:206\n65#3,2:213\n57#4:198\n35#4,2:199\n82#4,2:201\n84#4:205\n23#4:212\n67#4,4:215\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncRequestWithImmediateResult.kt\ncom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult\n*L\n91#1:187\n91#1:188,3\n139#1:191,7\n139#1:203,2\n139#1:206,6\n139#1:213,2\n139#1:198\n139#1:199,2\n139#1:201,2\n139#1:205\n139#1:212\n148#1:215,4\n*E\n"})
public abstract class FrontendAsyncRequestWithImmediateResult
extends FrontendAsyncRequest {
    @NotNull
    private final ClientAppSession session;
    @Nullable
    private final ResetUndoHistoryToken resetUndoHistoryToken;
    @NotNull
    private RdPatch patch;

    public FrontendAsyncRequestWithImmediateResult(@NotNull ClientAppSession session, @NotNull RdPatch initialPatch, @Nullable ResetUndoHistoryToken resetUndoHistoryToken) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)initialPatch, (String)"initialPatch");
        this.session = session;
        this.resetUndoHistoryToken = resetUndoHistoryToken;
        this.patch = initialPatch;
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    @Nullable
    protected final ResetUndoHistoryToken getResetUndoHistoryToken() {
        return this.resetUndoHistoryToken;
    }

    @NotNull
    public final RdPatch getPatch() {
        return this.patch;
    }

    @Override
    public boolean conflictWith(@NotNull RdPatch other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        RdPatch rdPatch = this.patch;
        return rdPatch != null ? RdPatchUtilsKt.isIntersecting((RdPatch)rdPatch, (RdPatch)other) : false;
    }

    @Override
    public final void undo(@NotNull FrontendRebaseSession rebaseSession) {
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        this.undo(rebaseSession, false);
    }

    @Override
    public final void redo(@NotNull FrontendRebaseSession rebaseSession) {
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        this.redo(rebaseSession, false);
    }

    @NotNull
    protected RdPatch doRedo(@NotNull FrontendRebaseSession rebaseSession) {
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        return this.redoInternal(rebaseSession, false);
    }

    public final void undo(@NotNull FrontendRebaseSession rebaseSession, boolean virtually) {
        FrontendRdPatchHandlerContext ctx;
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        PatchItemOperationType operation = virtually ? (PatchItemOperationType)PatchItemOperationType.SoftRollback.INSTANCE : (PatchItemOperationType)PatchItemOperationType.Rollback.INSTANCE;
        RdPatch patch = this.patch;
        if (patch != null) {
            ctx = new FrontendRdPatchHandlerContext(this.session, patch, this, operation, rebaseSession);
            rebaseSession.validateAndUpdateVersions(patch.getUpdatedItemVersions(), ctx);
        }
        this.undoInternal(rebaseSession, virtually);
        if (!virtually) {
            ResetUndoHistoryToken resetUndoHistoryToken = this.resetUndoHistoryToken;
            if (resetUndoHistoryToken != null) {
                resetUndoHistoryToken.resetHistory();
            }
        }
        if (patch != null) {
            ctx = new FrontendRdPatchHandlerContext(this.session, patch, this, operation, rebaseSession);
            rebaseSession.validateAndUpdateVersions(patch.getExpectedItemVersions(), ctx);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void redo(@NotNull FrontendRebaseSession rebaseSession, boolean virtually) {
        RdPatch patchAfterRedo;
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        PatchItemOperationType operation = virtually ? (PatchItemOperationType)PatchItemOperationType.SoftRedo.INSTANCE : (PatchItemOperationType)PatchItemOperationType.Redo.INSTANCE;
        RdPatch patchBefore = this.patch;
        if (patchBefore != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FrontendRdPatchHandlerContext ctx = new FrontendRdPatchHandlerContext(this.session, patchBefore, this, operation, rebaseSession);
            Map<RdPatchItemId, RdPatchItemVersion> map = rebaseSession.getUpdatedVersionsMap();
            Iterable iterable = patchBefore.getExpectedItemVersions();
            FrontendRebaseSession frontendRebaseSession = rebaseSession;
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RdPatchItemVersion rdPatchItemVersion = (RdPatchItemVersion)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                RdPatchItemVersion rdPatchItemVersion2 = map.get(it.getId());
                if (rdPatchItemVersion2 == null) {
                    rdPatchItemVersion2 = it;
                }
                collection.add(rdPatchItemVersion2);
            }
            frontendRebaseSession.validateAndUpdateVersions((List)destination$iv$iv, ctx);
        }
        if (!virtually) {
            ResetUndoHistoryToken resetUndoHistoryToken = this.resetUndoHistoryToken;
            if (resetUndoHistoryToken != null) {
                resetUndoHistoryToken.refresh();
            }
        }
        RdPatch rdPatch = patchAfterRedo = virtually ? this.redoInternal(rebaseSession, true) : this.doRedo(rebaseSession);
        if (patchAfterRedo != null) {
            FrontendRdPatchHandlerContext ctx = new FrontendRdPatchHandlerContext(this.session, patchAfterRedo, this, operation, rebaseSession);
            rebaseSession.validateAndUpdateVersions(patchAfterRedo.getUpdatedItemVersions(), ctx);
        }
        this.updatePatchAfterRedo(patchAfterRedo);
    }

    private final void undoInternal(FrontendRebaseSession rebaseSession, boolean virtually) {
        RdPatch rdPatch = this.patch;
        if (rdPatch == null) {
            return;
        }
        RdPatch patch = rdPatch;
        if (!((Collection)patch.getFeatures()).isEmpty()) {
            FrontendAsyncRequestWithImmediateResultKt.access$getLogger$p().error("Patch contains features: " + IPrintableKt.printToString((Object)patch));
        }
        PatchItemOperationType operation = virtually ? (PatchItemOperationType)PatchItemOperationType.SoftRollback.INSTANCE : (PatchItemOperationType)PatchItemOperationType.Rollback.INSTANCE;
        FrontendRdPatchHandlerContext ctx = new FrontendRdPatchHandlerContext(this.session, patch, this, operation, rebaseSession);
        FrontendRdPatchHandlerRegistry registry = FrontendRdPatchHandlerRegistry.Companion.getInstance();
        FrontendRdPatchItemHandlerKt.withHandlerContext(ctx, () -> FrontendAsyncRequestWithImmediateResult.undoInternal$lambda$0(rebaseSession, patch, ctx, registry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final RdPatch redoInternal(FrontendRebaseSession rebaseSession, boolean virtually) {
        RdPatch rdPatch;
        void $this$recordChanges$iv;
        RdPatch patchBeforeRedo = this.patch;
        FrontendRdPatchHandlerRegistry registry = FrontendRdPatchHandlerRegistry.Companion.getInstance();
        PatchItemOperationType operation = virtually ? (PatchItemOperationType)PatchItemOperationType.SoftRedo.INSTANCE : (PatchItemOperationType)PatchItemOperationType.Redo.INSTANCE;
        FrontendRdPatchHandlerContext ctx = new FrontendRdPatchHandlerContext(this.session, patchBeforeRedo, this, operation, rebaseSession);
        PatchEngine patchEngine = FrontendPatchEngineKt.getEngine(this.session);
        String description$iv = "Redoing " + this;
        boolean $i$f$recordChanges = false;
        $this$recordChanges$iv.softAssertThereIsNoActivePatch("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
        boolean alreadyOpened$iv = $this$recordChanges$iv.getHasActivePatch();
        try {
            RdPatch rdPatch2;
            AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$recordChanges$iv, (boolean)false, (String)description$iv, null, (int)4, null);
            Throwable throwable = null;
            try {
                Object object;
                void $this$runAndLogException$iv$iv;
                RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
                boolean bl5 = false;
                boolean $i$f$fileLogger22 = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                Logger $i$f$fileLogger22 = logger;
                boolean $i$f$runAndLogException = false;
                void var17_23 = $this$runAndLogException$iv$iv;
                try {
                    void $this$runAndLogException_u24lambda_u240$iv$iv = var17_23;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ChangeScope $this$redoInternal_u24lambda_u240 = it$iv.getSession().getChangeScope();
                    boolean bl4 = false;
                    FrontendRdPatchItemHandlerKt.withHandlerContext(ctx, () -> FrontendAsyncRequestWithImmediateResult.redoInternal$lambda$0$0(registry, patchBeforeRedo, ctx));
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv$iv);
                rdPatch2 = it$iv.getSession().buildPatchAndClear();
            }
            catch (Throwable bl5) {
                try {
                    throwable = bl5;
                    throw bl5;
                }
                catch (Throwable bl5) {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                    throw bl5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            rdPatch = rdPatch2;
        }
        finally {
            if (!alreadyOpened$iv && $this$recordChanges$iv.getHasActivePatch()) {
                void $this$thisLogger$iv$iv = $this$recordChanges$iv;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(PatchEngine.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                while ($this$recordChanges$iv.getHasActivePatch()) {
                    $this$recordChanges$iv.closeCurrentSession("Wrong dispose ordering: " + description$iv);
                }
            }
        }
        return rdPatch;
    }

    private final RdPatch updatePatchAfterRedo(RdPatch patchAfterRedo) {
        if (!Intrinsics.areEqual((Object)this.patch, (Object)patchAfterRedo)) {
            Logger $this$trace$iv = FrontendAsyncRequestWithImmediateResultKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Patch after redo: " + IPrintableKt.printToString((Object)patchAfterRedo));
            }
            this.patch = patchAfterRedo;
        }
        return this.patch;
    }

    private static final Unit undoInternal$lambda$0(FrontendRebaseSession $rebaseSession, RdPatch $patch, FrontendRdPatchHandlerContext $ctx, FrontendRdPatchHandlerRegistry $registry) {
        $rebaseSession.validateAndUpdateVersions($patch.getUpdatedItemVersions(), $ctx);
        $registry.apply(CollectionsKt.asReversed((List)$patch.getChanges()), $ctx);
        $registry.update($patch.getExpectedItemVersions(), $ctx);
        $rebaseSession.validateAndUpdateVersions($patch.getExpectedItemVersions(), $ctx);
        return Unit.INSTANCE;
    }

    private static final Unit redoInternal$lambda$0$0(FrontendRdPatchHandlerRegistry $registry, RdPatch $patchBeforeRedo, FrontendRdPatchHandlerContext $ctx) {
        $registry.apply($patchBeforeRedo.getChanges(), $ctx);
        return Unit.INSTANCE;
    }
}

