/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6NamedImports;
import com.intellij.lang.html.HtmlQuotesConverter;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.PostFormatProcessorUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSEnforceCodeStylePostProcessor
implements PostFormatProcessor {
    private static final TokenSet possiblyAmbiguousTokens = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACKET, JSTokenTypes.LPAR, JSTokenTypes.PLUS, JSTokenTypes.MINUS, JSTokenTypes.DIV, JSTokenTypes.REGEXP_LITERAL, JSTokenTypes.BACKQUOTE});

    JSEnforceCodeStylePostProcessor() {
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = PostFormatProcessorUtil.processElement(source, JSEnforceCodeStylePostProcessor::processTextRange);
        if (psiElement == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile rootPsi, @NotNull TextRange range, @NotNull CodeStyleSettings settings) {
        if (rootPsi == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(3);
        }
        if (range == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(5);
        }
        TextRange textRange = PostFormatProcessorUtil.processText(rootPsi, range, JSEnforceCodeStylePostProcessor::processTextRange);
        if (textRange == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @NotNull
    private static TextRange processTextRange(@NotNull PsiElement rootPsi, @NotNull TextRange range) {
        JSLanguageDialect dialect;
        if (rootPsi == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(7);
        }
        if (range == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(8);
        }
        if ((dialect = DialectDetector.languageDialectOfElement(rootPsi)) == null) {
            TextRange textRange = range;
            if (textRange == null) {
                JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(9);
            }
            return textRange;
        }
        DialectOptionHolder holder = DialectDetector.INSTANCE.getOptionHolder(dialect, rootPsi);
        if (!holder.isJavaScript() && !holder.isTypeScript && !holder.isECMA4 || !holder.hasJSSyntax()) {
            TextRange textRange = range;
            if (textRange == null) {
                JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(10);
            }
            return textRange;
        }
        if (rootPsi instanceof JSEmbeddedContent && rootPsi.getParent() instanceof XmlAttributeValue) {
            TextRange textRange = range;
            if (textRange == null) {
                JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(11);
            }
            return textRange;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)rootPsi.getContainingFile());
        HtmlCodeStyleSettings htmlSettings = (HtmlCodeStyleSettings)settings.getCustomSettings(HtmlCodeStyleSettings.class);
        JSCodeStyleSettings languageSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(dialect));
        if (!(languageSettings.FORCE_QUOTE_STYlE || languageSettings.FORCE_SEMICOLON_STYLE || htmlSettings.HTML_ENFORCE_QUOTES || languageSettings.ENFORCE_TRAILING_COMMA != JSCodeStyleSettings.TrailingCommaOption.Keep)) {
            TextRange textRange = range;
            if (textRange == null) {
                JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(12);
            }
            return textRange;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)rootPsi.getProject());
        Document document = rootPsi.getContainingFile().getViewProvider().getDocument();
        if (document == null) {
            TextRange textRange = range;
            if (textRange == null) {
                JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(13);
            }
            return textRange;
        }
        MyVisitor visitor = new MyVisitor(rootPsi, range, settings, document, dialect);
        DocumentUtil.executeInBulk((Document)document, () -> {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            rootPsi.accept((PsiElementVisitor)visitor);
            psiDocumentManager.commitDocument(document);
        });
        TextRange textRange = visitor.getResultRange();
        if (textRange == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(14);
        }
        return textRange;
    }

    private static boolean isComma(@Nullable PsiElement afterList) {
        return afterList != null && afterList.getNode().getElementType() == JSTokenTypes.COMMA;
    }

    private static boolean isNewLineWS(@Nullable PsiElement possiblyWhitespace) {
        return possiblyWhitespace instanceof PsiWhiteSpace && possiblyWhitespace.getText().contains("\n");
    }

    private static boolean isDestructuringAssignmentRest(@NotNull JSElement last) {
        if (last == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(15);
        }
        return last instanceof JSSpreadExpression && JSDestructuringUtil.parentIsDestructuringAssignmentLHS((JSExpression)last);
    }

    private static boolean isSafeToDeleteSemicolon(@NotNull PsiElement semicolon, @NotNull JSElement jsElement) {
        if (semicolon == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(16);
        }
        if (jsElement == null) {
            JSEnforceCodeStylePostProcessor.$$$reportNull$$$0(17);
        }
        if (!(jsElement instanceof JSStatement)) {
            return true;
        }
        JSStatement statementToCheck = (JSStatement)jsElement;
        if (PsiTreeUtil.prevLeaf((PsiElement)semicolon) instanceof OuterLanguageElement) {
            return false;
        }
        PsiElement parent = jsElement.getParent();
        while (parent instanceof JSStatement && !(parent instanceof JSBlockStatement)) {
            statementToCheck = (JSStatement)parent;
            parent = parent.getParent();
        }
        JSStatement nextStatement = (JSStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statementToCheck), JSStatement.class);
        if (nextStatement == null) {
            return true;
        }
        PsiElement firstLeaf = PsiTreeUtil.getDeepestFirst((PsiElement)nextStatement);
        return !possiblyAmbiguousTokens.contains(firstLeaf.getNode().getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 9, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPsi";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolon";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTextRange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDestructuringAssignmentRest";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToDeleteSemicolon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 9, 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    private static class MyVisitor
    extends JSRecursiveElementVisitor {
        private final CodeStyleSettings.QuoteStyle myHtmlQuoteStyle;
        private final boolean myEnforceHtmlQuotes;
        private final PostFormatProcessorHelper myPostProcessorHelper;
        private final TextRange myOriginalRange;
        private final JSCodeStyleSettings languageSettings;
        private final Document myDocument;
        private final HtmlQuotesConverter myQuotesConverter;
        private final String myNewQuote;
        private final boolean myTrailingCommaSupported;

        MyVisitor(@NotNull PsiElement context, @NotNull TextRange originalRange, @NotNull CodeStyleSettings settings, @NotNull Document document, @NotNull JSLanguageDialect languageDialect) {
            if (context == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (originalRange == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (document == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (languageDialect == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            HtmlCodeStyleSettings htmlSettings = (HtmlCodeStyleSettings)settings.getCustomSettings(HtmlCodeStyleSettings.class);
            this.myHtmlQuoteStyle = htmlSettings.HTML_QUOTE_STYLE;
            this.myEnforceHtmlQuotes = htmlSettings.HTML_ENFORCE_QUOTES;
            this.myOriginalRange = originalRange;
            this.myPostProcessorHelper = new PostFormatProcessorHelper(settings.getCommonSettings((Language)languageDialect));
            this.myPostProcessorHelper.setResultTextRange(originalRange);
            this.languageSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(languageDialect));
            this.myNewQuote = this.languageSettings.USE_DOUBLE_QUOTES ? "\"" : "'";
            this.myQuotesConverter = new HtmlQuotesConverter(this.myHtmlQuoteStyle, context, this.myPostProcessorHelper);
            this.myDocument = document;
            this.myTrailingCommaSupported = DialectDetector.INSTANCE.getOptionHolder(languageDialect, context).hasFeature(JSLanguageFeature.TRAILING_FUNCTION_COMMA);
        }

        public TextRange getResultRange() {
            return this.myPostProcessorHelper.getResultTextRange();
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            super.visitElement(element);
            this.applyJavaScriptQuoteStyle(element);
            if (element instanceof XmlAttributeValue) {
                this.myQuotesConverter.visitXmlAttributeValue((XmlAttributeValue)element);
            }
        }

        @Override
        public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
            if (importDeclaration == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            super.visitES6ImportDeclaration(importDeclaration);
            this.applySemicolonStyle(importDeclaration);
        }

        @Override
        public void visitES6NamedImports(@NotNull ES6NamedImports imports) {
            if (imports == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            super.visitES6NamedImports(imports);
            this.applyTrailingCommaStyle(imports.getSpecifiers(), JSTokenTypes.RBRACE);
        }

        @Override
        public void visitES6ExportDeclaration(@NotNull ES6ExportDeclaration exportDeclaration) {
            if (exportDeclaration == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            super.visitES6ExportDeclaration(exportDeclaration);
            this.applyTrailingCommaStyle(exportDeclaration.getExportSpecifiers(), JSTokenTypes.RBRACE);
            this.applySemicolonStyle(exportDeclaration);
        }

        @Override
        public void visitES6ExportDefaultAssignment(@NotNull ES6ExportDefaultAssignment node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            super.visitES6ExportDefaultAssignment(node);
            JSNamedElement element = node.getNamedElement();
            if (element instanceof JSClass || element instanceof JSFunction) {
                return;
            }
            this.applySemicolonStyle(node);
        }

        @Override
        public void visitJSStatement(@NotNull JSStatement node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            super.visitJSStatement(node);
            if (JSUtils.statementRequiresSemicolon(node)) {
                this.applySemicolonStyle(node);
            }
        }

        @Override
        public void visitJSTryStatement(@NotNull JSTryStatement node) {
            JSExpression initialization;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            super.visitJSTryStatement(node);
            JSVarStatement varDeclaration = node.getVarDeclaration();
            if (varDeclaration != null) {
                for (JSVariable variable : varDeclaration.getVariables()) {
                    variable.accept(this);
                }
            }
            if ((initialization = node.getResourceExpression()) != null) {
                initialization.accept(this);
            }
        }

        @Override
        public void visitJSForStatement(@NotNull JSForStatement node) {
            JSStatement body;
            JSExpression update;
            JSExpression initialization;
            JSVarStatement varDeclaration;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            if ((varDeclaration = node.getVarDeclaration()) != null) {
                for (JSVariable variable : varDeclaration.getVariables()) {
                    variable.accept(this);
                }
            }
            if ((initialization = node.getInitialization()) != null) {
                initialization.accept(this);
            }
            if ((update = node.getUpdate()) != null) {
                update.accept(this);
            }
            if ((body = node.getBody()) != null) {
                body.accept(this);
            }
        }

        @Override
        public void visitJSForInStatement(@NotNull JSForInStatement node) {
            JSStatement body;
            JSExpression collectionExpression;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            if ((collectionExpression = node.getCollectionExpression()) != null) {
                collectionExpression.accept(this);
            }
            if ((body = node.getBody()) != null) {
                body.accept(this);
            }
        }

        @Override
        public void visitJSArrayLiteralExpression(@NotNull JSArrayLiteralExpression node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            super.visitJSArrayLiteralExpression(node);
            this.applyTrailingCommaStyle((JSExpression)ArrayUtil.getLastElement((Object[])node.getExpressions()), JSTokenTypes.RBRACKET, el -> !JSEnforceCodeStylePostProcessor.isDestructuringAssignmentRest(el));
        }

        @Override
        public void visitJSObjectLiteralExpression(@NotNull JSObjectLiteralExpression node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            super.visitJSObjectLiteralExpression(node);
            this.applyTrailingCommaStyle((JSElement)ArrayUtil.getLastElement((Object[])node.getPropertiesIncludingSpreads()), JSTokenTypes.RBRACE, el -> !JSEnforceCodeStylePostProcessor.isDestructuringAssignmentRest(el));
        }

        @Override
        public void visitJSParameterList(@NotNull JSParameterList node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(16);
            }
            super.visitJSParameterList(node);
            if (this.myTrailingCommaSupported) {
                this.applyTrailingCommaStyle((JSElement)node.getParameters(), JSTokenTypes.RPAR, (Condition)p -> !p.isRest());
            }
        }

        @Override
        public void visitJSArgumentList(@NotNull JSArgumentList node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(17);
            }
            super.visitJSArgumentList(node);
            if (this.myTrailingCommaSupported) {
                this.applyTrailingCommaStyle(node.getArguments(), JSTokenTypes.RPAR);
            }
        }

        @Override
        public void visitJSDestructuringObject(@NotNull JSDestructuringObject destructuringObject) {
            if (destructuringObject == null) {
                MyVisitor.$$$reportNull$$$0(18);
            }
            super.visitJSDestructuringObject(destructuringObject);
            this.applyTrailingCommaStyle((JSElement)destructuringObject.getProperties(), JSTokenTypes.RBRACE, (Condition)p -> !p.isRest());
        }

        @Override
        public void visitTypeScriptObjectType(@NotNull TypeScriptObjectType objectType) {
            if (objectType == null) {
                MyVisitor.$$$reportNull$$$0(19);
            }
            super.visitTypeScriptObjectType(objectType);
            if (MyVisitor.canUseSemicolonAsSeparator(objectType)) {
                for (TypeScriptTypeMember typeMember : objectType.getTypeMembers()) {
                    PsiElement nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)typeMember);
                    if (!this.checkForceSemicolonCondition(typeMember) || nextElement != null && (!(nextElement instanceof LeafElement) || ((LeafElement)nextElement).getElementType() != JSTokenTypes.RBRACE) && !(nextElement instanceof TypeScriptTypeMember)) continue;
                    this.updateSemicolonIfNeeded(typeMember, false);
                }
            }
        }

        private static boolean canUseSemicolonAsSeparator(@NotNull TypeScriptObjectType objectType) {
            if (objectType == null) {
                MyVisitor.$$$reportNull$$$0(20);
            }
            if (!(objectType.getContext() instanceof TypeScriptInterface)) {
                return false;
            }
            for (TypeScriptTypeMember member : objectType.getTypeMembers()) {
                PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)member);
                if (!(next instanceof LeafElement) || ((LeafElement)next).getElementType() != JSTokenTypes.COMMA) continue;
                return false;
            }
            return true;
        }

        @Override
        public void visitJSDestructuringArray(@NotNull JSDestructuringArray destructuringArray) {
            if (destructuringArray == null) {
                MyVisitor.$$$reportNull$$$0(21);
            }
            super.visitJSDestructuringArray(destructuringArray);
            this.applyTrailingCommaStyle((JSElement)ObjectUtils.coalesce((Object)destructuringArray.getRestElement(), (Object)((JSElement)ArrayUtil.getLastElement((Object[])destructuringArray.getElements()))), JSTokenTypes.RBRACKET, t -> !(t instanceof JSDestructuringArrayRestElement));
        }

        private void applyJavaScriptQuoteStyle(@NotNull PsiElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(22);
            }
            if (!this.languageSettings.FORCE_QUOTE_STYlE || !this.containedInRange(element)) {
                return;
            }
            ASTNode node = element.getNode();
            if (!JSTokenTypes.STRING_LITERALS.contains(node.getElementType())) {
                return;
            }
            String stringValue = node.getText();
            if (stringValue.length() < 2) {
                return;
            }
            String currentQuote = stringValue.substring(0, 1);
            char currentQuoteChar = stringValue.charAt(0);
            if (stringValue.charAt(stringValue.length() - 1) != currentQuoteChar) {
                return;
            }
            if (StringUtil.equals((CharSequence)this.myNewQuote, (CharSequence)currentQuote)) {
                return;
            }
            TextRange nodeRange = node.getTextRange();
            this.replaceRange(nodeRange.getStartOffset(), nodeRange.getStartOffset() + 1, this.myNewQuote);
            this.replaceRange(nodeRange.getEndOffset() - 1, nodeRange.getEndOffset(), this.myNewQuote);
            String quotedValue = stringValue.substring(1, stringValue.length() - 1);
            String newQuotedValue = JSStringUtil.changeQuotesInLiteralValue(quotedValue, currentQuoteChar, this.myNewQuote.charAt(0));
            if (Strings.areSameInstance((String)newQuotedValue, (String)quotedValue)) {
                return;
            }
            this.replaceRange(nodeRange.getStartOffset() + 1, nodeRange.getEndOffset() - 1, newQuotedValue);
        }

        private void applySemicolonStyle(@NotNull JSElement node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(23);
            }
            if (!this.checkForceSemicolonCondition(node)) {
                return;
            }
            ASTNode lastLeafElement = node.getLastChild().getNode();
            boolean hasSemicolon = lastLeafElement.getElementType() == JSTokenTypes.SEMICOLON;
            this.updateSemicolonIfNeeded(node, hasSemicolon);
        }

        private void updateSemicolonIfNeeded(@NotNull JSElement node, boolean hasSemicolon) {
            boolean needSemicolon;
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(24);
            }
            if (hasSemicolon == (needSemicolon = this.languageSettings.USE_SEMICOLON_AFTER_STATEMENT)) {
                return;
            }
            ASTNode lastLeafElement = node.getLastChild().getNode();
            if (needSemicolon) {
                this.insertString(lastLeafElement.getStartOffset() + lastLeafElement.getTextLength(), ";");
            } else if (JSEnforceCodeStylePostProcessor.isSafeToDeleteSemicolon(lastLeafElement.getPsi(), node)) {
                this.deleteNode(lastLeafElement);
            }
        }

        private boolean checkForceSemicolonCondition(@NotNull JSElement node) {
            if (node == null) {
                MyVisitor.$$$reportNull$$$0(25);
            }
            return this.languageSettings.FORCE_SEMICOLON_STYLE && this.containedInRange((PsiElement)node) && !(PsiTreeUtil.getDeepestLast((PsiElement)node) instanceof PsiErrorElement);
        }

        private <T extends JSElement> void applyTrailingCommaStyle(T @NotNull [] listChildren, @NotNull IElementType rBracketType, @NotNull Condition<T> shouldAddToLastElement) {
            if (rBracketType == null) {
                MyVisitor.$$$reportNull$$$0(26);
            }
            if (shouldAddToLastElement == null) {
                MyVisitor.$$$reportNull$$$0(27);
            }
            if (listChildren == null) {
                MyVisitor.$$$reportNull$$$0(28);
            }
            this.applyTrailingCommaStyle((JSElement)ArrayUtil.getLastElement((Object[])listChildren), rBracketType, shouldAddToLastElement);
        }

        private <T extends JSElement> void applyTrailingCommaStyle(T @NotNull [] listChildren, @NotNull IElementType rBracketType) {
            if (rBracketType == null) {
                MyVisitor.$$$reportNull$$$0(29);
            }
            if (listChildren == null) {
                MyVisitor.$$$reportNull$$$0(30);
            }
            this.applyTrailingCommaStyle((JSElement)ArrayUtil.getLastElement((Object[])listChildren), rBracketType, Conditions.alwaysTrue());
        }

        private <T extends JSElement> void applyTrailingCommaStyle(@Nullable T lastListElement, @NotNull IElementType rBracketType, @NotNull Condition<T> shouldAddToLastElement) {
            JSCodeStyleSettings.TrailingCommaOption settingValue;
            if (rBracketType == null) {
                MyVisitor.$$$reportNull$$$0(31);
            }
            if (shouldAddToLastElement == null) {
                MyVisitor.$$$reportNull$$$0(32);
            }
            if ((settingValue = this.languageSettings.ENFORCE_TRAILING_COMMA) == JSCodeStyleSettings.TrailingCommaOption.Keep) {
                return;
            }
            if (lastListElement == null || !this.containedInRange((PsiElement)lastListElement)) {
                return;
            }
            PsiElement afterList = PsiTreeUtil.skipWhitespacesAndCommentsForward(lastListElement);
            if (afterList instanceof OuterLanguageElement || afterList != null && PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)afterList) instanceof OuterLanguageElement) {
                return;
            }
            if (settingValue == JSCodeStyleSettings.TrailingCommaOption.Remove) {
                if (JSEnforceCodeStylePostProcessor.isComma(afterList)) {
                    this.deleteNode(afterList.getNode());
                }
            } else if (settingValue == JSCodeStyleSettings.TrailingCommaOption.WhenMultiline) {
                PsiElement whitespaceToCheck;
                PsiElement parent = lastListElement.getParent();
                if (parent == null) {
                    return;
                }
                ASTNode rBracket = parent.getNode().findChildByType(rBracketType);
                ASTNode beforeBracketNode = rBracket != null ? rBracket.getTreePrev() : null;
                PsiElement psiElement = whitespaceToCheck = beforeBracketNode != null ? beforeBracketNode.getPsi() : null;
                if (JSEnforceCodeStylePostProcessor.isComma(afterList)) {
                    if (!JSEnforceCodeStylePostProcessor.isNewLineWS(whitespaceToCheck)) {
                        this.deleteNode(afterList.getNode());
                    }
                } else if (JSEnforceCodeStylePostProcessor.isNewLineWS(whitespaceToCheck) && shouldAddToLastElement.value(lastListElement)) {
                    this.insertString(lastListElement.getTextRange().getEndOffset(), ",");
                }
            }
        }

        private void insertString(int offset, String result) {
            int actualOffset = this.myPostProcessorHelper.mapOffset(offset);
            this.myDocument.insertString(actualOffset, (CharSequence)result);
            this.myPostProcessorHelper.updateResultRange(0, result.length());
        }

        private void deleteNode(ASTNode node) {
            TextRange range = node.getTextRange();
            this.replaceRange(range.getStartOffset(), range.getEndOffset(), "");
        }

        private void replaceRange(int start, int end, String result) {
            int mappedStart = this.myPostProcessorHelper.mapOffset(start);
            int mappedEnd = this.myPostProcessorHelper.mapOffset(end);
            this.myDocument.replaceString(mappedStart, mappedEnd, (CharSequence)result);
            this.myPostProcessorHelper.updateResultRange(mappedEnd - mappedStart, result.length());
        }

        private boolean containedInRange(@NotNull PsiElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(33);
            }
            return this.myOriginalRange.contains(element.getTextRange());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageDialect";
                    break;
                }
                case 5: 
                case 22: 
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importDeclaration";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "imports";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportDeclaration";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 23: 
                case 24: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destructuringObject";
                    break;
                }
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectType";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destructuringArray";
                    break;
                }
                case 26: 
                case 29: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rBracketType";
                    break;
                }
                case 27: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shouldAddToLastElement";
                    break;
                }
                case 28: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listChildren";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/formatter/JSEnforceCodeStylePostProcessor$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitES6ImportDeclaration";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitES6NamedImports";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitES6ExportDeclaration";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitES6ExportDefaultAssignment";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSStatement";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSTryStatement";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForStatement";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSForInStatement";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSArrayLiteralExpression";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSObjectLiteralExpression";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSParameterList";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSArgumentList";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDestructuringObject";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeScriptObjectType";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canUseSemicolonAsSeparator";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDestructuringArray";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyJavaScriptQuoteStyle";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applySemicolonStyle";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateSemicolonIfNeeded";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkForceSemicolonCondition";
                    break;
                }
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyTrailingCommaStyle";
                    break;
                }
                case 33: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containedInRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

