/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public class QuoteIdentifierQuickFix
implements LocalQuickFix {
    @FileModifier.SafeFieldForPreview
    private final SqlLanguageDialect myDialect;

    public QuoteIdentifierQuickFix(SqlLanguageDialect dialect) {
        this.myDialect = dialect;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"quickfix.name.quote.identifier", (Object[])new Object[0]);
        if (string == null) {
            QuoteIdentifierQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            QuoteIdentifierQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            QuoteIdentifierQuickFix.$$$reportNull$$$0(2);
        }
        if (!((element = descriptor.getPsiElement()) instanceof SqlIdentifier)) {
            return;
        }
        SqlImplUtil.quoteIdentifier(project, (SqlIdentifier)element, this.myDialect);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/QuoteIdentifierQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/QuoteIdentifierQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

