/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.go;

import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.go.UtilsKt;
import com.intellij.packageChecker.model.Package;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u001c0\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/intellij/packageChecker/go/GoBuildFileProvider;", "Lcom/intellij/packageChecker/api/BuildFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "id", "", "getId", "()Ljava/lang/String;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "()V", "importedPackages", "", "Lcom/intellij/packageChecker/model/Package;", "file", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "declaredDependencies", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "supports", "", "getRoots", "", "", "pkgs", "updatePackageDeclaration", "", "pkg", "version", "getModule", "fixSafeVersion", "intellij.packageChecker.go"})
@SourceDebugExtension(value={"SMAP\nGoBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoBuildFileProvider.kt\ncom/intellij/packageChecker/go/GoBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1617#2,9:75\n1869#2:84\n1870#2:86\n1626#2:87\n1617#2,9:88\n1869#2:97\n1870#2:99\n1626#2:100\n1285#2,2:101\n1299#2,4:103\n669#2,11:107\n1#3:85\n1#3:98\n*S KotlinDebug\n*F\n+ 1 GoBuildFileProvider.kt\ncom/intellij/packageChecker/go/GoBuildFileProvider\n*L\n26#1:75,9\n26#1:84\n26#1:86\n26#1:87\n41#1:88,9\n41#1:97\n41#1:99\n41#1:100\n41#1:101,2\n41#1:103,4\n47#1:107,11\n26#1:85\n41#1:98\n*E\n"})
public final class GoBuildFileProvider
implements BuildFileProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final String id;
    @NotNull
    private final Logger logger;

    public GoBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.id = "go";
        Logger logger = Logger.getInstance(GoBuildFileProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    private static /* synthetic */ void getLogger$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = GoUtil.module((PsiElement)((PsiElement)file));
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        VgoModule vgoModule = VgoModulesRegistry.getInstance((Project)this.project).findVgoModule(module2, file.getVirtualFile());
        if (vgoModule == null) {
            return CollectionsKt.emptyList();
        }
        VgoModule vgoModule2 = vgoModule;
        Collection collection = vgoModule2.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDependencies(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VgoDependency it = (VgoDependency)element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNull((Object)it);
            Package package_ = UtilsKt.toPackage(it, this.project);
            if (package_ == null) {
                package_ = null;
            }
            if (package_ == null) continue;
            Package it$iv$iv = package_;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean supports(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilsKt.isEnabled(file);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return UtilsKt.isEnabled(module);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Package, Set<Package>> getRoots(@NotNull PsiFile file, @NotNull List<Package> pkgs2) {
        void $this$associateWithTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        Iterable $this$mapNotNull$iv = UtilsKt.getDependencies(file);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Package it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VgoModuleSpec it = (VgoModuleSpec)element$iv$iv;
            boolean bl2 = false;
            if (UtilsKt.toPackage(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        destination$iv$iv = $this$associateWith$iv;
        Map destination$iv$iv2 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            element$iv$iv$iv = (Package)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Set set = SetsKt.emptySet();
            map2.put(t, set);
        }
        return destination$iv$iv2;
    }

    @Override
    public void updatePackageDeclaration(@NotNull PsiFile file, @NotNull Package pkg, @NotNull String version) {
        Object v3;
        VgoModule vgoModule;
        String safeVersion;
        Module module;
        block5: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Module module2 = this.getModule(file);
            if (module2 == null) {
                return;
            }
            module = module2;
            safeVersion = this.fixSafeVersion(version);
            VgoModule vgoModule2 = VgoModulesRegistry.getInstance((Project)this.project).findVgoModule(module, file.getVirtualFile());
            if (vgoModule2 == null) {
                return;
            }
            vgoModule = vgoModule2;
            Collection collection = vgoModule.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDependencies(...)");
            Iterable $this$singleOrNull$iv = collection;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                VgoDependency it = (VgoDependency)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)UtilsKt.toPackage(it, this.project), (Object)pkg)) continue;
                if (found$iv) {
                    v3 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v3 = !found$iv ? null : single$iv;
        }
        VgoDependency vgoDependency = v3;
        if (vgoDependency == null) {
            return;
        }
        VgoDependency dependency = vgoDependency;
        VgoUtil.addDependencyToGoMod((String)(dependency.getImportPath() + "@" + safeVersion), (Project)module.getProject(), (VgoModule)vgoModule);
    }

    private final Module getModule(PsiFile file) {
        if (!(file instanceof VgoFile)) {
            this.logger.warn("Not a Go module file: " + file.getName());
            return null;
        }
        Module module = GoUtil.module((PsiElement)((PsiElement)file));
        if (module == null) {
            this.logger.warn("Not a Go module by file: " + ((VgoFile)file).getName());
        }
        return module;
    }

    private final String fixSafeVersion(String version) {
        return StringsKt.startsWith$default((String)version, (String)"v", (boolean)false, (int)2, null) ? version : "v" + version;
    }
}

