/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.editors;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNodeEditingManager;
import com.intellij.diagram.DiagramNodeEditor;
import com.intellij.diagram.DiagramNodeRenderer;
import com.intellij.diagram.components.DiagramNodeBodyComponent;
import com.intellij.diagram.components.DiagramNodeHeaderComponent;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ComponentUtil;
import com.intellij.uml.core.renderers.DefaultUmlRenderer;
import java.awt.Rectangle;
import java.util.Optional;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramNodeCellEditor
extends AbstractCellEditor
implements DiagramNodeEditor {
    @NotNull
    private final DiagramBuilder myBuilder;
    @Nullable
    private JComponent myEditorComponent;

    public DiagramNodeCellEditor(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramNodeCellEditor.$$$reportNull$$$0(0);
        }
        this.myBuilder = builder;
    }

    @Override
    @Nullable
    public Object getCurrentValue() {
        return this.getSelectedItem();
    }

    @Override
    @Nullable
    public Object getCellEditorValue() {
        return this.getSelectedItem();
    }

    @Nullable
    private Object getSelectedItem() {
        return Optional.ofNullable(this.getNodeBodyComponent()).map(it -> it.getSelectedValue()).orElse(null);
    }

    @Nullable
    private DiagramNodeHeaderComponent getNodeHeaderComponent() {
        return ComponentUtil.findComponentsOfType((JComponent)this.getEditorComponent(), DiagramNodeHeaderComponent.class).stream().findFirst().orElse(null);
    }

    @Nullable
    private DiagramNodeBodyComponent getNodeBodyComponent() {
        return ComponentUtil.findComponentsOfType((JComponent)this.getEditorComponent(), DiagramNodeBodyComponent.class).stream().findFirst().orElse(null);
    }

    @Override
    @Nullable
    public JComponent getEditorComponent() {
        return this.myEditorComponent;
    }

    @Override
    @Nullable
    public Rectangle getSelectionBoundsOnCanvas() {
        DiagramNodeBodyComponent items = this.getNodeBodyComponent();
        if (items == null) {
            return null;
        }
        int selectedItemIndex = Math.max(0, items.getSelectedIndex());
        Node selectedNode = GraphSelectionService.getInstance().getSingleSelectedNode(this.myBuilder.getGraph());
        if (selectedNode == null) {
            return null;
        }
        Rectangle nodeCanvasBounds = GraphCanvasLocationService.getInstance().getNodeBoundsOnCanvas(selectedNode, this.myBuilder.getGraphBuilder());
        Rectangle itemBounds = items.getItemBounds(selectedItemIndex, true);
        double zoom = this.myBuilder.getView().getZoom();
        itemBounds.x = (int)((double)itemBounds.x * zoom);
        itemBounds.y = (int)((double)itemBounds.y * zoom);
        itemBounds.width = (int)((double)itemBounds.width * zoom);
        itemBounds.height = (int)((double)itemBounds.height * zoom);
        itemBounds.translate(nodeCanvasBounds.x, nodeCanvasBounds.y);
        return itemBounds;
    }

    public JComponent getNodeCellEditorComponent(@NotNull Graph2DView view, @NotNull NodeRealizer context, @Nullable Object value, boolean isSelected) {
        if (view == null) {
            DiagramNodeCellEditor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DiagramNodeCellEditor.$$$reportNull$$$0(2);
        }
        if (this.myEditorComponent == null) {
            this.initEditor(context);
        }
        return this.myEditorComponent;
    }

    private void initEditor(@NotNull NodeRealizer realizer) {
        DiagramNodeRenderer renderer;
        if (realizer == null) {
            DiagramNodeCellEditor.$$$reportNull$$$0(3);
        }
        if (!((renderer = this.myBuilder.getPresentationModel().getRenderer()) instanceof DefaultUmlRenderer)) {
            return;
        }
        DefaultUmlRenderer umlRenderer = (DefaultUmlRenderer)this.myBuilder.getPresentationModel().getRenderer();
        CellRendererPanel panel = new CellRendererPanel();
        panel.setOpaque(true);
        panel.setBorder(umlRenderer.getBorder(realizer, null, true));
        panel.setFocusable(false);
        panel.putClientProperty((Object)"cell.editor", (Object)Boolean.TRUE);
        panel.putClientProperty((Object)"NodeCellRenderer.noImage", (Object)Boolean.TRUE);
        umlRenderer.tuneNode(realizer, (JPanel)panel, GraphCanvasLocationService.getInstance().getNodeCoordinatesOnScreen(realizer.getNode(), this.myBuilder.getGraphBuilder()));
        this.myEditorComponent = panel;
        DiagramNodeEditingManager.getInstance().startEditing(this, this.myBuilder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realizer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/editors/DiagramNodeCellEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getNodeCellEditorComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "initEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

