/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.webcore.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaConfig {
    private static final Logger LOG = Logger.getInstance(KarmaConfig.class);
    private static final String BASE_PATH = "basePath";
    private static final String BROWSERS = "browsers";
    private static final String PROTOCOL = "protocol";
    private static final String HOST_NAME = "hostname";
    private static final String URL_ROOT = "urlRoot";
    private static final String DEBUG_INFO = "debugInfo";
    private static final String REMOTE_DEBUGGING_PORT = "--remote-debugging-port";
    private final List<String> myBrowsers;
    private final String myBasePath;
    private final String myProtocol;
    private final String myHostname;
    private final String myUrlRoot;
    private final int myRemoteDebuggingPort;

    public KarmaConfig(@NotNull String basePath, @NotNull List<String> browsers, @NotNull String protocol, @NotNull String hostname, @NotNull String urlRoot, int remoteDebuggingPort) {
        if (basePath == null) {
            KarmaConfig.$$$reportNull$$$0(0);
        }
        if (browsers == null) {
            KarmaConfig.$$$reportNull$$$0(1);
        }
        if (protocol == null) {
            KarmaConfig.$$$reportNull$$$0(2);
        }
        if (hostname == null) {
            KarmaConfig.$$$reportNull$$$0(3);
        }
        if (urlRoot == null) {
            KarmaConfig.$$$reportNull$$$0(4);
        }
        this.myBasePath = basePath;
        this.myBrowsers = ImmutableList.copyOf(browsers);
        this.myProtocol = protocol;
        this.myHostname = hostname;
        this.myUrlRoot = urlRoot;
        this.myRemoteDebuggingPort = remoteDebuggingPort;
    }

    @NotNull
    public String getBasePath() {
        String string = this.myBasePath;
        if (string == null) {
            KarmaConfig.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public List<String> getBrowsers() {
        List<String> list = this.myBrowsers;
        if (list == null) {
            KarmaConfig.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public String getProtocol() {
        String string = this.myProtocol;
        if (string == null) {
            KarmaConfig.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getHostname() {
        String string = this.myHostname;
        if (string == null) {
            KarmaConfig.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getUrlRoot() {
        String string = this.myUrlRoot;
        if (string == null) {
            KarmaConfig.$$$reportNull$$$0(9);
        }
        return string;
    }

    public int getRemoteDebuggingPort() {
        return this.myRemoteDebuggingPort;
    }

    @Nullable
    public static KarmaConfig parseFromJson(@NotNull JsonElement jsonElement, @NotNull String configurationFileDir) {
        if (jsonElement == null) {
            KarmaConfig.$$$reportNull$$$0(10);
        }
        if (configurationFileDir == null) {
            KarmaConfig.$$$reportNull$$$0(11);
        }
        if (jsonElement.isJsonObject()) {
            JsonObject rootObject = jsonElement.getAsJsonObject();
            List<String> browsers = KarmaConfig.parseBrowsers(rootObject);
            String basePath = KarmaConfig.parseBasePath(jsonElement, rootObject, configurationFileDir);
            String protocol = (String)ObjectUtils.notNull((Object)JsonUtil.getChildAsString((JsonObject)rootObject, (String)PROTOCOL), (Object)"http:");
            String hostname = KarmaConfig.parseHostname(jsonElement, rootObject);
            String urlRoot = KarmaConfig.parseUrlRoot(jsonElement, rootObject);
            JsonObject debugInfoObj = JsonUtil.getChildAsObject((JsonObject)rootObject, (String)DEBUG_INFO);
            int remoteDebuggingPort = debugInfoObj != null ? JsonUtil.getChildAsInteger((JsonObject)debugInfoObj, (String)REMOTE_DEBUGGING_PORT, (int)-1) : -1;
            return new KarmaConfig(basePath, browsers, protocol, hostname, urlRoot, remoteDebuggingPort);
        }
        return null;
    }

    @NotNull
    private static String parseBasePath(@NotNull JsonElement all, @NotNull JsonObject obj, @NotNull String configurationFileDir) {
        String basePath;
        if (all == null) {
            KarmaConfig.$$$reportNull$$$0(12);
        }
        if (obj == null) {
            KarmaConfig.$$$reportNull$$$0(13);
        }
        if (configurationFileDir == null) {
            KarmaConfig.$$$reportNull$$$0(14);
        }
        if ((basePath = JsonUtil.getChildAsString((JsonObject)obj, (String)BASE_PATH)) == null) {
            LOG.warn("Can not parse Karma config.basePath from " + String.valueOf(all));
            basePath = configurationFileDir;
        }
        String string = basePath;
        if (string == null) {
            KarmaConfig.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static String parseUrlRoot(@NotNull JsonElement all, @NotNull JsonObject obj) {
        Object urlRoot;
        if (all == null) {
            KarmaConfig.$$$reportNull$$$0(16);
        }
        if (obj == null) {
            KarmaConfig.$$$reportNull$$$0(17);
        }
        if ((urlRoot = JsonUtil.getChildAsString((JsonObject)obj, (String)URL_ROOT)) == null) {
            LOG.warn("Can not parse Karma config.urlRoot from " + String.valueOf(all));
            urlRoot = "/";
        }
        if (!((String)urlRoot).startsWith("/")) {
            urlRoot = "/" + (String)urlRoot;
        }
        if (((String)urlRoot).length() > 1 && ((String)urlRoot).endsWith("/")) {
            urlRoot = ((String)urlRoot).substring(0, ((String)urlRoot).length() - 1);
        }
        return urlRoot;
    }

    private static String parseHostname(@NotNull JsonElement all, @NotNull JsonObject obj) {
        String hostname;
        if (all == null) {
            KarmaConfig.$$$reportNull$$$0(18);
        }
        if (obj == null) {
            KarmaConfig.$$$reportNull$$$0(19);
        }
        if ((hostname = JsonUtil.getChildAsString((JsonObject)obj, (String)HOST_NAME)) == null) {
            LOG.warn("Can not parse Karma config.hostname from " + String.valueOf(all));
            hostname = "localhost";
        }
        hostname = StringUtil.toLowerCase((String)hostname);
        return hostname;
    }

    @NotNull
    private static List<String> parseBrowsers(@NotNull JsonObject obj) {
        JsonElement browsersElement;
        if (obj == null) {
            KarmaConfig.$$$reportNull$$$0(20);
        }
        if ((browsersElement = obj.get(BROWSERS)) != null && browsersElement.isJsonArray()) {
            JsonArray browsersArray = browsersElement.getAsJsonArray();
            ArrayList<String> browsers = new ArrayList<String>();
            for (JsonElement browserElement : browsersArray) {
                String browser = JsonUtil.getString((JsonElement)browserElement);
                if (browser == null) continue;
                browsers.add(browser);
            }
            ArrayList<String> arrayList = browsers;
            if (arrayList == null) {
                KarmaConfig.$$$reportNull$$$0(21);
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            KarmaConfig.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 15, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = BASE_PATH;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = BROWSERS;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROTOCOL;
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = HOST_NAME;
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ROOT;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/karma/KarmaConfig";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonElement";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFileDir";
                break;
            }
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "all";
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/karma/KarmaConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowsers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostname";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlRoot";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBasePath";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBrowsers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 21: 
            case 22: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseFromJson";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseBasePath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseUrlRoot";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseHostname";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseBrowsers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 15, 21, 22 -> new IllegalStateException(string);
        };
    }
}

