/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.debugger.JSDebuggerUiUtil;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.jetbrains.plugins.reactnative.PackagerState;
import com.jetbrains.plugins.reactnative.ReactNativeDebuggerBundle;
import com.jetbrains.plugins.reactnative.ReactNativePackager;
import com.jetbrains.plugins.reactnative.ReactNativePackagerBeforeRunTask;
import com.jetbrains.plugins.reactnative.ReactNativePackagerConfigurationEditor;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunnerKt;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTaskProvider;", "Lcom/intellij/execution/BeforeRunTaskProvider;", "Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTask;", "<init>", "()V", "getId", "Lcom/intellij/openapi/util/Key;", "getIcon", "Ljavax/swing/Icon;", "getName", "", "createTask", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "executeTask", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "configuration", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "task", "isConfigurable", "configureTask", "Lorg/jetbrains/concurrency/Promise;", "Companion", "intellij.javascript.reactNativeDebugger"})
public final class ReactNativePackagerBeforeRunTaskProvider
extends BeforeRunTaskProvider<ReactNativePackagerBeforeRunTask> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<ReactNativePackagerBeforeRunTask> ID;

    @NotNull
    public Key<ReactNativePackagerBeforeRunTask> getId() {
        return ID;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaScriptLanguageIcons.Logos.Jsx_16;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Jsx_16");
        return icon;
    }

    @NotNull
    public String getName() {
        String string = ReactNativeDebuggerBundle.message("react.native.task.bundler", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public ReactNativePackagerBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        return runConfiguration instanceof ReactNativeRunConfiguration ? new ReactNativePackagerBeforeRunTask() : null;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull ReactNativePackagerBeforeRunTask task) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        if (!(configuration instanceof ReactNativeRunConfiguration)) {
            JavaScriptDebugProcessKt.getLOG().error("Can't apply ReactNativePackagerBeforeRunTask to " + configuration.getClass().getName());
            return false;
        }
        Project project = env.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PackagerState packagerState = ReactNativePackager.Companion.getInstance(project).startPackager((ReactNativeRunConfiguration)configuration);
        if (packagerState == null) {
            NotificationGroup notificationGroup = JSDebuggerUiUtil.INSTANCE.getNOTIFICATION_GROUP();
            Object[] objectArray = new Object[]{this.getName(), ((ReactNativeRunConfiguration)configuration).getName()};
            String string = ReactNativeDebuggerBundle.message("react.native.task.error", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            MessageType messageType = MessageType.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
            notificationGroup.createNotification(string, messageType).notify(env.getProject());
            return false;
        }
        ProcessHandler packagerProcess = packagerState.getProcess();
        if (!packagerState.getAlreadyStarted()) {
            ApplicationManager.getApplication().invokeLater(() -> ReactNativePackagerBeforeRunTaskProvider.executeTask$lambda$0(packagerProcess, env));
        }
        return true;
    }

    public boolean isConfigurable() {
        return true;
    }

    @NotNull
    public Promise<Boolean> configureTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ReactNativePackagerBeforeRunTask task) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ReactNativePackagerConfigurationEditor dialog = new ReactNativePackagerConfigurationEditor(project);
        dialog.show();
        return Promises.resolvedPromise((Object)false);
    }

    private static final void executeTask$lambda$0(ProcessHandler $packagerProcess, ExecutionEnvironment $env) {
        ReactNativeProgramRunnerKt.showHelperProcessRunContent("react-native start", $packagerProcess, $env);
        $packagerProcess.startNotify();
    }

    static {
        Key key = Key.create((String)"ReactNativePackager");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        ID = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R'\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTaskProvider$Companion;", "", "<init>", "()V", "ID", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/plugins/reactnative/ReactNativePackagerBeforeRunTask;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getID$intellij_javascript_reactNativeDebugger", "()Lcom/intellij/openapi/util/Key;", "intellij.javascript.reactNativeDebugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<ReactNativePackagerBeforeRunTask> getID$intellij_javascript_reactNativeDebugger() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

