/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.RdProjectIdUtils;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\n\u0010\u000e\u001a\u00020\t*\u00020\u0006\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\t*\u00020\u0006\u001a\n\u0010\u0010\u001a\u00020\u0006*\u00020\t\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"(\u0010\b\u001a\u00020\u0006*\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"rdEarlyProjectDir", "Lcom/intellij/openapi/util/Key;", "", "getRdEarlyProjectDir", "()Lcom/intellij/openapi/util/Key;", "rdProjectUniqueId", "Lcom/jetbrains/rd/ide/model/RdProjectId;", "value", "rdProjectId", "Lcom/intellij/openapi/project/Project;", "getRdProjectId", "(Lcom/intellij/openapi/project/Project;)Lcom/jetbrains/rd/ide/model/RdProjectId;", "setRdProjectId", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/RdProjectId;)V", "toProject", "toProjectOrNull", "getOrCreateRdProjectId", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nProjectUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectUtil.kt\ncom/jetbrains/rd/platform/ProjectUtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n*L\n1#1,111:1\n3260#2,11:112\n68#3,6:123\n*S KotlinDebug\n*F\n+ 1 ProjectUtil.kt\ncom/jetbrains/rd/platform/ProjectUtilKt\n*L\n38#1:112,11\n40#1:123,6\n*E\n"})
public final class ProjectUtilKt {
    @NotNull
    private static final Key<String> rdEarlyProjectDir = new Key("rd.early.project.dir");
    @NotNull
    private static final Key<RdProjectId> rdProjectUniqueId = new Key("rd.project.uniqueId");

    @NotNull
    public static final Key<String> getRdEarlyProjectDir() {
        return rdEarlyProjectDir;
    }

    @NotNull
    public static final RdProjectId getRdProjectId(@NotNull Project $this$rdProjectId) {
        Intrinsics.checkNotNullParameter((Object)$this$rdProjectId, (String)"<this>");
        RdProjectId rdProjectId = (RdProjectId)$this$rdProjectId.getUserData(rdProjectUniqueId);
        if (rdProjectId == null) {
            throw new IllegalStateException(("rdProjectId must not be null. project: " + $this$rdProjectId).toString());
        }
        return rdProjectId;
    }

    public static final void setRdProjectId(@NotNull Project $this$rdProjectId, @NotNull RdProjectId value) {
        Intrinsics.checkNotNullParameter((Object)$this$rdProjectId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$rdProjectId.putUserData(rdProjectUniqueId, (Object)value);
    }

    @NotNull
    public static final Project toProject(@NotNull RdProjectId $this$toProject) {
        Intrinsics.checkNotNullParameter((Object)$this$toProject, (String)"<this>");
        Project project = ProjectUtilKt.toProjectOrNull($this$toProject);
        if (project == null) {
            throw new ProcessCanceledException((Throwable)new CancellationException("Can not find opened project with id " + $this$toProject));
        }
        return project;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Project toProjectOrNull(@NotNull RdProjectId $this$toProjectOrNull) {
        Object object;
        block2: {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)$this$toProjectOrNull, (String)"<this>");
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] $this$singleOrNull$iv = projectArray;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Project it = (Project)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUserData(rdProjectUniqueId), (Object)$this$toProjectOrNull)) continue;
                if (found$iv) {
                    object = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_3;
        }
        return (Project)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RdProjectId getOrCreateRdProjectId(@NotNull Project $this$getOrCreateRdProjectId) {
        void $this$getOrCreateUserDataUnsafe$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getOrCreateRdProjectId, (String)"<this>");
        UserDataHolder userDataHolder = (UserDataHolder)$this$getOrCreateRdProjectId;
        Key<RdProjectId> key$iv = rdProjectUniqueId;
        boolean $i$f$getOrCreateUserDataUnsafe = false;
        Object existing$iv = $this$getOrCreateUserDataUnsafe$iv.getUserData(key$iv);
        Object object = existing$iv;
        if (object == null) {
            boolean bl = false;
            RdProjectId value$iv = RdProjectIdUtils.INSTANCE.newUniqueProjectId($this$getOrCreateRdProjectId);
            $this$getOrCreateUserDataUnsafe$iv.putUserData(key$iv, (Object)value$iv);
            object = value$iv;
        }
        return (RdProjectId)object;
    }
}

