/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientDebuggerEvaluator;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientSourcePosition;
import com.intellij.platform.execution.frontend.split.debugger.ThinClientValueContainerBase;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.codeWithMe.model.SourcePositionModel;
import com.jetbrains.codeWithMe.model.StackFrameModel;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.ColoredTextContainerModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RichStringModel;
import com.jetbrains.rd.ide.model.SourcePositionBase;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.util.idea.ui.ModelRichTextExKt;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientStackFrame;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "frameModel", "Lcom/jetbrains/codeWithMe/model/StackFrameModel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/codeWithMe/model/StackFrameModel;)V", "getFrameModel", "()Lcom/jetbrains/codeWithMe/model/StackFrameModel;", "getSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getEqualityObject", "", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "getEvaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "customizePresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "Companion", "intellij.platform.execution.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientStackFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientStackFrame.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientStackFrame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,62:1\n1869#2,2:63\n13#3:65\n13#4:66\n*S KotlinDebug\n*F\n+ 1 ThinClientStackFrame.kt\ncom/intellij/platform/execution/frontend/split/debugger/ThinClientStackFrame\n*L\n54#1:63,2\n60#1:65\n60#1:66\n*E\n"})
public final class ThinClientStackFrame
extends XStackFrame {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final StackFrameModel frameModel;
    @NotNull
    private static final Logger logger;

    public ThinClientStackFrame(@NotNull Lifetime lifetime, @NotNull XDebugSession session2, @NotNull StackFrameModel frameModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)frameModel, (String)"frameModel");
        this.lifetime = lifetime;
        this.session = session2;
        this.frameModel = frameModel;
    }

    @NotNull
    public final StackFrameModel getFrameModel() {
        return this.frameModel;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        ThinClientSourcePosition thinClientSourcePosition;
        SourcePositionBase sourcePositionBase = this.frameModel.getSourcePosition();
        if (sourcePositionBase != null) {
            SourcePositionBase it = sourcePositionBase;
            boolean bl = false;
            thinClientSourcePosition = ThinClientSourcePosition.Companion.create((SourcePositionModel)it);
        } else {
            thinClientSourcePosition = null;
        }
        return thinClientSourcePosition;
    }

    @NotNull
    public Object getEqualityObject() {
        return CollectionsKt.joinToString$default((Iterable)this.frameModel.getPresentation().getFragments().getParts(), null, null, null, (int)0, null, ThinClientStackFrame::getEqualityObject$lambda$0, (int)31, null);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.isObsolete()) {
            return;
        }
        ThinClientValueContainerBase.INSTANCE.computeChildren(this.frameModel.getComputeLocals(), Unit.INSTANCE, this.session, this.lifetime, node, logger);
    }

    @NotNull
    public XDebuggerEvaluator getEvaluator() {
        return new ThinClientDebuggerEvaluator(this.lifetime, this.session, this.frameModel);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (component instanceof JComponent && !Intrinsics.areEqual((Object)((Component)component).getBackground(), (Object)UIUtil.getListSelectionBackground((boolean)true)) && !Intrinsics.areEqual((Object)((Component)component).getBackground(), (Object)UIUtil.getListSelectionBackground((boolean)false))) {
            AbstractColor backgroundColor = this.frameModel.getPresentation().getBackgroundColor();
            JComponent jComponent = (JComponent)component;
            Object object = backgroundColor;
            if (object == null || (object = ColorHostKt.toColor((AbstractColor)object)) == null) {
                Color color = UIUtil.getListBackground();
                object = color;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getListBackground(...)");
            }
            jComponent.setBackground((Color)object);
        }
        ColoredTextContainerModel presentationModel = this.frameModel.getPresentation();
        component.setToolTipText(presentationModel.getTooltipText());
        IconModel iconModel = presentationModel.getIcon();
        component.setIcon(iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null);
        Iterable $this$forEach$iv = presentationModel.getFragments().getParts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RichStringModel part = (RichStringModel)element$iv;
            boolean bl = false;
            component.append(part.getText(), ModelRichTextExKt.toSimpleTextAttributes$default((RichStringModel)part, null, null, (boolean)false, (int)7, null));
        }
    }

    private static final CharSequence getEqualityObject$lambda$0(RichStringModel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText();
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientStackFrame.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientStackFrame.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/execution/frontend/split/debugger/ThinClientStackFrame$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.frontend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

