/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.full.KTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u001a#\u0010\u0000\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a#\u0010\u0005\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0001\u001a#\u0010\u0007\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0002\u001a\u001a\u0010\t\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u001d\u0010\t\u001a\u00020\u0001\"\u0006\b\u0000\u0010\f\u0018\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003H\u0086\b\u001a\u001d\u0010\r\u001a\u00020\u0001\"\u0006\b\u0000\u0010\f\u0018\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003H\u0086\b\u001a\u0012\u0010\u000e\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003\u001a\u0012\u0010\u000f\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003H\u0007\u001a\u0012\u0010\u0012\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003\u001a\u0014\u0010\u0013\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003H\u0001\u001a\u0010\u0010\u0013\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0014H\u0000\u00f2\u0001\u0018\n\u0006\u0012\u0002\b\u00030\u0004\n\u0006\u0012\u0002\b\u00030\u0006\n\u0006\u0012\u0002\b\u00030\b\u00a8\u0006\u0015"}, d2={"isColumnGroup", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnGroup;", "isFrameColumn", "Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;", "isValueColumn", "Lorg/jetbrains/kotlinx/dataframe/columns/ValueColumn;", "isSubtypeOf", "type", "Lkotlin/reflect/KType;", "T", "isType", "isNumber", "isBigNumber", "isList", "isComparable", "valuesAreComparable", "isPrimitive", "Lkotlin/reflect/KClass;", "core"})
@SourceDebugExtension(value={"SMAP\nDataColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataColumnType.kt\norg/jetbrains/kotlinx/dataframe/api/DataColumnTypeKt\n*L\n1#1,90:1\n46#1:91\n46#1:92\n46#1:93\n*S KotlinDebug\n*F\n+ 1 DataColumnType.kt\norg/jetbrains/kotlinx/dataframe/api/DataColumnTypeKt\n*L\n50#1:91\n52#1:92\n75#1:93\n*E\n"})
public final class DataColumnTypeKt {
    public static final boolean isColumnGroup(@NotNull DataColumn<?> $this$isColumnGroup) {
        Intrinsics.checkNotNullParameter($this$isColumnGroup, (String)"<this>");
        return $this$isColumnGroup.kind() == ColumnKind.Group;
    }

    public static final boolean isFrameColumn(@NotNull DataColumn<?> $this$isFrameColumn) {
        Intrinsics.checkNotNullParameter($this$isFrameColumn, (String)"<this>");
        return $this$isFrameColumn.kind() == ColumnKind.Frame;
    }

    public static final boolean isValueColumn(@NotNull DataColumn<?> $this$isValueColumn) {
        Intrinsics.checkNotNullParameter($this$isValueColumn, (String)"<this>");
        return $this$isValueColumn.kind() == ColumnKind.Value;
    }

    public static final boolean isSubtypeOf(@NotNull DataColumn<?> $this$isSubtypeOf, @NotNull KType type) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return KTypes.isSubtypeOf((KType)DataColumnKt.getType($this$isSubtypeOf), (KType)type) && (!DataColumnKt.getType($this$isSubtypeOf).isMarkedNullable() || type.isMarkedNullable());
    }

    public static final /* synthetic */ <T> boolean isSubtypeOf(DataColumn<?> $this$isSubtypeOf) {
        Intrinsics.checkNotNullParameter($this$isSubtypeOf, (String)"<this>");
        boolean $i$f$isSubtypeOf = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        return DataColumnTypeKt.isSubtypeOf($this$isSubtypeOf, null);
    }

    public static final /* synthetic */ <T> boolean isType(DataColumn<?> $this$isType) {
        Intrinsics.checkNotNullParameter($this$isType, (String)"<this>");
        boolean $i$f$isType = false;
        KType kType = $this$isType.type();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        return Intrinsics.areEqual((Object)kType, null);
    }

    public static final boolean isNumber(@NotNull DataColumn<?> $this$isNumber) {
        Intrinsics.checkNotNullParameter($this$isNumber, (String)"<this>");
        DataColumn<?> $this$isSubtypeOf$iv = $this$isNumber;
        boolean $i$f$isSubtypeOf = false;
        return DataColumnTypeKt.isSubtypeOf($this$isSubtypeOf$iv, Reflection.nullableTypeOf(Number.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBigNumber(@NotNull DataColumn<?> $this$isBigNumber) {
        Intrinsics.checkNotNullParameter($this$isBigNumber, (String)"<this>");
        DataColumn<?> $this$isSubtypeOf$iv = $this$isBigNumber;
        boolean $i$f$isSubtypeOf = false;
        if (DataColumnTypeKt.isSubtypeOf($this$isSubtypeOf$iv, Reflection.nullableTypeOf(BigInteger.class))) return true;
        $this$isSubtypeOf$iv = $this$isBigNumber;
        $i$f$isSubtypeOf = false;
        if (!DataColumnTypeKt.isSubtypeOf($this$isSubtypeOf$iv, Reflection.nullableTypeOf(BigDecimal.class))) return false;
        return true;
    }

    public static final boolean isList(@NotNull DataColumn<?> $this$isList) {
        Intrinsics.checkNotNullParameter($this$isList, (String)"<this>");
        return Intrinsics.areEqual(DataColumnKt.getTypeClass($this$isList), (Object)Reflection.getOrCreateKotlinClass(List.class));
    }

    @Deprecated(message="This function is replaced by `valuesAreComparable()` to better reflect its purpose. Will be ERROR in 0.16.", replaceWith=@ReplaceWith(expression="valuesAreComparable()", imports={"org.jetbrains.kotlinx.dataframe.api.valuesAreComparable"}), level=DeprecationLevel.WARNING)
    public static final boolean isComparable(@NotNull DataColumn<?> $this$isComparable) {
        Intrinsics.checkNotNullParameter($this$isComparable, (String)"<this>");
        return DataColumnTypeKt.valuesAreComparable($this$isComparable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean valuesAreComparable(@NotNull DataColumn<?> $this$valuesAreComparable) {
        Intrinsics.checkNotNullParameter($this$valuesAreComparable, (String)"<this>");
        DataColumn<?> $this$isSubtypeOf$iv = $this$valuesAreComparable;
        boolean $i$f$isSubtypeOf = false;
        if (!DataColumnTypeKt.isSubtypeOf($this$isSubtypeOf$iv, Reflection.nullableTypeOf(Comparable.class, (KTypeProjection)KTypeProjection.Companion.getSTAR()))) return false;
        KTypeProjection it = (KTypeProjection)TypeUtilsKt.projectTo($this$valuesAreComparable.type(), Reflection.getOrCreateKotlinClass(Comparable.class)).getArguments().get(0);
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)KTypeProjection.Companion.getSTAR())) return false;
        KType kType = it.getType();
        if (kType == null) return true;
        if (!TypeUtilsKt.isNothing(kType)) return true;
        return false;
    }

    @PublishedApi
    public static final boolean isPrimitive(@NotNull DataColumn<?> $this$isPrimitive) {
        Intrinsics.checkNotNullParameter($this$isPrimitive, (String)"<this>");
        return DataColumnTypeKt.isPrimitive(DataColumnKt.getTypeClass($this$isPrimitive));
    }

    public static final boolean isPrimitive(@NotNull KClass<?> $this$isPrimitive) {
        Intrinsics.checkNotNullParameter($this$isPrimitive, (String)"<this>");
        return KClasses.isSubclassOf($this$isPrimitive, (KClass)Reflection.getOrCreateKotlinClass(Number.class)) || Intrinsics.areEqual($this$isPrimitive, (Object)Reflection.getOrCreateKotlinClass(String.class)) || Intrinsics.areEqual($this$isPrimitive, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE)) || Intrinsics.areEqual($this$isPrimitive, (Object)Reflection.getOrCreateKotlinClass(Object[].class)) || KClasses.isSubclassOf($this$isPrimitive, (KClass)Reflection.getOrCreateKotlinClass(Collection.class));
    }
}

