/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.monorepo;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.JSDetectingProjectFileScanner;
import com.intellij.javascript.nodejs.monorepo.JSMonorepoType;
import com.intellij.javascript.nodejs.monorepo.JSProjectConfigurationFusInfo;
import com.intellij.javascript.nodejs.monorepo.JSProjectConfigurationStateUsagesCollector;
import com.intellij.javascript.nodejs.monorepo.PartialProjectInfo;
import com.intellij.javascript.nodejs.monorepo.WorkspacePackageMatcher;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\tH\u0002J\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\u0003H\u0002J\n\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0018\u0010&\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003H\u0002J\u0018\u0010(\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\"H\u0002J\u0018\u0010*\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\"H\u0002J \u0010,\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\r\u001a.\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00030\u0003 \u000f*\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00030\u00030\u0011\u00a2\u0006\u0002\b\u00100\u000e\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/javascript/nodejs/monorepo/JSProjectConfigurationFusInfoBuilder;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)V", "hasLernaJson", "", "hasNxJson", "hasTurboJson", "hasRushJson", "packageJsonFiles", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "rootPackageJsonData", "Lcom/intellij/javascript/nodejs/PackageJsonData;", "collect", "Lcom/intellij/javascript/nodejs/monorepo/JSProjectConfigurationFusInfo;", "getMonorepoType", "Lcom/intellij/javascript/nodejs/monorepo/JSMonorepoType;", "findGitRoot", "hasRootPackageJsonWithWorkspaces", "countPackages", "", "", "countTsconfigJsons", "getWorkspacePackageMatcher", "Lcom/intellij/javascript/nodejs/monorepo/WorkspacePackageMatcher;", "parsePnpmWorkspaceYaml", "", "", "pnpmWorkspaceYamlFile", "collectPartialProjectInfo", "Lcom/intellij/javascript/nodejs/monorepo/PartialProjectInfo;", "isWorkspaceSubPackage", "subPackageDir", "hasChildFile", "fileName", "hasChildDirectory", "directoryName", "hasChild", "childName", "isDirectory", "intellij.javascript.backend"})
@ApiStatus.Internal
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nJSProjectConfigurationStateUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSProjectConfigurationStateUsagesCollector.kt\ncom/intellij/javascript/nodejs/monorepo/JSProjectConfigurationFusInfoBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n808#2,11:323\n13#3:334\n1#4:335\n*S KotlinDebug\n*F\n+ 1 JSProjectConfigurationStateUsagesCollector.kt\ncom/intellij/javascript/nodejs/monorepo/JSProjectConfigurationFusInfoBuilder\n*L\n224#1:323,11\n227#1:334\n*E\n"})
public final class JSProjectConfigurationFusInfoBuilder {
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final Project project;
    private final boolean hasLernaJson;
    private final boolean hasNxJson;
    private final boolean hasTurboJson;
    private final boolean hasRushJson;
    @NotNull
    private final Set<VirtualFile> packageJsonFiles;
    @Nullable
    private final PackageJsonData rootPackageJsonData;

    /*
     * WARNING - void declaration
     */
    public JSProjectConfigurationFusInfoBuilder(@NotNull VirtualFile root, @NotNull Project project) {
        PackageJsonData packageJsonData;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.root = root;
        this.project = project;
        this.hasLernaJson = this.hasChildFile(this.root, "lerna.json");
        this.hasNxJson = this.hasChildFile(this.root, "nx.json");
        this.hasTurboJson = this.hasChildFile(this.root, "turbo.json");
        this.hasRushJson = this.hasChildFile(this.root, "rush.json");
        Set<VirtualFile> set = PackageJsonFileManager.getInstance(this.project).getValidPackageJsonFiles();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getValidPackageJsonFiles(...)");
        this.packageJsonFiles = set;
        JSProjectConfigurationFusInfoBuilder jSProjectConfigurationFusInfoBuilder = this;
        VirtualFile virtualFile = PackageJsonUtil.findChildPackageJsonFile(this.root);
        if (virtualFile != null) {
            void it;
            VirtualFile virtualFile2 = virtualFile;
            JSProjectConfigurationFusInfoBuilder jSProjectConfigurationFusInfoBuilder2 = jSProjectConfigurationFusInfoBuilder;
            boolean bl = false;
            packageJsonData = PackageJsonData.getOrCreate((VirtualFile)it);
            jSProjectConfigurationFusInfoBuilder = jSProjectConfigurationFusInfoBuilder2;
        } else {
            packageJsonData = null;
        }
        jSProjectConfigurationFusInfoBuilder.rootPackageJsonData = packageJsonData;
    }

    @NotNull
    public final JSProjectConfigurationFusInfo collect() {
        JSMonorepoType monorepoType = this.getMonorepoType();
        Set set = BaseProjectDirectories.Companion.getBaseDirectories(this.project);
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)this.project).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        Set roots = SetsKt.plus((Set)set, (Object[])virtualFileArray);
        PartialProjectInfo partialInfo = this.collectPartialProjectInfo();
        PartialProjectInfo partialProjectInfo = partialInfo;
        PartialProjectInfo partialProjectInfo2 = partialInfo;
        PartialProjectInfo partialProjectInfo3 = partialInfo;
        return new JSProjectConfigurationFusInfo(this.rootPackageJsonData != null, roots.size(), monorepoType, this.hasLernaJson, this.hasNxJson, this.hasTurboJson, this.hasRushJson, this.packageJsonFiles.size(), this.countPackages(this.root, (Collection<? extends VirtualFile>)this.packageJsonFiles), this.countTsconfigJsons(), JSDetectingProjectFileScanner.isFirstProjectScanningDone(this.project), partialProjectInfo != null ? partialProjectInfo.isGitRootAbove() : false, partialProjectInfo2 != null ? partialProjectInfo2.isPackageJsonAbove() : false, partialProjectInfo3 != null ? partialProjectInfo3.isSubPackageOpened() : false);
    }

    private final JSMonorepoType getMonorepoType() {
        boolean hasRootPackageJsonWorkspaces = this.hasRootPackageJsonWithWorkspaces();
        return this.hasChildFile(this.root, "pnpm-workspace.yaml") ? JSMonorepoType.PNPM_WORKSPACES : (hasRootPackageJsonWorkspaces && this.hasChildFile(this.root, "yarn.lock") ? JSMonorepoType.YARN_WORKSPACES : (hasRootPackageJsonWorkspaces && this.hasChildFile(this.root, "package-lock.json") ? JSMonorepoType.NPM_WORKSPACES : (hasRootPackageJsonWorkspaces && this.hasChildFile(this.root, "bun") ? JSMonorepoType.BUN_WORKSPACES : (hasRootPackageJsonWorkspaces && this.hasChildFile(this.root, "pnpm-lock.yaml") ? JSMonorepoType.PNPM_WORKSPACES : (this.hasLernaJson ? JSMonorepoType.LERNA : (this.hasNxJson ? JSMonorepoType.NX : (this.hasTurboJson ? JSMonorepoType.TURBOREPO : (this.hasRushJson ? JSMonorepoType.RUSH : (this.hasChildFile(this.root, "MODULE.bazel") || this.hasChildFile(this.root, "BUILD.bazel") ? JSMonorepoType.BAZEL : (this.hasChildFile(this.root, "lage.config.js") ? JSMonorepoType.LAGE : (hasRootPackageJsonWorkspaces ? JSMonorepoType.UNKNOWN_WORKSPACES : JSMonorepoType.NONE)))))))))));
    }

    private final VirtualFile findGitRoot(VirtualFile root) {
        VirtualFile dir;
        for (dir = root; dir != null && !this.hasChildDirectory(dir, ".git"); dir = dir.getParent()) {
        }
        return dir;
    }

    private final boolean hasRootPackageJsonWithWorkspaces() {
        PackageJsonData packageJsonData = this.rootPackageJsonData;
        return (packageJsonData != null ? packageJsonData.getWorkspaces() : null) != null;
    }

    private final int countPackages(VirtualFile root, Collection<? extends VirtualFile> packageJsonFiles) {
        WorkspacePackageMatcher workspacePackageMatcher = this.getWorkspacePackageMatcher(root);
        if (workspacePackageMatcher == null) {
            return -1;
        }
        WorkspacePackageMatcher matcher = workspacePackageMatcher;
        int result2 = 0;
        for (VirtualFile virtualFile : packageJsonFiles) {
            VirtualFile parent = virtualFile.getParent();
            if (parent == null || !matcher.isMatched(parent)) continue;
            ++result2;
        }
        return result2;
    }

    private final int countTsconfigJsons() {
        return FileTypeIndex.getFiles((FileType)((FileType)TypeScriptConfigFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.project)).size();
    }

    private final WorkspacePackageMatcher getWorkspacePackageMatcher(VirtualFile root) {
        List<String> list;
        VirtualFile pnpmWorkspaceYamlFile = root.findChild("pnpm-workspace.yaml");
        if (pnpmWorkspaceYamlFile != null && !pnpmWorkspaceYamlFile.isDirectory()) {
            list = this.parsePnpmWorkspaceYaml(pnpmWorkspaceYamlFile);
        } else {
            VirtualFile virtualFile = PackageJsonUtil.findChildPackageJsonFile(root);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                list = PackageJsonData.getOrCreate(it).getWorkspaces();
            } else {
                list = null;
            }
        }
        List<String> workspaces = list;
        return workspaces != null ? new WorkspacePackageMatcher(root, workspaces) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> parsePnpmWorkspaceYaml(VirtualFile pnpmWorkspaceYamlFile) {
        try {
            void $this$filterIsInstanceTo$iv$iv;
            String string = VfsUtil.loadText((VirtualFile)pnpmWorkspaceYamlFile);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
            String text = string;
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            Map value = (Map)mapper.readValue(text, Map.class);
            Intrinsics.checkNotNull((Object)value);
            Object v = value.get("packages");
            List list = v instanceof List ? (List)v : null;
            if (list == null) {
                return CollectionsKt.emptyList();
            }
            List result2 = list;
            Iterable $this$filterIsInstance$iv = result2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof String)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(JSProjectConfigurationStateUsagesCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to parse pnpm workspace yaml file", (Throwable)e);
            return CollectionsKt.emptyList();
        }
    }

    private final PartialProjectInfo collectPartialProjectInfo() {
        Boolean bl;
        VirtualFile packageJsonOrGitRoot;
        VirtualFile virtualFile;
        VirtualFile gitRoot = this.findGitRoot(this.root);
        if (gitRoot == null || Intrinsics.areEqual((Object)gitRoot, (Object)this.root)) {
            return null;
        }
        VirtualFile virtualFile2 = this.root.getParent();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile rootParent = virtualFile2;
        VirtualFile it = virtualFile = (packageJsonOrGitRoot = JSProjectUtil.traverseUpAndFindFirst(rootParent, arg_0 -> JSProjectConfigurationFusInfoBuilder.collectPartialProjectInfo$lambda$1(arg_0 -> JSProjectConfigurationFusInfoBuilder.collectPartialProjectInfo$lambda$0(gitRoot, arg_0), arg_0)));
        boolean bl2 = false;
        Object upperPackageJson = it != null && !Intrinsics.areEqual((Object)it, (Object)gitRoot) ? virtualFile : null;
        VirtualFile virtualFile3 = upperPackageJson;
        if (virtualFile3 != null && (virtualFile3 = virtualFile3.getParent()) != null) {
            VirtualFile it2 = virtualFile3;
            boolean bl3 = false;
            bl = this.isWorkspaceSubPackage(it2, this.root);
        } else {
            bl = null;
        }
        Boolean isSubPackageOpened = bl;
        Boolean bl4 = isSubPackageOpened;
        return new PartialProjectInfo(true, upperPackageJson != null, bl4 != null ? bl4 : false);
    }

    private final boolean isWorkspaceSubPackage(VirtualFile root, VirtualFile subPackageDir) {
        WorkspacePackageMatcher workspacePackageMatcher = this.getWorkspacePackageMatcher(root);
        if (workspacePackageMatcher == null) {
            return false;
        }
        WorkspacePackageMatcher matcher = workspacePackageMatcher;
        return matcher.isMatched(subPackageDir);
    }

    private final boolean hasChildFile(VirtualFile root, String fileName) {
        return this.hasChild(root, fileName, false);
    }

    private final boolean hasChildDirectory(VirtualFile root, String directoryName) {
        return this.hasChild(root, directoryName, true);
    }

    private final boolean hasChild(VirtualFile root, String childName, boolean isDirectory) {
        VirtualFile child = root.findChild(childName);
        return child != null && child.isDirectory() == isDirectory;
    }

    private static final VirtualFile collectPartialProjectInfo$lambda$0(VirtualFile $gitRoot, VirtualFile it) {
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(it);
        if (packageJson != null) {
            return packageJson;
        }
        return Intrinsics.areEqual((Object)it, (Object)$gitRoot) ? $gitRoot : null;
    }

    private static final VirtualFile collectPartialProjectInfo$lambda$1(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }
}

