/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.injections.JSInXmlLanguagesInjector;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.regexp.ecmascript.EcmaScriptRegexpLanguage;
import org.intellij.lang.regexp.ecmascript.EcmaScriptUnicodeRegexpLanguage;
import org.jetbrains.annotations.NotNull;

public class JSLanguageInjector
implements MultiHostInjector {
    private static final Pattern EXAMPLE_FILE_PATTERN = Pattern.compile("name=['\"](\\S+)['\"]");

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            JSLanguageInjector.$$$reportNull$$$0(0);
        }
        if (host == null) {
            JSLanguageInjector.$$$reportNull$$$0(1);
        }
        if (!JSInheritedLanguagesHelper.supportsJavaScriptInjections((PsiElement)host)) {
            return;
        }
        if (host instanceof JSLiteralExpression && host instanceof PsiLanguageInjectionHost && ((JSLiteralExpression)host).isRegExpLiteral()) {
            JSLanguageInjector.injectInRegexLiteral(registrar, host);
        } else if (host instanceof JSDocComment) {
            int exampleStart;
            String text = host.getText();
            int exampleEnd = 0;
            do {
                exampleStart = text.indexOf("<example", exampleEnd);
                exampleEnd = text.indexOf("</example>", exampleStart);
                int i = exampleStart;
                while (i < exampleEnd && i > 0) {
                    int fileEnd;
                    int fileStart = text.indexOf("<file", i);
                    int n = fileEnd = fileStart > 0 ? text.indexOf("</file>", fileStart) : -1;
                    if (fileStart > 0 && fileEnd > 0) {
                        String startLine;
                        Matcher matcher;
                        int headerLineEnd = text.indexOf(10, fileStart);
                        int headerLineOffset = fileStart - text.lastIndexOf(10, fileStart);
                        if (headerLineEnd > 0 && headerLineEnd < fileEnd && (matcher = EXAMPLE_FILE_PATTERN.matcher(startLine = text.substring(fileStart, headerLineEnd))).find()) {
                            String filename = matcher.group(1);
                            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(filename);
                            if (fileType instanceof LanguageFileType) {
                                registrar.startInjecting(((LanguageFileType)fileType).getLanguage());
                                int lineEnd = headerLineEnd;
                                while (lineEnd < fileEnd) {
                                    int startOffset = lineEnd + headerLineOffset;
                                    if (startOffset <= text.indexOf(10, lineEnd + 1)) {
                                        int endOffset = Math.min(text.indexOf(10, startOffset), fileEnd);
                                        TextRange range = new TextRange(startOffset, Math.max(startOffset, endOffset));
                                        registrar.addPlace("", "\n", (PsiLanguageInjectionHost)host, range);
                                    }
                                    lineEnd = text.indexOf(10, lineEnd + 1);
                                }
                                registrar.doneInjecting();
                            }
                        }
                    }
                    i = fileEnd;
                }
            } while (exampleStart >= 0 && exampleEnd >= 0);
        }
    }

    public static boolean hasUnicodeFlag(String value, int offset) {
        return JSLanguageInjector.hasFlag(value, offset, 'u') || JSLanguageInjector.hasFlag(value, offset, 'v');
    }

    private static boolean hasFlag(String value, int offset, char flag) {
        int indexOfFlag = value.indexOf(flag, offset);
        if (indexOfFlag < 0) {
            return false;
        }
        if (indexOfFlag == 0) {
            return true;
        }
        char prev = value.charAt(indexOfFlag - 1);
        if (prev != '\\') {
            return true;
        }
        indexOfFlag = value.indexOf(flag, indexOfFlag + 1);
        while (indexOfFlag > 0) {
            prev = value.charAt(indexOfFlag - 1);
            if (prev != '\\') {
                return true;
            }
            indexOfFlag = value.indexOf(flag, indexOfFlag + 1);
        }
        return value.indexOf(String.format("\\u%04x", flag), offset) >= 0;
    }

    public static void injectInRegexLiteral(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        String text;
        int offset;
        if (registrar == null) {
            JSLanguageInjector.$$$reportNull$$$0(2);
        }
        if (host == null) {
            JSLanguageInjector.$$$reportNull$$$0(3);
        }
        if ((offset = (text = host.getText()).lastIndexOf(47)) > 1) {
            TextRange range = new TextRange(1, offset);
            registrar.startInjecting((Language)(JSLanguageInjector.hasUnicodeFlag(text, offset) ? EcmaScriptUnicodeRegexpLanguage.INSTANCE : EcmaScriptRegexpLanguage.INSTANCE)).addPlace(null, null, (PsiLanguageInjectionHost)host, range).doneInjecting();
        }
    }

    @Deprecated(forRemoval=true)
    public static void injectJSIntoAttributeValue(MultiHostRegistrar registrar, XmlAttributeValue host, boolean startsWithPrefix) {
        JSInXmlLanguagesInjector.injectJSIntoAttributeValue(registrar, host, startsWithPrefix);
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends PsiElement>> list = Arrays.asList(JSLiteralExpression.class, JSDocComment.class);
        if (list == null) {
            JSLanguageInjector.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSLanguageInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSLanguageInjector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "injectInRegexLiteral";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

