/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class GulpWatchTaskListener
extends ProcessAdapter {
    private static final Logger LOG = Logger.getInstance(GulpWatchTaskListener.class);
    private final Refresher myRefresher = new Refresher();
    private final StringBuilder myBuffer = new StringBuilder();

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        if (event == null) {
            GulpWatchTaskListener.$$$reportNull$$$0(0);
        }
        if (outputType == null) {
            GulpWatchTaskListener.$$$reportNull$$$0(1);
        }
        if (ProcessOutputType.isStdout((Key)outputType)) {
            this.myBuffer.append(event.getText());
            int startLineInd = 0;
            int endLineInd = StringUtil.indexOf((CharSequence)this.myBuffer, (char)'\n');
            while (endLineInd >= 0) {
                this.processLine(this.myBuffer.substring(startLineInd, endLineInd + 1));
                startLineInd = endLineInd + 1;
                endLineInd = StringUtil.indexOf((CharSequence)this.myBuffer, (char)'\n', (int)startLineInd);
            }
            this.myBuffer.delete(0, startLineInd);
        }
    }

    private void processLine(@NotNull String line) {
        String subString;
        if (line == null) {
            GulpWatchTaskListener.$$$reportNull$$$0(2);
        }
        if (line.length() > 10 && line.charAt(0) == '[' && line.charAt(9) == ']' && line.regionMatches(10, subString = " Finished '", 0, subString.length())) {
            this.myRefresher.scheduleRefresh(false);
        }
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            GulpWatchTaskListener.$$$reportNull$$$0(3);
        }
        this.myRefresher.scheduleRefresh(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpWatchTaskListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onTextAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processTerminated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Refresher {
        private final ScheduledExecutorService myExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"GulpWatchTaskListener.Refresher Pool", (int)1);
        private volatile boolean myStopAfterRefresh = false;
        private volatile ScheduledFuture<?> myFuture;

        private Refresher() {
        }

        synchronized void scheduleRefresh(boolean stopAfterRefresh) {
            if (!this.myStopAfterRefresh) {
                this.myStopAfterRefresh = stopAfterRefresh;
                ScheduledFuture<?> future = this.myFuture;
                if (future != null) {
                    future.cancel(false);
                }
                this.myFuture = this.myExecutorService.schedule(() -> {
                    LOG.info("Refreshing VFS on gulp " + (stopAfterRefresh ? "process termination" : "watch triggering"));
                    LocalFileSystem.getInstance().refresh(true);
                }, 500L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

