/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.ecmascript6.completion.ES6MemberAccessCompletionContributor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.generation.JavaScriptGenerateConstructorHandler;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptGenerateConstructorUtil {
    static void addTypeScriptOverloadCandidates(@NotNull PsiElement clazz, @NotNull Collection<? super JSChooserElementNode> candidates) {
        if (clazz == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(0);
        }
        if (candidates == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(1);
        }
        if (!(clazz instanceof TypeScriptClass)) {
            return;
        }
        ArrayList<JSNamedElementNode> constructors = new ArrayList<JSNamedElementNode>();
        for (JSClass superClass : ((JSClass)clazz).getSuperClasses()) {
            if (superClass.isInterface()) continue;
            JSFunction constructor = superClass.getConstructor();
            if (!(constructor instanceof TypeScriptFunction)) {
                return;
            }
            Collection overloadSignatures = TypeScriptPsiUtil.getAllOverloadSignatures((JSFunctionItem)constructor);
            if (overloadSignatures.isEmpty()) {
                return;
            }
            for (JSFunctionItem signature : overloadSignatures) {
                if (!(signature instanceof TypeScriptFunction) || ((TypeScriptFunction)signature).isOverloadImplementation()) continue;
                constructors.add(new JSNamedElementNode((JSPsiNamedElementBase)signature));
            }
        }
        if (constructors.size() > 1) {
            candidates.addAll(constructors);
        }
    }

    @NotNull
    static String createMultiOverloadConstructor(@NotNull PsiFile file, @NotNull List<? extends JSVariable> toProcess, @NotNull Set<? extends JSFunction> overloads, @NotNull Project project, PsiElement jsClass) {
        int i;
        if (file == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(2);
        }
        if (toProcess == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(3);
        }
        if (overloads == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(5);
        }
        HashMap<TypeScriptMemberInfo, JSClass> allMappings = new HashMap<TypeScriptMemberInfo, JSClass>();
        for (JSFunction jSFunction : overloads) {
            allMappings.put(TypeScriptMemberInfo.create(null, (JSElement)jSFunction), (JSClass)jSFunction.getParent());
        }
        TypeScriptImplementMemberUtil.Signature signature = TypeScriptImplementMemberUtil.getParametersAndReturnType(allMappings.keySet(), jsClass, allMappings);
        List<TypeScriptImplementMemberUtil.ParameterInfo> list = signature.params;
        Set names = list.stream().map(p1 -> p1.name).collect(Collectors.toSet());
        List toProcessAsParams = ContainerUtil.map(toProcess, v -> TypeScriptGenerateConstructorUtil.toParameterInfo(v, names, project, jsClass));
        signature.params = ContainerUtil.concat((List)toProcessAsParams, list);
        StringBuilder fullBuilder = new StringBuilder();
        for (JSFunction overload : ContainerUtil.sorted(overloads, Comparator.comparingInt(f -> f.getParameters().length))) {
            JSFunctionSignatureInfo info = TypeScriptImplementMemberUtil.buildFunctionInfo(TypeScriptMemberInfo.create(null, (JSElement)overload), jsClass, "constructor", allMappings, false);
            Set<String> namesInOverload = info.getParameters().stream().map(p -> (String)p.first).collect(Collectors.toSet());
            for (TypeScriptImplementMemberUtil.ParameterInfo inf : ContainerUtil.reverse((List)toProcessAsParams)) {
                info.addParameterAndTypeToStart(TypeScriptGenerateConstructorUtil.hackyMangleName(namesInOverload, inf.name), inf.type);
            }
            StringBuilder singleSignature = TypeScriptImplementMemberUtil.buildSignatureText(jsClass, info);
            fullBuilder.append((CharSequence)singleSignature).append(";");
        }
        StringBuilder functionText = TypeScriptImplementMemberUtil.buildCommonSignature("constructor", jsClass, signature);
        fullBuilder.append((CharSequence)functionText);
        fullBuilder.append("{\n");
        fullBuilder.append("super(");
        for (i = 0; i < list.size(); ++i) {
            TypeScriptImplementMemberUtil.ParameterInfo param = list.get(i);
            fullBuilder.append(param.name);
            if (i == list.size() - 1) continue;
            fullBuilder.append(',');
        }
        fullBuilder.append(");\n");
        for (i = 0; i < toProcess.size(); ++i) {
            JSVariable variable = toProcess.get(i);
            TypeScriptImplementMemberUtil.ParameterInfo info = (TypeScriptImplementMemberUtil.ParameterInfo)toProcessAsParams.get(i);
            String name = variable.getName();
            assert (name != null);
            String referenceExpression = "this" + ES6MemberAccessCompletionContributor.getNameWithAccess(name, JSUtils.isPrivateSharpItem((PsiElement)variable), false, (PsiElement)file);
            fullBuilder.append(referenceExpression).append(" = ").append(info.name).append(";\n");
        }
        fullBuilder.append("}");
        String string = fullBuilder.toString();
        if (string == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static TypeScriptImplementMemberUtil.ParameterInfo toParameterInfo(@NotNull JSVariable var, @NotNull Set<String> names, @NotNull Project project, @NotNull PsiElement jsClass) {
        boolean mangle;
        if (var == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(7);
        }
        if (names == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(8);
        }
        if (project == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(9);
        }
        if (jsClass == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(10);
        }
        String name = var.getName();
        String parameterName = JSFormatterUtil.transformVarNameToAccessorName((String)name, (PsiElement)var);
        boolean bl = mangle = !JSRefactoringUtil.isValidIdentifier(parameterName = TypeScriptGenerateConstructorUtil.hackyMangleName(names, parameterName), project);
        if (mangle) {
            parameterName = JavaScriptGenerateConstructorHandler.mangleParameterName(parameterName);
        }
        names.add(parameterName);
        TypeScriptImplementMemberUtil.ParameterInfo info = new TypeScriptImplementMemberUtil.ParameterInfo();
        info.name = parameterName;
        info.type = BaseCreateMembersFix.getProcessedType(var.getJSType(), jsClass, (PsiElement)var);
        info.isOptional = false;
        info.isRest = false;
        TypeScriptImplementMemberUtil.ParameterInfo parameterInfo = info;
        if (parameterInfo == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(11);
        }
        return parameterInfo;
    }

    @NotNull
    private static String hackyMangleName(@NotNull Set<String> names, @Nullable String parameterName) {
        if (names == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(12);
        }
        if (parameterName == null) {
            parameterName = "p";
        }
        while (names.contains(parameterName)) {
            parameterName = (String)parameterName + "1";
        }
        String string = parameterName;
        if (string == null) {
            TypeScriptGenerateConstructorUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloads";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/generation/TypeScriptGenerateConstructorUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/generation/TypeScriptGenerateConstructorUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMultiOverloadConstructor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toParameterInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "hackyMangleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTypeScriptOverloadCandidates";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMultiOverloadConstructor";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toParameterInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hackyMangleName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 13 -> new IllegalStateException(string);
        };
    }
}

