/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionGroup;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintTreeNode
extends CheckedTreeNode {
    private final Tree myTree;
    private final @NlsContexts.HintText String myDescription;
    private final @NlsContexts.Label String myTitle;
    private Object myValue;
    private boolean myMouseInside;

    public JSHintTreeNode(@NotNull Tree tree, @NotNull JSHintOptionGroup optionGroup) {
        if (tree == null) {
            JSHintTreeNode.$$$reportNull$$$0(0);
        }
        if (optionGroup == null) {
            JSHintTreeNode.$$$reportNull$$$0(1);
        }
        super((Object)optionGroup);
        this.myMouseInside = false;
        this.myTree = tree;
        this.myDescription = optionGroup.getDescription();
        this.myTitle = optionGroup.getTitle();
    }

    public JSHintTreeNode(@NotNull Tree tree, @NotNull JSHintOption option, @NlsContexts.HintText @NotNull String description) {
        if (tree == null) {
            JSHintTreeNode.$$$reportNull$$$0(2);
        }
        if (option == null) {
            JSHintTreeNode.$$$reportNull$$$0(3);
        }
        if (description == null) {
            JSHintTreeNode.$$$reportNull$$$0(4);
        }
        super((Object)option);
        this.myMouseInside = false;
        this.myTree = tree;
        this.myDescription = description;
        this.myTitle = option.getShortDescription();
        if (OptionTypes.isEnumOption(option)) {
            this.myValue = option.getDefaultValue();
        }
    }

    @NlsContexts.Label
    public String getTitle() {
        return this.myTitle;
    }

    @Nullable
    public Object getValue() {
        return this.myValue;
    }

    public void setValue(@Nullable Object value) {
        JSHintOption option = this.getUserDataAsOption();
        if (value == null && option != null) {
            value = option.getDefaultValue();
        }
        this.myValue = value;
        this.myTree.getModel().valueForPathChanged(new TreePath(this.getPath()), this.getUserObject());
    }

    public void setMouseInside(boolean mouseInside) {
        boolean changed = this.myMouseInside != mouseInside;
        this.myMouseInside = mouseInside;
        if (changed) {
            this.myTree.repaint();
        }
    }

    public boolean isMouseInside() {
        return this.myMouseInside;
    }

    @NlsContexts.HintText
    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            JSHintTreeNode.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public JSHintOption getUserDataAsOption() {
        return (JSHintOption)ObjectUtils.tryCast((Object)this.getUserObject(), JSHintOption.class);
    }

    @Nullable
    public JSHintOptionGroup getUserDataAsOptionGroup() {
        return (JSHintOptionGroup)ObjectUtils.tryCast((Object)this.getUserObject(), JSHintOptionGroup.class);
    }

    public boolean isEditLinkNeeded() {
        JSHintOption option = this.getUserDataAsOption();
        if (option == null) {
            return false;
        }
        return !OptionTypes.isBooleanOption(option);
    }

    public String toString() {
        JSHintOption option = this.getUserDataAsOption();
        if (option != null) {
            return "option " + option.getKey();
        }
        JSHintOptionGroup optionGroup = this.getUserDataAsOptionGroup();
        if (optionGroup != null) {
            return "optionGroup " + optionGroup.getTitle();
        }
        return "internal error";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionGroup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintTreeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintTreeNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

