/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintOptionCompletionObject;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintConfigCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        PsiElement position;
        if (parameters2 == null) {
            JSHintConfigCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSHintConfigCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!JSHintConfigFileUtil.isJSHintConfigFile(position = parameters2.getPosition())) {
            return;
        }
        boolean insideStringLiteral = JSLinterConfigFileUtil.isStringLiteral(position.getParent());
        JsonProperty property = JSLinterConfigFileUtil.getProperty(position);
        if (!JSHintConfigCompletionContributor.isExtendsValuePlace(property, position)) {
            JSLinterConfigFileUtil.skipOtherCompletionContributors(parameters2, result2);
        }
        if (property == null) {
            return;
        }
        PsiElement propertyKeyElement = JSLinterConfigFileUtil.getFirstChildAsStringLiteral(property);
        if (propertyKeyElement == null) {
            JSHintConfigCompletionContributor.completeJSHintOptions(result2, insideStringLiteral);
            return;
        }
        if (position.getParent() == propertyKeyElement) {
            JSHintConfigCompletionContributor.completeJSHintOptions(result2, insideStringLiteral);
        } else {
            JSHintOption option = JSHintOption.findByName(StringUtil.stripQuotesAroundValue((String)propertyKeyElement.getText()));
            List<Object> variants = Collections.emptyList();
            if (option != null) {
                if (OptionTypes.isBooleanOption(option)) {
                    variants = List.of(Boolean.TRUE.toString(), Boolean.FALSE.toString());
                } else if (OptionTypes.isEnumOption(option)) {
                    OptionEnumType enumType = OptionTypes.getOptionEnumType(option);
                    variants = new ArrayList();
                    for (OptionEnumVariant optionEnumVariant : enumType.getVariants()) {
                        String text = optionEnumVariant.getValueAsJsonStr();
                        if (insideStringLiteral) {
                            if (!(optionEnumVariant.getValue() instanceof String)) continue;
                            variants.add(StringUtil.stripQuotesAroundValue((String)text));
                            continue;
                        }
                        variants.add(text);
                    }
                }
                LookupElementRenderer<LookupElement> renderer = new LookupElementRenderer<LookupElement>(this){

                    public void renderElement(LookupElement element2, LookupElementPresentation presentation) {
                        presentation.setItemText(element2.getLookupString());
                        presentation.setItemTextBold(true);
                    }
                };
                for (String string : variants) {
                    LookupElementBuilder builder2 = LookupElementBuilder.create((String)string).withRenderer((LookupElementRenderer)renderer);
                    result2.addElement((LookupElement)builder2);
                }
            }
        }
    }

    private static boolean isExtendsValuePlace(@Nullable JsonProperty property, @NotNull PsiElement position) {
        if (position == null) {
            JSHintConfigCompletionContributor.$$$reportNull$$$0(2);
        }
        if (property == null) {
            return false;
        }
        PsiElement keyElement = JSLinterConfigFileUtil.getFirstChildAsStringLiteral(property);
        if (keyElement == null) {
            return false;
        }
        return JSLinterConfigFileUtil.isStringLiteral(position) && JSHintConfigFileUtil.isExtendsKey(keyElement);
    }

    private static void completeJSHintOptions(@NotNull CompletionResultSet result2, boolean insideStringLiteral) {
        if (result2 == null) {
            JSHintConfigCompletionContributor.$$$reportNull$$$0(3);
        }
        for (JSHintOption option : JSHintOption.values()) {
            JSHintConfigCompletionContributor.addCompletionVariant(result2, insideStringLiteral, option, option.getKey());
            if (option.getKeyAlias() == null) continue;
            JSHintConfigCompletionContributor.addCompletionVariant(result2, insideStringLiteral, option, option.getKeyAlias());
        }
        JSHintConfigCompletionContributor.addCompletionVariant(result2, insideStringLiteral, null, "extends");
    }

    private static void addCompletionVariant(@NotNull CompletionResultSet result2, boolean insideStringLiteral, final @Nullable JSHintOption option, @NotNull String variantName) {
        if (result2 == null) {
            JSHintConfigCompletionContributor.$$$reportNull$$$0(4);
        }
        if (variantName == null) {
            JSHintConfigCompletionContributor.$$$reportNull$$$0(5);
        }
        String lookupString = insideStringLiteral ? variantName : StringUtil.wrapWithDoubleQuote((String)variantName);
        LookupElementBuilder builder2 = LookupElementBuilder.create((Object)new JSHintOptionCompletionObject(lookupString), (String)lookupString);
        builder2 = builder2.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element2, LookupElementPresentation presentation) {
                presentation.setItemText(element2.getLookupString());
                presentation.setTypeGrayed(true);
                if (option != null) {
                    presentation.setTypeText(option.getShortDescription());
                }
            }
        });
        result2.addElement((LookupElement)builder2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isExtendsValuePlace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "completeJSHintOptions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionVariant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

