/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.stubs.factories;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSElementTypesImpl;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSInheritanceCallEvaluator;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementType;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSCallExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSCallExpressionStubImpl;
import com.intellij.lang.javascript.stubs.factories.JSStubFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/stubs/factories/JSCallExpressionStubFactory;", "Lcom/intellij/lang/javascript/stubs/factories/JSStubFactory;", "Lcom/intellij/lang/javascript/psi/stubs/JSCallExpressionStub;", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "<init>", "()V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "shouldCreateStub", "", "node", "Lcom/intellij/lang/ASTNode;", "intellij.javascript.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nJSCallExpressionStubFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSCallExpressionStubFactory.kt\ncom/intellij/lang/javascript/stubs/factories/JSCallExpressionStubFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1761#2,3:39\n*S KotlinDebug\n*F\n+ 1 JSCallExpressionStubFactory.kt\ncom/intellij/lang/javascript/stubs/factories/JSCallExpressionStubFactory\n*L\n36#1:39,3\n*E\n"})
public final class JSCallExpressionStubFactory
extends JSStubFactory<JSCallExpressionStub, JSCallExpression> {
    public JSCallExpressionStubFactory() {
        super(JSCallExpressionStubFactory::_init_$lambda$0);
    }

    @NotNull
    public JSCallExpressionStub createStub(@NotNull JSCallExpression psi, @Nullable StubElement<? extends PsiElement> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        return new JSCallExpressionStubImpl(psi, parentStub);
    }

    public boolean shouldCreateStub(@NotNull ASTNode node) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ASTNode methodExpression = node.getFirstChildNode();
            while (methodExpression != null && methodExpression.getElementType() == JSElementTypes.PARENTHESIZED_EXPRESSION) {
                methodExpression = JSParenthesizedExpressionImpl.getInnerExpression((ASTNode)methodExpression);
            }
            if (methodExpression != null && methodExpression.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
                ASTNode lastChildNode = methodExpression.getLastChildNode();
                if (lastChildNode != null) {
                    String string = lastChildNode.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String calledMethodName = string;
                    if (JSInheritanceCallEvaluator.isInheritanceMethodNameCandidate((String)calledMethodName)) {
                        return true;
                    }
                }
            } else if (methodExpression != null && JSElementTypes.FUNCTION_EXPRESSIONS.contains(methodExpression.getElementType())) {
                return true;
            }
            List list = FrameworkIndexingHandler.getExtensions((ASTNode)node);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExtensions(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FrameworkIndexingHandler it = (FrameworkIndexingHandler)element$iv;
                    boolean bl2 = false;
                    if (!it.shouldCreateStubForCallExpression(node)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final JSElementType _init_$lambda$0() {
        return JSElementTypesImpl.CALL_EXPRESSION;
    }
}

