/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.TypedJSReferenceChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferenceChecker
extends TypedJSReferenceChecker {
    public TypeScriptReferenceChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(0);
        }
        super(reporter);
    }

    @Override
    protected boolean processExpressionResolveResult(@Nullable JSExpression expression, @Nullable PsiElement resolved) {
        JSFunction function;
        JSAttributeList list;
        if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() instanceof JSSuperExpression && resolved instanceof JSFunction && (list = (function = (JSFunction)resolved).getAttributeList()) != null && list.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
            String message = JavaScriptBundle.message((String)"typescript.validation.message.abstract.member.access.super", (Object[])new Object[]{function.getName()});
            this.myReporter.registerProblem((PsiElement)expression, null, message, this.getUnresolvedReferenceHighlightType((JSReferenceExpression)expression), new LocalQuickFix[0]);
            return true;
        }
        return false;
    }

    @Override
    protected void addSurroundWithTypeGuardFix(@NotNull JSExpression qualifier, @NotNull @NotNull List<? super @NotNull LocalQuickFix> fixes, @NotNull String name) {
        if (qualifier == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(1);
        }
        if (fixes == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(2);
        }
        if (name == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(3);
        }
        TypeScriptTypeGuardFixHelper.addTypeGuardFixes(qualifier, fixes, name);
    }

    @Override
    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        if (node == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(4);
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    @Override
    public void checkCallReferences(JSReferenceExpression methodExpression, boolean isNewExpression) {
        if (TypeScriptReferenceChecker.shouldSkipResolveError(methodExpression)) {
            return;
        }
        super.checkCallReferences(methodExpression, isNewExpression);
    }

    @Override
    public void checkRefExpression(@NotNull JSReferenceExpression node) {
        if (node == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(5);
        }
        if (TypeScriptReferenceChecker.shouldSkipResolveError(node)) {
            return;
        }
        super.checkRefExpression(node);
    }

    private static boolean shouldSkipResolveError(@NotNull JSReferenceExpression methodExpression) {
        ResolveResult[] resolveResults;
        if (methodExpression == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(6);
        }
        if ((resolveResults = methodExpression.multiResolve(false)).length > 0 && !resolveResults[0].isValidResult() && resolveResults[0] instanceof JSResolveResult) {
            JSResolveResult.ProblemKind problemKind = ((JSResolveResult)resolveResults[0]).getResolveProblemKind();
            if (methodExpression.getContainingFile().getVirtualFile() instanceof VirtualFileWindow && JSResolveResult.ProblemKind.TS_NEED_TO_BE_INCLUDED_TO_CONFIG == problemKind) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/TypeScriptReferenceChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addSurroundWithTypeGuardFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnresolvedReferenceHighlightType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRefExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSkipResolveError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

