/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor.surroundWith;

import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public abstract class SqlSurrounderBase
implements Surrounder {
    @NotNull
    protected static TextRange surroundElementsWith(@NotNull Project project, @NotNull Editor editor, @NotNull String open, @NotNull String close, boolean caretAtEnd) {
        if (project == null) {
            SqlSurrounderBase.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SqlSurrounderBase.$$$reportNull$$$0(1);
        }
        if (open == null) {
            SqlSurrounderBase.$$$reportNull$$$0(2);
        }
        if (close == null) {
            SqlSurrounderBase.$$$reportNull$$$0(3);
        }
        SelectionModel model = editor.getSelectionModel();
        int[] starts = model.getBlockSelectionStarts();
        int[] ends = model.getBlockSelectionEnds();
        Document document = editor.getDocument();
        int offset = 0;
        for (int i = 0; i < starts.length; ++i) {
            document.insertString(starts[i] + offset, (CharSequence)open);
            document.insertString(ends[i] + (offset += open.length()), (CharSequence)close);
            offset += close.length();
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(editor.getDocument());
        PsiFile file = documentManager.getPsiFile(editor.getDocument());
        if (file == null) {
            TextRange textRange = TextRange.from((int)(caretAtEnd ? ends[ends.length - 1] + offset : starts[starts.length - 1] + offset - close.length()), (int)0);
            if (textRange == null) {
                SqlSurrounderBase.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            int pos = caretAtEnd ? caret.getSelectionEnd() + close.length() : caret.getSelectionStart() - open.length();
            caret.removeSelection();
            caret.moveToOffset(pos);
        }
        TextRange textRange = SurroundWithHandler.CARET_IS_OK;
        if (textRange == null) {
            SqlSurrounderBase.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "open";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "close";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/surroundWith/SqlSurrounderBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/surroundWith/SqlSurrounderBase";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "surroundElementsWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "surroundElementsWith";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

