/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.SpacingImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.puppet.formatter.PuppetAlignmentProcessor;
import com.intellij.lang.puppet.formatter.PuppetIndentProcessor;
import com.intellij.lang.puppet.formatter.PuppetWrappingProcessor;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.common.AbstractBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PuppetFormattingBlock
extends AbstractBlock {
    private final SpacingBuilder mySpacingBuilder;
    private final PuppetIndentProcessor myIndentProcessor;
    private final PuppetAlignmentProcessor myAlignmentProcessor;
    private final PuppetWrappingProcessor myWrappingProcessor;
    @Nullable
    private final Indent myIndent;
    private List<Block> myBlocks;

    PuppetFormattingBlock(ASTNode astNode, SpacingBuilder spacingBuilder, @NotNull PuppetIndentProcessor indentProcessor, @NotNull PuppetAlignmentProcessor alignmentProcessor, @NotNull PuppetWrappingProcessor wrappingProcessor) {
        if (indentProcessor == null) {
            PuppetFormattingBlock.$$$reportNull$$$0(0);
        }
        if (alignmentProcessor == null) {
            PuppetFormattingBlock.$$$reportNull$$$0(1);
        }
        if (wrappingProcessor == null) {
            PuppetFormattingBlock.$$$reportNull$$$0(2);
        }
        super(astNode, wrappingProcessor.getNodeWrap(astNode), alignmentProcessor.getNodeAlignment(astNode));
        this.myIndent = indentProcessor.getNodeIndent(astNode);
        this.mySpacingBuilder = spacingBuilder;
        this.myIndentProcessor = indentProcessor;
        this.myAlignmentProcessor = alignmentProcessor;
        this.myWrappingProcessor = wrappingProcessor;
    }

    @NotNull
    public List<Block> buildChildren() {
        if (this.myBlocks == null) {
            this.myBlocks = this.buildSubBlocks();
        }
        return new ArrayList<Block>(this.myBlocks);
    }

    private List<Block> buildSubBlocks() {
        ArrayList<PuppetFormattingBlock> myBlocks = new ArrayList<PuppetFormattingBlock>();
        for (ASTNode childNode = this.myNode.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            if (childNode.getTextRange().getLength() == 0 || childNode.getElementType() == TokenType.WHITE_SPACE) continue;
            myBlocks.add(new PuppetFormattingBlock(childNode, this.mySpacingBuilder, this.myIndentProcessor, this.myAlignmentProcessor, this.myWrappingProcessor));
        }
        return Collections.unmodifiableList(myBlocks);
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        SpacingImpl spacingImpl;
        Spacing spacing;
        if (child2 == null) {
            PuppetFormattingBlock.$$$reportNull$$$0(3);
        }
        if ((spacing = this.mySpacingBuilder.getSpacing((Block)this, child1, child2)) instanceof SpacingImpl && (spacingImpl = (SpacingImpl)spacing).getMinLineFeeds() > 0 && child2 instanceof AbstractBlock && this.myWrappingProcessor.isHereDocOnLineBefore(((AbstractBlock)child2).getNode())) {
            return Spacing.createSpacing((int)spacingImpl.getMinSpaces(), (int)spacingImpl.getMaxSpaces(), (int)0, (boolean)spacingImpl.shouldKeepLineFeeds(), (int)spacingImpl.getKeepBlankLines(), (int)spacingImpl.getPrefLineFeeds());
        }
        return spacing;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        PuppetFormattingBlock prevChildBlock = newChildIndex > 0 ? this.getBlockBefore(newChildIndex) : null;
        ASTNode prevChildNode = prevChildBlock == null ? null : prevChildBlock.getNode();
        Indent indent = this.myIndentProcessor.getChildNodeIndent(this.myNode, prevChildNode);
        Alignment alignment = this.myAlignmentProcessor.getNewChildAlignment(this.myNode, prevChildNode);
        if (indent == PuppetIndentProcessor.DELEGATE_TO_PREV) {
            ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
            if (childAttributes == null) {
                PuppetFormattingBlock.$$$reportNull$$$0(4);
            }
            return childAttributes;
        }
        return new ChildAttributes(indent, alignment);
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    @Nullable
    private PuppetFormattingBlock getBlockBefore(int newChildIndex) {
        if (newChildIndex == 0) {
            return null;
        }
        int prevIndex = newChildIndex - 1;
        return (PuppetFormattingBlock)((Object)this.getSubBlocks().get(prevIndex));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignmentProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappingProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/formatter/PuppetFormattingBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/formatter/PuppetFormattingBlock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

