/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.exceptions.DBColumnAccessDeniedException;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.exceptions.DBLoginFailedException;
import com.intellij.database.remote.jdba.exceptions.DBSchemaAccessDeniedException;
import com.intellij.database.remote.jdba.exceptions.NoTableOrViewException;
import com.intellij.database.remote.jdba.jdbc.BaseExceptionRecognizer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseExceptionRecognizer
extends BaseExceptionRecognizer {
    public static final SybaseExceptionRecognizer INSTANCE = new SybaseExceptionRecognizer();
    private static final Map<Integer, Class<? extends DBException>> simpleExceptionMap = new HashMap<Integer, Class<? extends DBException>>();
    private static final Map<String, Class<? extends DBException>> nativeExceptionMap = new HashMap<String, Class<? extends DBException>>();

    @Override
    @Nullable
    protected DBException recognizeSpecificException(@NotNull SQLException sqle, @Nullable String statementText) {
        int errCode;
        if (sqle == null) {
            SybaseExceptionRecognizer.$$$reportNull$$$0(0);
        }
        if ((errCode = sqle.getErrorCode()) > 0) {
            return this.recognizeForJTDS(sqle, statementText, errCode);
        }
        String state = sqle.getSQLState();
        if (state != null && !state.isEmpty()) {
            return this.recognizeForNative(sqle, statementText, state);
        }
        return null;
    }

    @Nullable
    private DBException recognizeForJTDS(@NotNull SQLException sqle, @Nullable String statementText, int errCode) {
        Class<? extends DBException> exceptionClass;
        if (sqle == null) {
            SybaseExceptionRecognizer.$$$reportNull$$$0(1);
        }
        if ((exceptionClass = simpleExceptionMap.get(errCode)) != null) {
            return this.instantiateDBException(exceptionClass, sqle, statementText);
        }
        return null;
    }

    @Nullable
    private DBException recognizeForNative(SQLException sqle, String statementText, String state) {
        Class<? extends DBException> exceptionClass = nativeExceptionMap.get(state);
        if (exceptionClass != null) {
            return this.instantiateDBException(exceptionClass, sqle, statementText);
        }
        return null;
    }

    static {
        simpleExceptionMap.put(208, NoTableOrViewException.class);
        simpleExceptionMap.put(4002, DBLoginFailedException.class);
        simpleExceptionMap.put(10332, DBColumnAccessDeniedException.class);
        simpleExceptionMap.put(10351, DBSchemaAccessDeniedException.class);
        nativeExceptionMap.put("JZ00L", DBLoginFailedException.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "sqle";
        objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/dialects/SybaseExceptionRecognizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "recognizeSpecificException";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "recognizeForJTDS";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

