/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractFilterChildren;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigHelper;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4EnvHelper;
import org.jetbrains.idea.perforce.perforce.connections.P4ParamsCalculator;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;

public class P4ConnectionCalculator {
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(P4ConnectionCalculator.class);
    private PerforceMultipleConnections myMultipleConnections;

    public P4ConnectionCalculator(Project project) {
        this.myProject = project;
    }

    public void execute() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        PerforceVcs vcs = PerforceVcs.getInstance(this.myProject);
        P4EnvHelper p4EnvHelper = P4EnvHelper.getConfigHelper(this.myProject);
        p4EnvHelper.reset();
        String p4ConfigFileName = p4EnvHelper.getP4Config();
        LOG.debug("Using p4config file name: " + p4ConfigFileName);
        ArrayList<VirtualFile> detailedVcsMappings = new ArrayList<VirtualFile>(Arrays.asList(vcsManager.getRootsUnderVcs((AbstractVcs)vcs)));
        Map<VirtualFile, File> configsMap = p4ConfigFileName == null ? Collections.emptyMap() : P4ConnectionCalculator.fillConfigsMap(detailedVcsMappings, p4ConfigFileName);
        HashMap<VirtualFile, P4ConnectionParameters> connectionSettings = new HashMap<VirtualFile, P4ConnectionParameters>();
        P4ConnectionParameters defaultParameters = p4EnvHelper.getDefaultParams();
        ApplicationManager.getApplication().runReadAction(() -> {
            P4ConnectionCalculator.filterByConfigFiles(configsMap, detailedVcsMappings);
            for (VirtualFile mapping : detailedVcsMappings) {
                P4ConnectionParameters value;
                File configParentDir = (File)configsMap.get(mapping);
                if (configParentDir == null) {
                    value = new P4ConnectionParameters();
                    value.setNoConfigFound(true);
                } else {
                    assert (p4ConfigFileName != null);
                    value = P4ParamsCalculator.getParametersFromConfig(configParentDir, p4ConfigFileName);
                }
                value.setConfigFileName(p4ConfigFileName);
                p4EnvHelper.fillDefaultValues(value);
                LOG.debug("Using " + String.valueOf(value) + " for " + String.valueOf(mapping));
                connectionSettings.put(mapping, value);
            }
        });
        P4ConnectionCalculator.filterSimilarConfigFiles(connectionSettings, detailedVcsMappings);
        connectionSettings.keySet().retainAll(detailedVcsMappings);
        configsMap.keySet().retainAll(detailedVcsMappings);
        this.myMultipleConnections = new PerforceMultipleConnections(p4ConfigFileName, defaultParameters, connectionSettings, configsMap);
    }

    @NotNull
    public PerforceMultipleConnections getMultipleConnections() {
        PerforceMultipleConnections perforceMultipleConnections = this.myMultipleConnections;
        if (perforceMultipleConnections == null) {
            P4ConnectionCalculator.$$$reportNull$$$0(0);
        }
        return perforceMultipleConnections;
    }

    @Contract(mutates="param2")
    private static void filterSimilarConfigFiles(final Map<VirtualFile, P4ConnectionParameters> connectionSettings, List<VirtualFile> detailedVcsMappings) {
        AbstractFilterChildren<VirtualFile> filter = new AbstractFilterChildren<VirtualFile>(){

            protected void sortAscending(List<? extends VirtualFile> list) {
                list.sort((Comparator<? extends VirtualFile>)FilePathComparator.getInstance());
            }

            protected boolean isAncestor(VirtualFile parent, VirtualFile child) {
                P4ConnectionParameters parentSettings = (P4ConnectionParameters)connectionSettings.get(parent);
                P4ConnectionParameters childSettings = (P4ConnectionParameters)connectionSettings.get(child);
                if (parentSettings.hasProblems() || childSettings.hasProblems()) {
                    return false;
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false)) {
                    return false;
                }
                return parentSettings.equals(childSettings);
            }
        };
        filter.doFilter(detailedVcsMappings);
    }

    private static void filterByConfigFiles(final Map<VirtualFile, File> configsMap, List<VirtualFile> detailedVcsMappings) {
        AbstractFilterChildren<VirtualFile> filter = new AbstractFilterChildren<VirtualFile>(){

            protected void sortAscending(List<? extends VirtualFile> list) {
                list.sort((Comparator<? extends VirtualFile>)FilePathComparator.getInstance());
            }

            protected boolean isAncestor(VirtualFile parent, VirtualFile child) {
                if (!Comparing.equal((Object)((File)configsMap.get(parent)), (Object)((File)configsMap.get(child)))) {
                    return false;
                }
                return VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false);
            }
        };
        filter.doFilter(detailedVcsMappings);
    }

    private static Map<VirtualFile, File> fillConfigsMap(List<VirtualFile> detailedVcsMappings, @NotNull String p4ConfigFileName) {
        if (p4ConfigFileName == null) {
            P4ConnectionCalculator.$$$reportNull$$$0(1);
        }
        P4ConfigHelper p4ConfigHelper = new P4ConfigHelper();
        HashMap<VirtualFile, File> result = new HashMap<VirtualFile, File>();
        for (VirtualFile vcsMapping : detailedVcsMappings) {
            result.put(vcsMapping, p4ConfigHelper.findDirWithP4ConfigFile(vcsMapping, p4ConfigFileName));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/connections/P4ConnectionCalculator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p4ConfigFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultipleConnections";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/connections/P4ConnectionCalculator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fillConfigsMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

