/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.sql.SqlBundle;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SqlEditorOptions", storages={@Storage(value="editor.xml")}, category=SettingsCategory.CODE)
public class SqlEditorOptions
implements PersistentStateComponent<SqlEditorOptions> {
    private boolean myConcatenateStringsOnEnter = true;
    private boolean myCloseBlocksOnEnter = true;
    private static final QualificationType DEFAULT_QUALIFICATION_WITH = QualificationType.ALWAYS;
    private static final QualificationType DEFAULT_QUALIFICATION_IN = QualificationType.SMART;
    private static final QualificationType DEFAULT_JOIN_QUALIFICATION = QualificationType.ALWAYS;
    @NotNull
    private QualificationType myDatabaseQualification = DEFAULT_QUALIFICATION_WITH;
    @NotNull
    private QualificationType mySchemaQualification = DEFAULT_QUALIFICATION_WITH;
    @NotNull
    private QualificationType myTableQualification = DEFAULT_QUALIFICATION_WITH;
    @NotNull
    private QualificationType myAliasQualification = DEFAULT_QUALIFICATION_WITH;
    @NotNull
    private QualificationType myCompletionQualification = DEFAULT_QUALIFICATION_IN;
    @NotNull
    private QualificationType myJoinConditionQualification = DEFAULT_JOIN_QUALIFICATION;
    @NotNull
    private QualificationType myRefactoringQualification = DEFAULT_QUALIFICATION_IN;
    @NotNull
    private QualificationType myLiveTemplateQualification = DEFAULT_QUALIFICATION_IN;
    @NotNull
    private QualificationType myDragAndDropQualification = DEFAULT_QUALIFICATION_IN;

    private SqlEditorOptions load(SqlEditorOptions options) {
        this.myConcatenateStringsOnEnter = options.myConcatenateStringsOnEnter;
        this.myCloseBlocksOnEnter = options.myCloseBlocksOnEnter;
        this.myDatabaseQualification = options.myDatabaseQualification;
        this.mySchemaQualification = options.mySchemaQualification;
        this.myTableQualification = options.myTableQualification;
        this.myAliasQualification = options.myAliasQualification;
        this.myCompletionQualification = options.myCompletionQualification;
        this.myJoinConditionQualification = options.myJoinConditionQualification;
        this.myRefactoringQualification = options.myRefactoringQualification;
        this.myLiveTemplateQualification = options.myLiveTemplateQualification;
        this.myDragAndDropQualification = options.myDragAndDropQualification;
        return this;
    }

    @Nullable
    public SqlEditorOptions getState() {
        return new SqlEditorOptions().load(this);
    }

    public void loadState(@NotNull SqlEditorOptions state) {
        if (state == null) {
            SqlEditorOptions.$$$reportNull$$$0(0);
        }
        this.load(state);
    }

    public boolean isConcatenateStringsOnEnter() {
        return this.myConcatenateStringsOnEnter;
    }

    public void setConcatenateStringsOnEnter(boolean concatenateStringsOnEnter) {
        this.myConcatenateStringsOnEnter = concatenateStringsOnEnter;
    }

    public boolean isCloseBlocksOnEnter() {
        return this.myCloseBlocksOnEnter;
    }

    public void setCloseBlocksOnEnter(boolean closeBlocksOnEnter) {
        this.myCloseBlocksOnEnter = closeBlocksOnEnter;
    }

    @NotNull
    public QualificationType getDatabaseQualification() {
        QualificationType qualificationType = this.myDatabaseQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(1);
        }
        return qualificationType;
    }

    @OptionTag(converter=QualificationTypeConverter.class)
    public void setDatabaseQualification(@Nullable QualificationType type) {
        this.myDatabaseQualification = type != null ? type : DEFAULT_QUALIFICATION_WITH;
    }

    @NotNull
    public QualificationType getSchemaQualification() {
        QualificationType qualificationType = this.mySchemaQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(2);
        }
        return qualificationType;
    }

    @OptionTag(converter=QualificationTypeConverter.class)
    public void setSchemaQualification(@Nullable QualificationType type) {
        this.mySchemaQualification = type != null ? type : DEFAULT_QUALIFICATION_WITH;
    }

    @Deprecated
    public QualificationType getNamespaceQualification() {
        return null;
    }

    @Deprecated
    @OptionTag(converter=QualificationTypeConverter.class)
    public void setNamespaceQualification(@Nullable QualificationType type) {
        this.setDatabaseQualification(type);
        this.setSchemaQualification(type);
    }

    @NotNull
    public QualificationType getTableQualification() {
        QualificationType qualificationType = this.myTableQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(3);
        }
        return qualificationType;
    }

    @OptionTag(converter=QualificationTypeConverter.class)
    public void setTableQualification(@Nullable QualificationType type) {
        this.myTableQualification = type != null ? type : DEFAULT_QUALIFICATION_WITH;
    }

    @NotNull
    public QualificationType getAliasQualification() {
        QualificationType qualificationType = this.myAliasQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(4);
        }
        return qualificationType;
    }

    @OptionTag(converter=QualificationTypeConverter.class)
    public void setAliasQualification(@Nullable QualificationType type) {
        this.myAliasQualification = type != null ? type : DEFAULT_QUALIFICATION_WITH;
    }

    @NotNull
    public QualificationType getCompletionQualification() {
        QualificationType qualificationType = this.myCompletionQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(5);
        }
        return qualificationType;
    }

    @OptionTag(converter=QualificationTypeConverter.class)
    public void setCompletionQualification(@Nullable QualificationType type) {
        this.myCompletionQualification = type != null ? type : DEFAULT_QUALIFICATION_IN;
    }

    @NotNull
    public QualificationType getJoinConditionQualification() {
        QualificationType qualificationType = this.myJoinConditionQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(6);
        }
        return qualificationType;
    }

    @OptionTag(converter=QualificationTypeConverter.class)
    public void setJoinConditionQualification(@Nullable QualificationType type) {
        this.myJoinConditionQualification = type != null ? type : DEFAULT_JOIN_QUALIFICATION;
    }

    @NotNull
    public QualificationType getRefactoringQualification() {
        QualificationType qualificationType = this.myRefactoringQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(7);
        }
        return qualificationType;
    }

    @OptionTag(converter=QualificationTypeConverter.class)
    public void setRefactoringQualification(@Nullable QualificationType type) {
        this.myRefactoringQualification = type != null ? type : DEFAULT_QUALIFICATION_IN;
    }

    @NotNull
    public QualificationType getLiveTemplateQualification() {
        QualificationType qualificationType = this.myLiveTemplateQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(8);
        }
        return qualificationType;
    }

    @OptionTag(converter=QualificationTypeConverter.class)
    public void setLiveTemplateQualification(@Nullable QualificationType type) {
        this.myLiveTemplateQualification = type != null ? type : DEFAULT_QUALIFICATION_IN;
    }

    @NotNull
    public QualificationType getDragAndDropQualification() {
        QualificationType qualificationType = this.myDragAndDropQualification;
        if (qualificationType == null) {
            SqlEditorOptions.$$$reportNull$$$0(9);
        }
        return qualificationType;
    }

    @OptionTag(converter=QualificationTypeConverter.class)
    public void setDragAndDropQualification(@Nullable QualificationType type) {
        this.myDragAndDropQualification = type != null ? type : DEFAULT_QUALIFICATION_IN;
    }

    @NotNull
    public static SqlEditorOptions getInstance() {
        SqlEditorOptions sqlEditorOptions = (SqlEditorOptions)ApplicationManager.getApplication().getService(SqlEditorOptions.class);
        if (sqlEditorOptions == null) {
            SqlEditorOptions.$$$reportNull$$$0(10);
        }
        return sqlEditorOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlEditorOptions options = (SqlEditorOptions)o;
        return this.myConcatenateStringsOnEnter == options.myConcatenateStringsOnEnter && this.myCloseBlocksOnEnter == options.myCloseBlocksOnEnter && this.myDatabaseQualification == options.myDatabaseQualification && this.mySchemaQualification == options.mySchemaQualification && this.myTableQualification == options.myTableQualification && this.myAliasQualification == options.myAliasQualification && this.myCompletionQualification == options.myCompletionQualification && this.myJoinConditionQualification == options.myJoinConditionQualification && this.myRefactoringQualification == options.myRefactoringQualification && this.myLiveTemplateQualification == options.myLiveTemplateQualification && this.myDragAndDropQualification == options.myDragAndDropQualification;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myConcatenateStringsOnEnter, this.myCloseBlocksOnEnter, this.myDatabaseQualification, this.mySchemaQualification, this.myTableQualification, this.myAliasQualification, this.myCompletionQualification, this.myJoinConditionQualification, this.myRefactoringQualification, this.myLiveTemplateQualification, this.myDragAndDropQualification});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SqlEditorOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SqlEditorOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseQualification";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaQualification";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableQualification";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasQualification";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionQualification";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJoinConditionQualification";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringQualification";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiveTemplateQualification";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDragAndDropQualification";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    public static enum QualificationType {
        ALWAYS{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return true;
            }

            @Override
            @NotNull
            public QualificationType and(@NotNull QualificationType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                QualificationType qualificationType = type;
                if (qualificationType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return qualificationType;
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = SqlBundle.message("settings.smart.keys.always", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/editor/SqlEditorOptions$QualificationType$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/editor/SqlEditorOptions$QualificationType$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "and";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "and";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }
        ,
        SMART{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return conflictedObjectsCount > 1 || conflictedObjectsCount == 0;
            }

            @Override
            @NotNull
            public QualificationType and(@NotNull QualificationType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(0);
                }
                QualificationType qualificationType = type == NOT_QUALIFY ? type : this;
                if (qualificationType == null) {
                    2.$$$reportNull$$$0(1);
                }
                return qualificationType;
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = SqlBundle.message("settings.smart.keys.on.collisions", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/editor/SqlEditorOptions$QualificationType$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/editor/SqlEditorOptions$QualificationType$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "and";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "and";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        }
        ,
        NOT_QUALIFY{

            @Override
            public boolean shouldQualify(int conflictedObjectsCount) {
                return false;
            }

            @Override
            @NotNull
            public QualificationType and(@NotNull QualificationType type) {
                if (type == null) {
                    3.$$$reportNull$$$0(0);
                }
                3 v0 = this;
                if (v0 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return v0;
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = SqlBundle.message("settings.smart.keys.never", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/editor/SqlEditorOptions$QualificationType$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/editor/SqlEditorOptions$QualificationType$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "and";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "and";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };


        public abstract boolean shouldQualify(int var1);

        @NotNull
        public abstract QualificationType and(@NotNull QualificationType var1);

        @NotNull
        public abstract String getDisplayName();
    }

    private static class QualificationTypeConverter
    extends Converter<QualificationType> {
        private static final QualificationType[] ENUM_VALUES = QualificationType.values();

        private QualificationTypeConverter() {
        }

        @NotNull
        public QualificationType fromString(@NotNull String value) {
            if (value == null) {
                QualificationTypeConverter.$$$reportNull$$$0(0);
            }
            for (QualificationType enumValue : ENUM_VALUES) {
                if (!value.equals(enumValue.name())) continue;
                QualificationType qualificationType = enumValue;
                if (qualificationType == null) {
                    QualificationTypeConverter.$$$reportNull$$$0(1);
                }
                return qualificationType;
            }
            QualificationType qualificationType = switch (value) {
                case "Never" -> QualificationType.NOT_QUALIFY;
                case "Always" -> QualificationType.ALWAYS;
                default -> QualificationType.SMART;
            };
            if (qualificationType == null) {
                QualificationTypeConverter.$$$reportNull$$$0(2);
            }
            return qualificationType;
        }

        @NotNull
        public String toString(@NotNull QualificationType value) {
            if (value == null) {
                QualificationTypeConverter.$$$reportNull$$$0(3);
            }
            String string = value.name();
            if (string == null) {
                QualificationTypeConverter.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/editor/SqlEditorOptions$QualificationTypeConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/editor/SqlEditorOptions$QualificationTypeConverter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 4 -> new IllegalStateException(string);
            };
        }
    }
}

