/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.database.SqlDataSource;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u00060\tR\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016J&\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002J&\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0002J*\u0010\u0017\u001a\u00020\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/actions/DumpToDdlDataSourceFileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createSession", "Lcom/intellij/database/actions/DumpToDdlDataSourceFileManager$Session;", "sqlDs", "Lcom/intellij/sql/database/SqlDataSource;", "collectAllFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "addFiles", "", "files", "", "removeFiles", "suggestAddingPaths", "extra", "suggestDeletingFiles", "fileListMsg", "", "output", "limit", "", "Companion", "Session", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDumpToDdlDataSourceFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpToDdlDataSourceFileManager.kt\ncom/intellij/database/actions/DumpToDdlDataSourceFileManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1#2:155\n1563#3:156\n1634#3,3:157\n1563#3:160\n1634#3,3:161\n*S KotlinDebug\n*F\n+ 1 DumpToDdlDataSourceFileManager.kt\ncom/intellij/database/actions/DumpToDdlDataSourceFileManager\n*L\n60#1:156\n60#1:157,3\n79#1:160\n79#1:161,3\n*E\n"})
public class DumpToDdlDataSourceFileManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger log;

    public DumpToDdlDataSourceFileManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Session createSession(@NotNull SqlDataSource sqlDs) {
        Intrinsics.checkNotNullParameter((Object)sqlDs, (String)"sqlDs");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        return new Session(sqlDs);
    }

    private final Set<VirtualFile> collectAllFiles(SqlDataSource sqlDs) {
        LinkedHashSet all = new LinkedHashSet();
        sqlDs.processFiles(all::add);
        return all;
    }

    public void addFiles(@NotNull SqlDataSource sqlDs, @NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter((Object)sqlDs, (String)"sqlDs");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        ApplicationManager.getApplication().invokeLater(() -> DumpToDdlDataSourceFileManager.addFiles$lambda$0(this, sqlDs, files2));
    }

    public void removeFiles(@NotNull SqlDataSource sqlDs, @NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter((Object)sqlDs, (String)"sqlDs");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        ApplicationManager.getApplication().invokeLater(() -> DumpToDdlDataSourceFileManager.removeFiles$lambda$0(this, sqlDs, files2));
    }

    /*
     * WARNING - void declaration
     */
    private final void suggestAddingPaths(Project project, SqlDataSource sqlDs, List<? extends VirtualFile> extra) {
        VirtualFile virtualFile;
        String string = sqlDs.getOutputPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(it);
        } else {
            virtualFile = null;
        }
        VirtualFile output = virtualFile;
        String string2 = DatabaseBundle.message((String)"dialog.message.add.new.files.to.sql.data.source", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message = string2;
        String fileList = this.fileListMsg(extra, output, Integer.MAX_VALUE);
        String[] stringArray = new String[]{Messages.getYesButton(), DatabaseBundle.message((String)"add.output.folder", (Object[])new Object[0]), Messages.getNoButton()};
        int res2 = MessagesService.Companion.getInstance().showMoreInfoMessageDialog(project, message, DatabaseBundle.message((String)"dialog.title.new.files.produced", (Object[])new Object[0]), fileList, stringArray, 0, -1, null);
        switch (res2) {
            case 0: {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List list = sqlDs.getUrls();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUrls(...)");
                Iterable iterable = extra;
                Collection collection2 = list;
                SqlDataSource sqlDataSource = sqlDs;
                boolean $i$f$map = false;
                void var11_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getUrl());
                }
                collection = (List)destination$iv$iv;
                sqlDataSource.setUrls(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
                break;
            }
            case 1: {
                VirtualFile virtualFile3 = output;
                if (virtualFile3 == null) {
                    return;
                }
                VirtualFile file = virtualFile3;
                List list = sqlDs.getUrls();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUrls(...)");
                sqlDs.setUrls(CollectionsKt.plus((Collection)list, (Object)file.getUrl()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void suggestDeletingFiles(Project project, SqlDataSource sqlDs, List<? extends VirtualFile> extra) {
        VirtualFile virtualFile;
        Object[] it;
        Object[] objectArray = sqlDs.getOutputPath();
        if (objectArray != null) {
            it = objectArray;
            boolean bl = false;
            virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath((String)it);
        } else {
            virtualFile = null;
        }
        VirtualFile output = virtualFile;
        it = new Object[]{""};
        String string = DatabaseBundle.message((String)"dialog.message.existing.files.haven.t.been.mentioned.during.code.generation.delete.them", (Object[])it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        String fileList = this.fileListMsg(extra, output, Integer.MAX_VALUE);
        String[] stringArray = new String[]{Messages.getYesButton(), Messages.getNoButton()};
        int res2 = MessagesService.Companion.getInstance().showMoreInfoMessageDialog(project, message, DatabaseBundle.message((String)"dialog.title.outdated.files", (Object[])new Object[0]), fileList, stringArray, 0, -1, null);
        if (res2 == 0) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list = sqlDs.getUrls();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUrls(...)");
            Iterable iterable = extra;
            Iterable iterable2 = list;
            SqlDataSource sqlDataSource = sqlDs;
            boolean $i$f$map = false;
            void var11_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it2.getUrl());
            }
            collection = (List)destination$iv$iv;
            sqlDataSource.setUrls(CollectionsKt.minus((Iterable)iterable2, (Iterable)collection));
            WriteAction.run(() -> DumpToDdlDataSourceFileManager.suggestDeletingFiles$lambda$2(extra, sqlDs));
        }
    }

    @Nls
    private final String fileListMsg(List<? extends VirtualFile> extra, VirtualFile output, int limit) {
        Object object;
        List<? extends VirtualFile> list = extra.size() <= limit ? extra : extra.subList(0, limit);
        String files2 = SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), arg_0 -> DumpToDdlDataSourceFileManager.fileListMsg$lambda$0(output, arg_0)), DumpToDdlDataSourceFileManager::fileListMsg$lambda$1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (extra.size() <= limit) {
            object = "";
        } else {
            Object[] objectArray = new Object[]{extra.size() - limit};
            object = "\n" + DatabaseBundle.message((String)"and.0.files.more", (Object[])objectArray);
        }
        String more = object;
        return files2 + more;
    }

    static /* synthetic */ String fileListMsg$default(DumpToDdlDataSourceFileManager dumpToDdlDataSourceFileManager, List list, VirtualFile virtualFile, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fileListMsg");
        }
        if ((n2 & 4) != 0) {
            n = 3;
        }
        return dumpToDdlDataSourceFileManager.fileListMsg(list, virtualFile, n);
    }

    private static final void addFiles$lambda$0(DumpToDdlDataSourceFileManager this$0, SqlDataSource $sqlDs, List $files) {
        this$0.suggestAddingPaths(this$0.project, $sqlDs, $files);
    }

    private static final void removeFiles$lambda$0(DumpToDdlDataSourceFileManager this$0, SqlDataSource $sqlDs, List $files) {
        this$0.suggestDeletingFiles(this$0.project, $sqlDs, $files);
    }

    private static final void suggestDeletingFiles$lambda$2(List $extra, SqlDataSource $sqlDs) {
        for (VirtualFile file : $extra) {
            file.delete((Object)$sqlDs);
        }
    }

    private static final String fileListMsg$lambda$0(VirtualFile $output, VirtualFile it) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                object = $output;
                if (object == null) break block2;
                VirtualFile p = object;
                boolean bl = false;
                String string = VfsUtil.findRelativePath((VirtualFile)p, (VirtualFile)it, (char)File.separatorChar);
                object = string;
                if (string != null) break block3;
            }
            String string = it.getPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        }
        return object;
    }

    private static final boolean fileListMsg$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    static {
        Logger logger = Logger.getInstance(DumpToDdlDataSourceFileManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/actions/DumpToDdlDataSourceFileManager$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00170\u00162\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/actions/DumpToDdlDataSourceFileManager$Session;", "", "sqlDs", "Lcom/intellij/sql/database/SqlDataSource;", "<init>", "(Lcom/intellij/database/actions/DumpToDdlDataSourceFileManager;Lcom/intellij/sql/database/SqlDataSource;)V", "generated", "Ljava/util/LinkedHashSet;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/collections/LinkedHashSet;", "add", "", "file", "Ljava/nio/file/Path;", "text", "", "complete", "", "dropExtraFile", "", "findOrCreateFile", "computeFileListChanges", "Lcom/intellij/openapi/util/Couple;", "", "allFiles", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDumpToDdlDataSourceFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpToDdlDataSourceFileManager.kt\ncom/intellij/database/actions/DumpToDdlDataSourceFileManager$Session\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,154:1\n1255#2,2:155\n*S KotlinDebug\n*F\n+ 1 DumpToDdlDataSourceFileManager.kt\ncom/intellij/database/actions/DumpToDdlDataSourceFileManager$Session\n*L\n148#1:155,2\n*E\n"})
    public final class Session {
        @NotNull
        private final SqlDataSource sqlDs;
        @NotNull
        private final LinkedHashSet<VirtualFile> generated;

        public Session(SqlDataSource sqlDs) {
            Intrinsics.checkNotNullParameter((Object)sqlDs, (String)"sqlDs");
            this.sqlDs = sqlDs;
            this.generated = new LinkedHashSet();
        }

        public final void add(@NotNull Path file, @NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            WriteAction.runAndWait(() -> Session.add$lambda$0(this, file, text));
        }

        @NotNull
        public final Set<VirtualFile> complete(boolean dropExtraFile) {
            WriteAction.runAndWait(Session::complete$lambda$0);
            Set all = DumpToDdlDataSourceFileManager.this.collectAllFiles(this.sqlDs);
            Couple<List<VirtualFile>> changes = this.computeFileListChanges((Set<? extends VirtualFile>)this.generated, all);
            Object object = changes.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
            if (!((Collection)object).isEmpty()) {
                Object object2 = changes.first;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
                DumpToDdlDataSourceFileManager.this.addFiles(this.sqlDs, (List)object2);
            }
            Object object3 = changes.second;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"second");
            if (!((Collection)object3).isEmpty() && dropExtraFile) {
                Object object4 = changes.second;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"second");
                DumpToDdlDataSourceFileManager.this.removeFiles(this.sqlDs, (List)object4);
            }
            return this.generated;
        }

        private final VirtualFile findOrCreateFile(Path file) {
            VirtualFile parent2;
            VirtualFile virtualFile = VfsUtil.findFile((Path)file, (boolean)true);
            if (virtualFile != null) {
                return virtualFile;
            }
            VirtualFile virtualFile2 = parent2 = VfsUtil.createDirectoryIfMissing((String)((Object)file.getParent()).toString());
            return virtualFile2 != null ? virtualFile2.createChildData((Object)DumpToDdlDataSourceFileManager.this, ((Object)file.getFileName()).toString()) : null;
        }

        private final Couple<List<VirtualFile>> computeFileListChanges(Set<? extends VirtualFile> generated, Set<? extends VirtualFile> allFiles) {
            ArrayList extra = new ArrayList();
            ArrayList deleted = new ArrayList();
            for (VirtualFile virtualFile : allFiles) {
                if (virtualFile.isDirectory() || generated.contains(virtualFile)) continue;
                ((Collection)deleted).add(virtualFile);
            }
            for (VirtualFile virtualFile : generated) {
                boolean inDs;
                boolean bl;
                block3: {
                    Sequence $this$any$iv = SequencesKt.generateSequence((Object)virtualFile, Session::computeFileListChanges$lambda$0);
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        if (!allFiles.contains(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (inDs = bl) continue;
                ((Collection)extra).add(virtualFile);
            }
            Couple couple = Couple.of(extra, deleted);
            Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"of(...)");
            return couple;
        }

        private static final void add$lambda$0(Session this$0, Path $file, String $text) {
            VirtualFile virtualFile = this$0.findOrCreateFile($file);
            if (virtualFile == null) {
                log.error("Unable to create: " + $file);
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document != null) {
                document.setText((CharSequence)$text);
            } else {
                VfsUtil.saveText((VirtualFile)virtualFile, (String)$text);
            }
            this$0.generated.add(virtualFile);
        }

        private static final void complete$lambda$0() {
            FileDocumentManager.getInstance().saveAllDocuments();
        }

        private static final VirtualFile computeFileListChanges$lambda$0(VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getParent();
        }
    }
}

