/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.utils;

import com.intellij.station.comms.common.netty.client.StationServicesClientBase;
import java.net.UnixDomainSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\u001a\u001a\u00020\u0005J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001cH\u0007J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0017H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/intellij/station/comms/common/utils/StationConstants;", "", "<init>", "()V", "ideIdHeader", "", "getIdeIdHeader", "()Ljava/lang/String;", "idePidHeader", "getIdePidHeader", "ideInstallPathHeader", "getIdeInstallPathHeader", "ideFullVersionHeader", "getIdeFullVersionHeader", "stationFailureHeader", "getStationFailureHeader", "unknownEndpointValue", "getUnknownEndpointValue", "isLinux", "", "()Z", "isMac", "getStationClientAddress", "Ljava/net/UnixDomainSocketAddress;", "getStationAddress", "getAdditionalLinkAddress", "getIdeBaseDirectory", "getBaseDirectoryAndUserName", "Lkotlin/Pair;", "getLinuxXdgRuntimeDir", "getStationAddressCommonTempdir", "getStationAddressLinuxPreferred", "intellij.station.comms.common"})
@SourceDebugExtension(value={"SMAP\nStationConstants.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StationConstants.kt\ncom/intellij/station/comms/common/utils/StationConstants\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1#2:88\n*E\n"})
public final class StationConstants {
    @NotNull
    public static final StationConstants INSTANCE = new StationConstants();
    @NotNull
    private static final String ideIdHeader = "X-Ide-Id";
    @NotNull
    private static final String idePidHeader = "X-Ide-Pid";
    @NotNull
    private static final String ideInstallPathHeader = "X-Ide-Install-Path";
    @NotNull
    private static final String ideFullVersionHeader = "X-Ide-Full-Version";
    @NotNull
    private static final String stationFailureHeader = "X-Station-Failure";
    @NotNull
    private static final String unknownEndpointValue = "no-endpoint";
    private static final boolean isLinux;
    private static final boolean isMac;

    private StationConstants() {
    }

    @NotNull
    public final String getIdeIdHeader() {
        return ideIdHeader;
    }

    @NotNull
    public final String getIdePidHeader() {
        return idePidHeader;
    }

    @NotNull
    public final String getIdeInstallPathHeader() {
        return ideInstallPathHeader;
    }

    @NotNull
    public final String getIdeFullVersionHeader() {
        return ideFullVersionHeader;
    }

    @NotNull
    public final String getStationFailureHeader() {
        return stationFailureHeader;
    }

    @NotNull
    public final String getUnknownEndpointValue() {
        return unknownEndpointValue;
    }

    public final boolean isLinux() {
        return isLinux;
    }

    public final boolean isMac() {
        return isMac;
    }

    @NotNull
    public final UnixDomainSocketAddress getStationClientAddress() {
        return StationServicesClientBase.Companion.chooseAddress$intellij_station_comms_common(this.getStationAddress(), this.getAdditionalLinkAddress());
    }

    @NotNull
    public final UnixDomainSocketAddress getStationAddress() {
        UnixDomainSocketAddress unixDomainSocketAddress = this.getStationAddressLinuxPreferred();
        if (unixDomainSocketAddress != null) {
            UnixDomainSocketAddress it = unixDomainSocketAddress;
            boolean bl = false;
            return it;
        }
        return this.getStationAddressCommonTempdir();
    }

    @Nullable
    public final UnixDomainSocketAddress getAdditionalLinkAddress() {
        if (this.getStationAddressLinuxPreferred() == null) {
            return null;
        }
        return this.getStationAddressCommonTempdir();
    }

    @NotNull
    public final String getIdeBaseDirectory() {
        String string = this.getLinuxXdgRuntimeDir();
        if (string == null) {
            String string2 = System.getProperty("java.io.tmpdir");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final Pair<String, String> getBaseDirectoryAndUserName() {
        String string;
        String it = System.getProperty("user.name");
        boolean bl = false;
        CharSequence charSequence = it;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)it, (Object)"?")) {
            string = System.getenv("USER");
            if (string == null) {
                string = "user";
            }
        } else {
            void var3_1;
            string = var3_1;
        }
        String userName = string;
        String tempDirectory = System.getProperty("java.io.tmpdir");
        return TuplesKt.to((Object)tempDirectory, (Object)userName);
    }

    private final String getLinuxXdgRuntimeDir() {
        if (!isLinux) {
            return null;
        }
        String xdgRuntimeDir = System.getenv("XDG_RUNTIME_DIR");
        CharSequence charSequence = xdgRuntimeDir;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && Files.exists(Path.of(xdgRuntimeDir, new String[0]), new LinkOption[0])) {
            return xdgRuntimeDir;
        }
        return null;
    }

    private final UnixDomainSocketAddress getStationAddressCommonTempdir() {
        Pair<String, String> pair = this.getBaseDirectoryAndUserName();
        String tempDirectory = (String)pair.component1();
        String userName = (String)pair.component2();
        String[] stringArray = new String[]{"jb.station." + userName + ".sock"};
        UnixDomainSocketAddress unixDomainSocketAddress = UnixDomainSocketAddress.of(Path.of(tempDirectory, stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)unixDomainSocketAddress, (String)"of(...)");
        return unixDomainSocketAddress;
    }

    private final UnixDomainSocketAddress getStationAddressLinuxPreferred() {
        UnixDomainSocketAddress unixDomainSocketAddress;
        String string = this.getLinuxXdgRuntimeDir();
        if (string != null) {
            String it = string;
            boolean bl = false;
            String[] stringArray = new String[]{"jb.station.sock"};
            unixDomainSocketAddress = UnixDomainSocketAddress.of(Path.of(it, stringArray));
        } else {
            unixDomainSocketAddress = null;
        }
        return unixDomainSocketAddress;
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        isLinux = StringsKt.startsWith((String)string, (String)"linux", (boolean)true);
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        isMac = StringsKt.startsWith((String)string2, (String)"mac", (boolean)true);
    }
}

