/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.TargetingDimensionMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;

public class CountrySetApkMatcher
extends TargetingDimensionMatcher<Targeting.CountrySetTargeting> {
    public CountrySetApkMatcher(Devices.DeviceSpec deviceSpec) {
        super(deviceSpec);
    }

    @Override
    protected Targeting.CountrySetTargeting getTargetingValue(Targeting.ApkTargeting apkTargeting) {
        return apkTargeting.getCountrySetTargeting();
    }

    @Override
    protected Targeting.CountrySetTargeting getTargetingValue(Targeting.VariantTargeting variantTargeting) {
        return Targeting.CountrySetTargeting.getDefaultInstance();
    }

    @Override
    public boolean matchesTargeting(Targeting.CountrySetTargeting targeting) {
        if (targeting.equals(Targeting.CountrySetTargeting.getDefaultInstance())) {
            return true;
        }
        ImmutableSet<String> values2 = ImmutableSet.copyOf(targeting.getValueList());
        ImmutableSet<String> alternatives = ImmutableSet.copyOf(targeting.getAlternativesList());
        Sets.SetView<String> intersection = Sets.intersection(values2, alternatives);
        Preconditions.checkArgument(intersection.isEmpty(), "Expected targeting values and alternatives to be mutually exclusive, but both contain: %s", intersection);
        if (!this.getDeviceSpec().hasCountrySet() || this.getDeviceSpec().getCountrySet().getValue().isEmpty()) {
            return values2.isEmpty() && !alternatives.isEmpty();
        }
        return values2.contains(this.getDeviceSpec().getCountrySet().getValue());
    }

    @Override
    protected boolean isDeviceDimensionPresent() {
        return this.getDeviceSpec().hasCountrySet();
    }

    @Override
    protected void checkDeviceCompatibleInternal(Targeting.CountrySetTargeting targeting) {
        if (targeting.equals(Targeting.CountrySetTargeting.getDefaultInstance())) {
            return;
        }
        if (!this.getDeviceSpec().hasCountrySet() || this.getDeviceSpec().getCountrySet().getValue().isEmpty()) {
            return;
        }
        ImmutableSet valuesAndAlternatives = Streams.concat(targeting.getValueList().stream(), targeting.getAlternativesList().stream()).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument(valuesAndAlternatives.contains(this.getDeviceSpec().getCountrySet().getValue()), "The specified country set '%s' does not match any of the available values: %s.", (Object)this.getDeviceSpec().getCountrySet().getValue(), (Object)String.join((CharSequence)", ", valuesAndAlternatives));
    }
}

