// This file is generated by modules/charset/ambiguous/generate.go DO NOT EDIT
// Copyright 2022 The Gitea Authors. All rights reserved.
// SPDX-License-Identifier: MIT

package charset

import "unicode"

// This file is generated from https://github.com/hediet/vscode-unicode-data/blob/main/out/ambiguous.json

// AmbiguousTable matches a confusable rune with its partner for the Locale
type AmbiguousTable struct {
	Confusable []rune
	With       []rune
	Locale     string
	RangeTable *unicode.RangeTable
}

// AmbiguousCharacters provides a map by locale name to the confusable characters in that locale
var AmbiguousCharacters = map[string]*AmbiguousTable{
	"_common": {
		Confusable: []rune{184, 383, 388, 397, 422, 423, 439, 444, 445, 448, 451, 540, 546, 547, 577, 593, 609, 611, 617, 618, 623, 651, 655, 660, 697, 699, 700, 701, 702, 706, 707, 708, 710, 712, 714, 715, 720, 727, 731, 732, 756, 760, 884, 890, 894, 895, 900, 913, 914, 917, 918, 919, 922, 924, 925, 927, 929, 932, 933, 935, 945, 947, 953, 957, 959, 961, 963, 965, 978, 988, 1000, 1010, 1011, 1017, 1018, 1029, 1030, 1032, 1109, 1110, 1112, 1121, 1140, 1141, 1198, 1199, 1211, 1213, 1216, 1231, 1248, 1281, 1292, 1307, 1308, 1309, 1357, 1359, 1365, 1370, 1373, 1377, 1379, 1382, 1392, 1400, 1404, 1405, 1409, 1412, 1413, 1417, 1472, 1475, 1493, 1496, 1497, 1503, 1505, 1523, 1549, 1575, 1607, 1632, 1633, 1637, 1639, 1643, 1645, 1726, 1729, 1748, 1749, 1776, 1777, 1781, 1783, 1793, 1794, 1795, 1796, 1984, 1994, 2036, 2037, 2042, 2307, 2406, 2429, 2534, 2538, 2541, 2662, 2663, 2666, 2691, 2790, 2819, 2848, 2918, 2920, 3046, 3074, 3174, 3202, 3302, 3330, 3360, 3430, 3437, 3458, 3664, 3792, 4125, 4160, 4327, 4351, 4608, 4816, 5024, 5025, 5026, 5029, 5033, 5034, 5035, 5036, 5038, 5043, 5047, 5051, 5053, 5056, 5058, 5059, 5070, 5071, 5074, 5076, 5077, 5081, 5082, 5086, 5087, 5090, 5094, 5095, 5102, 5107, 5108, 5120, 5167, 5171, 5176, 5194, 5196, 5229, 5231, 5234, 5261, 5290, 5311, 5441, 5500, 5501, 5511, 5551, 5556, 5573, 5598, 5610, 5616, 5623, 5741, 5742, 5760, 5810, 5815, 5825, 5836, 5845, 5846, 5868, 5869, 5941, 6147, 6153, 7428, 7439, 7441, 7452, 7456, 7457, 7458, 7462, 7555, 7564, 7837, 7935, 8125, 8126, 8127, 8128, 8175, 8189, 8190, 8192, 8193, 8194, 8195, 8196, 8197, 8198, 8199, 8200, 8201, 8202, 8208, 8209, 8210, 8218, 8219, 8228, 8232, 8233, 8239, 8242, 8249, 8250, 8257, 8259, 8260, 8270, 8275, 8282, 8287, 8450, 8458, 8459, 8460, 8461, 8462, 8464, 8465, 8466, 8467, 8469, 8473, 8474, 8475, 8476, 8477, 8484, 8488, 8490, 8492, 8493, 8494, 8495, 8496, 8497, 8499, 8500, 8505, 8509, 8517, 8518, 8519, 8520, 8521, 8544, 8548, 8553, 8556, 8557, 8558, 8559, 8560, 8564, 8569, 8572, 8573, 8574, 8722, 8725, 8726, 8727, 8739, 8744, 8746, 8758, 8764, 8868, 8897, 8899, 8959, 9075, 9076, 9082, 9213, 9585, 9587, 10088, 10089, 10094, 10095, 10098, 10099, 10100, 10101, 10133, 10134, 10187, 10189, 10201, 10539, 10540, 10741, 10744, 10745, 10799, 11397, 11406, 11410, 11412, 11416, 11418, 11422, 11423, 11426, 11427, 11428, 11429, 11430, 11432, 11436, 11450, 11462, 11466, 11468, 11472, 11474, 11576, 11577, 11599, 11601, 11604, 11605, 11613, 11840, 12034, 12035, 12295, 12308, 12309, 12339, 12448, 12755, 12756, 20022, 20031, 42192, 42193, 42194, 42195, 42196, 42198, 42199, 42201, 42202, 42204, 42205, 42207, 42208, 42209, 42210, 42211, 42214, 42215, 42218, 42219, 42220, 42222, 42224, 42226, 42227, 42228, 42232, 42233, 42237, 42239, 42510, 42564, 42567, 42719, 42731, 42735, 42801, 42842, 42858, 42862, 42872, 42889, 42892, 42904, 42905, 42911, 42923, 42930, 42931, 42932, 43826, 43829, 43837, 43847, 43848, 43854, 43858, 43866, 43893, 43905, 43907, 43923, 43945, 43946, 43951, 64422, 64423, 64424, 64425, 64426, 64427, 64428, 64429, 64830, 64831, 65072, 65101, 65102, 65103, 65112, 65128, 65165, 65166, 65257, 65258, 65259, 65260, 65282, 65284, 65285, 65286, 65287, 65290, 65291, 65293, 65294, 65295, 65296, 65297, 65298, 65299, 65300, 65301, 65302, 65303, 65304, 65305, 65308, 65309, 65310, 65312, 65313, 65314, 65315, 65316, 65317, 65318, 65319, 65320, 65321, 65322, 65323, 65324, 65325, 65326, 65327, 65328, 65329, 65330, 65331, 65332, 65333, 65334, 65335, 65336, 65337, 65338, 65339, 65340, 65341, 65342, 65343, 65344, 65345, 65346, 65347, 65348, 65349, 65350, 65351, 65352, 65353, 65354, 65355, 65356, 65357, 65358, 65359, 65360, 65361, 65362, 65363, 65364, 65365, 65366, 65367, 65368, 65369, 65370, 65371, 65372, 65373, 65512, 66178, 66182, 66183, 66186, 66192, 66194, 66197, 66198, 66199, 66203, 66208, 66209, 66210, 66213, 66219, 66224, 66225, 66226, 66228, 66255, 66293, 66305, 66306, 66313, 66321, 66325, 66327, 66330, 66335, 66336, 66338, 66564, 66581, 66587, 66592, 66604, 66621, 66632, 66740, 66754, 66766, 66770, 66794, 66806, 66835, 66838, 66840, 66844, 66845, 66853, 66854, 66855, 68176, 70864, 71430, 71434, 71438, 71439, 71840, 71842, 71843, 71844, 71846, 71849, 71852, 71854, 71855, 71858, 71861, 71864, 71867, 71868, 71872, 71873, 71874, 71875, 71876, 71878, 71880, 71882, 71884, 71893, 71894, 71895, 71896, 71900, 71904, 71909, 71910, 71913, 71916, 71919, 71922, 93960, 93962, 93974, 93992, 94005, 94010, 94011, 94015, 94016, 94018, 94019, 94033, 94034, 119060, 119149, 119302, 119309, 119311, 119314, 119315, 119318, 119338, 119350, 119351, 119354, 119355, 119808, 119809, 119810, 119811, 119812, 119813, 119814, 119815, 119816, 119817, 119818, 119819, 119820, 119821, 119822, 119823, 119824, 119825, 119826, 119827, 119828, 119829, 119830, 119831, 119832, 119833, 119834, 119835, 119836, 119837, 119838, 119839, 119840, 119841, 119842, 119843, 119844, 119845, 119847, 119848, 119849, 119850, 119851, 119852, 119853, 119854, 119855, 119856, 119857, 119858, 119859, 119860, 119861, 119862, 119863, 119864, 119865, 119866, 119867, 119868, 119869, 119870, 119871, 119872, 119873, 119874, 119875, 119876, 119877, 119878, 119879, 119880, 119881, 119882, 119883, 119884, 119885, 119886, 119887, 119888, 119889, 119890, 119891, 119892, 119894, 119895, 119896, 119897, 119899, 119900, 119901, 119902, 119903, 119904, 119905, 119906, 119907, 119908, 119909, 119910, 119911, 119912, 119913, 119914, 119915, 119916, 119917, 119918, 119919, 119920, 119921, 119922, 119923, 119924, 119925, 119926, 119927, 119928, 119929, 119930, 119931, 119932, 119933, 119934, 119935, 119936, 119937, 119938, 119939, 119940, 119941, 119942, 119943, 119944, 119945, 119946, 119947, 119948, 119949, 119951, 119952, 119953, 119954, 119955, 119956, 119957, 119958, 119959, 119960, 119961, 119962, 119963, 119964, 119966, 119967, 119970, 119973, 119974, 119977, 119978, 119979, 119980, 119982, 119983, 119984, 119985, 119986, 119987, 119988, 119989, 119990, 119991, 119992, 119993, 119995, 119997, 119998, 119999, 120000, 120001, 120003, 120005, 120006, 120007, 120008, 120009, 120010, 120011, 120012, 120013, 120014, 120015, 120016, 120017, 120018, 120019, 120020, 120021, 120022, 120023, 120024, 120025, 120026, 120027, 120028, 120029, 120030, 120031, 120032, 120033, 120034, 120035, 120036, 120037, 120038, 120039, 120040, 120041, 120042, 120043, 120044, 120045, 120046, 120047, 120048, 120049, 120050, 120051, 120052, 120053, 120055, 120056, 120057, 120058, 120059, 120060, 120061, 120062, 120063, 120064, 120065, 120066, 120067, 120068, 120069, 120071, 120072, 120073, 120074, 120077, 120078, 120079, 120080, 120081, 120082, 120083, 120084, 120086, 120087, 120088, 120089, 120090, 120091, 120092, 120094, 120095, 120096, 120097, 120098, 120099, 120100, 120101, 120102, 120103, 120104, 120105, 120107, 120108, 120109, 120110, 120111, 120112, 120113, 120114, 120115, 120116, 120117, 120118, 120119, 120120, 120121, 120123, 120124, 120125, 120126, 120128, 120129, 120130, 120131, 120132, 120134, 120138, 120139, 120140, 120141, 120142, 120143, 120144, 120146, 120147, 120148, 120149, 120150, 120151, 120152, 120153, 120154, 120155, 120156, 120157, 120159, 120160, 120161, 120162, 120163, 120164, 120165, 120166, 120167, 120168, 120169, 120170, 120171, 120172, 120173, 120174, 120175, 120176, 120177, 120178, 120179, 120180, 120181, 120182, 120183, 120184, 120185, 120186, 120187, 120188, 120189, 120190, 120191, 120192, 120193, 120194, 120195, 120196, 120197, 120198, 120199, 120200, 120201, 120202, 120203, 120204, 120205, 120206, 120207, 120208, 120209, 120211, 120212, 120213, 120214, 120215, 120216, 120217, 120218, 120219, 120220, 120221, 120222, 120223, 120224, 120225, 120226, 120227, 120228, 120229, 120230, 120231, 120232, 120233, 120234, 120235, 120236, 120237, 120238, 120239, 120240, 120241, 120242, 120243, 120244, 120245, 120246, 120247, 120248, 120249, 120250, 120251, 120252, 120253, 120254, 120255, 120256, 120257, 120258, 120259, 120260, 120261, 120263, 120264, 120265, 120266, 120267, 120268, 120269, 120270, 120271, 120272, 120273, 120274, 120275, 120276, 120277, 120278, 120279, 120280, 120281, 120282, 120283, 120284, 120285, 120286, 120287, 120288, 120289, 120290, 120291, 120292, 120293, 120294, 120295, 120296, 120297, 120298, 120299, 120300, 120301, 120302, 120303, 120304, 120305, 120306, 120307, 120308, 120309, 120310, 120311, 120312, 120313, 120315, 120316, 120317, 120318, 120319, 120320, 120321, 120322, 120323, 120324, 120325, 120326, 120327, 120328, 120329, 120330, 120331, 120332, 120333, 120334, 120335, 120336, 120337, 120338, 120339, 120340, 120341, 120342, 120343, 120344, 120345, 120346, 120347, 120348, 120349, 120350, 120351, 120352, 120353, 120354, 120355, 120356, 120357, 120358, 120359, 120360, 120361, 120362, 120363, 120364, 120365, 120367, 120368, 120369, 120370, 120371, 120372, 120373, 120374, 120375, 120376, 120377, 120378, 120379, 120380, 120381, 120382, 120383, 120384, 120385, 120386, 120387, 120388, 120389, 120390, 120391, 120392, 120393, 120394, 120395, 120396, 120397, 120398, 120399, 120400, 120401, 120402, 120403, 120404, 120405, 120406, 120407, 120408, 120409, 120410, 120411, 120412, 120413, 120414, 120415, 120416, 120417, 120419, 120420, 120421, 120422, 120423, 120424, 120425, 120426, 120427, 120428, 120429, 120430, 120431, 120432, 120433, 120434, 120435, 120436, 120437, 120438, 120439, 120440, 120441, 120442, 120443, 120444, 120445, 120446, 120447, 120448, 120449, 120450, 120451, 120452, 120453, 120454, 120455, 120456, 120457, 120458, 120459, 120460, 120461, 120462, 120463, 120464, 120465, 120466, 120467, 120468, 120469, 120471, 120472, 120473, 120474, 120475, 120476, 120477, 120478, 120479, 120480, 120481, 120482, 120483, 120484, 120488, 120489, 120492, 120493, 120494, 120496, 120497, 120499, 120500, 120502, 120504, 120507, 120508, 120510, 120514, 120516, 120522, 120526, 120528, 120530, 120532, 120534, 120544, 120546, 120547, 120550, 120551, 120552, 120554, 120555, 120557, 120558, 120560, 120562, 120565, 120566, 120568, 120572, 120574, 120580, 120584, 120586, 120588, 120590, 120592, 120602, 120604, 120605, 120608, 120609, 120610, 120612, 120613, 120615, 120616, 120618, 120620, 120623, 120624, 120626, 120630, 120632, 120638, 120642, 120644, 120646, 120648, 120650, 120660, 120662, 120663, 120666, 120667, 120668, 120670, 120671, 120673, 120674, 120676, 120678, 120681, 120682, 120684, 120688, 120690, 120696, 120700, 120702, 120704, 120706, 120708, 120718, 120720, 120721, 120724, 120725, 120726, 120728, 120729, 120731, 120732, 120734, 120736, 120739, 120740, 120742, 120746, 120748, 120754, 120758, 120760, 120762, 120764, 120766, 120776, 120778, 120782, 120783, 120784, 120785, 120786, 120787, 120788, 120789, 120790, 120791, 120792, 120793, 120794, 120795, 120796, 120797, 120798, 120799, 120800, 120801, 120802, 120803, 120804, 120805, 120806, 120807, 120808, 120809, 120810, 120811, 120812, 120813, 120814, 120815, 120816, 120817, 120818, 120819, 120820, 120821, 120822, 120823, 120824, 120825, 120826, 120827, 120828, 120829, 120830, 120831, 125127, 125131, 126464, 126500, 126564, 126592, 126596, 128844, 128872, 130032, 130033, 130034, 130035, 130036, 130037, 130038, 130039, 130040, 130041},
		With:       []rune{44, 102, 98, 103, 82, 50, 51, 53, 115, 73, 33, 51, 56, 56, 63, 97, 103, 121, 105, 105, 119, 117, 121, 63, 96, 96, 96, 96, 96, 60, 62, 94, 94, 96, 96, 96, 58, 45, 105, 126, 96, 58, 96, 105, 59, 74, 96, 65, 66, 69, 90, 72, 75, 77, 78, 79, 80, 84, 89, 88, 97, 121, 105, 118, 111, 112, 111, 117, 89, 70, 50, 99, 106, 67, 77, 83, 73, 74, 115, 105, 106, 119, 86, 118, 89, 121, 104, 101, 73, 105, 51, 100, 71, 113, 87, 119, 85, 83, 79, 96, 96, 119, 113, 113, 104, 110, 110, 117, 103, 102, 111, 58, 108, 58, 108, 118, 96, 108, 111, 96, 44, 108, 111, 46, 108, 111, 86, 44, 42, 111, 111, 45, 111, 46, 73, 111, 86, 46, 46, 58, 58, 79, 108, 96, 96, 95, 58, 111, 63, 79, 56, 57, 111, 57, 56, 58, 111, 56, 79, 79, 57, 111, 111, 111, 111, 111, 111, 111, 111, 57, 111, 111, 111, 111, 111, 121, 111, 85, 79, 68, 82, 84, 105, 89, 65, 74, 69, 63, 87, 77, 72, 89, 71, 104, 90, 52, 98, 82, 87, 83, 86, 83, 76, 67, 80, 75, 100, 54, 71, 66, 61, 86, 62, 60, 96, 85, 80, 100, 98, 74, 76, 50, 120, 72, 120, 82, 98, 70, 65, 68, 68, 77, 66, 88, 120, 32, 60, 88, 73, 96, 75, 77, 58, 43, 47, 58, 58, 99, 111, 111, 117, 118, 119, 122, 114, 103, 121, 102, 121, 96, 105, 96, 126, 96, 96, 96, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 45, 45, 45, 44, 96, 46, 32, 32, 32, 96, 60, 62, 47, 45, 47, 42, 126, 58, 32, 67, 103, 72, 72, 72, 104, 73, 73, 76, 108, 78, 80, 81, 82, 82, 82, 90, 90, 75, 66, 67, 101, 101, 69, 70, 77, 111, 105, 121, 68, 100, 101, 105, 106, 73, 86, 88, 76, 67, 68, 77, 105, 118, 120, 73, 99, 100, 45, 47, 92, 42, 73, 118, 85, 58, 126, 84, 118, 85, 69, 105, 112, 97, 73, 47, 88, 40, 41, 60, 62, 40, 41, 123, 125, 43, 45, 47, 92, 84, 120, 120, 92, 47, 92, 120, 114, 72, 73, 75, 77, 78, 79, 111, 80, 112, 67, 99, 84, 89, 88, 45, 47, 57, 51, 76, 54, 86, 69, 73, 33, 79, 81, 88, 61, 92, 47, 79, 40, 41, 47, 61, 47, 92, 92, 47, 66, 80, 100, 68, 84, 71, 75, 74, 67, 90, 70, 77, 78, 76, 83, 82, 86, 72, 87, 88, 89, 65, 69, 73, 79, 85, 46, 44, 58, 61, 46, 50, 105, 86, 63, 50, 115, 50, 51, 57, 38, 58, 96, 70, 102, 117, 51, 74, 88, 66, 101, 102, 111, 114, 114, 117, 117, 121, 105, 114, 119, 122, 118, 115, 99, 111, 111, 111, 111, 111, 111, 111, 111, 40, 41, 58, 95, 95, 95, 45, 92, 108, 108, 111, 111, 111, 111, 34, 36, 37, 38, 96, 42, 43, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 60, 61, 62, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 73, 66, 69, 70, 124, 88, 79, 80, 83, 84, 43, 65, 66, 67, 70, 79, 77, 84, 89, 88, 72, 90, 66, 67, 124, 77, 84, 88, 56, 42, 108, 88, 79, 67, 76, 83, 111, 99, 115, 82, 79, 85, 55, 111, 117, 78, 79, 75, 67, 86, 70, 76, 88, 46, 79, 118, 119, 119, 119, 86, 70, 76, 89, 69, 90, 57, 69, 52, 76, 79, 85, 53, 84, 118, 115, 70, 105, 122, 55, 111, 51, 57, 54, 57, 111, 117, 121, 79, 90, 87, 67, 88, 87, 67, 86, 84, 76, 73, 82, 83, 51, 62, 65, 85, 89, 96, 96, 123, 46, 51, 86, 92, 55, 70, 82, 76, 60, 62, 47, 92, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 105, 106, 107, 108, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 67, 68, 71, 74, 75, 78, 79, 80, 81, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 102, 104, 105, 106, 107, 108, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 68, 69, 70, 71, 74, 75, 76, 77, 78, 79, 80, 81, 83, 84, 85, 86, 87, 88, 89, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 73, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 68, 69, 70, 71, 73, 74, 75, 76, 77, 79, 83, 84, 85, 86, 87, 88, 89, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 73, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 73, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 73, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 73, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 73, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 73, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 73, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 105, 65, 66, 69, 90, 72, 73, 75, 77, 78, 79, 80, 84, 89, 88, 97, 121, 105, 118, 111, 112, 111, 117, 112, 65, 66, 69, 90, 72, 73, 75, 77, 78, 79, 80, 84, 89, 88, 97, 121, 105, 118, 111, 112, 111, 117, 112, 65, 66, 69, 90, 72, 73, 75, 77, 78, 79, 80, 84, 89, 88, 97, 121, 105, 118, 111, 112, 111, 117, 112, 65, 66, 69, 90, 72, 73, 75, 77, 78, 79, 80, 84, 89, 88, 97, 121, 105, 118, 111, 112, 111, 117, 112, 65, 66, 69, 90, 72, 73, 75, 77, 78, 79, 80, 84, 89, 88, 97, 121, 105, 118, 111, 112, 111, 117, 112, 70, 79, 73, 50, 51, 52, 53, 54, 55, 56, 57, 79, 73, 50, 51, 52, 53, 54, 55, 56, 57, 79, 73, 50, 51, 52, 53, 54, 55, 56, 57, 79, 73, 50, 51, 52, 53, 54, 55, 56, 57, 79, 73, 50, 51, 52, 53, 54, 55, 56, 57, 108, 56, 108, 111, 111, 108, 111, 67, 84, 79, 73, 50, 51, 52, 53, 54, 55, 56, 57},
		Locale:     "_common",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 184, Hi: 383, Stride: 199},
				{Lo: 388, Hi: 397, Stride: 9},
				{Lo: 422, Hi: 423, Stride: 1},
				{Lo: 439, Hi: 444, Stride: 5},
				{Lo: 445, Hi: 451, Stride: 3},
				{Lo: 540, Hi: 546, Stride: 6},
				{Lo: 547, Hi: 577, Stride: 30},
				{Lo: 593, Hi: 609, Stride: 16},
				{Lo: 611, Hi: 617, Stride: 6},
				{Lo: 618, Hi: 623, Stride: 5},
				{Lo: 651, Hi: 655, Stride: 4},
				{Lo: 660, Hi: 697, Stride: 37},
				{Lo: 699, Hi: 702, Stride: 1},
				{Lo: 706, Hi: 708, Stride: 1},
				{Lo: 710, Hi: 714, Stride: 2},
				{Lo: 715, Hi: 720, Stride: 5},
				{Lo: 727, Hi: 731, Stride: 4},
				{Lo: 732, Hi: 756, Stride: 24},
				{Lo: 760, Hi: 884, Stride: 124},
				{Lo: 890, Hi: 894, Stride: 4},
				{Lo: 895, Hi: 900, Stride: 5},
				{Lo: 913, Hi: 914, Stride: 1},
				{Lo: 917, Hi: 919, Stride: 1},
				{Lo: 922, Hi: 924, Stride: 2},
				{Lo: 925, Hi: 929, Stride: 2},
				{Lo: 932, Hi: 933, Stride: 1},
				{Lo: 935, Hi: 945, Stride: 10},
				{Lo: 947, Hi: 953, Stride: 6},
				{Lo: 957, Hi: 965, Stride: 2},
				{Lo: 978, Hi: 988, Stride: 10},
				{Lo: 1000, Hi: 1010, Stride: 10},
				{Lo: 1011, Hi: 1017, Stride: 6},
				{Lo: 1018, Hi: 1029, Stride: 11},
				{Lo: 1030, Hi: 1032, Stride: 2},
				{Lo: 1109, Hi: 1110, Stride: 1},
				{Lo: 1112, Hi: 1121, Stride: 9},
				{Lo: 1140, Hi: 1141, Stride: 1},
				{Lo: 1198, Hi: 1199, Stride: 1},
				{Lo: 1211, Hi: 1213, Stride: 2},
				{Lo: 1216, Hi: 1231, Stride: 15},
				{Lo: 1248, Hi: 1281, Stride: 33},
				{Lo: 1292, Hi: 1307, Stride: 15},
				{Lo: 1308, Hi: 1309, Stride: 1},
				{Lo: 1357, Hi: 1359, Stride: 2},
				{Lo: 1365, Hi: 1370, Stride: 5},
				{Lo: 1373, Hi: 1377, Stride: 4},
				{Lo: 1379, Hi: 1382, Stride: 3},
				{Lo: 1392, Hi: 1400, Stride: 8},
				{Lo: 1404, Hi: 1405, Stride: 1},
				{Lo: 1409, Hi: 1412, Stride: 3},
				{Lo: 1413, Hi: 1417, Stride: 4},
				{Lo: 1472, Hi: 1475, Stride: 3},
				{Lo: 1493, Hi: 1496, Stride: 3},
				{Lo: 1497, Hi: 1503, Stride: 6},
				{Lo: 1505, Hi: 1523, Stride: 18},
				{Lo: 1549, Hi: 1575, Stride: 26},
				{Lo: 1607, Hi: 1632, Stride: 25},
				{Lo: 1633, Hi: 1637, Stride: 4},
				{Lo: 1639, Hi: 1643, Stride: 4},
				{Lo: 1645, Hi: 1726, Stride: 81},
				{Lo: 1729, Hi: 1748, Stride: 19},
				{Lo: 1749, Hi: 1776, Stride: 27},
				{Lo: 1777, Hi: 1781, Stride: 4},
				{Lo: 1783, Hi: 1793, Stride: 10},
				{Lo: 1794, Hi: 1796, Stride: 1},
				{Lo: 1984, Hi: 1994, Stride: 10},
				{Lo: 2036, Hi: 2037, Stride: 1},
				{Lo: 2042, Hi: 2307, Stride: 265},
				{Lo: 2406, Hi: 2429, Stride: 23},
				{Lo: 2534, Hi: 2538, Stride: 4},
				{Lo: 2541, Hi: 2662, Stride: 121},
				{Lo: 2663, Hi: 2666, Stride: 3},
				{Lo: 2691, Hi: 2790, Stride: 99},
				{Lo: 2819, Hi: 2848, Stride: 29},
				{Lo: 2918, Hi: 2920, Stride: 2},
				{Lo: 3046, Hi: 3074, Stride: 28},
				{Lo: 3174, Hi: 3202, Stride: 28},
				{Lo: 3302, Hi: 3330, Stride: 28},
				{Lo: 3360, Hi: 3430, Stride: 70},
				{Lo: 3437, Hi: 3458, Stride: 21},
				{Lo: 3664, Hi: 3792, Stride: 128},
				{Lo: 4125, Hi: 4160, Stride: 35},
				{Lo: 4327, Hi: 4351, Stride: 24},
				{Lo: 4608, Hi: 5024, Stride: 208},
				{Lo: 5025, Hi: 5026, Stride: 1},
				{Lo: 5029, Hi: 5033, Stride: 4},
				{Lo: 5034, Hi: 5036, Stride: 1},
				{Lo: 5038, Hi: 5043, Stride: 5},
				{Lo: 5047, Hi: 5051, Stride: 4},
				{Lo: 5053, Hi: 5056, Stride: 3},
				{Lo: 5058, Hi: 5059, Stride: 1},
				{Lo: 5070, Hi: 5071, Stride: 1},
				{Lo: 5074, Hi: 5076, Stride: 2},
				{Lo: 5077, Hi: 5081, Stride: 4},
				{Lo: 5082, Hi: 5086, Stride: 4},
				{Lo: 5087, Hi: 5090, Stride: 3},
				{Lo: 5094, Hi: 5095, Stride: 1},
				{Lo: 5102, Hi: 5107, Stride: 5},
				{Lo: 5108, Hi: 5120, Stride: 12},
				{Lo: 5167, Hi: 5171, Stride: 4},
				{Lo: 5176, Hi: 5194, Stride: 18},
				{Lo: 5196, Hi: 5229, Stride: 33},
				{Lo: 5231, Hi: 5234, Stride: 3},
				{Lo: 5261, Hi: 5290, Stride: 29},
				{Lo: 5311, Hi: 5441, Stride: 130},
				{Lo: 5500, Hi: 5501, Stride: 1},
				{Lo: 5511, Hi: 5551, Stride: 40},
				{Lo: 5556, Hi: 5573, Stride: 17},
				{Lo: 5598, Hi: 5610, Stride: 12},
				{Lo: 5616, Hi: 5623, Stride: 7},
				{Lo: 5741, Hi: 5742, Stride: 1},
				{Lo: 5760, Hi: 5810, Stride: 50},
				{Lo: 5815, Hi: 5825, Stride: 10},
				{Lo: 5836, Hi: 5845, Stride: 9},
				{Lo: 5846, Hi: 5868, Stride: 22},
				{Lo: 5869, Hi: 5941, Stride: 72},
				{Lo: 6147, Hi: 6153, Stride: 6},
				{Lo: 7428, Hi: 7439, Stride: 11},
				{Lo: 7441, Hi: 7452, Stride: 11},
				{Lo: 7456, Hi: 7458, Stride: 1},
				{Lo: 7462, Hi: 7555, Stride: 93},
				{Lo: 7564, Hi: 7837, Stride: 273},
				{Lo: 7935, Hi: 8125, Stride: 190},
				{Lo: 8126, Hi: 8128, Stride: 1},
				{Lo: 8175, Hi: 8189, Stride: 14},
				{Lo: 8190, Hi: 8192, Stride: 2},
				{Lo: 8193, Hi: 8202, Stride: 1},
				{Lo: 8208, Hi: 8210, Stride: 1},
				{Lo: 8218, Hi: 8219, Stride: 1},
				{Lo: 8228, Hi: 8232, Stride: 4},
				{Lo: 8233, Hi: 8239, Stride: 6},
				{Lo: 8242, Hi: 8249, Stride: 7},
				{Lo: 8250, Hi: 8257, Stride: 7},
				{Lo: 8259, Hi: 8260, Stride: 1},
				{Lo: 8270, Hi: 8275, Stride: 5},
				{Lo: 8282, Hi: 8287, Stride: 5},
				{Lo: 8450, Hi: 8458, Stride: 8},
				{Lo: 8459, Hi: 8462, Stride: 1},
				{Lo: 8464, Hi: 8467, Stride: 1},
				{Lo: 8469, Hi: 8473, Stride: 4},
				{Lo: 8474, Hi: 8477, Stride: 1},
				{Lo: 8484, Hi: 8488, Stride: 4},
				{Lo: 8490, Hi: 8492, Stride: 2},
				{Lo: 8493, Hi: 8497, Stride: 1},
				{Lo: 8499, Hi: 8500, Stride: 1},
				{Lo: 8505, Hi: 8509, Stride: 4},
				{Lo: 8517, Hi: 8521, Stride: 1},
				{Lo: 8544, Hi: 8548, Stride: 4},
				{Lo: 8553, Hi: 8556, Stride: 3},
				{Lo: 8557, Hi: 8560, Stride: 1},
				{Lo: 8564, Hi: 8569, Stride: 5},
				{Lo: 8572, Hi: 8574, Stride: 1},
				{Lo: 8722, Hi: 8725, Stride: 3},
				{Lo: 8726, Hi: 8727, Stride: 1},
				{Lo: 8739, Hi: 8744, Stride: 5},
				{Lo: 8746, Hi: 8758, Stride: 12},
				{Lo: 8764, Hi: 8868, Stride: 104},
				{Lo: 8897, Hi: 8899, Stride: 2},
				{Lo: 8959, Hi: 9075, Stride: 116},
				{Lo: 9076, Hi: 9082, Stride: 6},
				{Lo: 9213, Hi: 9585, Stride: 372},
				{Lo: 9587, Hi: 10088, Stride: 501},
				{Lo: 10089, Hi: 10094, Stride: 5},
				{Lo: 10095, Hi: 10098, Stride: 3},
				{Lo: 10099, Hi: 10101, Stride: 1},
				{Lo: 10133, Hi: 10134, Stride: 1},
				{Lo: 10187, Hi: 10189, Stride: 2},
				{Lo: 10201, Hi: 10539, Stride: 338},
				{Lo: 10540, Hi: 10741, Stride: 201},
				{Lo: 10744, Hi: 10745, Stride: 1},
				{Lo: 10799, Hi: 11397, Stride: 598},
				{Lo: 11406, Hi: 11410, Stride: 4},
				{Lo: 11412, Hi: 11416, Stride: 4},
				{Lo: 11418, Hi: 11422, Stride: 4},
				{Lo: 11423, Hi: 11426, Stride: 3},
				{Lo: 11427, Hi: 11430, Stride: 1},
				{Lo: 11432, Hi: 11436, Stride: 4},
				{Lo: 11450, Hi: 11462, Stride: 12},
				{Lo: 11466, Hi: 11468, Stride: 2},
				{Lo: 11472, Hi: 11474, Stride: 2},
				{Lo: 11576, Hi: 11577, Stride: 1},
				{Lo: 11599, Hi: 11601, Stride: 2},
				{Lo: 11604, Hi: 11605, Stride: 1},
				{Lo: 11613, Hi: 11840, Stride: 227},
				{Lo: 12034, Hi: 12035, Stride: 1},
				{Lo: 12295, Hi: 12308, Stride: 13},
				{Lo: 12309, Hi: 12339, Stride: 30},
				{Lo: 12448, Hi: 12755, Stride: 307},
				{Lo: 12756, Hi: 20022, Stride: 7266},
				{Lo: 20031, Hi: 42192, Stride: 22161},
				{Lo: 42193, Hi: 42196, Stride: 1},
				{Lo: 42198, Hi: 42199, Stride: 1},
				{Lo: 42201, Hi: 42202, Stride: 1},
				{Lo: 42204, Hi: 42205, Stride: 1},
				{Lo: 42207, Hi: 42211, Stride: 1},
				{Lo: 42214, Hi: 42215, Stride: 1},
				{Lo: 42218, Hi: 42220, Stride: 1},
				{Lo: 42222, Hi: 42226, Stride: 2},
				{Lo: 42227, Hi: 42228, Stride: 1},
				{Lo: 42232, Hi: 42233, Stride: 1},
				{Lo: 42237, Hi: 42239, Stride: 2},
				{Lo: 42510, Hi: 42564, Stride: 54},
				{Lo: 42567, Hi: 42719, Stride: 152},
				{Lo: 42731, Hi: 42735, Stride: 4},
				{Lo: 42801, Hi: 42842, Stride: 41},
				{Lo: 42858, Hi: 42862, Stride: 4},
				{Lo: 42872, Hi: 42889, Stride: 17},
				{Lo: 42892, Hi: 42904, Stride: 12},
				{Lo: 42905, Hi: 42911, Stride: 6},
				{Lo: 42923, Hi: 42930, Stride: 7},
				{Lo: 42931, Hi: 42932, Stride: 1},
				{Lo: 43826, Hi: 43829, Stride: 3},
				{Lo: 43837, Hi: 43847, Stride: 10},
				{Lo: 43848, Hi: 43854, Stride: 6},
				{Lo: 43858, Hi: 43866, Stride: 8},
				{Lo: 43893, Hi: 43905, Stride: 12},
				{Lo: 43907, Hi: 43923, Stride: 16},
				{Lo: 43945, Hi: 43946, Stride: 1},
				{Lo: 43951, Hi: 64422, Stride: 20471},
				{Lo: 64423, Hi: 64429, Stride: 1},
				{Lo: 64830, Hi: 64831, Stride: 1},
				{Lo: 65072, Hi: 65101, Stride: 29},
				{Lo: 65102, Hi: 65103, Stride: 1},
				{Lo: 65112, Hi: 65128, Stride: 16},
				{Lo: 65165, Hi: 65166, Stride: 1},
				{Lo: 65257, Hi: 65260, Stride: 1},
				{Lo: 65282, Hi: 65284, Stride: 2},
				{Lo: 65285, Hi: 65287, Stride: 1},
				{Lo: 65290, Hi: 65291, Stride: 1},
				{Lo: 65293, Hi: 65305, Stride: 1},
				{Lo: 65308, Hi: 65310, Stride: 1},
				{Lo: 65312, Hi: 65373, Stride: 1},
				{Lo: 65512, Hi: 65512, Stride: 1},
			},
			R32: []unicode.Range32{
				{Lo: 66178, Hi: 66182, Stride: 4},
				{Lo: 66183, Hi: 66186, Stride: 3},
				{Lo: 66192, Hi: 66194, Stride: 2},
				{Lo: 66197, Hi: 66199, Stride: 1},
				{Lo: 66203, Hi: 66208, Stride: 5},
				{Lo: 66209, Hi: 66210, Stride: 1},
				{Lo: 66213, Hi: 66219, Stride: 6},
				{Lo: 66224, Hi: 66226, Stride: 1},
				{Lo: 66228, Hi: 66255, Stride: 27},
				{Lo: 66293, Hi: 66305, Stride: 12},
				{Lo: 66306, Hi: 66313, Stride: 7},
				{Lo: 66321, Hi: 66325, Stride: 4},
				{Lo: 66327, Hi: 66330, Stride: 3},
				{Lo: 66335, Hi: 66336, Stride: 1},
				{Lo: 66338, Hi: 66564, Stride: 226},
				{Lo: 66581, Hi: 66587, Stride: 6},
				{Lo: 66592, Hi: 66604, Stride: 12},
				{Lo: 66621, Hi: 66632, Stride: 11},
				{Lo: 66740, Hi: 66754, Stride: 14},
				{Lo: 66766, Hi: 66770, Stride: 4},
				{Lo: 66794, Hi: 66806, Stride: 12},
				{Lo: 66835, Hi: 66838, Stride: 3},
				{Lo: 66840, Hi: 66844, Stride: 4},
				{Lo: 66845, Hi: 66853, Stride: 8},
				{Lo: 66854, Hi: 66855, Stride: 1},
				{Lo: 68176, Hi: 70864, Stride: 2688},
				{Lo: 71430, Hi: 71438, Stride: 4},
				{Lo: 71439, Hi: 71840, Stride: 401},
				{Lo: 71842, Hi: 71844, Stride: 1},
				{Lo: 71846, Hi: 71852, Stride: 3},
				{Lo: 71854, Hi: 71855, Stride: 1},
				{Lo: 71858, Hi: 71867, Stride: 3},
				{Lo: 71868, Hi: 71872, Stride: 4},
				{Lo: 71873, Hi: 71876, Stride: 1},
				{Lo: 71878, Hi: 71884, Stride: 2},
				{Lo: 71893, Hi: 71896, Stride: 1},
				{Lo: 71900, Hi: 71904, Stride: 4},
				{Lo: 71909, Hi: 71910, Stride: 1},
				{Lo: 71913, Hi: 71922, Stride: 3},
				{Lo: 93960, Hi: 93962, Stride: 2},
				{Lo: 93974, Hi: 93992, Stride: 18},
				{Lo: 94005, Hi: 94010, Stride: 5},
				{Lo: 94011, Hi: 94015, Stride: 4},
				{Lo: 94016, Hi: 94018, Stride: 2},
				{Lo: 94019, Hi: 94033, Stride: 14},
				{Lo: 94034, Hi: 119060, Stride: 25026},
				{Lo: 119149, Hi: 119302, Stride: 153},
				{Lo: 119309, Hi: 119311, Stride: 2},
				{Lo: 119314, Hi: 119315, Stride: 1},
				{Lo: 119318, Hi: 119338, Stride: 20},
				{Lo: 119350, Hi: 119351, Stride: 1},
				{Lo: 119354, Hi: 119355, Stride: 1},
				{Lo: 119808, Hi: 119845, Stride: 1},
				{Lo: 119847, Hi: 119892, Stride: 1},
				{Lo: 119894, Hi: 119897, Stride: 1},
				{Lo: 119899, Hi: 119949, Stride: 1},
				{Lo: 119951, Hi: 119964, Stride: 1},
				{Lo: 119966, Hi: 119967, Stride: 1},
				{Lo: 119970, Hi: 119973, Stride: 3},
				{Lo: 119974, Hi: 119977, Stride: 3},
				{Lo: 119978, Hi: 119980, Stride: 1},
				{Lo: 119982, Hi: 119993, Stride: 1},
				{Lo: 119995, Hi: 119997, Stride: 2},
				{Lo: 119998, Hi: 120001, Stride: 1},
				{Lo: 120003, Hi: 120005, Stride: 2},
				{Lo: 120006, Hi: 120053, Stride: 1},
				{Lo: 120055, Hi: 120069, Stride: 1},
				{Lo: 120071, Hi: 120074, Stride: 1},
				{Lo: 120077, Hi: 120084, Stride: 1},
				{Lo: 120086, Hi: 120092, Stride: 1},
				{Lo: 120094, Hi: 120105, Stride: 1},
				{Lo: 120107, Hi: 120121, Stride: 1},
				{Lo: 120123, Hi: 120126, Stride: 1},
				{Lo: 120128, Hi: 120132, Stride: 1},
				{Lo: 120134, Hi: 120138, Stride: 4},
				{Lo: 120139, Hi: 120144, Stride: 1},
				{Lo: 120146, Hi: 120157, Stride: 1},
				{Lo: 120159, Hi: 120209, Stride: 1},
				{Lo: 120211, Hi: 120261, Stride: 1},
				{Lo: 120263, Hi: 120313, Stride: 1},
				{Lo: 120315, Hi: 120365, Stride: 1},
				{Lo: 120367, Hi: 120417, Stride: 1},
				{Lo: 120419, Hi: 120469, Stride: 1},
				{Lo: 120471, Hi: 120484, Stride: 1},
				{Lo: 120488, Hi: 120489, Stride: 1},
				{Lo: 120492, Hi: 120494, Stride: 1},
				{Lo: 120496, Hi: 120497, Stride: 1},
				{Lo: 120499, Hi: 120500, Stride: 1},
				{Lo: 120502, Hi: 120504, Stride: 2},
				{Lo: 120507, Hi: 120508, Stride: 1},
				{Lo: 120510, Hi: 120514, Stride: 4},
				{Lo: 120516, Hi: 120522, Stride: 6},
				{Lo: 120526, Hi: 120534, Stride: 2},
				{Lo: 120544, Hi: 120546, Stride: 2},
				{Lo: 120547, Hi: 120550, Stride: 3},
				{Lo: 120551, Hi: 120552, Stride: 1},
				{Lo: 120554, Hi: 120555, Stride: 1},
				{Lo: 120557, Hi: 120558, Stride: 1},
				{Lo: 120560, Hi: 120562, Stride: 2},
				{Lo: 120565, Hi: 120566, Stride: 1},
				{Lo: 120568, Hi: 120572, Stride: 4},
				{Lo: 120574, Hi: 120580, Stride: 6},
				{Lo: 120584, Hi: 120592, Stride: 2},
				{Lo: 120602, Hi: 120604, Stride: 2},
				{Lo: 120605, Hi: 120608, Stride: 3},
				{Lo: 120609, Hi: 120610, Stride: 1},
				{Lo: 120612, Hi: 120613, Stride: 1},
				{Lo: 120615, Hi: 120616, Stride: 1},
				{Lo: 120618, Hi: 120620, Stride: 2},
				{Lo: 120623, Hi: 120624, Stride: 1},
				{Lo: 120626, Hi: 120630, Stride: 4},
				{Lo: 120632, Hi: 120638, Stride: 6},
				{Lo: 120642, Hi: 120650, Stride: 2},
				{Lo: 120660, Hi: 120662, Stride: 2},
				{Lo: 120663, Hi: 120666, Stride: 3},
				{Lo: 120667, Hi: 120668, Stride: 1},
				{Lo: 120670, Hi: 120671, Stride: 1},
				{Lo: 120673, Hi: 120674, Stride: 1},
				{Lo: 120676, Hi: 120678, Stride: 2},
				{Lo: 120681, Hi: 120682, Stride: 1},
				{Lo: 120684, Hi: 120688, Stride: 4},
				{Lo: 120690, Hi: 120696, Stride: 6},
				{Lo: 120700, Hi: 120708, Stride: 2},
				{Lo: 120718, Hi: 120720, Stride: 2},
				{Lo: 120721, Hi: 120724, Stride: 3},
				{Lo: 120725, Hi: 120726, Stride: 1},
				{Lo: 120728, Hi: 120729, Stride: 1},
				{Lo: 120731, Hi: 120732, Stride: 1},
				{Lo: 120734, Hi: 120736, Stride: 2},
				{Lo: 120739, Hi: 120740, Stride: 1},
				{Lo: 120742, Hi: 120746, Stride: 4},
				{Lo: 120748, Hi: 120754, Stride: 6},
				{Lo: 120758, Hi: 120766, Stride: 2},
				{Lo: 120776, Hi: 120778, Stride: 2},
				{Lo: 120782, Hi: 120831, Stride: 1},
				{Lo: 125127, Hi: 125131, Stride: 4},
				{Lo: 126464, Hi: 126500, Stride: 36},
				{Lo: 126564, Hi: 126592, Stride: 28},
				{Lo: 126596, Hi: 128844, Stride: 2248},
				{Lo: 128872, Hi: 130032, Stride: 1160},
				{Lo: 130033, Hi: 130041, Stride: 1},
			},
			LatinOffset: 0,
		},
	},
	"_default": {
		Confusable: []rune{160, 180, 215, 305, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8211, 8216, 8217, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{32, 96, 120, 105, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 45, 96, 96, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "_default",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 160, Hi: 180, Stride: 20},
				{Lo: 215, Hi: 305, Stride: 90},
				{Lo: 921, Hi: 1009, Stride: 88},
				{Lo: 1040, Hi: 1042, Stride: 2},
				{Lo: 1045, Hi: 1047, Stride: 2},
				{Lo: 1050, Hi: 1052, Stride: 2},
				{Lo: 1053, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8211, Hi: 8216, Stride: 5},
				{Lo: 8217, Hi: 8245, Stride: 28},
				{Lo: 12494, Hi: 65281, Stride: 52787},
				{Lo: 65283, Hi: 65288, Stride: 5},
				{Lo: 65289, Hi: 65292, Stride: 3},
				{Lo: 65306, Hi: 65307, Stride: 1},
				{Lo: 65311, Hi: 65374, Stride: 63},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
	"cs": {
		Confusable: []rune{180, 305, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8216, 8217, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{96, 105, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 96, 96, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "cs",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 180, Hi: 305, Stride: 125},
				{Lo: 921, Hi: 1009, Stride: 88},
				{Lo: 1040, Hi: 1042, Stride: 2},
				{Lo: 1045, Hi: 1047, Stride: 2},
				{Lo: 1050, Hi: 1052, Stride: 2},
				{Lo: 1053, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8216, Hi: 8217, Stride: 1},
				{Lo: 8245, Hi: 12494, Stride: 4249},
				{Lo: 65281, Hi: 65283, Stride: 2},
				{Lo: 65288, Hi: 65289, Stride: 1},
				{Lo: 65292, Hi: 65306, Stride: 14},
				{Lo: 65307, Hi: 65311, Stride: 4},
				{Lo: 65374, Hi: 65374, Stride: 1},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 0,
		},
	},
	"de": {
		Confusable: []rune{180, 305, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8216, 8217, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{96, 105, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 96, 96, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "de",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 180, Hi: 305, Stride: 125},
				{Lo: 921, Hi: 1009, Stride: 88},
				{Lo: 1040, Hi: 1042, Stride: 2},
				{Lo: 1045, Hi: 1047, Stride: 2},
				{Lo: 1050, Hi: 1052, Stride: 2},
				{Lo: 1053, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8216, Hi: 8217, Stride: 1},
				{Lo: 8245, Hi: 12494, Stride: 4249},
				{Lo: 65281, Hi: 65283, Stride: 2},
				{Lo: 65288, Hi: 65289, Stride: 1},
				{Lo: 65292, Hi: 65306, Stride: 14},
				{Lo: 65307, Hi: 65311, Stride: 4},
				{Lo: 65374, Hi: 65374, Stride: 1},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 0,
		},
	},
	"es": {
		Confusable: []rune{180, 215, 305, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8211, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{96, 120, 105, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 45, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "es",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 180, Hi: 215, Stride: 35},
				{Lo: 305, Hi: 1009, Stride: 704},
				{Lo: 1040, Hi: 1042, Stride: 2},
				{Lo: 1045, Hi: 1047, Stride: 2},
				{Lo: 1050, Hi: 1052, Stride: 2},
				{Lo: 1053, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8211, Hi: 8245, Stride: 34},
				{Lo: 12494, Hi: 65281, Stride: 52787},
				{Lo: 65283, Hi: 65288, Stride: 5},
				{Lo: 65289, Hi: 65292, Stride: 3},
				{Lo: 65306, Hi: 65307, Stride: 1},
				{Lo: 65311, Hi: 65374, Stride: 63},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
	"fr": {
		Confusable: []rune{215, 305, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8216, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{120, 105, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 96, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "fr",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 215, Hi: 305, Stride: 90},
				{Lo: 921, Hi: 1009, Stride: 88},
				{Lo: 1040, Hi: 1042, Stride: 2},
				{Lo: 1045, Hi: 1047, Stride: 2},
				{Lo: 1050, Hi: 1052, Stride: 2},
				{Lo: 1053, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8216, Hi: 8245, Stride: 29},
				{Lo: 12494, Hi: 65281, Stride: 52787},
				{Lo: 65283, Hi: 65288, Stride: 5},
				{Lo: 65289, Hi: 65292, Stride: 3},
				{Lo: 65306, Hi: 65307, Stride: 1},
				{Lo: 65311, Hi: 65374, Stride: 63},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 0,
		},
	},
	"it": {
		Confusable: []rune{160, 180, 215, 305, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8211, 8216, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{32, 96, 120, 105, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 45, 96, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "it",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 160, Hi: 180, Stride: 20},
				{Lo: 215, Hi: 305, Stride: 90},
				{Lo: 921, Hi: 1009, Stride: 88},
				{Lo: 1040, Hi: 1042, Stride: 2},
				{Lo: 1045, Hi: 1047, Stride: 2},
				{Lo: 1050, Hi: 1052, Stride: 2},
				{Lo: 1053, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8211, Hi: 8216, Stride: 5},
				{Lo: 8245, Hi: 12494, Stride: 4249},
				{Lo: 65281, Hi: 65283, Stride: 2},
				{Lo: 65288, Hi: 65289, Stride: 1},
				{Lo: 65292, Hi: 65306, Stride: 14},
				{Lo: 65307, Hi: 65311, Stride: 4},
				{Lo: 65374, Hi: 65374, Stride: 1},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
	"ja": {
		Confusable: []rune{180, 215, 305, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8211, 8216, 8217, 8245, 65281, 65283, 65292, 65306, 65307},
		With:       []rune{96, 120, 105, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 45, 96, 96, 96, 33, 35, 44, 58, 59},
		Locale:     "ja",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 180, Hi: 215, Stride: 35},
				{Lo: 305, Hi: 921, Stride: 616},
				{Lo: 1009, Hi: 1040, Stride: 31},
				{Lo: 1042, Hi: 1045, Stride: 3},
				{Lo: 1047, Hi: 1050, Stride: 3},
				{Lo: 1052, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8211, Hi: 8216, Stride: 5},
				{Lo: 8217, Hi: 8245, Stride: 28},
				{Lo: 65281, Hi: 65283, Stride: 2},
				{Lo: 65292, Hi: 65306, Stride: 14},
				{Lo: 65307, Hi: 65307, Stride: 1},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
	"ko": {
		Confusable: []rune{180, 215, 305, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8211, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{96, 120, 105, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 45, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "ko",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 180, Hi: 215, Stride: 35},
				{Lo: 305, Hi: 921, Stride: 616},
				{Lo: 1009, Hi: 1040, Stride: 31},
				{Lo: 1042, Hi: 1045, Stride: 3},
				{Lo: 1047, Hi: 1050, Stride: 3},
				{Lo: 1052, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8211, Hi: 8245, Stride: 34},
				{Lo: 12494, Hi: 65281, Stride: 52787},
				{Lo: 65283, Hi: 65288, Stride: 5},
				{Lo: 65289, Hi: 65292, Stride: 3},
				{Lo: 65306, Hi: 65307, Stride: 1},
				{Lo: 65311, Hi: 65374, Stride: 63},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
	"pl": {
		Confusable: []rune{180, 215, 305, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8216, 8217, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{96, 120, 105, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 96, 96, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "pl",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 180, Hi: 215, Stride: 35},
				{Lo: 305, Hi: 921, Stride: 616},
				{Lo: 1009, Hi: 1040, Stride: 31},
				{Lo: 1042, Hi: 1045, Stride: 3},
				{Lo: 1047, Hi: 1050, Stride: 3},
				{Lo: 1052, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8216, Hi: 8217, Stride: 1},
				{Lo: 8245, Hi: 12494, Stride: 4249},
				{Lo: 65281, Hi: 65283, Stride: 2},
				{Lo: 65288, Hi: 65289, Stride: 1},
				{Lo: 65292, Hi: 65306, Stride: 14},
				{Lo: 65307, Hi: 65311, Stride: 4},
				{Lo: 65374, Hi: 65374, Stride: 1},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
	"pt-BR": {
		Confusable: []rune{180, 215, 305, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8216, 8217, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{96, 120, 105, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 96, 96, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "pt-BR",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 180, Hi: 215, Stride: 35},
				{Lo: 305, Hi: 921, Stride: 616},
				{Lo: 1009, Hi: 1040, Stride: 31},
				{Lo: 1042, Hi: 1045, Stride: 3},
				{Lo: 1047, Hi: 1050, Stride: 3},
				{Lo: 1052, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8216, Hi: 8217, Stride: 1},
				{Lo: 8245, Hi: 12494, Stride: 4249},
				{Lo: 65281, Hi: 65283, Stride: 2},
				{Lo: 65288, Hi: 65289, Stride: 1},
				{Lo: 65292, Hi: 65306, Stride: 14},
				{Lo: 65307, Hi: 65311, Stride: 4},
				{Lo: 65374, Hi: 65374, Stride: 1},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
	"qps-ploc": {
		Confusable: []rune{160, 180, 215, 305, 921, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8211, 8216, 8217, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{32, 96, 120, 105, 73, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 45, 96, 96, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "qps-ploc",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 160, Hi: 180, Stride: 20},
				{Lo: 215, Hi: 305, Stride: 90},
				{Lo: 921, Hi: 1040, Stride: 119},
				{Lo: 1042, Hi: 1045, Stride: 3},
				{Lo: 1047, Hi: 1050, Stride: 3},
				{Lo: 1052, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8211, Hi: 8216, Stride: 5},
				{Lo: 8217, Hi: 8245, Stride: 28},
				{Lo: 12494, Hi: 65281, Stride: 52787},
				{Lo: 65283, Hi: 65288, Stride: 5},
				{Lo: 65289, Hi: 65292, Stride: 3},
				{Lo: 65306, Hi: 65307, Stride: 1},
				{Lo: 65311, Hi: 65374, Stride: 63},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
	"ru": {
		Confusable: []rune{180, 215, 305, 921, 1009, 8216, 8217, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{96, 120, 105, 73, 112, 96, 96, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "ru",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 180, Hi: 215, Stride: 35},
				{Lo: 305, Hi: 921, Stride: 616},
				{Lo: 1009, Hi: 8216, Stride: 7207},
				{Lo: 8217, Hi: 8245, Stride: 28},
				{Lo: 12494, Hi: 65281, Stride: 52787},
				{Lo: 65283, Hi: 65288, Stride: 5},
				{Lo: 65289, Hi: 65292, Stride: 3},
				{Lo: 65306, Hi: 65307, Stride: 1},
				{Lo: 65311, Hi: 65374, Stride: 63},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
	"tr": {
		Confusable: []rune{160, 180, 215, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8211, 8245, 12494, 65281, 65283, 65288, 65289, 65292, 65306, 65307, 65311, 65374},
		With:       []rune{32, 96, 120, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 45, 96, 47, 33, 35, 40, 41, 44, 58, 59, 63, 126},
		Locale:     "tr",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 160, Hi: 180, Stride: 20},
				{Lo: 215, Hi: 921, Stride: 706},
				{Lo: 1009, Hi: 1040, Stride: 31},
				{Lo: 1042, Hi: 1045, Stride: 3},
				{Lo: 1047, Hi: 1050, Stride: 3},
				{Lo: 1052, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8211, Hi: 8245, Stride: 34},
				{Lo: 12494, Hi: 65281, Stride: 52787},
				{Lo: 65283, Hi: 65288, Stride: 5},
				{Lo: 65289, Hi: 65292, Stride: 3},
				{Lo: 65306, Hi: 65307, Stride: 1},
				{Lo: 65311, Hi: 65374, Stride: 63},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
	"zh-hans": {
		Confusable: []rune{180, 215, 305, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8245, 12494, 65281, 65288, 65289, 65306, 65374},
		With:       []rune{96, 120, 105, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 96, 47, 33, 40, 41, 58, 126},
		Locale:     "zh-hans",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 180, Hi: 215, Stride: 35},
				{Lo: 305, Hi: 921, Stride: 616},
				{Lo: 1009, Hi: 1040, Stride: 31},
				{Lo: 1042, Hi: 1045, Stride: 3},
				{Lo: 1047, Hi: 1050, Stride: 3},
				{Lo: 1052, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8245, Hi: 12494, Stride: 4249},
				{Lo: 65281, Hi: 65288, Stride: 7},
				{Lo: 65289, Hi: 65306, Stride: 17},
				{Lo: 65374, Hi: 65374, Stride: 1},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
	"zh-hant": {
		Confusable: []rune{180, 215, 305, 921, 1009, 1040, 1042, 1045, 1047, 1050, 1052, 1053, 1054, 1056, 1057, 1058, 1059, 1061, 1068, 1072, 1073, 1075, 1077, 1086, 1088, 1089, 1091, 1093, 8211, 12494, 65283, 65307, 65374},
		With:       []rune{96, 120, 105, 73, 112, 65, 66, 69, 51, 75, 77, 72, 79, 80, 67, 84, 89, 88, 98, 97, 54, 114, 101, 111, 112, 99, 121, 120, 45, 47, 35, 59, 126},
		Locale:     "zh-hant",
		RangeTable: &unicode.RangeTable{
			R16: []unicode.Range16{
				{Lo: 180, Hi: 215, Stride: 35},
				{Lo: 305, Hi: 921, Stride: 616},
				{Lo: 1009, Hi: 1040, Stride: 31},
				{Lo: 1042, Hi: 1045, Stride: 3},
				{Lo: 1047, Hi: 1050, Stride: 3},
				{Lo: 1052, Hi: 1054, Stride: 1},
				{Lo: 1056, Hi: 1059, Stride: 1},
				{Lo: 1061, Hi: 1068, Stride: 7},
				{Lo: 1072, Hi: 1073, Stride: 1},
				{Lo: 1075, Hi: 1077, Stride: 2},
				{Lo: 1086, Hi: 1088, Stride: 2},
				{Lo: 1089, Hi: 1093, Stride: 2},
				{Lo: 8211, Hi: 12494, Stride: 4283},
				{Lo: 65283, Hi: 65307, Stride: 24},
				{Lo: 65374, Hi: 65374, Stride: 1},
			},
			R32:         []unicode.Range32{},
			LatinOffset: 1,
		},
	},
}
