// Code generated by github.com/go-enry/go-enry/v2/internal/code-generator DO NOT EDIT.
// Extracted from github/linguist commit: 5fad8d57605a914026a65b0e3ff6815d739944de

package data

// LanguageInfo exposes the data for a language's Linguist YAML entry as a Go struct.
// See https://github.com/github/linguist/blob/master/lib/linguist/languages.yml
type LanguageInfo struct {
	// Name is the language name. May contain symbols not safe for use in some filesystems (e.g., `F*`).
	Name string
	// FSName is the filesystem safe name. Will only be set if Name is not safe for use in all filesystems.
	FSName string
	// Type is the language Type. See data.Type for values.
	Type Type
	// Color is the CSS hex color to represent the language. Only used if type is "programming" or "markup".
	Color string
	// Group is the name of the parent language. Languages in a group are counted in the statistics as the parent language.
	Group string
	// Aliases is a slice of additional aliases (implicitly includes name.downcase)
	Aliases []string
	// Extensions is a slice of associated extensions (the first one is considered the primary extension).
	Extensions []string
	// A slice of associated interpreters
	Interpreters []string
	// Filenames is a slice of filenames commonly associated with the language.
	Filenames []string
	// MimeType (maps to codemirror_mime_type in linguist.yaml) is the string name of the file mime type used for highlighting whenever a file is edited.
	MimeType string
	// TMScope is the TextMate scope that represents this programming language.
	TMScope string
	// AceMode is the name of the Ace Mode used for highlighting whenever a file is edited.
	AceMode string
	// CodeMirrorMode is the name of the CodeMirror Mode used for highlighting whenever a file is edited.
	CodeMirrorMode string
	// Wrap is a boolean flag to enable line wrapping in an editor.
	Wrap bool
	// LanguageID is the Linguist-assigned numeric ID for the language.
	LanguageID int
}

// LanguageInfoByID allows accessing LanguageInfo by a language's ID.
var LanguageInfoByID = map[int]LanguageInfo{
	0: LanguageInfo{
		Name:    "1C Enterprise",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#814CCC",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bsl",
			".os",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.bsl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     0,
	},
	387204628: LanguageInfo{
		Name:    "2-Dimensional Array",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#38761D",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".2da",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.2da",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     387204628,
	},
	577529595: LanguageInfo{
		Name:    "4D",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#004289",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".4dm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.4dm",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     577529595,
	},
	1: LanguageInfo{
		Name:    "ABAP",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#E8274B",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".abap",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.abap",
		AceMode:        "abap",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     1,
	},
	452681853: LanguageInfo{
		Name:    "ABAP CDS",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#555e25",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".asddls",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.abapcds",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     452681853,
	},
	429: LanguageInfo{
		Name:    "ABNF",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".abnf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.abnf",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     429,
	},
	2: LanguageInfo{
		Name:   "AGS Script",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#B9D9FF",
		Group:  "",
		Aliases: []string{
			"ags",
		},
		Extensions: []string{
			".asc",
			".ash",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-c++src",
		TMScope:        "source.c++",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     2,
	},
	451700185: LanguageInfo{
		Name:    "AIDL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#34EB6B",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".aidl",
		},
		Interpreters: []string{
			"aidl",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.aidl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     451700185,
	},
	658971832: LanguageInfo{
		Name:    "AL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3AA2B5",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".al",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.al",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     658971832,
	},
	3: LanguageInfo{
		Name:    "AMPL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#E6EFBB",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ampl",
			".mod",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ampl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     3,
	},
	4: LanguageInfo{
		Name:    "ANTLR",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#9DC3FF",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".g4",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.antlr",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     4,
	},
	5: LanguageInfo{
		Name:    "API Blueprint",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#2ACCA8",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".apib",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.markdown.source.gfm.apib",
		AceMode:        "markdown",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     5,
	},
	6: LanguageInfo{
		Name:    "APL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#5A8164",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".apl",
			".dyalog",
		},
		Interpreters: []string{
			"apl",
			"aplx",
			"dyalog",
		},
		Filenames:      []string{},
		MimeType:       "text/apl",
		TMScope:        "source.apl",
		AceMode:        "text",
		CodeMirrorMode: "apl",
		Wrap:           false,
		LanguageID:     6,
	},
	124996147: LanguageInfo{
		Name:    "ASL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".asl",
			".dsl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.asl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     124996147,
	},
	7: LanguageInfo{
		Name:    "ASN.1",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".asn",
			".asn1",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-ttcn-asn",
		TMScope:        "source.asn",
		AceMode:        "text",
		CodeMirrorMode: "asn.1",
		Wrap:           false,
		LanguageID:     7,
	},
	564186416: LanguageInfo{
		Name:   "ASP.NET",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#9400ff",
		Group:  "",
		Aliases: []string{
			"aspx",
			"aspx-vb",
		},
		Extensions: []string{
			".asax",
			".ascx",
			".ashx",
			".asmx",
			".aspx",
			".axd",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/x-aspx",
		TMScope:        "text.html.asp",
		AceMode:        "text",
		CodeMirrorMode: "htmlembedded",
		Wrap:           false,
		LanguageID:     564186416,
	},
	9: LanguageInfo{
		Name:   "ATS",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#1ac620",
		Group:  "",
		Aliases: []string{
			"ats2",
		},
		Extensions: []string{
			".dats",
			".hats",
			".sats",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ats",
		AceMode:        "ocaml",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     9,
	},
	10: LanguageInfo{
		Name:   "ActionScript",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#882B0F",
		Group:  "",
		Aliases: []string{
			"actionscript 3",
			"actionscript3",
			"as3",
		},
		Extensions: []string{
			".as",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.actionscript.3",
		AceMode:        "actionscript",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     10,
	},
	11: LanguageInfo{
		Name:   "Ada",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#02f88c",
		Group:  "",
		Aliases: []string{
			"ada95",
			"ada2005",
		},
		Extensions: []string{
			".adb",
			".ada",
			".ads",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ada",
		AceMode:        "ada",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     11,
	},
	884614762: LanguageInfo{
		Name:   "Adblock Filter List",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#800000",
		Group:  "",
		Aliases: []string{
			"ad block filters",
			"ad block",
			"adb",
			"adblock",
		},
		Extensions: []string{
			".txt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.adblock",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     884614762,
	},
	147198098: LanguageInfo{
		Name:   "Adobe Font Metrics",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#fa0f00",
		Group:  "",
		Aliases: []string{
			"acfm",
			"adobe composite font metrics",
			"adobe multiple font metrics",
			"amfm",
		},
		Extensions: []string{
			".afm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.afm",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     147198098,
	},
	12: LanguageInfo{
		Name:    "Agda",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#315665",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".agda",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.agda",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     12,
	},
	13: LanguageInfo{
		Name:    "Alloy",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#64C800",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".als",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.alloy",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     13,
	},
	14: LanguageInfo{
		Name:   "Alpine Abuild",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#0D597F",
		Group:  "Shell",
		Aliases: []string{
			"abuild",
			"apkbuild",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"APKBUILD",
		},
		MimeType:       "text/x-sh",
		TMScope:        "source.shell",
		AceMode:        "sh",
		CodeMirrorMode: "shell",
		Wrap:           false,
		LanguageID:     14,
	},
	187772328: LanguageInfo{
		Name:   "Altium Designer",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#A89663",
		Group:  "",
		Aliases: []string{
			"altium",
		},
		Extensions: []string{
			".OutJob",
			".PcbDoc",
			".PrjPCB",
			".SchDoc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ini",
		AceMode:        "ini",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     187772328,
	},
	389477596: LanguageInfo{
		Name:    "AngelScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#C7D7DC",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".as",
			".angelscript",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-c++src",
		TMScope:        "source.angelscript",
		AceMode:        "text",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     389477596,
	},
	15: LanguageInfo{
		Name:         "Ant Build System",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "#A9157E",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"ant.xml",
			"build.xml",
		},
		MimeType:       "application/xml",
		TMScope:        "text.xml.ant",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     15,
	},
	1067292663: LanguageInfo{
		Name:    "Antlers",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#ff269e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".antlers.html",
			".antlers.php",
			".antlers.xml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.statamic",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     1067292663,
	},
	16: LanguageInfo{
		Name:   "ApacheConf",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#d12127",
		Group:  "",
		Aliases: []string{
			"aconf",
			"apache",
		},
		Extensions: []string{
			".apacheconf",
			".vhost",
		},
		Interpreters: []string{},
		Filenames: []string{
			".htaccess",
			"apache2.conf",
			"httpd.conf",
		},
		MimeType:       "",
		TMScope:        "source.apache-config",
		AceMode:        "apache_conf",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     16,
	},
	17: LanguageInfo{
		Name:    "Apex",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#1797c0",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cls",
			".trigger",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-java",
		TMScope:        "source.apex",
		AceMode:        "java",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     17,
	},
	18: LanguageInfo{
		Name:    "Apollo Guidance Computer",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0B3D91",
		Group:   "Assembly",
		Aliases: []string{},
		Extensions: []string{
			".agc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.agc",
		AceMode:        "assembly_x86",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     18,
	},
	19: LanguageInfo{
		Name:   "AppleScript",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#101F1F",
		Group:  "",
		Aliases: []string{
			"osascript",
		},
		Extensions: []string{
			".applescript",
			".scpt",
		},
		Interpreters: []string{
			"osascript",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.applescript",
		AceMode:        "applescript",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     19,
	},
	20: LanguageInfo{
		Name:    "Arc",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#aa2afe",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".arc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     20,
	},
	22: LanguageInfo{
		Name:    "AsciiDoc",
		FSName:  "",
		Type:    TypeForString("prose"),
		Color:   "#73a0c5",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".asciidoc",
			".adoc",
			".asc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.asciidoc",
		AceMode:        "asciidoc",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     22,
	},
	23: LanguageInfo{
		Name:    "AspectJ",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#a957b0",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".aj",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.aspectj",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     23,
	},
	24: LanguageInfo{
		Name:   "Assembly",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#6E4C13",
		Group:  "",
		Aliases: []string{
			"asm",
			"nasm",
		},
		Extensions: []string{
			".asm",
			".a51",
			".i",
			".inc",
			".nas",
			".nasm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.assembly",
		AceMode:        "assembly_x86",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     24,
	},
	578209015: LanguageInfo{
		Name:    "Astro",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#ff5a03",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".astro",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/jsx",
		TMScope:        "source.astro",
		AceMode:        "html",
		CodeMirrorMode: "jsx",
		Wrap:           false,
		LanguageID:     578209015,
	},
	591605007: LanguageInfo{
		Name:    "Asymptote",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ff0000",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".asy",
		},
		Interpreters: []string{
			"asy",
		},
		Filenames:      []string{},
		MimeType:       "text/x-kotlin",
		TMScope:        "source.c++",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     591605007,
	},
	25: LanguageInfo{
		Name:    "Augeas",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#9CC134",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".aug",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     25,
	},
	26: LanguageInfo{
		Name:   "AutoHotkey",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#6594b9",
		Group:  "",
		Aliases: []string{
			"ahk",
		},
		Extensions: []string{
			".ahk",
			".ahkl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ahk",
		AceMode:        "autohotkey",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     26,
	},
	27: LanguageInfo{
		Name:   "AutoIt",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#1C3552",
		Group:  "",
		Aliases: []string{
			"au3",
			"AutoIt3",
			"AutoItScript",
		},
		Extensions: []string{
			".au3",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.autoit",
		AceMode:        "autohotkey",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     27,
	},
	785497837: LanguageInfo{
		Name:    "Avro IDL",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#0040FF",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".avdl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.avro",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     785497837,
	},
	28: LanguageInfo{
		Name:    "Awk",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#c30e9b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".awk",
			".auk",
			".gawk",
			".mawk",
			".nawk",
		},
		Interpreters: []string{
			"awk",
			"gawk",
			"mawk",
			"nawk",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.awk",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     28,
	},
	96642275: LanguageInfo{
		Name:   "B4X",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#00e4ff",
		Group:  "",
		Aliases: []string{
			"basic for android",
		},
		Extensions: []string{
			".bas",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-vb",
		TMScope:        "source.vba",
		AceMode:        "text",
		CodeMirrorMode: "vb",
		Wrap:           false,
		LanguageID:     96642275,
	},
	28923963: LanguageInfo{
		Name:    "BASIC",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ff0000",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bas",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.basic",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     28923963,
	},
	330386870: LanguageInfo{
		Name:    "BQN",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#2b7067",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bqn",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.bqn",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     330386870,
	},
	720859680: LanguageInfo{
		Name:    "Ballerina",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#FF5000",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bal",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ballerina",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     720859680,
	},
	29: LanguageInfo{
		Name:   "Batchfile",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#C1F12E",
		Group:  "",
		Aliases: []string{
			"bat",
			"batch",
			"dosbatch",
			"winbatch",
		},
		Extensions: []string{
			".bat",
			".cmd",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.batchfile",
		AceMode:        "batchfile",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     29,
	},
	545626333: LanguageInfo{
		Name:    "Beef",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#a52f4e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csharp",
		TMScope:        "source.cs",
		AceMode:        "csharp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     545626333,
	},
	30: LanguageInfo{
		Name:    "Befunge",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".befunge",
			".bf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.befunge",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     30,
	},
	121855308: LanguageInfo{
		Name:   "Berry",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#15A13C",
		Group:  "",
		Aliases: []string{
			"be",
		},
		Extensions: []string{
			".be",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.berry",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     121855308,
	},
	982188347: LanguageInfo{
		Name:    "BibTeX",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#778899",
		Group:   "TeX",
		Aliases: []string{},
		Extensions: []string{
			".bib",
			".bibtex",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-stex",
		TMScope:        "text.bibtex",
		AceMode:        "tex",
		CodeMirrorMode: "stex",
		Wrap:           false,
		LanguageID:     982188347,
	},
	321200902: LanguageInfo{
		Name:    "Bicep",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#519aba",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bicep",
			".bicepparam",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.bicep",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     321200902,
	},
	1055528081: LanguageInfo{
		Name:    "Bikeshed",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#5562ac",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/html",
		TMScope:        "source.csswg",
		AceMode:        "html",
		CodeMirrorMode: "htmlmixed",
		Wrap:           false,
		LanguageID:     1055528081,
	},
	31: LanguageInfo{
		Name:    "Bison",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#6A463F",
		Group:   "Yacc",
		Aliases: []string{},
		Extensions: []string{
			".bison",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.yacc",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     31,
	},
	32: LanguageInfo{
		Name:    "BitBake",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00bce4",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bb",
			".bbappend",
			".bbclass",
			".inc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.bb",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     32,
	},
	33: LanguageInfo{
		Name:    "Blade",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#f7523f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".blade",
			".blade.php",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.php.blade",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     33,
	},
	34: LanguageInfo{
		Name:   "BlitzBasic",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#00FFAE",
		Group:  "",
		Aliases: []string{
			"b3d",
			"blitz3d",
			"blitzplus",
			"bplus",
		},
		Extensions: []string{
			".bb",
			".decls",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.blitzmax",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     34,
	},
	35: LanguageInfo{
		Name:   "BlitzMax",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#cd6400",
		Group:  "",
		Aliases: []string{
			"bmax",
		},
		Extensions: []string{
			".bmx",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.blitzmax",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     35,
	},
	36: LanguageInfo{
		Name:   "Bluespec",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#12223c",
		Group:  "",
		Aliases: []string{
			"bluespec bsv",
			"bsv",
		},
		Extensions: []string{
			".bsv",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-systemverilog",
		TMScope:        "source.bsv",
		AceMode:        "verilog",
		CodeMirrorMode: "verilog",
		Wrap:           false,
		LanguageID:     36,
	},
	641580358: LanguageInfo{
		Name:   "Bluespec BH",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#12223c",
		Group:  "Bluespec",
		Aliases: []string{
			"bh",
			"bluespec classic",
		},
		Extensions: []string{
			".bs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-haskell",
		TMScope:        "source.bh",
		AceMode:        "haskell",
		CodeMirrorMode: "haskell",
		Wrap:           false,
		LanguageID:     641580358,
	},
	37: LanguageInfo{
		Name:    "Boo",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#d4bec1",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".boo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.boo",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     37,
	},
	955017407: LanguageInfo{
		Name:    "Boogie",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#c80fa0",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bpl",
		},
		Interpreters: []string{
			"boogie",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.boogie",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     955017407,
	},
	38: LanguageInfo{
		Name:    "Brainfuck",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#2F2530",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".b",
			".bf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-brainfuck",
		TMScope:        "source.bf",
		AceMode:        "text",
		CodeMirrorMode: "brainfuck",
		Wrap:           false,
		LanguageID:     38,
	},
	943571030: LanguageInfo{
		Name:    "BrighterScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#66AABB",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.brs",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     943571030,
	},
	39: LanguageInfo{
		Name:    "Brightscript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#662D91",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".brs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.brs",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     39,
	},
	153503348: LanguageInfo{
		Name:         "Browserslist",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "#ffd539",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			".browserslistrc",
			"browserslist",
		},
		MimeType:       "",
		TMScope:        "text.browserslist",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     153503348,
	},
	41: LanguageInfo{
		Name:    "C",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#555555",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".c",
			".cats",
			".h",
			".idc",
		},
		Interpreters: []string{
			"tcc",
		},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.c",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     41,
	},
	42: LanguageInfo{
		Name:   "C#",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#178600",
		Group:  "",
		Aliases: []string{
			"csharp",
			"cake",
			"cakescript",
		},
		Extensions: []string{
			".cs",
			".cake",
			".cs.pp",
			".csx",
			".linq",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csharp",
		TMScope:        "source.cs",
		AceMode:        "csharp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     42,
	},
	43: LanguageInfo{
		Name:   "C++",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#f34b7d",
		Group:  "",
		Aliases: []string{
			"cpp",
		},
		Extensions: []string{
			".cpp",
			".c++",
			".cc",
			".cp",
			".cppm",
			".cxx",
			".h",
			".h++",
			".hh",
			".hpp",
			".hxx",
			".inc",
			".inl",
			".ino",
			".ipp",
			".ixx",
			".re",
			".tcc",
			".tpp",
			".txx",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-c++src",
		TMScope:        "source.c++",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     43,
	},
	44: LanguageInfo{
		Name:    "C-ObjDump",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".c-objdump",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "objdump.x86asm",
		AceMode:        "assembly_x86",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     44,
	},
	45: LanguageInfo{
		Name:   "C2hs Haskell",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "Haskell",
		Aliases: []string{
			"c2hs",
		},
		Extensions: []string{
			".chs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-haskell",
		TMScope:        "source.haskell",
		AceMode:        "haskell",
		CodeMirrorMode: "haskell",
		Wrap:           false,
		LanguageID:     45,
	},
	390788699: LanguageInfo{
		Name:   "CAP CDS",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#0092d1",
		Group:  "",
		Aliases: []string{
			"cds",
		},
		Extensions: []string{
			".cds",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.cds",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     390788699,
	},
	29176339: LanguageInfo{
		Name:    "CIL",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cil",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.cil",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     29176339,
	},
	46: LanguageInfo{
		Name:    "CLIPS",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00A300",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".clp",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.clips",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     46,
	},
	47: LanguageInfo{
		Name:    "CMake",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#DA3434",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cmake",
			".cmake.in",
		},
		Interpreters: []string{},
		Filenames: []string{
			"CMakeLists.txt",
		},
		MimeType:       "text/x-cmake",
		TMScope:        "source.cmake",
		AceMode:        "text",
		CodeMirrorMode: "cmake",
		Wrap:           false,
		LanguageID:     47,
	},
	48: LanguageInfo{
		Name:    "COBOL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cob",
			".cbl",
			".ccp",
			".cobol",
			".cpy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-cobol",
		TMScope:        "source.cobol",
		AceMode:        "cobol",
		CodeMirrorMode: "cobol",
		Wrap:           false,
		LanguageID:     48,
	},
	321684729: LanguageInfo{
		Name:         "CODEOWNERS",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"CODEOWNERS",
		},
		MimeType:       "",
		TMScope:        "text.codeowners",
		AceMode:        "gitignore",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     321684729,
	},
	49: LanguageInfo{
		Name:    "COLLADA",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#F1A42B",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dae",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/xml",
		TMScope:        "text.xml",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     49,
	},
	424: LanguageInfo{
		Name:    "CSON",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#244776",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cson",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-coffeescript",
		TMScope:        "source.coffee",
		AceMode:        "coffee",
		CodeMirrorMode: "coffeescript",
		Wrap:           false,
		LanguageID:     424,
	},
	50: LanguageInfo{
		Name:    "CSS",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#663399",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".css",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/css",
		TMScope:        "source.css",
		AceMode:        "css",
		CodeMirrorMode: "css",
		Wrap:           false,
		LanguageID:     50,
	},
	51: LanguageInfo{
		Name:    "CSV",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#237346",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".csv",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     51,
	},
	356063509: LanguageInfo{
		Name:    "CUE",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#5886E1",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cue",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.cue",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     356063509,
	},
	657332628: LanguageInfo{
		Name:    "CWeb",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00007a",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".w",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     657332628,
	},
	677095381: LanguageInfo{
		Name:   "Cabal Config",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#483465",
		Group:  "",
		Aliases: []string{
			"Cabal",
		},
		Extensions: []string{
			".cabal",
		},
		Interpreters: []string{},
		Filenames: []string{
			"cabal.config",
			"cabal.project",
		},
		MimeType:       "text/x-haskell",
		TMScope:        "source.cabal",
		AceMode:        "haskell",
		CodeMirrorMode: "haskell",
		Wrap:           false,
		LanguageID:     677095381,
	},
	615465151: LanguageInfo{
		Name:   "Caddyfile",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#22b638",
		Group:  "",
		Aliases: []string{
			"Caddy",
		},
		Extensions: []string{
			".caddyfile",
		},
		Interpreters: []string{},
		Filenames: []string{
			"Caddyfile",
		},
		MimeType:       "",
		TMScope:        "source.Caddyfile",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     615465151,
	},
	270184138: LanguageInfo{
		Name:    "Cadence",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00ef8b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cdc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.cadence",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     270184138,
	},
	620599567: LanguageInfo{
		Name:    "Cairo",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ff4a48",
		Group:   "Cairo",
		Aliases: []string{},
		Extensions: []string{
			".cairo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.cairo",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     620599567,
	},
	891399890: LanguageInfo{
		Name:    "Cairo Zero",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ff4a48",
		Group:   "Cairo",
		Aliases: []string{},
		Extensions: []string{
			".cairo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.cairo0",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     891399890,
	},
	829207807: LanguageInfo{
		Name:    "CameLIGO",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3be133",
		Group:   "LigoLANG",
		Aliases: []string{},
		Extensions: []string{
			".mligo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-ocaml",
		TMScope:        "source.mligo",
		AceMode:        "ocaml",
		CodeMirrorMode: "mllike",
		Wrap:           false,
		LanguageID:     829207807,
	},
	52: LanguageInfo{
		Name:    "Cap'n Proto",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#c42727",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".capnp",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.capnp",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     52,
	},
	55627273: LanguageInfo{
		Name:    "Carbon",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#222222",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".carbon",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-go",
		TMScope:        "source.v",
		AceMode:        "golang",
		CodeMirrorMode: "go",
		Wrap:           false,
		LanguageID:     55627273,
	},
	53: LanguageInfo{
		Name:   "CartoCSS",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"Carto",
		},
		Extensions: []string{
			".mss",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.css.mss",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     53,
	},
	54: LanguageInfo{
		Name:    "Ceylon",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#dfa535",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ceylon",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ceylon",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     54,
	},
	55: LanguageInfo{
		Name:   "Chapel",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#8dc63f",
		Group:  "",
		Aliases: []string{
			"chpl",
		},
		Extensions: []string{
			".chpl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.chapel",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     55,
	},
	56: LanguageInfo{
		Name:    "Charity",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ch",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     56,
	},
	372063053: LanguageInfo{
		Name:   "Checksums",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"checksum",
			"hash",
			"hashes",
			"sum",
			"sums",
		},
		Extensions: []string{
			".crc32",
			".md2",
			".md4",
			".md5",
			".sha1",
			".sha2",
			".sha224",
			".sha256",
			".sha256sum",
			".sha3",
			".sha384",
			".sha512",
		},
		Interpreters: []string{},
		Filenames: []string{
			"MD5SUMS",
			"SHA1SUMS",
			"SHA256SUMS",
			"SHA256SUMS.txt",
			"SHA512SUMS",
			"checksums.txt",
			"cksums",
			"md5sum.txt",
		},
		MimeType:       "",
		TMScope:        "text.checksums",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     372063053,
	},
	57: LanguageInfo{
		Name:    "ChucK",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3f8000",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ck",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-java",
		TMScope:        "source.java",
		AceMode:        "java",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     57,
	},
	1042332086: LanguageInfo{
		Name:    "Circom",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#707575",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".circom",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.circom",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     1042332086,
	},
	58: LanguageInfo{
		Name:    "Cirru",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ccccff",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cirru",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.cirru",
		AceMode:        "cirru",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     58,
	},
	59: LanguageInfo{
		Name:    "Clarion",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#db901e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".clw",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.clarion",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     59,
	},
	91493841: LanguageInfo{
		Name:    "Clarity",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#5546ff",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".clar",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.clar",
		AceMode:        "lisp",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     91493841,
	},
	8: LanguageInfo{
		Name:   "Classic ASP",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#6a40fd",
		Group:  "",
		Aliases: []string{
			"asp",
		},
		Extensions: []string{
			".asp",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.asp",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     8,
	},
	60: LanguageInfo{
		Name:    "Clean",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3F85AF",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".icl",
			".dcl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.clean",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     60,
	},
	61: LanguageInfo{
		Name:    "Click",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#E4E6F3",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".click",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.click",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     61,
	},
	62: LanguageInfo{
		Name:    "Clojure",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#db5855",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".clj",
			".bb",
			".boot",
			".cl2",
			".cljc",
			".cljs",
			".cljs.hl",
			".cljscm",
			".cljx",
			".hic",
		},
		Interpreters: []string{
			"bb",
		},
		Filenames: []string{
			"riemann.config",
		},
		MimeType:       "text/x-clojure",
		TMScope:        "source.clojure",
		AceMode:        "clojure",
		CodeMirrorMode: "clojure",
		Wrap:           false,
		LanguageID:     62,
	},
	357046146: LanguageInfo{
		Name:   "Closure Templates",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#0d948f",
		Group:  "",
		Aliases: []string{
			"soy",
		},
		Extensions: []string{
			".soy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-soy",
		TMScope:        "text.html.soy",
		AceMode:        "soy_template",
		CodeMirrorMode: "soy",
		Wrap:           false,
		LanguageID:     357046146,
	},
	407996372: LanguageInfo{
		Name:         "Cloud Firestore Security Rules",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "#FFA000",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"firestore.rules",
		},
		MimeType:       "text/css",
		TMScope:        "source.firestore",
		AceMode:        "less",
		CodeMirrorMode: "css",
		Wrap:           false,
		LanguageID:     407996372,
	},
	421026389: LanguageInfo{
		Name:   "CoNLL-U",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"CoNLL",
			"CoNLL-X",
		},
		Extensions: []string{
			".conllu",
			".conll",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.conllu",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     421026389,
	},
	424259634: LanguageInfo{
		Name:   "CodeQL",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#140f46",
		Group:  "",
		Aliases: []string{
			"ql",
		},
		Extensions: []string{
			".ql",
			".qll",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ql",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     424259634,
	},
	63: LanguageInfo{
		Name:   "CoffeeScript",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#244776",
		Group:  "",
		Aliases: []string{
			"coffee",
			"coffee-script",
		},
		Extensions: []string{
			".coffee",
			"._coffee",
			".cake",
			".cjsx",
			".iced",
		},
		Interpreters: []string{
			"coffee",
		},
		Filenames: []string{
			"Cakefile",
		},
		MimeType:       "text/x-coffeescript",
		TMScope:        "source.coffee",
		AceMode:        "coffee",
		CodeMirrorMode: "coffeescript",
		Wrap:           false,
		LanguageID:     63,
	},
	64: LanguageInfo{
		Name:   "ColdFusion",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#ed2cd6",
		Group:  "",
		Aliases: []string{
			"cfm",
			"cfml",
			"coldfusion html",
		},
		Extensions: []string{
			".cfm",
			".cfml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.cfm",
		AceMode:        "coldfusion",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     64,
	},
	65: LanguageInfo{
		Name:   "ColdFusion CFC",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#ed2cd6",
		Group:  "ColdFusion",
		Aliases: []string{
			"cfc",
		},
		Extensions: []string{
			".cfc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.cfscript",
		AceMode:        "coldfusion",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     65,
	},
	66: LanguageInfo{
		Name:   "Common Lisp",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#3fb68b",
		Group:  "",
		Aliases: []string{
			"lisp",
		},
		Extensions: []string{
			".lisp",
			".asd",
			".cl",
			".l",
			".lsp",
			".ny",
			".podsl",
			".sexp",
		},
		Interpreters: []string{
			"lisp",
			"sbcl",
			"ccl",
			"clisp",
			"ecl",
		},
		Filenames:      []string{},
		MimeType:       "text/x-common-lisp",
		TMScope:        "source.commonlisp",
		AceMode:        "lisp",
		CodeMirrorMode: "commonlisp",
		Wrap:           false,
		LanguageID:     66,
	},
	988547172: LanguageInfo{
		Name:   "Common Workflow Language",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#B5314C",
		Group:  "",
		Aliases: []string{
			"cwl",
		},
		Extensions: []string{
			".cwl",
		},
		Interpreters: []string{
			"cwl-runner",
		},
		Filenames:      []string{},
		MimeType:       "text/x-yaml",
		TMScope:        "source.cwl",
		AceMode:        "yaml",
		CodeMirrorMode: "yaml",
		Wrap:           false,
		LanguageID:     988547172,
	},
	67: LanguageInfo{
		Name:    "Component Pascal",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#B0CE4E",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cp",
			".cps",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-pascal",
		TMScope:        "source.pascal",
		AceMode:        "pascal",
		CodeMirrorMode: "pascal",
		Wrap:           false,
		LanguageID:     67,
	},
	68: LanguageInfo{
		Name:    "Cool",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.cool",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     68,
	},
	69: LanguageInfo{
		Name:    "Coq",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#d0b68c",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".coq",
			".v",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.coq",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     69,
	},
	70: LanguageInfo{
		Name:   "Cpp-ObjDump",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"c++-objdump",
		},
		Extensions: []string{
			".cppobjdump",
			".c++-objdump",
			".c++objdump",
			".cpp-objdump",
			".cxx-objdump",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "objdump.x86asm",
		AceMode:        "assembly_x86",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     70,
	},
	71: LanguageInfo{
		Name:    "Creole",
		FSName:  "",
		Type:    TypeForString("prose"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".creole",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.creole",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     71,
	},
	72: LanguageInfo{
		Name:    "Crystal",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#000100",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cr",
		},
		Interpreters: []string{
			"crystal",
		},
		Filenames:      []string{},
		MimeType:       "text/x-crystal",
		TMScope:        "source.crystal",
		AceMode:        "ruby",
		CodeMirrorMode: "crystal",
		Wrap:           false,
		LanguageID:     72,
	},
	73: LanguageInfo{
		Name:   "Csound",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#1a1a1a",
		Group:  "",
		Aliases: []string{
			"csound-orc",
		},
		Extensions: []string{
			".orc",
			".udo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.csound",
		AceMode:        "csound_orchestra",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     73,
	},
	74: LanguageInfo{
		Name:   "Csound Document",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#1a1a1a",
		Group:  "",
		Aliases: []string{
			"csound-csd",
		},
		Extensions: []string{
			".csd",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.csound-document",
		AceMode:        "csound_document",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     74,
	},
	75: LanguageInfo{
		Name:   "Csound Score",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#1a1a1a",
		Group:  "",
		Aliases: []string{
			"csound-sco",
		},
		Extensions: []string{
			".sco",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.csound-score",
		AceMode:        "csound_score",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     75,
	},
	77: LanguageInfo{
		Name:    "Cuda",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3A4E3A",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cu",
			".cuh",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-c++src",
		TMScope:        "source.cuda-c++",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     77,
	},
	942714150: LanguageInfo{
		Name:    "Cue Sheet",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cue",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.cuesheet",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     942714150,
	},
	439829048: LanguageInfo{
		Name:    "Curry",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#531242",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".curry",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.curry",
		AceMode:        "haskell",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     439829048,
	},
	78: LanguageInfo{
		Name:    "Cycript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/javascript",
		TMScope:        "source.js",
		AceMode:        "javascript",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     78,
	},
	476447814: LanguageInfo{
		Name:    "Cylc",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#00b3fd",
		Group:   "INI",
		Aliases: []string{},
		Extensions: []string{
			".cylc",
		},
		Interpreters: []string{},
		Filenames: []string{
			"suite.rc",
		},
		MimeType:       "",
		TMScope:        "source.cylc",
		AceMode:        "ini",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     476447814,
	},
	850806976: LanguageInfo{
		Name:    "Cypher",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#34c0eb",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cyp",
			".cypher",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.cypher",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     850806976,
	},
	79: LanguageInfo{
		Name:   "Cython",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#fedf5b",
		Group:  "",
		Aliases: []string{
			"pyrex",
		},
		Extensions: []string{
			".pyx",
			".pxd",
			".pxi",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-cython",
		TMScope:        "source.cython",
		AceMode:        "text",
		CodeMirrorMode: "python",
		Wrap:           false,
		LanguageID:     79,
	},
	80: LanguageInfo{
		Name:   "D",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#ba595e",
		Group:  "",
		Aliases: []string{
			"Dlang",
		},
		Extensions: []string{
			".d",
			".di",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-d",
		TMScope:        "source.d",
		AceMode:        "d",
		CodeMirrorMode: "d",
		Wrap:           false,
		LanguageID:     80,
	},
	81: LanguageInfo{
		Name:    "D-ObjDump",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".d-objdump",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "objdump.x86asm",
		AceMode:        "assembly_x86",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     81,
	},
	37531557: LanguageInfo{
		Name:   "D2",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#526ee8",
		Group:  "",
		Aliases: []string{
			"d2lang",
		},
		Extensions: []string{
			".d2",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.d2",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     37531557,
	},
	82: LanguageInfo{
		Name:   "DIGITAL Command Language",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"dcl",
		},
		Extensions: []string{
			".com",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     82,
	},
	83: LanguageInfo{
		Name:   "DM",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#447265",
		Group:  "",
		Aliases: []string{
			"byond",
		},
		Extensions: []string{
			".dm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.dm",
		AceMode:        "c_cpp",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     83,
	},
	84: LanguageInfo{
		Name:    "DNS Zone",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".zone",
			".arpa",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.zone_file",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     84,
	},
	85: LanguageInfo{
		Name:   "DTrace",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"dtrace-script",
		},
		Extensions: []string{
			".d",
		},
		Interpreters: []string{
			"dtrace",
		},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.c",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     85,
	},
	969323346: LanguageInfo{
		Name:    "Dafny",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#FFEC25",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dfy",
		},
		Interpreters: []string{
			"dafny",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.dfy.dafny",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     969323346,
	},
	86: LanguageInfo{
		Name:   "Darcs Patch",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#8eff23",
		Group:  "",
		Aliases: []string{
			"dpatch",
		},
		Extensions: []string{
			".darcspatch",
			".dpatch",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     86,
	},
	87: LanguageInfo{
		Name:    "Dart",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00B4AB",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dart",
		},
		Interpreters: []string{
			"dart",
		},
		Filenames:      []string{},
		MimeType:       "application/dart",
		TMScope:        "source.dart",
		AceMode:        "dart",
		CodeMirrorMode: "dart",
		Wrap:           false,
		LanguageID:     87,
	},
	974514097: LanguageInfo{
		Name:    "DataWeave",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#003a52",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dwl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.data-weave",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     974514097,
	},
	527438264: LanguageInfo{
		Name:    "Debian Package Control File",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#D70751",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dsc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.deb-control",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     527438264,
	},
	435000929: LanguageInfo{
		Name:    "DenizenScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#FBEE96",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dsc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-yaml",
		TMScope:        "source.denizenscript",
		AceMode:        "yaml",
		CodeMirrorMode: "yaml",
		Wrap:           false,
		LanguageID:     435000929,
	},
	793969321: LanguageInfo{
		Name:    "Dhall",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#dfafff",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dhall",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-haskell",
		TMScope:        "source.haskell",
		AceMode:        "haskell",
		CodeMirrorMode: "haskell",
		Wrap:           false,
		LanguageID:     793969321,
	},
	88: LanguageInfo{
		Name:   "Diff",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"udiff",
		},
		Extensions: []string{
			".diff",
			".patch",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-diff",
		TMScope:        "source.diff",
		AceMode:        "diff",
		CodeMirrorMode: "diff",
		Wrap:           false,
		LanguageID:     88,
	},
	201049282: LanguageInfo{
		Name:    "DirectX 3D File",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#aace60",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".x",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     201049282,
	},
	89: LanguageInfo{
		Name:   "Dockerfile",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#384d54",
		Group:  "",
		Aliases: []string{
			"Containerfile",
		},
		Extensions: []string{
			".dockerfile",
			".containerfile",
		},
		Interpreters: []string{},
		Filenames: []string{
			"Containerfile",
			"Dockerfile",
		},
		MimeType:       "text/x-dockerfile",
		TMScope:        "source.dockerfile",
		AceMode:        "dockerfile",
		CodeMirrorMode: "dockerfile",
		Wrap:           false,
		LanguageID:     89,
	},
	90: LanguageInfo{
		Name:    "Dogescript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#cca760",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".djs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     90,
	},
	111148035: LanguageInfo{
		Name:    "Dotenv",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#e5d559",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".env",
		},
		Interpreters: []string{},
		Filenames: []string{
			".env",
			".env.ci",
			".env.dev",
			".env.development",
			".env.development.local",
			".env.example",
			".env.local",
			".env.prod",
			".env.production",
			".env.sample",
			".env.staging",
			".env.test",
			".env.testing",
		},
		MimeType:       "",
		TMScope:        "source.dotenv",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     111148035,
	},
	754574151: LanguageInfo{
		Name:         "Dune",
		FSName:       "",
		Type:         TypeForString("programming"),
		Color:        "#89421e",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"dune-project",
		},
		MimeType:       "",
		TMScope:        "source.dune",
		AceMode:        "lisp",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     754574151,
	},
	91: LanguageInfo{
		Name:    "Dylan",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#6c616e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dylan",
			".dyl",
			".intr",
			".lid",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-dylan",
		TMScope:        "source.dylan",
		AceMode:        "text",
		CodeMirrorMode: "dylan",
		Wrap:           false,
		LanguageID:     91,
	},
	92: LanguageInfo{
		Name:    "E",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ccce35",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".e",
		},
		Interpreters: []string{
			"rune",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     92,
	},
	529653389: LanguageInfo{
		Name:   "E-mail",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"email",
			"eml",
			"mail",
			"mbox",
		},
		Extensions: []string{
			".eml",
			".mbox",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/mbox",
		TMScope:        "text.eml.basic",
		AceMode:        "text",
		CodeMirrorMode: "mbox",
		Wrap:           false,
		LanguageID:     529653389,
	},
	430: LanguageInfo{
		Name:    "EBNF",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ebnf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-ebnf",
		TMScope:        "source.ebnf",
		AceMode:        "text",
		CodeMirrorMode: "ebnf",
		Wrap:           false,
		LanguageID:     430,
	},
	93: LanguageInfo{
		Name:    "ECL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#8a1267",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ecl",
			".eclxml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-ecl",
		TMScope:        "source.ecl",
		AceMode:        "text",
		CodeMirrorMode: "ecl",
		Wrap:           false,
		LanguageID:     93,
	},
	94: LanguageInfo{
		Name:    "ECLiPSe",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#001d9d",
		Group:   "Prolog",
		Aliases: []string{},
		Extensions: []string{
			".ecl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.prolog.eclipse",
		AceMode:        "prolog",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     94,
	},
	95: LanguageInfo{
		Name:    "EJS",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#a91e50",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ejs",
			".ect",
			".ejs.t",
			".jst",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.js",
		AceMode:        "ejs",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     95,
	},
	96: LanguageInfo{
		Name:    "EQ",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#a78649",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".eq",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csharp",
		TMScope:        "source.cs",
		AceMode:        "csharp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     96,
	},
	97: LanguageInfo{
		Name:    "Eagle",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sch",
			".brd",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/xml",
		TMScope:        "text.xml",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     97,
	},
	963512632: LanguageInfo{
		Name:   "Earthly",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#2af0ff",
		Group:  "",
		Aliases: []string{
			"Earthfile",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"Earthfile",
		},
		MimeType:       "",
		TMScope:        "source.earthfile",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     963512632,
	},
	342840477: LanguageInfo{
		Name:    "Easybuild",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#069406",
		Group:   "Python",
		Aliases: []string{},
		Extensions: []string{
			".eb",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-python",
		TMScope:        "source.python",
		AceMode:        "python",
		CodeMirrorMode: "python",
		Wrap:           false,
		LanguageID:     342840477,
	},
	98: LanguageInfo{
		Name:    "Ecere Projects",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#913960",
		Group:   "JavaScript",
		Aliases: []string{},
		Extensions: []string{
			".epj",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/json",
		TMScope:        "source.json",
		AceMode:        "json",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     98,
	},
	844766630: LanguageInfo{
		Name:   "Ecmarkup",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#eb8131",
		Group:  "HTML",
		Aliases: []string{
			"ecmarkdown",
		},
		Extensions: []string{
			".html",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/html",
		TMScope:        "text.html.ecmarkup",
		AceMode:        "html",
		CodeMirrorMode: "htmlmixed",
		Wrap:           false,
		LanguageID:     844766630,
	},
	460509620: LanguageInfo{
		Name:    "Edge",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#0dffe0",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".edge",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.edge",
		AceMode:        "html",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     460509620,
	},
	925235833: LanguageInfo{
		Name:   "EdgeQL",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#31A7FF",
		Group:  "",
		Aliases: []string{
			"esdl",
		},
		Extensions: []string{
			".edgeql",
			".esdl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.edgeql",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     925235833,
	},
	96139566: LanguageInfo{
		Name:   "EditorConfig",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#fff1f2",
		Group:  "INI",
		Aliases: []string{
			"editor-config",
		},
		Extensions: []string{
			".editorconfig",
		},
		Interpreters: []string{},
		Filenames: []string{
			".editorconfig",
		},
		MimeType:       "text/x-properties",
		TMScope:        "source.editorconfig",
		AceMode:        "ini",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     96139566,
	},
	342840478: LanguageInfo{
		Name:    "Edje Data Collection",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".edc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-c++src",
		TMScope:        "source.c++",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     342840478,
	},
	99: LanguageInfo{
		Name:    "Eiffel",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#4d6977",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".e",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-eiffel",
		TMScope:        "source.eiffel",
		AceMode:        "eiffel",
		CodeMirrorMode: "eiffel",
		Wrap:           false,
		LanguageID:     99,
	},
	100: LanguageInfo{
		Name:    "Elixir",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#6e4a7e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ex",
			".exs",
		},
		Interpreters: []string{
			"elixir",
		},
		Filenames: []string{
			"mix.lock",
		},
		MimeType:       "",
		TMScope:        "source.elixir",
		AceMode:        "elixir",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     100,
	},
	101: LanguageInfo{
		Name:    "Elm",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#60B5CC",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".elm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-elm",
		TMScope:        "source.elm",
		AceMode:        "elm",
		CodeMirrorMode: "elm",
		Wrap:           false,
		LanguageID:     101,
	},
	570996448: LanguageInfo{
		Name:    "Elvish",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#55BB55",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".elv",
		},
		Interpreters: []string{
			"elvish",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.elvish",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     570996448,
	},
	452025714: LanguageInfo{
		Name:           "Elvish Transcript",
		FSName:         "",
		Type:           TypeForString("programming"),
		Color:          "#55BB55",
		Group:          "Elvish",
		Aliases:        []string{},
		Extensions:     []string{},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.elvish-transcript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     452025714,
	},
	102: LanguageInfo{
		Name:   "Emacs Lisp",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#c065db",
		Group:  "",
		Aliases: []string{
			"elisp",
			"emacs",
		},
		Extensions: []string{
			".el",
			".emacs",
			".emacs.desktop",
		},
		Interpreters: []string{},
		Filenames: []string{
			".abbrev_defs",
			".emacs",
			".emacs.desktop",
			".gnus",
			".spacemacs",
			".viper",
			"Cask",
			"Project.ede",
			"_emacs",
			"abbrev_defs",
		},
		MimeType:       "text/x-common-lisp",
		TMScope:        "source.emacs.lisp",
		AceMode:        "lisp",
		CodeMirrorMode: "commonlisp",
		Wrap:           false,
		LanguageID:     102,
	},
	103: LanguageInfo{
		Name:    "EmberScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#FFF4F3",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".em",
			".emberscript",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-coffeescript",
		TMScope:        "source.coffee",
		AceMode:        "coffee",
		CodeMirrorMode: "coffeescript",
		Wrap:           false,
		LanguageID:     103,
	},
	104: LanguageInfo{
		Name:    "Erlang",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#B83998",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".erl",
			".app",
			".app.src",
			".es",
			".escript",
			".hrl",
			".xrl",
			".yrl",
		},
		Interpreters: []string{
			"escript",
		},
		Filenames: []string{
			"Emakefile",
			"rebar.config",
			"rebar.config.lock",
			"rebar.lock",
		},
		MimeType:       "text/x-erlang",
		TMScope:        "source.erlang",
		AceMode:        "erlang",
		CodeMirrorMode: "erlang",
		Wrap:           false,
		LanguageID:     104,
	},
	880693982: LanguageInfo{
		Name:    "Euphoria",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#FF790B",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".e",
			".ex",
		},
		Interpreters: []string{
			"eui",
			"euiw",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.euphoria",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     880693982,
	},
	105: LanguageInfo{
		Name:   "F#",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#b845fc",
		Group:  "",
		Aliases: []string{
			"fsharp",
		},
		Extensions: []string{
			".fs",
			".fsi",
			".fsx",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-fsharp",
		TMScope:        "source.fsharp",
		AceMode:        "text",
		CodeMirrorMode: "mllike",
		Wrap:           false,
		LanguageID:     105,
	},
	336943375: LanguageInfo{
		Name:   "F*",
		FSName: "Fstar",
		Type:   TypeForString("programming"),
		Color:  "#572e30",
		Group:  "",
		Aliases: []string{
			"fstar",
		},
		Extensions: []string{
			".fst",
			".fsti",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.fstar",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     336943375,
	},
	686129783: LanguageInfo{
		Name:   "FIGlet Font",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#FFDDBB",
		Group:  "",
		Aliases: []string{
			"FIGfont",
		},
		Extensions: []string{
			".flf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.figfont",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     686129783,
	},
	906694254: LanguageInfo{
		Name:    "FIRRTL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#2f632f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".fir",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.firrtl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     906694254,
	},
	106: LanguageInfo{
		Name:    "FLUX",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#88ccff",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".fx",
			".flux",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     106,
	},
	108: LanguageInfo{
		Name:    "Factor",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#636746",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".factor",
		},
		Interpreters: []string{},
		Filenames: []string{
			".factor-boot-rc",
			".factor-rc",
		},
		MimeType:       "text/x-factor",
		TMScope:        "source.factor",
		AceMode:        "text",
		CodeMirrorMode: "factor",
		Wrap:           false,
		LanguageID:     108,
	},
	109: LanguageInfo{
		Name:    "Fancy",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#7b9db4",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".fy",
			".fancypack",
		},
		Interpreters: []string{},
		Filenames: []string{
			"Fakefile",
		},
		MimeType:       "",
		TMScope:        "source.fancy",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     109,
	},
	110: LanguageInfo{
		Name:    "Fantom",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#14253c",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".fan",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.fan",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     110,
	},
	622529198: LanguageInfo{
		Name:    "Faust",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#c37240",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dsp",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.faust",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     622529198,
	},
	239946126: LanguageInfo{
		Name:    "Fennel",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#fff3d7",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".fnl",
		},
		Interpreters: []string{
			"fennel",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.fnl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     239946126,
	},
	111: LanguageInfo{
		Name:    "Filebench WML",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#F6B900",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".f",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     111,
	},
	112: LanguageInfo{
		Name:    "Filterscript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "RenderScript",
		Aliases: []string{},
		Extensions: []string{
			".fs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     112,
	},
	206353404: LanguageInfo{
		Name:    "Fluent",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ffcc33",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ftl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ftl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     206353404,
	},
	113: LanguageInfo{
		Name:    "Formatted",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".for",
			".eam.fs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     113,
	},
	114: LanguageInfo{
		Name:    "Forth",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#341708",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".fth",
			".4th",
			".f",
			".for",
			".forth",
			".fr",
			".frt",
			".fs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-forth",
		TMScope:        "source.forth",
		AceMode:        "forth",
		CodeMirrorMode: "forth",
		Wrap:           false,
		LanguageID:     114,
	},
	107: LanguageInfo{
		Name:    "Fortran",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#4d41b1",
		Group:   "Fortran",
		Aliases: []string{},
		Extensions: []string{
			".f",
			".f77",
			".for",
			".fpp",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-fortran",
		TMScope:        "source.fortran",
		AceMode:        "text",
		CodeMirrorMode: "fortran",
		Wrap:           false,
		LanguageID:     107,
	},
	761352333: LanguageInfo{
		Name:    "Fortran Free Form",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#4d41b1",
		Group:   "Fortran",
		Aliases: []string{},
		Extensions: []string{
			".f90",
			".f03",
			".f08",
			".f95",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-fortran",
		TMScope:        "source.fortran.modern",
		AceMode:        "text",
		CodeMirrorMode: "fortran",
		Wrap:           false,
		LanguageID:     761352333,
	},
	472896659: LanguageInfo{
		Name:   "FreeBASIC",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#141AC9",
		Group:  "",
		Aliases: []string{
			"fb",
		},
		Extensions: []string{
			".bi",
			".bas",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-vb",
		TMScope:        "source.vbnet",
		AceMode:        "text",
		CodeMirrorMode: "vb",
		Wrap:           false,
		LanguageID:     472896659,
	},
	115: LanguageInfo{
		Name:   "FreeMarker",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#0050b2",
		Group:  "",
		Aliases: []string{
			"ftl",
		},
		Extensions: []string{
			".ftl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.ftl",
		AceMode:        "ftl",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     115,
	},
	116: LanguageInfo{
		Name:    "Frege",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00cafe",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".fr",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.haskell",
		AceMode:        "haskell",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     116,
	},
	97358117: LanguageInfo{
		Name:    "Futhark",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#5f021f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".fut",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.futhark",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     97358117,
	},
	117: LanguageInfo{
		Name:    "G-code",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#D08CF2",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".g",
			".cnc",
			".gco",
			".gcode",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gcode",
		AceMode:        "gcode",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     117,
	},
	290345951: LanguageInfo{
		Name:    "GAML",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#FFC766",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gaml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     290345951,
	},
	118: LanguageInfo{
		Name:    "GAMS",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#f49a22",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gms",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     118,
	},
	119: LanguageInfo{
		Name:    "GAP",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0000cc",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".g",
			".gap",
			".gd",
			".gi",
			".tst",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gap",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     119,
	},
	121: LanguageInfo{
		Name:    "GCC Machine Description",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#FFCFAB",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".md",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-common-lisp",
		TMScope:        "source.lisp",
		AceMode:        "lisp",
		CodeMirrorMode: "commonlisp",
		Wrap:           false,
		LanguageID:     121,
	},
	122: LanguageInfo{
		Name:    "GDB",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gdb",
			".gdbinit",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gdb",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     122,
	},
	123: LanguageInfo{
		Name:    "GDScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#355570",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gd",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gdscript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     123,
	},
	459577965: LanguageInfo{
		Name:    "GEDCOM",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#003058",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ged",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gedcom",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     459577965,
	},
	124: LanguageInfo{
		Name:    "GLSL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#5686a5",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".glsl",
			".fp",
			".frag",
			".frg",
			".fs",
			".fsh",
			".fshader",
			".geo",
			".geom",
			".glslf",
			".glslv",
			".gs",
			".gshader",
			".rchit",
			".rmiss",
			".shader",
			".tesc",
			".tese",
			".vert",
			".vrx",
			".vs",
			".vsh",
			".vshader",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.glsl",
		AceMode:        "glsl",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     124,
	},
	302957008: LanguageInfo{
		Name:    "GN",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gn",
			".gni",
		},
		Interpreters: []string{
			"gn",
		},
		Filenames: []string{
			".gn",
		},
		MimeType:       "text/x-python",
		TMScope:        "source.gn",
		AceMode:        "python",
		CodeMirrorMode: "python",
		Wrap:           false,
		LanguageID:     302957008,
	},
	257856279: LanguageInfo{
		Name:    "GSC",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#FF6800",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gsc",
			".csc",
			".gsh",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.gsc",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     257856279,
	},
	125: LanguageInfo{
		Name:    "Game Maker Language",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#71b417",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-c++src",
		TMScope:        "source.c++",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     125,
	},
	907065713: LanguageInfo{
		Name:         "Gemfile.lock",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "#701516",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"Gemfile.lock",
		},
		MimeType:       "",
		TMScope:        "source.gemfile-lock",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     907065713,
	},
	310828396: LanguageInfo{
		Name:   "Gemini",
		FSName: "",
		Type:   TypeForString("prose"),
		Color:  "#ff6900",
		Group:  "",
		Aliases: []string{
			"gemtext",
		},
		Extensions: []string{
			".gmi",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gemini",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     310828396,
	},
	986054050: LanguageInfo{
		Name:    "Genero 4gl",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#63408e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".4gl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.genero-4gl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     986054050,
	},
	902995658: LanguageInfo{
		Name:    "Genero per",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#d8df39",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".per",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.genero-per",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     902995658,
	},
	792408528: LanguageInfo{
		Name:    "Genie",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#fb855d",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     792408528,
	},
	126: LanguageInfo{
		Name:   "Genshi",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#951531",
		Group:  "",
		Aliases: []string{
			"xml+genshi",
			"xml+kid",
		},
		Extensions: []string{
			".kid",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/xml",
		TMScope:        "text.xml.genshi",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     126,
	},
	127: LanguageInfo{
		Name:    "Gentoo Ebuild",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#9400ff",
		Group:   "Shell",
		Aliases: []string{},
		Extensions: []string{
			".ebuild",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-sh",
		TMScope:        "source.shell",
		AceMode:        "sh",
		CodeMirrorMode: "shell",
		Wrap:           false,
		LanguageID:     127,
	},
	128: LanguageInfo{
		Name:    "Gentoo Eclass",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#9400ff",
		Group:   "Shell",
		Aliases: []string{},
		Extensions: []string{
			".eclass",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-sh",
		TMScope:        "source.shell",
		AceMode:        "sh",
		CodeMirrorMode: "shell",
		Wrap:           false,
		LanguageID:     128,
	},
	404627610: LanguageInfo{
		Name:   "Gerber Image",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#d20b00",
		Group:  "",
		Aliases: []string{
			"rs-274x",
		},
		Extensions: []string{
			".gbr",
			".cmp",
			".gbl",
			".gbo",
			".gbp",
			".gbs",
			".gko",
			".gml",
			".gpb",
			".gpt",
			".gtl",
			".gto",
			".gtp",
			".gts",
			".ncl",
			".sol",
		},
		Interpreters: []string{
			"gerbv",
			"gerbview",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gerber",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     404627610,
	},
	129: LanguageInfo{
		Name:   "Gettext Catalog",
		FSName: "",
		Type:   TypeForString("prose"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"pot",
		},
		Extensions: []string{
			".po",
			".pot",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.po",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     129,
	},
	76: LanguageInfo{
		Name:   "Gherkin",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#5B2063",
		Group:  "",
		Aliases: []string{
			"cucumber",
		},
		Extensions: []string{
			".feature",
			".story",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.gherkin.feature",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     76,
	},
	956324166: LanguageInfo{
		Name:   "Git Attributes",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#F44D27",
		Group:  "",
		Aliases: []string{
			"gitattributes",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			".gitattributes",
		},
		MimeType:       "text/x-sh",
		TMScope:        "source.gitattributes",
		AceMode:        "gitignore",
		CodeMirrorMode: "shell",
		Wrap:           false,
		LanguageID:     956324166,
	},
	807968997: LanguageInfo{
		Name:   "Git Config",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#F44D27",
		Group:  "INI",
		Aliases: []string{
			"gitconfig",
			"gitmodules",
		},
		Extensions: []string{
			".gitconfig",
		},
		Interpreters: []string{},
		Filenames: []string{
			".gitconfig",
			".gitmodules",
		},
		MimeType:       "text/x-properties",
		TMScope:        "source.gitconfig",
		AceMode:        "ini",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     807968997,
	},
	461881235: LanguageInfo{
		Name:   "Git Revision List",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#F44D27",
		Group:  "",
		Aliases: []string{
			"Git Blame Ignore Revs",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			".git-blame-ignore-revs",
		},
		MimeType:       "",
		TMScope:        "source.git-revlist",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     461881235,
	},
	1054258749: LanguageInfo{
		Name:    "Gleam",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ffaff3",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gleam",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gleam",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     1054258749,
	},
	5523150: LanguageInfo{
		Name:    "Glimmer JS",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#F5835F",
		Group:   "JavaScript",
		Aliases: []string{},
		Extensions: []string{
			".gjs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gjs",
		AceMode:        "javascript",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     5523150,
	},
	95110458: LanguageInfo{
		Name:    "Glimmer TS",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3178c6",
		Group:   "TypeScript",
		Aliases: []string{},
		Extensions: []string{
			".gts",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gts",
		AceMode:        "typescript",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     95110458,
	},
	130: LanguageInfo{
		Name:    "Glyph",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#c1ac7f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".glf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-tcl",
		TMScope:        "source.tcl",
		AceMode:        "tcl",
		CodeMirrorMode: "tcl",
		Wrap:           false,
		LanguageID:     130,
	},
	997665271: LanguageInfo{
		Name:    "Glyph Bitmap Distribution Format",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bdf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.bdf",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     997665271,
	},
	131: LanguageInfo{
		Name:    "Gnuplot",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#f0a9f0",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gp",
			".gnu",
			".gnuplot",
			".p",
			".plot",
			".plt",
		},
		Interpreters: []string{
			"gnuplot",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gnuplot",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     131,
	},
	132: LanguageInfo{
		Name:   "Go",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#00ADD8",
		Group:  "",
		Aliases: []string{
			"golang",
		},
		Extensions: []string{
			".go",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-go",
		TMScope:        "source.go",
		AceMode:        "golang",
		CodeMirrorMode: "go",
		Wrap:           false,
		LanguageID:     132,
	},
	1054391671: LanguageInfo{
		Name:   "Go Checksums",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#00ADD8",
		Group:  "",
		Aliases: []string{
			"go.sum",
			"go sum",
			"go.work.sum",
			"go work sum",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"go.sum",
			"go.work.sum",
		},
		MimeType:       "",
		TMScope:        "go.sum",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     1054391671,
	},
	947461016: LanguageInfo{
		Name:   "Go Module",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#00ADD8",
		Group:  "",
		Aliases: []string{
			"go.mod",
			"go mod",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"go.mod",
		},
		MimeType:       "",
		TMScope:        "go.mod",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     947461016,
	},
	934546256: LanguageInfo{
		Name:   "Go Workspace",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#00ADD8",
		Group:  "",
		Aliases: []string{
			"go.work",
			"go work",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"go.work",
		},
		MimeType:       "",
		TMScope:        "go.mod",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     934546256,
	},
	738107771: LanguageInfo{
		Name:    "Godot Resource",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#355570",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gdnlib",
			".gdns",
			".tres",
			".tscn",
		},
		Interpreters: []string{},
		Filenames: []string{
			"project.godot",
		},
		MimeType:       "",
		TMScope:        "source.gdresource",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     738107771,
	},
	133: LanguageInfo{
		Name:    "Golo",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#88562A",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".golo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.golo",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     133,
	},
	134: LanguageInfo{
		Name:    "Gosu",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#82937f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gs",
			".gst",
			".gsx",
			".vark",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.gosu.2",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     134,
	},
	135: LanguageInfo{
		Name:    "Grace",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#615f8b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".grace",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.grace",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     135,
	},
	136: LanguageInfo{
		Name:    "Gradle",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#02303a",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gradle",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.groovy.gradle",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     136,
	},
	432600901: LanguageInfo{
		Name:    "Gradle Kotlin DSL",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#02303a",
		Group:   "Gradle",
		Aliases: []string{},
		Extensions: []string{
			".gradle.kts",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.kotlin",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     432600901,
	},
	137: LanguageInfo{
		Name:   "Grammatical Framework",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#ff0000",
		Group:  "",
		Aliases: []string{
			"gf",
		},
		Extensions: []string{
			".gf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-haskell",
		TMScope:        "source.gf",
		AceMode:        "haskell",
		CodeMirrorMode: "haskell",
		Wrap:           false,
		LanguageID:     137,
	},
	138: LanguageInfo{
		Name:    "Graph Modeling Language",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".gml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     138,
	},
	139: LanguageInfo{
		Name:    "GraphQL",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#e10098",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".graphql",
			".gql",
			".graphqls",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.graphql",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     139,
	},
	140: LanguageInfo{
		Name:    "Graphviz (DOT)",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#2596be",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dot",
			".gv",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.dot",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     140,
	},
	142: LanguageInfo{
		Name:    "Groovy",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#4298b8",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".groovy",
			".grt",
			".gtpl",
			".gvy",
		},
		Interpreters: []string{
			"groovy",
		},
		Filenames: []string{
			"Jenkinsfile",
		},
		MimeType:       "text/x-groovy",
		TMScope:        "source.groovy",
		AceMode:        "groovy",
		CodeMirrorMode: "groovy",
		Wrap:           false,
		LanguageID:     142,
	},
	143: LanguageInfo{
		Name:   "Groovy Server Pages",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#4298b8",
		Group:  "Groovy",
		Aliases: []string{
			"gsp",
			"java server page",
		},
		Extensions: []string{
			".gsp",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/x-jsp",
		TMScope:        "text.html.jsp",
		AceMode:        "jsp",
		CodeMirrorMode: "htmlembedded",
		Wrap:           false,
		LanguageID:     143,
	},
	366607477: LanguageInfo{
		Name:    "HAProxy",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#106da9",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cfg",
		},
		Interpreters: []string{},
		Filenames: []string{
			"haproxy.cfg",
		},
		MimeType:       "",
		TMScope:        "source.haproxy-config",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     366607477,
	},
	144: LanguageInfo{
		Name:   "HCL",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#844FBA",
		Group:  "",
		Aliases: []string{
			"HashiCorp Configuration Language",
			"terraform",
		},
		Extensions: []string{
			".hcl",
			".nomad",
			".tf",
			".tfvars",
			".workflow",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-ruby",
		TMScope:        "source.hcl",
		AceMode:        "ruby",
		CodeMirrorMode: "ruby",
		Wrap:           false,
		LanguageID:     144,
	},
	145: LanguageInfo{
		Name:    "HLSL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#aace60",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".hlsl",
			".cginc",
			".fx",
			".fxh",
			".hlsli",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.hlsl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     145,
	},
	679725279: LanguageInfo{
		Name:    "HOCON",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#9ff8ee",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".hocon",
		},
		Interpreters: []string{},
		Filenames: []string{
			".scalafix.conf",
			".scalafmt.conf",
		},
		MimeType:       "",
		TMScope:        "source.hocon",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     679725279,
	},
	146: LanguageInfo{
		Name:   "HTML",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#e34c26",
		Group:  "",
		Aliases: []string{
			"xhtml",
		},
		Extensions: []string{
			".html",
			".hta",
			".htm",
			".html.hl",
			".inc",
			".xht",
			".xhtml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/html",
		TMScope:        "text.html.basic",
		AceMode:        "html",
		CodeMirrorMode: "htmlmixed",
		Wrap:           false,
		LanguageID:     146,
	},
	148: LanguageInfo{
		Name:   "HTML+ECR",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#2e1052",
		Group:  "HTML",
		Aliases: []string{
			"ecr",
		},
		Extensions: []string{
			".ecr",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/html",
		TMScope:        "text.html.ecr",
		AceMode:        "text",
		CodeMirrorMode: "htmlmixed",
		Wrap:           false,
		LanguageID:     148,
	},
	149: LanguageInfo{
		Name:   "HTML+EEX",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#6e4a7e",
		Group:  "HTML",
		Aliases: []string{
			"eex",
			"heex",
			"leex",
		},
		Extensions: []string{
			".eex",
			".html.heex",
			".html.leex",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/html",
		TMScope:        "text.html.elixir",
		AceMode:        "text",
		CodeMirrorMode: "htmlmixed",
		Wrap:           false,
		LanguageID:     149,
	},
	150: LanguageInfo{
		Name:   "HTML+ERB",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#701516",
		Group:  "HTML",
		Aliases: []string{
			"erb",
			"rhtml",
			"html+ruby",
		},
		Extensions: []string{
			".erb",
			".erb.deface",
			".rhtml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/x-erb",
		TMScope:        "text.html.erb",
		AceMode:        "text",
		CodeMirrorMode: "htmlembedded",
		Wrap:           false,
		LanguageID:     150,
	},
	151: LanguageInfo{
		Name:    "HTML+PHP",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#4f5d95",
		Group:   "HTML",
		Aliases: []string{},
		Extensions: []string{
			".phtml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/x-httpd-php",
		TMScope:        "text.html.php",
		AceMode:        "php",
		CodeMirrorMode: "php",
		Wrap:           false,
		LanguageID:     151,
	},
	479039817: LanguageInfo{
		Name:   "HTML+Razor",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#512be4",
		Group:  "HTML",
		Aliases: []string{
			"razor",
		},
		Extensions: []string{
			".cshtml",
			".razor",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/html",
		TMScope:        "text.html.cshtml",
		AceMode:        "razor",
		CodeMirrorMode: "htmlmixed",
		Wrap:           false,
		LanguageID:     479039817,
	},
	152: LanguageInfo{
		Name:    "HTTP",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#005C9C",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".http",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "message/http",
		TMScope:        "source.httpspec",
		AceMode:        "text",
		CodeMirrorMode: "http",
		Wrap:           false,
		LanguageID:     152,
	},
	786683730: LanguageInfo{
		Name:    "HXML",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#f68712",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".hxml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.hxml",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     786683730,
	},
	153: LanguageInfo{
		Name:    "Hack",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#878787",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".hack",
			".hh",
			".hhi",
			".php",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/x-httpd-php",
		TMScope:        "source.hack",
		AceMode:        "php",
		CodeMirrorMode: "php",
		Wrap:           false,
		LanguageID:     153,
	},
	154: LanguageInfo{
		Name:    "Haml",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#ece2a9",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".haml",
			".haml.deface",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-haml",
		TMScope:        "text.haml",
		AceMode:        "haml",
		CodeMirrorMode: "haml",
		Wrap:           false,
		LanguageID:     154,
	},
	155: LanguageInfo{
		Name:   "Handlebars",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#f7931e",
		Group:  "",
		Aliases: []string{
			"hbs",
			"htmlbars",
		},
		Extensions: []string{
			".handlebars",
			".hbs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.handlebars",
		AceMode:        "handlebars",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     155,
	},
	156: LanguageInfo{
		Name:    "Harbour",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0e60e3",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".hb",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.harbour",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     156,
	},
	463518941: LanguageInfo{
		Name:    "Hare",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#9d7424",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ha",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     463518941,
	},
	157: LanguageInfo{
		Name:    "Haskell",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#5e5086",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".hs",
			".hs-boot",
			".hsc",
		},
		Interpreters: []string{
			"runghc",
			"runhaskell",
			"runhugs",
		},
		Filenames:      []string{},
		MimeType:       "text/x-haskell",
		TMScope:        "source.haskell",
		AceMode:        "haskell",
		CodeMirrorMode: "haskell",
		Wrap:           false,
		LanguageID:     157,
	},
	158: LanguageInfo{
		Name:    "Haxe",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#df7900",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".hx",
			".hxsl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-haxe",
		TMScope:        "source.hx",
		AceMode:        "haxe",
		CodeMirrorMode: "haxe",
		Wrap:           false,
		LanguageID:     158,
	},
	931814087: LanguageInfo{
		Name:    "HiveQL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#dce200",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".q",
			".hql",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.hql",
		AceMode:        "sql",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     931814087,
	},
	928121743: LanguageInfo{
		Name:    "HolyC",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ffefaf",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".hc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.hc",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     928121743,
	},
	231021894: LanguageInfo{
		Name:   "Hosts File",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#308888",
		Group:  "",
		Aliases: []string{
			"hosts",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"HOSTS",
			"hosts",
			"hosts.txt",
		},
		MimeType:       "",
		TMScope:        "source.hosts",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     231021894,
	},
	159: LanguageInfo{
		Name:   "Hy",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#7790B2",
		Group:  "",
		Aliases: []string{
			"hylang",
		},
		Extensions: []string{
			".hy",
		},
		Interpreters: []string{
			"hy",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.hy",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     159,
	},
	160: LanguageInfo{
		Name:    "HyPhy",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".bf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     160,
	},
	161: LanguageInfo{
		Name:    "IDL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#a3522f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pro",
			".dlm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-idl",
		TMScope:        "source.idl",
		AceMode:        "text",
		CodeMirrorMode: "idl",
		Wrap:           false,
		LanguageID:     161,
	},
	162: LanguageInfo{
		Name:   "IGOR Pro",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#0000cc",
		Group:  "",
		Aliases: []string{
			"igor",
			"igorpro",
		},
		Extensions: []string{
			".ipf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.igor",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     162,
	},
	163: LanguageInfo{
		Name:   "INI",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#d1dbe0",
		Group:  "",
		Aliases: []string{
			"dosini",
		},
		Extensions: []string{
			".ini",
			".cfg",
			".cnf",
			".dof",
			".lektorproject",
			".prefs",
			".pro",
			".properties",
			".url",
		},
		Interpreters: []string{},
		Filenames: []string{
			".buckconfig",
			".coveragerc",
			".flake8",
			".pylintrc",
			"HOSTS",
			"buildozer.spec",
			"hosts",
			"pylintrc",
			"vlcrc",
		},
		MimeType:       "text/x-properties",
		TMScope:        "source.ini",
		AceMode:        "ini",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     163,
	},
	164: LanguageInfo{
		Name:   "IRC log",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"irc",
			"irc logs",
		},
		Extensions: []string{
			".irclog",
			".weechatlog",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/mirc",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "mirc",
		Wrap:           false,
		LanguageID:     164,
	},
	165: LanguageInfo{
		Name:    "Idris",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#b30000",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".idr",
			".lidr",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.idris",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     165,
	},
	74444240: LanguageInfo{
		Name:   "Ignore List",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#000000",
		Group:  "",
		Aliases: []string{
			"ignore",
			"gitignore",
			"git-ignore",
		},
		Extensions: []string{
			".gitignore",
		},
		Interpreters: []string{},
		Filenames: []string{
			".atomignore",
			".babelignore",
			".bzrignore",
			".coffeelintignore",
			".cvsignore",
			".dockerignore",
			".easignore",
			".eleventyignore",
			".eslintignore",
			".gitignore",
			".ignore",
			".markdownlintignore",
			".nodemonignore",
			".npmignore",
			".prettierignore",
			".stylelintignore",
			".vercelignore",
			".vscodeignore",
			"gitignore-global",
			"gitignore_global",
		},
		MimeType:       "text/x-sh",
		TMScope:        "source.gitignore",
		AceMode:        "gitignore",
		CodeMirrorMode: "shell",
		Wrap:           false,
		LanguageID:     74444240,
	},
	575143428: LanguageInfo{
		Name:   "ImageJ Macro",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#99AAFF",
		Group:  "",
		Aliases: []string{
			"ijm",
		},
		Extensions: []string{
			".ijm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     575143428,
	},
	1057618448: LanguageInfo{
		Name:    "Imba",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#16cec6",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".imba",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.imba",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     1057618448,
	},
	166: LanguageInfo{
		Name:   "Inform 7",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"i7",
			"inform7",
		},
		Extensions: []string{
			".ni",
			".i7x",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.inform7",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     166,
	},
	838252715: LanguageInfo{
		Name:    "Ink",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ink",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ink",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     838252715,
	},
	167: LanguageInfo{
		Name:    "Inno Setup",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#264b99",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".iss",
			".isl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.inno",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     167,
	},
	168: LanguageInfo{
		Name:    "Io",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#a9188d",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".io",
		},
		Interpreters: []string{
			"io",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.io",
		AceMode:        "io",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     168,
	},
	169: LanguageInfo{
		Name:    "Ioke",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#078193",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ik",
		},
		Interpreters: []string{
			"ioke",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ioke",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     169,
	},
	170: LanguageInfo{
		Name:    "Isabelle",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#FEFE00",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".thy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.isabelle.theory",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     170,
	},
	171: LanguageInfo{
		Name:         "Isabelle ROOT",
		FSName:       "",
		Type:         TypeForString("programming"),
		Color:        "#FEFE00",
		Group:        "Isabelle",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"ROOT",
		},
		MimeType:       "",
		TMScope:        "source.isabelle.root",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     171,
	},
	172: LanguageInfo{
		Name:    "J",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#9EEDFF",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ijs",
		},
		Interpreters: []string{
			"jconsole",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.j",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     172,
	},
	447261135: LanguageInfo{
		Name:         "JAR Manifest",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "#b07219",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"MANIFEST.MF",
		},
		MimeType:       "",
		TMScope:        "source.yaml",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     447261135,
	},
	316620079: LanguageInfo{
		Name:    "JCL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#d90e09",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".jcl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.jcl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     316620079,
	},
	173: LanguageInfo{
		Name:    "JFlex",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#DBCA00",
		Group:   "Lex",
		Aliases: []string{},
		Extensions: []string{
			".flex",
			".jflex",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.jflex",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     173,
	},
	174: LanguageInfo{
		Name:   "JSON",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#292929",
		Group:  "",
		Aliases: []string{
			"geojson",
			"jsonl",
			"sarif",
			"topojson",
		},
		Extensions: []string{
			".json",
			".4DForm",
			".4DProject",
			".avsc",
			".geojson",
			".gltf",
			".har",
			".ice",
			".JSON-tmLanguage",
			".json.example",
			".jsonl",
			".mcmeta",
			".sarif",
			".tact",
			".tfstate",
			".tfstate.backup",
			".topojson",
			".webapp",
			".webmanifest",
			".yy",
			".yyp",
		},
		Interpreters: []string{},
		Filenames: []string{
			".all-contributorsrc",
			".arcconfig",
			".auto-changelog",
			".c8rc",
			".htmlhintrc",
			".imgbotconfig",
			".nycrc",
			".tern-config",
			".tern-project",
			".watchmanconfig",
			"MODULE.bazel.lock",
			"Pipfile.lock",
			"composer.lock",
			"deno.lock",
			"flake.lock",
			"mcmod.info",
		},
		MimeType:       "application/json",
		TMScope:        "source.json",
		AceMode:        "json",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     174,
	},
	423: LanguageInfo{
		Name:   "JSON with Comments",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#292929",
		Group:  "JSON",
		Aliases: []string{
			"jsonc",
		},
		Extensions: []string{
			".jsonc",
			".code-snippets",
			".code-workspace",
			".sublime-build",
			".sublime-color-scheme",
			".sublime-commands",
			".sublime-completions",
			".sublime-keymap",
			".sublime-macro",
			".sublime-menu",
			".sublime-mousemap",
			".sublime-project",
			".sublime-settings",
			".sublime-theme",
			".sublime-workspace",
			".sublime_metrics",
			".sublime_session",
		},
		Interpreters: []string{},
		Filenames: []string{
			".babelrc",
			".devcontainer.json",
			".eslintrc.json",
			".jscsrc",
			".jshintrc",
			".jslintrc",
			".swcrc",
			"api-extractor.json",
			"devcontainer.json",
			"jsconfig.json",
			"language-configuration.json",
			"tsconfig.json",
			"tslint.json",
		},
		MimeType:       "text/javascript",
		TMScope:        "source.js",
		AceMode:        "javascript",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     423,
	},
	175: LanguageInfo{
		Name:    "JSON5",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#267CB9",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".json5",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/json",
		TMScope:        "source.js",
		AceMode:        "javascript",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     175,
	},
	176: LanguageInfo{
		Name:    "JSONLD",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#0c479c",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".jsonld",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/json",
		TMScope:        "source.js",
		AceMode:        "javascript",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     176,
	},
	177: LanguageInfo{
		Name:    "JSONiq",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#40d47e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".jq",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/json",
		TMScope:        "source.jsoniq",
		AceMode:        "jsoniq",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     177,
	},
	1028705371: LanguageInfo{
		Name:    "Janet",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0886a5",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".janet",
		},
		Interpreters: []string{
			"janet",
		},
		Filenames:      []string{},
		MimeType:       "text/x-scheme",
		TMScope:        "source.janet",
		AceMode:        "scheme",
		CodeMirrorMode: "scheme",
		Wrap:           false,
		LanguageID:     1028705371,
	},
	180: LanguageInfo{
		Name:    "Jasmin",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#d03600",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".j",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.jasmin",
		AceMode:        "java",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     180,
	},
	181: LanguageInfo{
		Name:    "Java",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#b07219",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".java",
			".jav",
			".jsh",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-java",
		TMScope:        "source.java",
		AceMode:        "java",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     181,
	},
	519377561: LanguageInfo{
		Name:    "Java Properties",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#2A6277",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".properties",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-properties",
		TMScope:        "source.java-properties",
		AceMode:        "properties",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     519377561,
	},
	182: LanguageInfo{
		Name:   "Java Server Pages",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#2A6277",
		Group:  "Java",
		Aliases: []string{
			"jsp",
		},
		Extensions: []string{
			".jsp",
			".tag",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/x-jsp",
		TMScope:        "text.html.jsp",
		AceMode:        "jsp",
		CodeMirrorMode: "htmlembedded",
		Wrap:           false,
		LanguageID:     182,
	},
	599494012: LanguageInfo{
		Name:   "Java Template Engine",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#2A6277",
		Group:  "Java",
		Aliases: []string{
			"jte",
		},
		Extensions: []string{
			".jte",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.jte",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     599494012,
	},
	183: LanguageInfo{
		Name:   "JavaScript",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#f1e05a",
		Group:  "",
		Aliases: []string{
			"js",
			"node",
		},
		Extensions: []string{
			".js",
			"._js",
			".bones",
			".cjs",
			".es",
			".es6",
			".frag",
			".gs",
			".jake",
			".javascript",
			".jsb",
			".jscad",
			".jsfl",
			".jslib",
			".jsm",
			".jspre",
			".jss",
			".jsx",
			".mjs",
			".njs",
			".pac",
			".sjs",
			".ssjs",
			".xsjs",
			".xsjslib",
		},
		Interpreters: []string{
			"chakra",
			"d8",
			"gjs",
			"js",
			"node",
			"nodejs",
			"qjs",
			"rhino",
			"v8",
			"v8-shell",
		},
		Filenames: []string{
			"Jakefile",
		},
		MimeType:       "text/javascript",
		TMScope:        "source.js",
		AceMode:        "javascript",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     183,
	},
	914318960: LanguageInfo{
		Name:    "JavaScript+ERB",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#f1e05a",
		Group:   "JavaScript",
		Aliases: []string{},
		Extensions: []string{
			".js.erb",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/javascript",
		TMScope:        "source.js",
		AceMode:        "javascript",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     914318960,
	},
	774635084: LanguageInfo{
		Name:    "Jest Snapshot",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#15c213",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".snap",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/javascript",
		TMScope:        "source.jest.snap",
		AceMode:        "javascript",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     774635084,
	},
	465165328: LanguageInfo{
		Name:   "JetBrains MPS",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#21D789",
		Group:  "",
		Aliases: []string{
			"mps",
		},
		Extensions: []string{
			".mps",
			".mpl",
			".msd",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/xml",
		TMScope:        "none",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     465165328,
	},
	147: LanguageInfo{
		Name:   "Jinja",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#a52a22",
		Group:  "",
		Aliases: []string{
			"django",
			"html+django",
			"html+jinja",
			"htmldjango",
		},
		Extensions: []string{
			".jinja",
			".j2",
			".jinja2",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-django",
		TMScope:        "text.html.django",
		AceMode:        "django",
		CodeMirrorMode: "django",
		Wrap:           false,
		LanguageID:     147,
	},
	284531423: LanguageInfo{
		Name:    "Jison",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#56b3cb",
		Group:   "Yacc",
		Aliases: []string{},
		Extensions: []string{
			".jison",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.jison",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     284531423,
	},
	406395330: LanguageInfo{
		Name:    "Jison Lex",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#56b3cb",
		Group:   "Lex",
		Aliases: []string{},
		Extensions: []string{
			".jisonlex",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.jisonlex",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     406395330,
	},
	998078858: LanguageInfo{
		Name:    "Jolie",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#843179",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ol",
			".iol",
		},
		Interpreters: []string{
			"jolie",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.jolie",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     998078858,
	},
	664885656: LanguageInfo{
		Name:    "Jsonnet",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0064bd",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".jsonnet",
			".libsonnet",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.jsonnet",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     664885656,
	},
	184: LanguageInfo{
		Name:    "Julia",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#a270ba",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".jl",
		},
		Interpreters: []string{
			"julia",
		},
		Filenames:      []string{},
		MimeType:       "text/x-julia",
		TMScope:        "source.julia",
		AceMode:        "julia",
		CodeMirrorMode: "julia",
		Wrap:           false,
		LanguageID:     184,
	},
	220689142: LanguageInfo{
		Name:           "Julia REPL",
		FSName:         "",
		Type:           TypeForString("programming"),
		Color:          "#a270ba",
		Group:          "Julia",
		Aliases:        []string{},
		Extensions:     []string{},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.julia.console",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     220689142,
	},
	185: LanguageInfo{
		Name:   "Jupyter Notebook",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#DA5B0B",
		Group:  "",
		Aliases: []string{
			"IPython Notebook",
		},
		Extensions: []string{
			".ipynb",
		},
		Interpreters: []string{},
		Filenames: []string{
			"Notebook",
		},
		MimeType:       "application/json",
		TMScope:        "source.json",
		AceMode:        "json",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     185,
	},
	128447695: LanguageInfo{
		Name:   "Just",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#384d54",
		Group:  "",
		Aliases: []string{
			"Justfile",
		},
		Extensions: []string{
			".just",
		},
		Interpreters: []string{},
		Filenames: []string{
			".JUSTFILE",
			".Justfile",
			".justfile",
			"JUSTFILE",
			"Justfile",
			"justfile",
		},
		MimeType:       "",
		TMScope:        "source.just",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     128447695,
	},
	186: LanguageInfo{
		Name:    "KRL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#28430A",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".krl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     186,
	},
	818804755: LanguageInfo{
		Name:   "Kaitai Struct",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#773b37",
		Group:  "",
		Aliases: []string{
			"ksy",
		},
		Extensions: []string{
			".ksy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-yaml",
		TMScope:        "source.yaml",
		AceMode:        "yaml",
		CodeMirrorMode: "yaml",
		Wrap:           false,
		LanguageID:     818804755,
	},
	603336474: LanguageInfo{
		Name:   "KakouneScript",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#6f8042",
		Group:  "",
		Aliases: []string{
			"kak",
			"kakscript",
		},
		Extensions: []string{
			".kak",
		},
		Interpreters: []string{},
		Filenames: []string{
			"kakrc",
		},
		MimeType:       "",
		TMScope:        "source.kakscript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     603336474,
	},
	59716426: LanguageInfo{
		Name:    "KerboScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#41adf0",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ks",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.kerboscript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     59716426,
	},
	187: LanguageInfo{
		Name:   "KiCad Layout",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#2f4aab",
		Group:  "",
		Aliases: []string{
			"pcbnew",
		},
		Extensions: []string{
			".kicad_pcb",
			".kicad_mod",
			".kicad_wks",
		},
		Interpreters: []string{},
		Filenames: []string{
			"fp-lib-table",
		},
		MimeType:       "text/x-common-lisp",
		TMScope:        "source.pcb.sexp",
		AceMode:        "lisp",
		CodeMirrorMode: "commonlisp",
		Wrap:           false,
		LanguageID:     187,
	},
	140848857: LanguageInfo{
		Name:    "KiCad Legacy Layout",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#2f4aab",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".brd",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pcb.board",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     140848857,
	},
	622447435: LanguageInfo{
		Name:   "KiCad Schematic",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#2f4aab",
		Group:  "",
		Aliases: []string{
			"eeschema schematic",
		},
		Extensions: []string{
			".kicad_sch",
			".sch",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pcb.schematic",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     622447435,
	},
	692635484: LanguageInfo{
		Name:    "Kickstart",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ks",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.kickstart",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     692635484,
	},
	188: LanguageInfo{
		Name:    "Kit",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".kit",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/html",
		TMScope:        "text.html.basic",
		AceMode:        "html",
		CodeMirrorMode: "htmlmixed",
		Wrap:           false,
		LanguageID:     188,
	},
	189: LanguageInfo{
		Name:    "Kotlin",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#A97BFF",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".kt",
			".ktm",
			".kts",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-kotlin",
		TMScope:        "source.kotlin",
		AceMode:        "text",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     189,
	},
	225697190: LanguageInfo{
		Name:    "Kusto",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".csl",
			".kql",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.kusto",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     225697190,
	},
	190: LanguageInfo{
		Name:    "LFE",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#4C3023",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".lfe",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-common-lisp",
		TMScope:        "source.lisp",
		AceMode:        "lisp",
		CodeMirrorMode: "commonlisp",
		Wrap:           false,
		LanguageID:     190,
	},
	191: LanguageInfo{
		Name:    "LLVM",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#185619",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ll",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.llvm",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     191,
	},
	192: LanguageInfo{
		Name:    "LOLCODE",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#cc9900",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".lol",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.lolcode",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     192,
	},
	193: LanguageInfo{
		Name:    "LSL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3d9970",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".lsl",
			".lslp",
		},
		Interpreters: []string{
			"lsl",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.lsl",
		AceMode:        "lsl",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     193,
	},
	1013566805: LanguageInfo{
		Name:    "LTspice Symbol",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".asy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-spreadsheet",
		TMScope:        "source.ltspice.symbol",
		AceMode:        "text",
		CodeMirrorMode: "spreadsheet",
		Wrap:           false,
		LanguageID:     1013566805,
	},
	194: LanguageInfo{
		Name:    "LabVIEW",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#fede06",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".lvproj",
			".lvclass",
			".lvlib",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/xml",
		TMScope:        "text.xml",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     194,
	},
	758480799: LanguageInfo{
		Name:    "Lark",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#2980B9",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".lark",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-ebnf",
		TMScope:        "source.lark",
		AceMode:        "text",
		CodeMirrorMode: "ebnf",
		Wrap:           false,
		LanguageID:     758480799,
	},
	195: LanguageInfo{
		Name:   "Lasso",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#999999",
		Group:  "",
		Aliases: []string{
			"lassoscript",
		},
		Extensions: []string{
			".lasso",
			".las",
			".lasso8",
			".lasso9",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "file.lasso",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     195,
	},
	196: LanguageInfo{
		Name:    "Latte",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#f2a542",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".latte",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-smarty",
		TMScope:        "text.html.smarty",
		AceMode:        "smarty",
		CodeMirrorMode: "smarty",
		Wrap:           false,
		LanguageID:     196,
	},
	197: LanguageInfo{
		Name:    "Lean",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".lean",
			".hlean",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.lean",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     197,
	},
	455147478: LanguageInfo{
		Name:    "Lean 4",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "Lean",
		Aliases: []string{},
		Extensions: []string{
			".lean",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.lean4",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     455147478,
	},
	198: LanguageInfo{
		Name:   "Less",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#1d365d",
		Group:  "",
		Aliases: []string{
			"less-css",
		},
		Extensions: []string{
			".less",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/css",
		TMScope:        "source.css.less",
		AceMode:        "less",
		CodeMirrorMode: "css",
		Wrap:           false,
		LanguageID:     198,
	},
	199: LanguageInfo{
		Name:   "Lex",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#DBCA00",
		Group:  "",
		Aliases: []string{
			"flex",
		},
		Extensions: []string{
			".l",
			".lex",
		},
		Interpreters: []string{},
		Filenames: []string{
			"Lexer.x",
			"lexer.x",
		},
		MimeType:       "",
		TMScope:        "source.lex",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     199,
	},
	1040646257: LanguageInfo{
		Name:    "LigoLANG",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0e74ff",
		Group:   "LigoLANG",
		Aliases: []string{},
		Extensions: []string{
			".ligo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-pascal",
		TMScope:        "source.ligo",
		AceMode:        "pascal",
		CodeMirrorMode: "pascal",
		Wrap:           false,
		LanguageID:     1040646257,
	},
	200: LanguageInfo{
		Name:    "LilyPond",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#9ccc7c",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ly",
			".ily",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.lilypond",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     200,
	},
	201: LanguageInfo{
		Name:    "Limbo",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".b",
			".m",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     201,
	},
	202: LanguageInfo{
		Name:    "Linker Script",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ld",
			".lds",
			".x",
		},
		Interpreters: []string{},
		Filenames: []string{
			"ld.script",
		},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     202,
	},
	203: LanguageInfo{
		Name:    "Linux Kernel Module",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mod",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     203,
	},
	204: LanguageInfo{
		Name:    "Liquid",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#67b8de",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".liquid",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.liquid",
		AceMode:        "liquid",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     204,
	},
	205: LanguageInfo{
		Name:    "Literate Agda",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#315665",
		Group:   "Agda",
		Aliases: []string{},
		Extensions: []string{
			".lagda",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     205,
	},
	206: LanguageInfo{
		Name:   "Literate CoffeeScript",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#244776",
		Group:  "CoffeeScript",
		Aliases: []string{
			"litcoffee",
		},
		Extensions: []string{
			".litcoffee",
			".coffee.md",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.litcoffee",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     206,
	},
	207: LanguageInfo{
		Name:   "Literate Haskell",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#5e5086",
		Group:  "Haskell",
		Aliases: []string{
			"lhaskell",
			"lhs",
		},
		Extensions: []string{
			".lhs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-literate-haskell",
		TMScope:        "text.tex.latex.haskell",
		AceMode:        "text",
		CodeMirrorMode: "haskell-literate",
		Wrap:           false,
		LanguageID:     207,
	},
	891017: LanguageInfo{
		Name:    "LiveCode Script",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0c5ba5",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".livecodescript",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.livecodescript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     891017,
	},
	208: LanguageInfo{
		Name:   "LiveScript",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#499886",
		Group:  "",
		Aliases: []string{
			"live-script",
			"ls",
		},
		Extensions: []string{
			".ls",
			"._ls",
		},
		Interpreters: []string{},
		Filenames: []string{
			"Slakefile",
		},
		MimeType:       "text/x-livescript",
		TMScope:        "source.livescript",
		AceMode:        "livescript",
		CodeMirrorMode: "livescript",
		Wrap:           false,
		LanguageID:     208,
	},
	209: LanguageInfo{
		Name:    "Logos",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".xm",
			".x",
			".xi",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.logos",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     209,
	},
	210: LanguageInfo{
		Name:    "Logtalk",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#295b9a",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".lgt",
			".logtalk",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.logtalk",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     210,
	},
	211: LanguageInfo{
		Name:    "LookML",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#652B81",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".lkml",
			".lookml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-yaml",
		TMScope:        "source.yaml",
		AceMode:        "yaml",
		CodeMirrorMode: "yaml",
		Wrap:           false,
		LanguageID:     211,
	},
	212: LanguageInfo{
		Name:    "LoomScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ls",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.loomscript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     212,
	},
	213: LanguageInfo{
		Name:    "Lua",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#000080",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".lua",
			".fcgi",
			".nse",
			".p8",
			".pd_lua",
			".rbxs",
			".rockspec",
			".wlua",
		},
		Interpreters: []string{
			"lua",
		},
		Filenames: []string{
			".luacheckrc",
		},
		MimeType:       "text/x-lua",
		TMScope:        "source.lua",
		AceMode:        "lua",
		CodeMirrorMode: "lua",
		Wrap:           false,
		LanguageID:     213,
	},
	365050359: LanguageInfo{
		Name:    "Luau",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00A2FF",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".luau",
		},
		Interpreters: []string{
			"luau",
		},
		Filenames:      []string{},
		MimeType:       "text/x-lua",
		TMScope:        "source.luau",
		AceMode:        "lua",
		CodeMirrorMode: "lua",
		Wrap:           false,
		LanguageID:     365050359,
	},
	214: LanguageInfo{
		Name:   "M",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"mumps",
		},
		Extensions: []string{
			".mumps",
			".m",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-mumps",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "mumps",
		Wrap:           false,
		LanguageID:     214,
	},
	215: LanguageInfo{
		Name:    "M4",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".m4",
			".mc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.m4",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     215,
	},
	216: LanguageInfo{
		Name:   "M4Sugar",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "M4",
		Aliases: []string{
			"autoconf",
		},
		Extensions: []string{
			".m4",
		},
		Interpreters: []string{},
		Filenames: []string{
			"configure.ac",
		},
		MimeType:       "",
		TMScope:        "source.m4",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     216,
	},
	225: LanguageInfo{
		Name:   "MATLAB",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#e16737",
		Group:  "",
		Aliases: []string{
			"octave",
		},
		Extensions: []string{
			".matlab",
			".m",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-octave",
		TMScope:        "source.matlab",
		AceMode:        "matlab",
		CodeMirrorMode: "octave",
		Wrap:           false,
		LanguageID:     225,
	},
	217: LanguageInfo{
		Name:    "MAXScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00a6a6",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ms",
			".mcr",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.maxscript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     217,
	},
	512838272: LanguageInfo{
		Name:    "MDX",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#fcb32c",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mdx",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-gfm",
		TMScope:        "source.mdx",
		AceMode:        "markdown",
		CodeMirrorMode: "gfm",
		Wrap:           true,
		LanguageID:     512838272,
	},
	448253929: LanguageInfo{
		Name:    "MLIR",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#5EC8DB",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mlir",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.mlir",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     448253929,
	},
	426: LanguageInfo{
		Name:    "MQL4",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#62A8D6",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mq4",
			".mqh",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.mql5",
		AceMode:        "c_cpp",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     426,
	},
	427: LanguageInfo{
		Name:    "MQL5",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#4A76B8",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mq5",
			".mqh",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.mql5",
		AceMode:        "c_cpp",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     427,
	},
	218: LanguageInfo{
		Name:    "MTML",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#b7e1f4",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mtml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/html",
		TMScope:        "text.html.basic",
		AceMode:        "html",
		CodeMirrorMode: "htmlmixed",
		Wrap:           false,
		LanguageID:     218,
	},
	219: LanguageInfo{
		Name:    "MUF",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "Forth",
		Aliases: []string{},
		Extensions: []string{
			".muf",
			".m",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-forth",
		TMScope:        "none",
		AceMode:        "forth",
		CodeMirrorMode: "forth",
		Wrap:           false,
		LanguageID:     219,
	},
	34167825: LanguageInfo{
		Name:   "Macaulay2",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#d8ffff",
		Group:  "",
		Aliases: []string{
			"m2",
		},
		Extensions: []string{
			".m2",
		},
		Interpreters: []string{
			"M2",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.m2",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     34167825,
	},
	220: LanguageInfo{
		Name:   "Makefile",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#427819",
		Group:  "",
		Aliases: []string{
			"bsdmake",
			"make",
			"mf",
		},
		Extensions: []string{
			".mak",
			".d",
			".make",
			".makefile",
			".mk",
			".mkfile",
		},
		Interpreters: []string{
			"make",
		},
		Filenames: []string{
			"BSDmakefile",
			"GNUmakefile",
			"Kbuild",
			"Makefile",
			"Makefile.am",
			"Makefile.boot",
			"Makefile.frag",
			"Makefile.in",
			"Makefile.inc",
			"Makefile.wat",
			"makefile",
			"makefile.sco",
			"mkfile",
		},
		MimeType:       "text/x-cmake",
		TMScope:        "source.makefile",
		AceMode:        "makefile",
		CodeMirrorMode: "cmake",
		Wrap:           false,
		LanguageID:     220,
	},
	221: LanguageInfo{
		Name:    "Mako",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#7e858d",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mako",
			".mao",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.mako",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     221,
	},
	222: LanguageInfo{
		Name:   "Markdown",
		FSName: "",
		Type:   TypeForString("prose"),
		Color:  "#083fa1",
		Group:  "",
		Aliases: []string{
			"md",
			"pandoc",
		},
		Extensions: []string{
			".md",
			".livemd",
			".markdown",
			".mdown",
			".mdwn",
			".mkd",
			".mkdn",
			".mkdown",
			".ronn",
			".scd",
			".workbook",
		},
		Interpreters: []string{},
		Filenames: []string{
			"contents.lr",
		},
		MimeType:       "text/x-gfm",
		TMScope:        "text.md",
		AceMode:        "markdown",
		CodeMirrorMode: "gfm",
		Wrap:           true,
		LanguageID:     222,
	},
	932782397: LanguageInfo{
		Name:   "Marko",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#42bff2",
		Group:  "",
		Aliases: []string{
			"markojs",
		},
		Extensions: []string{
			".marko",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/html",
		TMScope:        "text.marko",
		AceMode:        "text",
		CodeMirrorMode: "htmlmixed",
		Wrap:           false,
		LanguageID:     932782397,
	},
	223: LanguageInfo{
		Name:    "Mask",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#f97732",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mask",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.mask",
		AceMode:        "mask",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     223,
	},
	224: LanguageInfo{
		Name:   "Mathematica",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#dd1100",
		Group:  "",
		Aliases: []string{
			"mma",
			"wolfram",
			"wolfram language",
			"wolfram lang",
			"wl",
		},
		Extensions: []string{
			".mathematica",
			".cdf",
			".m",
			".ma",
			".mt",
			".nb",
			".nbp",
			".wl",
			".wlt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-mathematica",
		TMScope:        "source.mathematica",
		AceMode:        "text",
		CodeMirrorMode: "mathematica",
		Wrap:           false,
		LanguageID:     224,
	},
	226: LanguageInfo{
		Name:         "Maven POM",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "",
		Group:        "XML",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"pom.xml",
		},
		MimeType:       "text/xml",
		TMScope:        "text.xml.pom",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     226,
	},
	227: LanguageInfo{
		Name:   "Max",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#c4a79c",
		Group:  "",
		Aliases: []string{
			"max/msp",
			"maxmsp",
		},
		Extensions: []string{
			".maxpat",
			".maxhelp",
			".maxproj",
			".mxt",
			".pat",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/json",
		TMScope:        "source.json",
		AceMode:        "json",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     227,
	},
	229: LanguageInfo{
		Name:    "Mercury",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ff2b2b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".m",
			".moo",
		},
		Interpreters: []string{
			"mmi",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.mercury",
		AceMode:        "prolog",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     229,
	},
	385992043: LanguageInfo{
		Name:   "Mermaid",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#ff3670",
		Group:  "",
		Aliases: []string{
			"mermaid example",
		},
		Extensions: []string{
			".mmd",
			".mermaid",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.mermaid",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     385992043,
	},
	799141244: LanguageInfo{
		Name:         "Meson",
		FSName:       "",
		Type:         TypeForString("programming"),
		Color:        "#007800",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"meson.build",
			"meson_options.txt",
		},
		MimeType:       "",
		TMScope:        "source.meson",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     799141244,
	},
	230: LanguageInfo{
		Name:    "Metal",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#8f14e9",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".metal",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-c++src",
		TMScope:        "source.c++",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     230,
	},
	800983837: LanguageInfo{
		Name:    "Microsoft Developer Studio Project",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dsp",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     800983837,
	},
	849523096: LanguageInfo{
		Name:    "Microsoft Visual Studio Solution",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sln",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.solution",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     849523096,
	},
	231: LanguageInfo{
		Name:    "MiniD",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".minid",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     231,
	},
	4896465: LanguageInfo{
		Name:    "MiniYAML",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#ff1111",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".yaml",
			".yml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-yaml",
		TMScope:        "source.miniyaml",
		AceMode:        "yaml",
		CodeMirrorMode: "yaml",
		Wrap:           false,
		LanguageID:     4896465,
	},
	968740319: LanguageInfo{
		Name:    "Mint",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#02b046",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mint",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.mint",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     968740319,
	},
	232: LanguageInfo{
		Name:    "Mirah",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#c7a938",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".druby",
			".duby",
			".mirah",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-ruby",
		TMScope:        "source.ruby",
		AceMode:        "ruby",
		CodeMirrorMode: "ruby",
		Wrap:           false,
		LanguageID:     232,
	},
	233: LanguageInfo{
		Name:    "Modelica",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#de1d31",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-modelica",
		TMScope:        "source.modelica",
		AceMode:        "text",
		CodeMirrorMode: "modelica",
		Wrap:           false,
		LanguageID:     233,
	},
	234: LanguageInfo{
		Name:    "Modula-2",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#10253f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mod",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.modula2",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     234,
	},
	564743864: LanguageInfo{
		Name:    "Modula-3",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#223388",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".i3",
			".ig",
			".m3",
			".mg",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.modula-3",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     564743864,
	},
	235: LanguageInfo{
		Name:    "Module Management System",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mms",
			".mmk",
		},
		Interpreters: []string{},
		Filenames: []string{
			"descrip.mmk",
			"descrip.mms",
		},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     235,
	},
	1045019587: LanguageInfo{
		Name:    "Mojo",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ff4c1f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mojo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-python",
		TMScope:        "source.mojo",
		AceMode:        "python",
		CodeMirrorMode: "python",
		Wrap:           false,
		LanguageID:     1045019587,
	},
	236: LanguageInfo{
		Name:    "Monkey",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".monkey",
			".monkey2",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.monkey",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     236,
	},
	231751931: LanguageInfo{
		Name:    "Monkey C",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#8D6747",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.mc",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     231751931,
	},
	237: LanguageInfo{
		Name:    "Moocode",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".moo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     237,
	},
	181453007: LanguageInfo{
		Name:    "MoonBit",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#b92381",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mbt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.moonbit",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     181453007,
	},
	238: LanguageInfo{
		Name:    "MoonScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ff4585",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".moon",
		},
		Interpreters: []string{
			"moon",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.moonscript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     238,
	},
	202937027: LanguageInfo{
		Name:    "Motoko",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#fbb03b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.mo",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     202937027,
	},
	477582706: LanguageInfo{
		Name:   "Motorola 68K Assembly",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#005daa",
		Group:  "Assembly",
		Aliases: []string{
			"m68k",
		},
		Extensions: []string{
			".asm",
			".i",
			".inc",
			".s",
			".x68",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.m68k",
		AceMode:        "assembly_x86",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     477582706,
	},
	638334599: LanguageInfo{
		Name:    "Move",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#4a137a",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".move",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.move",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     638334599,
	},
	474864066: LanguageInfo{
		Name:   "Muse",
		FSName: "",
		Type:   TypeForString("prose"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"amusewiki",
			"emacs muse",
		},
		Extensions: []string{
			".muse",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.muse",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     474864066,
	},
	638334590: LanguageInfo{
		Name:    "Mustache",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#724b3b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mustache",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-smarty",
		TMScope:        "text.html.smarty",
		AceMode:        "smarty",
		CodeMirrorMode: "smarty",
		Wrap:           false,
		LanguageID:     638334590,
	},
	239: LanguageInfo{
		Name:    "Myghty",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".myt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     239,
	},
	171666519: LanguageInfo{
		Name:    "NASL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nasl",
			".inc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.nasl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     171666519,
	},
	240: LanguageInfo{
		Name:    "NCL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#28431f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ncl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ncl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     240,
	},
	481192983: LanguageInfo{
		Name:   "NEON",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"nette object notation",
			"ne-on",
		},
		Extensions: []string{
			".neon",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.neon",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     481192983,
	},
	241: LanguageInfo{
		Name:    "NL",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     241,
	},
	136456478: LanguageInfo{
		Name:    "NMODL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00356B",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mod",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     136456478,
	},
	685022663: LanguageInfo{
		Name:   "NPM Config",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#cb3837",
		Group:  "INI",
		Aliases: []string{
			"npmrc",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			".npmrc",
		},
		MimeType:       "",
		TMScope:        "source.ini.npmrc",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     685022663,
	},
	242: LanguageInfo{
		Name:    "NSIS",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nsi",
			".nsh",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-nsis",
		TMScope:        "source.nsis",
		AceMode:        "text",
		CodeMirrorMode: "nsis",
		Wrap:           false,
		LanguageID:     242,
	},
	731233819: LanguageInfo{
		Name:    "NWScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#111522",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nss",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.c.nwscript",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     731233819,
	},
	178322513: LanguageInfo{
		Name:    "Nasal",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#1d2c4e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nas",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.nasal",
		AceMode:        "nasal",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     178322513,
	},
	521429430: LanguageInfo{
		Name:    "Nearley",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#990000",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ne",
			".nearley",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ne",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     521429430,
	},
	243: LanguageInfo{
		Name:    "Nemerle",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3d3c6e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".n",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.nemerle",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     243,
	},
	244: LanguageInfo{
		Name:    "NetLinx",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0aa0ff",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".axs",
			".axi",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.netlinx",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     244,
	},
	245: LanguageInfo{
		Name:    "NetLinx+ERB",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#747faa",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".axs.erb",
			".axi.erb",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.netlinx.erb",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     245,
	},
	246: LanguageInfo{
		Name:    "NetLogo",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ff6375",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nlogo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-common-lisp",
		TMScope:        "source.lisp",
		AceMode:        "lisp",
		CodeMirrorMode: "commonlisp",
		Wrap:           false,
		LanguageID:     246,
	},
	247: LanguageInfo{
		Name:    "NewLisp",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#87AED7",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nl",
			".lisp",
			".lsp",
		},
		Interpreters: []string{
			"newlisp",
		},
		Filenames:      []string{},
		MimeType:       "text/x-common-lisp",
		TMScope:        "source.lisp",
		AceMode:        "lisp",
		CodeMirrorMode: "commonlisp",
		Wrap:           false,
		LanguageID:     247,
	},
	506780613: LanguageInfo{
		Name:    "Nextflow",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3ac486",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nf",
		},
		Interpreters: []string{
			"nextflow",
		},
		Filenames: []string{
			"nextflow.config",
		},
		MimeType:       "",
		TMScope:        "source.nextflow",
		AceMode:        "groovy",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     506780613,
	},
	248: LanguageInfo{
		Name:   "Nginx",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#009639",
		Group:  "",
		Aliases: []string{
			"nginx configuration file",
		},
		Extensions: []string{
			".nginx",
			".nginxconf",
			".vhost",
		},
		Interpreters: []string{},
		Filenames: []string{
			"nginx.conf",
		},
		MimeType:       "text/x-nginx-conf",
		TMScope:        "source.nginx",
		AceMode:        "text",
		CodeMirrorMode: "nginx",
		Wrap:           false,
		LanguageID:     248,
	},
	249: LanguageInfo{
		Name:    "Nim",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ffc200",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nim",
			".nim.cfg",
			".nimble",
			".nimrod",
			".nims",
		},
		Interpreters: []string{},
		Filenames: []string{
			"nim.cfg",
		},
		MimeType:       "",
		TMScope:        "source.nim",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     249,
	},
	250: LanguageInfo{
		Name:    "Ninja",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ninja",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ninja",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     250,
	},
	251: LanguageInfo{
		Name:    "Nit",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#009917",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nit",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.nit",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     251,
	},
	252: LanguageInfo{
		Name:   "Nix",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#7e7eff",
		Group:  "",
		Aliases: []string{
			"nixos",
		},
		Extensions: []string{
			".nix",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.nix",
		AceMode:        "nix",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     252,
	},
	813068465: LanguageInfo{
		Name:   "Noir",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#2f1f49",
		Group:  "",
		Aliases: []string{
			"nargo",
		},
		Extensions: []string{
			".nr",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-rustsrc",
		TMScope:        "source.nr",
		AceMode:        "rust",
		CodeMirrorMode: "rust",
		Wrap:           false,
		LanguageID:     813068465,
	},
	253: LanguageInfo{
		Name:   "Nu",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#c9df40",
		Group:  "",
		Aliases: []string{
			"nush",
		},
		Extensions: []string{
			".nu",
		},
		Interpreters: []string{
			"nush",
		},
		Filenames: []string{
			"Nukefile",
		},
		MimeType:       "text/x-scheme",
		TMScope:        "source.nu",
		AceMode:        "scheme",
		CodeMirrorMode: "scheme",
		Wrap:           false,
		LanguageID:     253,
	},
	254: LanguageInfo{
		Name:    "NumPy",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#9C8AF9",
		Group:   "Python",
		Aliases: []string{},
		Extensions: []string{
			".numpy",
			".numpyw",
			".numsc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-python",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "python",
		Wrap:           false,
		LanguageID:     254,
	},
	461856962: LanguageInfo{
		Name:   "Nunjucks",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#3d8137",
		Group:  "",
		Aliases: []string{
			"njk",
		},
		Extensions: []string{
			".njk",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.nunjucks",
		AceMode:        "nunjucks",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     461856962,
	},
	446573572: LanguageInfo{
		Name:   "Nushell",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#4E9906",
		Group:  "",
		Aliases: []string{
			"nu-script",
			"nushell-script",
		},
		Extensions: []string{
			".nu",
		},
		Interpreters: []string{
			"nu",
		},
		Filenames:      []string{},
		MimeType:       "text/x-sh",
		TMScope:        "source.nushell",
		AceMode:        "sh",
		CodeMirrorMode: "shell",
		Wrap:           false,
		LanguageID:     446573572,
	},
	834374816: LanguageInfo{
		Name:    "OASv2-json",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#85ea2d",
		Group:   "OpenAPI Specification v2",
		Aliases: []string{},
		Extensions: []string{
			".json",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/json",
		TMScope:        "source.json",
		AceMode:        "json",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     834374816,
	},
	105187618: LanguageInfo{
		Name:    "OASv2-yaml",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#85ea2d",
		Group:   "OpenAPI Specification v2",
		Aliases: []string{},
		Extensions: []string{
			".yaml",
			".yml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-yaml",
		TMScope:        "source.yaml",
		AceMode:        "yaml",
		CodeMirrorMode: "yaml",
		Wrap:           false,
		LanguageID:     105187618,
	},
	980062566: LanguageInfo{
		Name:    "OASv3-json",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#85ea2d",
		Group:   "OpenAPI Specification v3",
		Aliases: []string{},
		Extensions: []string{
			".json",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/json",
		TMScope:        "source.json",
		AceMode:        "json",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     980062566,
	},
	51239111: LanguageInfo{
		Name:    "OASv3-yaml",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#85ea2d",
		Group:   "OpenAPI Specification v3",
		Aliases: []string{},
		Extensions: []string{
			".yaml",
			".yml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-yaml",
		TMScope:        "source.yaml",
		AceMode:        "yaml",
		CodeMirrorMode: "yaml",
		Wrap:           false,
		LanguageID:     51239111,
	},
	255: LanguageInfo{
		Name:    "OCaml",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ef7a08",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ml",
			".eliom",
			".eliomi",
			".ml4",
			".mli",
			".mll",
			".mly",
		},
		Interpreters: []string{
			"ocaml",
			"ocamlrun",
			"ocamlscript",
		},
		Filenames:      []string{},
		MimeType:       "text/x-ocaml",
		TMScope:        "source.ocaml",
		AceMode:        "ocaml",
		CodeMirrorMode: "mllike",
		Wrap:           false,
		LanguageID:     255,
	},
	677210597: LanguageInfo{
		Name:    "Oberon",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ob2",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.modula2",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     677210597,
	},
	256: LanguageInfo{
		Name:    "ObjDump",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".objdump",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "objdump.x86asm",
		AceMode:        "assembly_x86",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     256,
	},
	985227236: LanguageInfo{
		Name:    "Object Data Instance Notation",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".odin",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.odin-ehr",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     985227236,
	},
	202735509: LanguageInfo{
		Name:    "ObjectScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#424893",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cls",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.objectscript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     202735509,
	},
	257: LanguageInfo{
		Name:   "Objective-C",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#438eff",
		Group:  "",
		Aliases: []string{
			"obj-c",
			"objc",
			"objectivec",
		},
		Extensions: []string{
			".m",
			".h",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-objectivec",
		TMScope:        "source.objc",
		AceMode:        "objectivec",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     257,
	},
	258: LanguageInfo{
		Name:   "Objective-C++",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#6866fb",
		Group:  "",
		Aliases: []string{
			"obj-c++",
			"objc++",
			"objectivec++",
		},
		Extensions: []string{
			".mm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-objectivec",
		TMScope:        "source.objc++",
		AceMode:        "objectivec",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     258,
	},
	259: LanguageInfo{
		Name:   "Objective-J",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#ff0c5a",
		Group:  "",
		Aliases: []string{
			"obj-j",
			"objectivej",
			"objj",
		},
		Extensions: []string{
			".j",
			".sj",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.js.objj",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     259,
	},
	889244082: LanguageInfo{
		Name:   "Odin",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#60AFFE",
		Group:  "",
		Aliases: []string{
			"odinlang",
			"odin-lang",
		},
		Extensions: []string{
			".odin",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.odin",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     889244082,
	},
	260: LanguageInfo{
		Name:    "Omgrofl",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#cabbff",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".omgrofl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     260,
	},
	261: LanguageInfo{
		Name:    "Opa",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".opa",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.opa",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     261,
	},
	262: LanguageInfo{
		Name:    "Opal",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#f7ede0",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".opal",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.opal",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     262,
	},
	840483232: LanguageInfo{
		Name:    "Open Policy Agent",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#7d9199",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".rego",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.rego",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     840483232,
	},
	848295328: LanguageInfo{
		Name:   "OpenAPI Specification v2",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#85ea2d",
		Group:  "",
		Aliases: []string{
			"oasv2",
		},
		Extensions:     []string{},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     848295328,
	},
	557959099: LanguageInfo{
		Name:   "OpenAPI Specification v3",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#85ea2d",
		Group:  "",
		Aliases: []string{
			"oasv3",
		},
		Extensions:     []string{},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     557959099,
	},
	263: LanguageInfo{
		Name:    "OpenCL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ed2e2d",
		Group:   "C",
		Aliases: []string{},
		Extensions: []string{
			".cl",
			".opencl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.c",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     263,
	},
	264: LanguageInfo{
		Name:   "OpenEdge ABL",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#5ce600",
		Group:  "",
		Aliases: []string{
			"progress",
			"openedge",
			"abl",
		},
		Extensions: []string{
			".p",
			".cls",
			".w",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.abl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     264,
	},
	153739399: LanguageInfo{
		Name:    "OpenQASM",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#AA70FF",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".qasm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.qasm",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     153739399,
	},
	265: LanguageInfo{
		Name:   "OpenRC runscript",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "Shell",
		Aliases: []string{
			"openrc",
		},
		Extensions: []string{},
		Interpreters: []string{
			"openrc-run",
		},
		Filenames:      []string{},
		MimeType:       "text/x-sh",
		TMScope:        "source.shell",
		AceMode:        "sh",
		CodeMirrorMode: "shell",
		Wrap:           false,
		LanguageID:     265,
	},
	266: LanguageInfo{
		Name:    "OpenSCAD",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#e5cd45",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".scad",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.scad",
		AceMode:        "scad",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     266,
	},
	598917541: LanguageInfo{
		Name:    "OpenStep Property List",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".plist",
			".glyphs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.plist",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     598917541,
	},
	374317347: LanguageInfo{
		Name:   "OpenType Feature File",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"AFDKO",
		},
		Extensions: []string{
			".fea",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.opentype",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     374317347,
	},
	723589315: LanguageInfo{
		Name:   "Option List",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#476732",
		Group:  "",
		Aliases: []string{
			"opts",
			"ackrc",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			".ackrc",
			".rspec",
			".yardopts",
			"ackrc",
			"mocha.opts",
		},
		MimeType:       "text/x-sh",
		TMScope:        "source.opts",
		AceMode:        "sh",
		CodeMirrorMode: "shell",
		Wrap:           false,
		LanguageID:     723589315,
	},
	267: LanguageInfo{
		Name:    "Org",
		FSName:  "",
		Type:    TypeForString("prose"),
		Color:   "#77aa99",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".org",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     267,
	},
	268: LanguageInfo{
		Name:    "Ox",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ox",
			".oxh",
			".oxo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ox",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     268,
	},
	269: LanguageInfo{
		Name:    "Oxygene",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#cdd0e3",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".oxygene",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     269,
	},
	270: LanguageInfo{
		Name:    "Oz",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#fab738",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".oz",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-oz",
		TMScope:        "source.oz",
		AceMode:        "text",
		CodeMirrorMode: "oz",
		Wrap:           false,
		LanguageID:     270,
	},
	348895984: LanguageInfo{
		Name:    "P4",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#7055b5",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".p4",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.p4",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     348895984,
	},
	736235603: LanguageInfo{
		Name:    "PDDL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0d00ff",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pddl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pddl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     736235603,
	},
	81442128: LanguageInfo{
		Name:    "PEG.js",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#234d6b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pegjs",
			".peggy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/javascript",
		TMScope:        "source.peggy",
		AceMode:        "javascript",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     81442128,
	},
	272: LanguageInfo{
		Name:   "PHP",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#4F5D95",
		Group:  "",
		Aliases: []string{
			"inc",
		},
		Extensions: []string{
			".php",
			".aw",
			".ctp",
			".fcgi",
			".inc",
			".php3",
			".php4",
			".php5",
			".phps",
			".phpt",
		},
		Interpreters: []string{
			"php",
		},
		Filenames: []string{
			".php",
			".php_cs",
			".php_cs.dist",
			"Phakefile",
		},
		MimeType:       "application/x-httpd-php",
		TMScope:        "text.html.php",
		AceMode:        "php",
		CodeMirrorMode: "php",
		Wrap:           false,
		LanguageID:     272,
	},
	273: LanguageInfo{
		Name:    "PLSQL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#dad8d8",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pls",
			".bdy",
			".ddl",
			".fnc",
			".pck",
			".pkb",
			".pks",
			".plb",
			".plsql",
			".prc",
			".spc",
			".sql",
			".tpb",
			".tps",
			".trg",
			".vw",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-plsql",
		TMScope:        "none",
		AceMode:        "sql",
		CodeMirrorMode: "sql",
		Wrap:           false,
		LanguageID:     273,
	},
	274: LanguageInfo{
		Name:    "PLpgSQL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#336790",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pgsql",
			".sql",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-sql",
		TMScope:        "source.sql",
		AceMode:        "pgsql",
		CodeMirrorMode: "sql",
		Wrap:           false,
		LanguageID:     274,
	},
	275: LanguageInfo{
		Name:   "POV-Ray SDL",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#6bac65",
		Group:  "",
		Aliases: []string{
			"pov-ray",
			"povray",
		},
		Extensions: []string{
			".pov",
			".inc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pov-ray sdl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     275,
	},
	756774415: LanguageInfo{
		Name:    "Pact",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#F7A8B8",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pact",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pact",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     756774415,
	},
	276: LanguageInfo{
		Name:    "Pan",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#cc0000",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pan",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pan",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     276,
	},
	277: LanguageInfo{
		Name:    "Papyrus",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#6600cc",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".psc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.papyrus.skyrim",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     277,
	},
	278: LanguageInfo{
		Name:    "Parrot",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#f3ca0a",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".parrot",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     278,
	},
	279: LanguageInfo{
		Name:   "Parrot Assembly",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "Parrot",
		Aliases: []string{
			"pasm",
		},
		Extensions: []string{
			".pasm",
		},
		Interpreters: []string{
			"parrot",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     279,
	},
	280: LanguageInfo{
		Name:   "Parrot Internal Representation",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "Parrot",
		Aliases: []string{
			"pir",
		},
		Extensions: []string{
			".pir",
		},
		Interpreters: []string{
			"parrot",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.parrot.pir",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     280,
	},
	281: LanguageInfo{
		Name:   "Pascal",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#E3F171",
		Group:  "",
		Aliases: []string{
			"delphi",
			"objectpascal",
		},
		Extensions: []string{
			".pas",
			".dfm",
			".dpr",
			".inc",
			".lpr",
			".pascal",
			".pp",
		},
		Interpreters: []string{
			"instantfpc",
		},
		Filenames:      []string{},
		MimeType:       "text/x-pascal",
		TMScope:        "source.pascal",
		AceMode:        "pascal",
		CodeMirrorMode: "pascal",
		Wrap:           false,
		LanguageID:     281,
	},
	271: LanguageInfo{
		Name:    "Pawn",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#dbb284",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pwn",
			".inc",
			".sma",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pawn",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     271,
	},
	840372442: LanguageInfo{
		Name:    "Pep8",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#C76F5B",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pep",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pep8",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     840372442,
	},
	282: LanguageInfo{
		Name:   "Perl",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#0298c3",
		Group:  "",
		Aliases: []string{
			"cperl",
		},
		Extensions: []string{
			".pl",
			".al",
			".cgi",
			".fcgi",
			".perl",
			".ph",
			".plx",
			".pm",
			".psgi",
			".t",
		},
		Interpreters: []string{
			"cperl",
			"perl",
		},
		Filenames: []string{
			".latexmkrc",
			"Makefile.PL",
			"Rexfile",
			"ack",
			"cpanfile",
			"latexmkrc",
		},
		MimeType:       "text/x-perl",
		TMScope:        "source.perl",
		AceMode:        "perl",
		CodeMirrorMode: "perl",
		Wrap:           false,
		LanguageID:     282,
	},
	425: LanguageInfo{
		Name:   "Pic",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "",
		Group:  "Roff",
		Aliases: []string{
			"pikchr",
		},
		Extensions: []string{
			".pic",
			".chem",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/troff",
		TMScope:        "source.pic",
		AceMode:        "text",
		CodeMirrorMode: "troff",
		Wrap:           false,
		LanguageID:     425,
	},
	284: LanguageInfo{
		Name:    "Pickle",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pkl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     284,
	},
	285: LanguageInfo{
		Name:    "PicoLisp",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#6067af",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".l",
		},
		Interpreters: []string{
			"picolisp",
			"pil",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.lisp",
		AceMode:        "lisp",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     285,
	},
	286: LanguageInfo{
		Name:    "PigLatin",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#fcd7de",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pig",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pig_latin",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     286,
	},
	287: LanguageInfo{
		Name:    "Pike",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#005390",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pike",
			".pmod",
		},
		Interpreters: []string{
			"pike",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pike",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     287,
	},
	684385621: LanguageInfo{
		Name:         "Pip Requirements",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "#FFD343",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"requirements-dev.txt",
			"requirements.txt",
		},
		MimeType:       "",
		TMScope:        "source.pip-requirements",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     684385621,
	},
	288822799: LanguageInfo{
		Name:    "Pkl",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#6b9543",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pkl",
		},
		Interpreters: []string{
			"pkl",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pkl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     288822799,
	},
	833504686: LanguageInfo{
		Name:    "PlantUML",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#fbbd16",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".puml",
			".iuml",
			".plantuml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.wsd",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     833504686,
	},
	288: LanguageInfo{
		Name:    "Pod",
		FSName:  "",
		Type:    TypeForString("prose"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pod",
		},
		Interpreters: []string{
			"perl",
		},
		Filenames:      []string{},
		MimeType:       "text/x-perl",
		TMScope:        "none",
		AceMode:        "perl",
		CodeMirrorMode: "perl",
		Wrap:           true,
		LanguageID:     288,
	},
	155357471: LanguageInfo{
		Name:    "Pod 6",
		FSName:  "",
		Type:    TypeForString("prose"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pod",
			".pod6",
		},
		Interpreters: []string{
			"perl6",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.raku",
		AceMode:        "perl",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     155357471,
	},
	289: LanguageInfo{
		Name:    "PogoScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#d80074",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pogo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pogoscript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     289,
	},
	839112914: LanguageInfo{
		Name:    "Polar",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ae81ff",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".polar",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.polar",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     839112914,
	},
	290: LanguageInfo{
		Name:    "Pony",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pony",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.pony",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     290,
	},
	832391833: LanguageInfo{
		Name:    "Portugol",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#f8bd00",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".por",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.portugol",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     832391833,
	},
	262764437: LanguageInfo{
		Name:    "PostCSS",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#dc3a0c",
		Group:   "CSS",
		Aliases: []string{},
		Extensions: []string{
			".pcss",
			".postcss",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.postcss",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     262764437,
	},
	291: LanguageInfo{
		Name:   "PostScript",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#da291c",
		Group:  "",
		Aliases: []string{
			"postscr",
		},
		Extensions: []string{
			".ps",
			".eps",
			".epsi",
			".pfa",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.postscript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     291,
	},
	292: LanguageInfo{
		Name:    "PowerBuilder",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#8f0f8d",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pbt",
			".sra",
			".sru",
			".srw",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.powerbuilder",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     292,
	},
	293: LanguageInfo{
		Name:   "PowerShell",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#012456",
		Group:  "",
		Aliases: []string{
			"posh",
			"pwsh",
		},
		Extensions: []string{
			".ps1",
			".psd1",
			".psm1",
		},
		Interpreters: []string{
			"pwsh",
		},
		Filenames:      []string{},
		MimeType:       "application/x-powershell",
		TMScope:        "source.powershell",
		AceMode:        "powershell",
		CodeMirrorMode: "powershell",
		Wrap:           false,
		LanguageID:     293,
	},
	106029007: LanguageInfo{
		Name:    "Praat",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#c8506d",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".praat",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.praat",
		AceMode:        "praat",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     106029007,
	},
	499933428: LanguageInfo{
		Name:    "Prisma",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#0c344b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".prisma",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.prisma",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     499933428,
	},
	294: LanguageInfo{
		Name:    "Processing",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0096D8",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pde",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.processing",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     294,
	},
	305313959: LanguageInfo{
		Name:         "Procfile",
		FSName:       "",
		Type:         TypeForString("programming"),
		Color:        "#3B2F63",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"Procfile",
		},
		MimeType:       "",
		TMScope:        "source.procfile",
		AceMode:        "batchfile",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     305313959,
	},
	716513858: LanguageInfo{
		Name:    "Proguard",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pro",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     716513858,
	},
	295: LanguageInfo{
		Name:    "Prolog",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#74283c",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pl",
			".plt",
			".pro",
			".prolog",
			".yap",
		},
		Interpreters: []string{
			"swipl",
			"yap",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.prolog",
		AceMode:        "prolog",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     295,
	},
	441858312: LanguageInfo{
		Name:    "Promela",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#de0000",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.promela",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     441858312,
	},
	296: LanguageInfo{
		Name:    "Propeller Spin",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#7fa2a7",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".spin",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.spin",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     296,
	},
	297: LanguageInfo{
		Name:   "Protocol Buffer",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"proto",
			"protobuf",
			"Protocol Buffers",
		},
		Extensions: []string{
			".proto",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-protobuf",
		TMScope:        "source.proto",
		AceMode:        "protobuf",
		CodeMirrorMode: "protobuf",
		Wrap:           false,
		LanguageID:     297,
	},
	436568854: LanguageInfo{
		Name:   "Protocol Buffer Text Format",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"text proto",
			"protobuf text format",
		},
		Extensions: []string{
			".textproto",
			".pbt",
			".pbtxt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.textproto",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     436568854,
	},
	298: LanguageInfo{
		Name:    "Public Key",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".asc",
			".pub",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/pgp",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "asciiarmor",
		Wrap:           false,
		LanguageID:     298,
	},
	179: LanguageInfo{
		Name:    "Pug",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#a86454",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".jade",
			".pug",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-pug",
		TMScope:        "text.jade",
		AceMode:        "jade",
		CodeMirrorMode: "pug",
		Wrap:           false,
		LanguageID:     179,
	},
	299: LanguageInfo{
		Name:    "Puppet",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#302B6D",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pp",
		},
		Interpreters: []string{},
		Filenames: []string{
			"Modulefile",
		},
		MimeType:       "text/x-puppet",
		TMScope:        "source.puppet",
		AceMode:        "text",
		CodeMirrorMode: "puppet",
		Wrap:           false,
		LanguageID:     299,
	},
	300: LanguageInfo{
		Name:    "Pure Data",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pd",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     300,
	},
	301: LanguageInfo{
		Name:    "PureBasic",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#5a6986",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pb",
			".pbi",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     301,
	},
	302: LanguageInfo{
		Name:    "PureScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#1D222D",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".purs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-haskell",
		TMScope:        "source.purescript",
		AceMode:        "haskell",
		CodeMirrorMode: "haskell",
		Wrap:           false,
		LanguageID:     302,
	},
	252961827: LanguageInfo{
		Name:    "Pyret",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ee1e10",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".arr",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.arr",
		AceMode:        "python",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     252961827,
	},
	303: LanguageInfo{
		Name:   "Python",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#3572A5",
		Group:  "",
		Aliases: []string{
			"python3",
			"rusthon",
		},
		Extensions: []string{
			".py",
			".cgi",
			".fcgi",
			".gyp",
			".gypi",
			".lmi",
			".py3",
			".pyde",
			".pyi",
			".pyp",
			".pyt",
			".pyw",
			".rpy",
			".spec",
			".tac",
			".wsgi",
			".xpy",
		},
		Interpreters: []string{
			"python",
			"python2",
			"python3",
			"py",
			"pypy",
			"pypy3",
		},
		Filenames: []string{
			".gclient",
			"DEPS",
			"SConscript",
			"SConstruct",
			"wscript",
		},
		MimeType:       "text/x-python",
		TMScope:        "source.python",
		AceMode:        "python",
		CodeMirrorMode: "python",
		Wrap:           false,
		LanguageID:     303,
	},
	428: LanguageInfo{
		Name:   "Python console",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#3572A5",
		Group:  "Python",
		Aliases: []string{
			"pycon",
		},
		Extensions:     []string{},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.python.console",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     428,
	},
	304: LanguageInfo{
		Name:    "Python traceback",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#3572A5",
		Group:   "Python",
		Aliases: []string{},
		Extensions: []string{
			".pytb",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.python.traceback",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     304,
	},
	697448245: LanguageInfo{
		Name:   "Q#",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#fed659",
		Group:  "",
		Aliases: []string{
			"qsharp",
		},
		Extensions: []string{
			".qs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.qsharp",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     697448245,
	},
	305: LanguageInfo{
		Name:    "QML",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#44a51c",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".qml",
			".qbs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.qml",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     305,
	},
	306: LanguageInfo{
		Name:    "QMake",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".pro",
			".pri",
		},
		Interpreters: []string{
			"qmake",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.qmake",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     306,
	},
	558193693: LanguageInfo{
		Name:    "Qt Script",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00b841",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".qs",
		},
		Interpreters: []string{},
		Filenames: []string{
			"installscript.qs",
			"toolchain_installscript.qs",
		},
		MimeType:       "text/javascript",
		TMScope:        "source.js",
		AceMode:        "javascript",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     558193693,
	},
	375265331: LanguageInfo{
		Name:         "Quake",
		FSName:       "",
		Type:         TypeForString("programming"),
		Color:        "#882233",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"m3makefile",
			"m3overrides",
		},
		MimeType:       "",
		TMScope:        "source.quake",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     375265331,
	},
	593107205: LanguageInfo{
		Name:   "QuickBASIC",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#008080",
		Group:  "",
		Aliases: []string{
			"qb",
			"qbasic",
			"qb64",
			"classic qbasic",
			"classic quickbasic",
		},
		Extensions: []string{
			".bas",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-vb",
		TMScope:        "source.QB64",
		AceMode:        "text",
		CodeMirrorMode: "vb",
		Wrap:           false,
		LanguageID:     593107205,
	},
	307: LanguageInfo{
		Name:   "R",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#198CE7",
		Group:  "",
		Aliases: []string{
			"Rscript",
			"splus",
		},
		Extensions: []string{
			".r",
			".rd",
			".rsx",
		},
		Interpreters: []string{
			"Rscript",
		},
		Filenames: []string{
			".Rprofile",
			"expr-dist",
		},
		MimeType:       "text/x-rsrc",
		TMScope:        "source.r",
		AceMode:        "r",
		CodeMirrorMode: "r",
		Wrap:           false,
		LanguageID:     307,
	},
	308: LanguageInfo{
		Name:    "RAML",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#77d9fb",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".raml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-yaml",
		TMScope:        "source.yaml",
		AceMode:        "yaml",
		CodeMirrorMode: "yaml",
		Wrap:           false,
		LanguageID:     308,
	},
	899227493: LanguageInfo{
		Name:    "RBS",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#701516",
		Group:   "Ruby",
		Aliases: []string{},
		Extensions: []string{
			".rbs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-ruby",
		TMScope:        "source.rbs",
		AceMode:        "ruby",
		CodeMirrorMode: "ruby",
		Wrap:           false,
		LanguageID:     899227493,
	},
	309: LanguageInfo{
		Name:    "RDoc",
		FSName:  "",
		Type:    TypeForString("prose"),
		Color:   "#701516",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".rdoc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.rdoc",
		AceMode:        "rdoc",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     309,
	},
	310: LanguageInfo{
		Name:    "REALbasic",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".rbbas",
			".rbfrm",
			".rbmnu",
			".rbres",
			".rbtbar",
			".rbuistate",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.vbnet",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     310,
	},
	311: LanguageInfo{
		Name:   "REXX",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#d90e09",
		Group:  "",
		Aliases: []string{
			"arexx",
		},
		Extensions: []string{
			".rexx",
			".pprx",
			".rex",
		},
		Interpreters: []string{
			"regina",
			"rexx",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.rexx",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     311,
	},
	313: LanguageInfo{
		Name:    "RMarkdown",
		FSName:  "",
		Type:    TypeForString("prose"),
		Color:   "#198ce7",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".qmd",
			".rmd",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-gfm",
		TMScope:        "text.md",
		AceMode:        "markdown",
		CodeMirrorMode: "gfm",
		Wrap:           true,
		LanguageID:     313,
	},
	587855233: LanguageInfo{
		Name:    "RON",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#a62c00",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ron",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ron",
		AceMode:        "rust",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     587855233,
	},
	1031374237: LanguageInfo{
		Name:   "RPC",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"rpcgen",
			"oncrpc",
			"xdr",
		},
		Extensions: []string{
			".x",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.c",
		AceMode:        "c_cpp",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     1031374237,
	},
	609977990: LanguageInfo{
		Name:   "RPGLE",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#2BDE21",
		Group:  "",
		Aliases: []string{
			"ile rpg",
			"sqlrpgle",
		},
		Extensions: []string{
			".rpgle",
			".sqlrpgle",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.rpgle",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     609977990,
	},
	314: LanguageInfo{
		Name:   "RPM Spec",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"specfile",
		},
		Extensions: []string{
			".spec",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-rpm-spec",
		TMScope:        "source.rpm-spec",
		AceMode:        "text",
		CodeMirrorMode: "rpm",
		Wrap:           false,
		LanguageID:     314,
	},
	315: LanguageInfo{
		Name:    "RUNOFF",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#665a4e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".rnh",
			".rno",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.runoff",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     315,
	},
	316: LanguageInfo{
		Name:    "Racket",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3c5caa",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".rkt",
			".rktd",
			".rktl",
			".scrbl",
		},
		Interpreters: []string{
			"racket",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.racket",
		AceMode:        "lisp",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     316,
	},
	317: LanguageInfo{
		Name:   "Ragel",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#9d5200",
		Group:  "",
		Aliases: []string{
			"ragel-rb",
			"ragel-ruby",
		},
		Extensions: []string{
			".rl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     317,
	},
	283: LanguageInfo{
		Name:   "Raku",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#0000fb",
		Group:  "",
		Aliases: []string{
			"perl6",
			"perl-6",
		},
		Extensions: []string{
			".6pl",
			".6pm",
			".nqp",
			".p6",
			".p6l",
			".p6m",
			".pl",
			".pl6",
			".pm",
			".pm6",
			".raku",
			".rakumod",
			".t",
		},
		Interpreters: []string{
			"perl6",
			"raku",
			"rakudo",
		},
		Filenames:      []string{},
		MimeType:       "text/x-perl",
		TMScope:        "source.raku",
		AceMode:        "perl",
		CodeMirrorMode: "perl",
		Wrap:           false,
		LanguageID:     283,
	},
	173616037: LanguageInfo{
		Name:    "Rascal",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#fffaa0",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".rsc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.rascal",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     173616037,
	},
	318: LanguageInfo{
		Name:   "Raw token data",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"raw",
		},
		Extensions: []string{
			".raw",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     318,
	},
	501875647: LanguageInfo{
		Name:    "ReScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ed5051",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".res",
		},
		Interpreters: []string{
			"ocaml",
		},
		Filenames:      []string{},
		MimeType:       "text/x-rustsrc",
		TMScope:        "source.rescript",
		AceMode:        "rust",
		CodeMirrorMode: "rust",
		Wrap:           false,
		LanguageID:     501875647,
	},
	538732839: LanguageInfo{
		Name:   "Readline Config",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "INI",
		Aliases: []string{
			"inputrc",
			"readline",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			".inputrc",
			"inputrc",
		},
		MimeType:       "",
		TMScope:        "source.inputrc",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     538732839,
	},
	869538413: LanguageInfo{
		Name:    "Reason",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ff5847",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".re",
			".rei",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-rustsrc",
		TMScope:        "source.reason",
		AceMode:        "rust",
		CodeMirrorMode: "rust",
		Wrap:           false,
		LanguageID:     869538413,
	},
	319002153: LanguageInfo{
		Name:    "ReasonLIGO",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ff5847",
		Group:   "LigoLANG",
		Aliases: []string{},
		Extensions: []string{
			".religo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-rustsrc",
		TMScope:        "source.religo",
		AceMode:        "rust",
		CodeMirrorMode: "rust",
		Wrap:           false,
		LanguageID:     319002153,
	},
	319: LanguageInfo{
		Name:    "Rebol",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#358a5b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".reb",
			".r",
			".r2",
			".r3",
			".rebol",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.rebol",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     319,
	},
	865765202: LanguageInfo{
		Name:         "Record Jar",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "#0673ba",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"language-subtag-registry.txt",
		},
		MimeType:       "text/x-properties",
		TMScope:        "source.record-jar",
		AceMode:        "text",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     865765202,
	},
	320: LanguageInfo{
		Name:   "Red",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#f50000",
		Group:  "",
		Aliases: []string{
			"red/system",
		},
		Extensions: []string{
			".red",
			".reds",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.red",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     320,
	},
	321: LanguageInfo{
		Name:    "Redcode",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".cw",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     321,
	},
	1020148948: LanguageInfo{
		Name:   "Redirect Rules",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"redirects",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"_redirects",
		},
		MimeType:       "",
		TMScope:        "source.redirects",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     1020148948,
	},
	363378884: LanguageInfo{
		Name:   "Regular Expression",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#009a00",
		Group:  "",
		Aliases: []string{
			"regexp",
			"regex",
		},
		Extensions: []string{
			".regexp",
			".regex",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.regexp",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     363378884,
	},
	322: LanguageInfo{
		Name:   "Ren'Py",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#ff7f7f",
		Group:  "",
		Aliases: []string{
			"renpy",
		},
		Extensions: []string{
			".rpy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.renpy",
		AceMode:        "python",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     322,
	},
	323: LanguageInfo{
		Name:    "RenderScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".rs",
			".rsh",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     323,
	},
	498022874: LanguageInfo{
		Name:    "Rez",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#FFDAB3",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".r",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.rez",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     498022874,
	},
	51601661: LanguageInfo{
		Name:    "Rich Text Format",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".rtf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.rtf",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     51601661,
	},
	431: LanguageInfo{
		Name:    "Ring",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#2D54CB",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ring",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ring",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     431,
	},
	878396783: LanguageInfo{
		Name:    "Riot",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#A71E49",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".riot",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.riot",
		AceMode:        "html",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     878396783,
	},
	324: LanguageInfo{
		Name:    "RobotFramework",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00c0b5",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".robot",
			".resource",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.robot",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     324,
	},
	440182480: LanguageInfo{
		Name:    "Roc",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#7c38f5",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".roc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.roc",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     440182480,
	},
	141: LanguageInfo{
		Name:   "Roff",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#ecdebe",
		Group:  "",
		Aliases: []string{
			"groff",
			"man",
			"manpage",
			"man page",
			"man-page",
			"mdoc",
			"nroff",
			"troff",
		},
		Extensions: []string{
			".roff",
			".1",
			".1in",
			".1m",
			".1x",
			".2",
			".3",
			".3in",
			".3m",
			".3p",
			".3pm",
			".3qt",
			".3x",
			".4",
			".5",
			".6",
			".7",
			".8",
			".9",
			".l",
			".man",
			".mdoc",
			".me",
			".ms",
			".n",
			".nr",
			".rno",
			".tmac",
		},
		Interpreters: []string{},
		Filenames: []string{
			"eqnrc",
			"mmn",
			"mmt",
			"troffrc",
			"troffrc-end",
		},
		MimeType:       "text/troff",
		TMScope:        "text.roff",
		AceMode:        "text",
		CodeMirrorMode: "troff",
		Wrap:           true,
		LanguageID:     141,
	},
	612669833: LanguageInfo{
		Name:    "Roff Manpage",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#ecdebe",
		Group:   "Roff",
		Aliases: []string{},
		Extensions: []string{
			".1",
			".1in",
			".1m",
			".1x",
			".2",
			".3",
			".3in",
			".3m",
			".3p",
			".3pm",
			".3qt",
			".3x",
			".4",
			".5",
			".6",
			".7",
			".8",
			".9",
			".man",
			".mdoc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/troff",
		TMScope:        "text.roff",
		AceMode:        "text",
		CodeMirrorMode: "troff",
		Wrap:           true,
		LanguageID:     612669833,
	},
	325: LanguageInfo{
		Name:    "Rouge",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#cc0088",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".rg",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-clojure",
		TMScope:        "source.clojure",
		AceMode:        "clojure",
		CodeMirrorMode: "clojure",
		Wrap:           false,
		LanguageID:     325,
	},
	592853203: LanguageInfo{
		Name:    "RouterOS Script",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#DE3941",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".rsc",
		},
		Interpreters: []string{
			"RouterOS",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     592853203,
	},
	326: LanguageInfo{
		Name:   "Ruby",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#701516",
		Group:  "",
		Aliases: []string{
			"jruby",
			"macruby",
			"rake",
			"rb",
			"rbx",
		},
		Extensions: []string{
			".rb",
			".builder",
			".eye",
			".fcgi",
			".gemspec",
			".god",
			".jbuilder",
			".mspec",
			".pluginspec",
			".podspec",
			".prawn",
			".rabl",
			".rake",
			".rbi",
			".rbuild",
			".rbw",
			".rbx",
			".ru",
			".ruby",
			".spec",
			".thor",
			".watchr",
		},
		Interpreters: []string{
			"ruby",
			"macruby",
			"rake",
			"jruby",
			"rbx",
		},
		Filenames: []string{
			".irbrc",
			".pryrc",
			".simplecov",
			"Appraisals",
			"Berksfile",
			"Brewfile",
			"Buildfile",
			"Capfile",
			"Dangerfile",
			"Deliverfile",
			"Fastfile",
			"Gemfile",
			"Guardfile",
			"Jarfile",
			"Mavenfile",
			"Podfile",
			"Puppetfile",
			"Rakefile",
			"Snapfile",
			"Steepfile",
			"Thorfile",
			"Vagrantfile",
			"buildfile",
		},
		MimeType:       "text/x-ruby",
		TMScope:        "source.ruby",
		AceMode:        "ruby",
		CodeMirrorMode: "ruby",
		Wrap:           false,
		LanguageID:     326,
	},
	327: LanguageInfo{
		Name:   "Rust",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#dea584",
		Group:  "",
		Aliases: []string{
			"rs",
		},
		Extensions: []string{
			".rs",
			".rs.in",
		},
		Interpreters: []string{
			"rust-script",
		},
		Filenames:      []string{},
		MimeType:       "text/x-rustsrc",
		TMScope:        "source.rust",
		AceMode:        "rust",
		CodeMirrorMode: "rust",
		Wrap:           false,
		LanguageID:     327,
	},
	328: LanguageInfo{
		Name:    "SAS",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#B34936",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sas",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-sas",
		TMScope:        "source.sas",
		AceMode:        "text",
		CodeMirrorMode: "sas",
		Wrap:           false,
		LanguageID:     328,
	},
	329: LanguageInfo{
		Name:    "SCSS",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#c6538c",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".scss",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-scss",
		TMScope:        "source.css.scss",
		AceMode:        "scss",
		CodeMirrorMode: "css",
		Wrap:           false,
		LanguageID:     329,
	},
	880010326: LanguageInfo{
		Name:   "SELinux Policy",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"SELinux Kernel Policy Language",
			"sepolicy",
		},
		Extensions: []string{
			".te",
		},
		Interpreters: []string{},
		Filenames: []string{
			"file_contexts",
			"genfs_contexts",
			"initial_sids",
			"port_contexts",
			"security_classes",
		},
		MimeType:       "",
		TMScope:        "source.sepolicy",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     880010326,
	},
	330: LanguageInfo{
		Name:    "SMT",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".smt2",
			".smt",
		},
		Interpreters: []string{
			"boolector",
			"cvc4",
			"mathsat5",
			"opensmt",
			"smtinterpol",
			"smt-rat",
			"stp",
			"verit",
			"yices2",
			"z3",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.smt",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     330,
	},
	331: LanguageInfo{
		Name:    "SPARQL",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#0C4597",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sparql",
			".rq",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/sparql-query",
		TMScope:        "source.sparql",
		AceMode:        "text",
		CodeMirrorMode: "sparql",
		Wrap:           false,
		LanguageID:     331,
	},
	332: LanguageInfo{
		Name:    "SQF",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3F3F3F",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sqf",
			".hqf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.sqf",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     332,
	},
	333: LanguageInfo{
		Name:    "SQL",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#e38c00",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sql",
			".cql",
			".ddl",
			".inc",
			".mysql",
			".prc",
			".tab",
			".udf",
			".viw",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-sql",
		TMScope:        "source.sql",
		AceMode:        "sql",
		CodeMirrorMode: "sql",
		Wrap:           false,
		LanguageID:     333,
	},
	334: LanguageInfo{
		Name:    "SQLPL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#e38c00",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sql",
			".db2",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-sql",
		TMScope:        "source.sql",
		AceMode:        "sql",
		CodeMirrorMode: "sql",
		Wrap:           false,
		LanguageID:     334,
	},
	335: LanguageInfo{
		Name:    "SRecode Template",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#348a34",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".srt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-common-lisp",
		TMScope:        "source.lisp",
		AceMode:        "lisp",
		CodeMirrorMode: "commonlisp",
		Wrap:           false,
		LanguageID:     335,
	},
	554920715: LanguageInfo{
		Name:   "SSH Config",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "INI",
		Aliases: []string{
			"sshconfig",
			"sshdconfig",
			"ssh_config",
			"sshd_config",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"ssh-config",
			"ssh_config",
			"sshconfig",
			"sshconfig.snip",
			"sshd-config",
			"sshd_config",
		},
		MimeType:       "",
		TMScope:        "source.ssh-config",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     554920715,
	},
	424510560: LanguageInfo{
		Name:    "STAR",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".star",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.star",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     424510560,
	},
	455361735: LanguageInfo{
		Name:   "STL",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#373b5e",
		Group:  "",
		Aliases: []string{
			"ascii stl",
			"stla",
		},
		Extensions: []string{
			".stl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.stl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     455361735,
	},
	336: LanguageInfo{
		Name:    "STON",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "Smalltalk",
		Aliases: []string{},
		Extensions: []string{
			".ston",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.smalltalk",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     336,
	},
	337: LanguageInfo{
		Name:    "SVG",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#ff9900",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".svg",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/xml",
		TMScope:        "text.xml.svg",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     337,
	},
	1066250075: LanguageInfo{
		Name:    "SWIG",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".i",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-c++src",
		TMScope:        "source.c++",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     1066250075,
	},
	338: LanguageInfo{
		Name:    "Sage",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sage",
			".sagews",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-python",
		TMScope:        "source.python",
		AceMode:        "python",
		CodeMirrorMode: "python",
		Wrap:           false,
		LanguageID:     338,
	},
	339: LanguageInfo{
		Name:   "SaltStack",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#646464",
		Group:  "",
		Aliases: []string{
			"saltstate",
			"salt",
		},
		Extensions: []string{
			".sls",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-yaml",
		TMScope:        "source.yaml.salt",
		AceMode:        "yaml",
		CodeMirrorMode: "yaml",
		Wrap:           false,
		LanguageID:     339,
	},
	340: LanguageInfo{
		Name:    "Sass",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#a53b70",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sass",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-sass",
		TMScope:        "source.sass",
		AceMode:        "sass",
		CodeMirrorMode: "sass",
		Wrap:           false,
		LanguageID:     340,
	},
	341: LanguageInfo{
		Name:    "Scala",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#c22d40",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".scala",
			".kojo",
			".sbt",
			".sc",
		},
		Interpreters: []string{
			"scala",
		},
		Filenames:      []string{},
		MimeType:       "text/x-scala",
		TMScope:        "source.scala",
		AceMode:        "scala",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     341,
	},
	342: LanguageInfo{
		Name:    "Scaml",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#bd181a",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".scaml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.scaml",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     342,
	},
	619814037: LanguageInfo{
		Name:    "Scenic",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#fdc700",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".scenic",
		},
		Interpreters: []string{
			"scenic",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.scenic",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     619814037,
	},
	343: LanguageInfo{
		Name:    "Scheme",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#1e4aec",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".scm",
			".sch",
			".sld",
			".sls",
			".sps",
			".ss",
		},
		Interpreters: []string{
			"scheme",
			"guile",
			"bigloo",
			"chicken",
			"csi",
			"gosh",
			"r6rs",
		},
		Filenames:      []string{},
		MimeType:       "text/x-scheme",
		TMScope:        "source.scheme",
		AceMode:        "scheme",
		CodeMirrorMode: "scheme",
		Wrap:           false,
		LanguageID:     343,
	},
	344: LanguageInfo{
		Name:    "Scilab",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ca0f21",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sci",
			".sce",
			".tst",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.scilab",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     344,
	},
	345: LanguageInfo{
		Name:    "Self",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0579aa",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".self",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     345,
	},
	664257356: LanguageInfo{
		Name:    "ShaderLab",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#222c37",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".shader",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.shaderlab",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     664257356,
	},
	346: LanguageInfo{
		Name:   "Shell",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#89e051",
		Group:  "",
		Aliases: []string{
			"sh",
			"shell-script",
			"bash",
			"zsh",
			"envrc",
		},
		Extensions: []string{
			".sh",
			".bash",
			".bats",
			".cgi",
			".command",
			".fcgi",
			".ksh",
			".sh.in",
			".tmux",
			".tool",
			".trigger",
			".zsh",
			".zsh-theme",
		},
		Interpreters: []string{
			"ash",
			"bash",
			"dash",
			"ksh",
			"mksh",
			"pdksh",
			"rc",
			"sh",
			"zsh",
		},
		Filenames: []string{
			".bash_aliases",
			".bash_functions",
			".bash_history",
			".bash_logout",
			".bash_profile",
			".bashrc",
			".cshrc",
			".envrc",
			".flaskenv",
			".kshrc",
			".login",
			".profile",
			".tmux.conf",
			".zlogin",
			".zlogout",
			".zprofile",
			".zshenv",
			".zshrc",
			"9fs",
			"PKGBUILD",
			"bash_aliases",
			"bash_logout",
			"bash_profile",
			"bashrc",
			"cshrc",
			"gradlew",
			"kshrc",
			"login",
			"man",
			"profile",
			"tmux.conf",
			"zlogin",
			"zlogout",
			"zprofile",
			"zshenv",
			"zshrc",
		},
		MimeType:       "text/x-sh",
		TMScope:        "source.shell",
		AceMode:        "sh",
		CodeMirrorMode: "shell",
		Wrap:           false,
		LanguageID:     346,
	},
	687511714: LanguageInfo{
		Name:   "ShellCheck Config",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#cecfcb",
		Group:  "",
		Aliases: []string{
			"shellcheckrc",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			".shellcheckrc",
		},
		MimeType:       "text/x-properties",
		TMScope:        "source.shellcheckrc",
		AceMode:        "ini",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     687511714,
	},
	347: LanguageInfo{
		Name:   "ShellSession",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"bash session",
			"console",
		},
		Extensions: []string{
			".sh-session",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-sh",
		TMScope:        "text.shell-session",
		AceMode:        "sh",
		CodeMirrorMode: "shell",
		Wrap:           false,
		LanguageID:     347,
	},
	348: LanguageInfo{
		Name:    "Shen",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#120F14",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".shen",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.shen",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     348,
	},
	208976687: LanguageInfo{
		Name:    "Sieve",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sieve",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/sieve",
		TMScope:        "source.sieve",
		AceMode:        "text",
		CodeMirrorMode: "sieve",
		Wrap:           false,
		LanguageID:     208976687,
	},
	735623761: LanguageInfo{
		Name:   "Simple File Verification",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#C9BFED",
		Group:  "Checksums",
		Aliases: []string{
			"sfv",
		},
		Extensions: []string{
			".sfv",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-properties",
		TMScope:        "source.sfv",
		AceMode:        "ini",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     735623761,
	},
	987024632: LanguageInfo{
		Name:         "Singularity",
		FSName:       "",
		Type:         TypeForString("programming"),
		Color:        "#64E6AD",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"Singularity",
		},
		MimeType:       "",
		TMScope:        "source.singularity",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     987024632,
	},
	349: LanguageInfo{
		Name:    "Slash",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#007eff",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.slash",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     349,
	},
	894641667: LanguageInfo{
		Name:    "Slice",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#003fa2",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ice",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ice",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     894641667,
	},
	350: LanguageInfo{
		Name:    "Slim",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#2b2b2b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".slim",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-slim",
		TMScope:        "text.slim",
		AceMode:        "text",
		CodeMirrorMode: "slim",
		Wrap:           false,
		LanguageID:     350,
	},
	119900149: LanguageInfo{
		Name:    "Slint",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#2379F4",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".slint",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.slint",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     119900149,
	},
	164123055: LanguageInfo{
		Name:   "SmPL",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#c94949",
		Group:  "",
		Aliases: []string{
			"coccinelle",
		},
		Extensions: []string{
			".cocci",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.smpl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     164123055,
	},
	351: LanguageInfo{
		Name:    "Smali",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".smali",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.smali",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     351,
	},
	352: LanguageInfo{
		Name:   "Smalltalk",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#596706",
		Group:  "",
		Aliases: []string{
			"squeak",
		},
		Extensions: []string{
			".st",
			".cs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-stsrc",
		TMScope:        "source.smalltalk",
		AceMode:        "text",
		CodeMirrorMode: "smalltalk",
		Wrap:           false,
		LanguageID:     352,
	},
	353: LanguageInfo{
		Name:    "Smarty",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#f0c040",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".tpl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-smarty",
		TMScope:        "text.html.smarty",
		AceMode:        "smarty",
		CodeMirrorMode: "smarty",
		Wrap:           false,
		LanguageID:     353,
	},
	1027892786: LanguageInfo{
		Name:    "Smithy",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#c44536",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".smithy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.smithy",
		AceMode:        "text",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     1027892786,
	},
	151241392: LanguageInfo{
		Name:   "Snakemake",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#419179",
		Group:  "Python",
		Aliases: []string{
			"snakefile",
		},
		Extensions: []string{
			".smk",
			".snakefile",
		},
		Interpreters: []string{},
		Filenames: []string{
			"Snakefile",
		},
		MimeType:       "text/x-python",
		TMScope:        "source.python",
		AceMode:        "python",
		CodeMirrorMode: "python",
		Wrap:           false,
		LanguageID:     151241392,
	},
	237469032: LanguageInfo{
		Name:    "Solidity",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#AA6746",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sol",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.solidity",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     237469032,
	},
	222900098: LanguageInfo{
		Name:         "Soong",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"Android.bp",
		},
		MimeType:       "",
		TMScope:        "source.bp",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     222900098,
	},
	354: LanguageInfo{
		Name:   "SourcePawn",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#f69e1d",
		Group:  "",
		Aliases: []string{
			"sourcemod",
		},
		Extensions: []string{
			".sp",
			".inc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.sourcepawn",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     354,
	},
	767169629: LanguageInfo{
		Name:    "Spline Font Database",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sfd",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.sfd",
		AceMode:        "yaml",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     767169629,
	},
	355: LanguageInfo{
		Name:    "Squirrel",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#800000",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nut",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-c++src",
		TMScope:        "source.nut",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     355,
	},
	356: LanguageInfo{
		Name:    "Stan",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#b2011d",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".stan",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.stan",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     356,
	},
	357: LanguageInfo{
		Name:   "Standard ML",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#dc566d",
		Group:  "",
		Aliases: []string{
			"sml",
		},
		Extensions: []string{
			".ml",
			".fun",
			".sig",
			".sml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-ocaml",
		TMScope:        "source.ml",
		AceMode:        "text",
		CodeMirrorMode: "mllike",
		Wrap:           false,
		LanguageID:     357,
	},
	960266174: LanguageInfo{
		Name:   "Starlark",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#76d275",
		Group:  "",
		Aliases: []string{
			"bazel",
			"bzl",
		},
		Extensions: []string{
			".bzl",
			".star",
		},
		Interpreters: []string{},
		Filenames: []string{
			"BUCK",
			"BUILD",
			"BUILD.bazel",
			"MODULE.bazel",
			"Tiltfile",
			"WORKSPACE",
			"WORKSPACE.bazel",
			"WORKSPACE.bzlmod",
		},
		MimeType:       "text/x-python",
		TMScope:        "source.python",
		AceMode:        "python",
		CodeMirrorMode: "python",
		Wrap:           false,
		LanguageID:     960266174,
	},
	358: LanguageInfo{
		Name:    "Stata",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#1a5f91",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".do",
			".ado",
			".doh",
			".ihlp",
			".mata",
			".matah",
			".sthlp",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.stata",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     358,
	},
	89855901: LanguageInfo{
		Name:    "StringTemplate",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#3fb34f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".st",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/html",
		TMScope:        "source.string-template",
		AceMode:        "html",
		CodeMirrorMode: "htmlmixed",
		Wrap:           false,
		LanguageID:     89855901,
	},
	359: LanguageInfo{
		Name:    "Stylus",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#ff6347",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".styl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.stylus",
		AceMode:        "stylus",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     359,
	},
	360: LanguageInfo{
		Name:    "SubRip Text",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#9e0101",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".srt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.srt",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     360,
	},
	826404698: LanguageInfo{
		Name:    "SugarSS",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#2fcc9f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sss",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.css.postcss.sugarss",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     826404698,
	},
	361: LanguageInfo{
		Name:    "SuperCollider",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#46390b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sc",
			".scd",
		},
		Interpreters: []string{
			"sclang",
			"scsynth",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.supercollider",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     361,
	},
	928734530: LanguageInfo{
		Name:    "Svelte",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#ff3e00",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".svelte",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/html",
		TMScope:        "source.svelte",
		AceMode:        "html",
		CodeMirrorMode: "htmlmixed",
		Wrap:           false,
		LanguageID:     928734530,
	},
	271471144: LanguageInfo{
		Name:    "Sway",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00F58C",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sw",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-rustsrc",
		TMScope:        "source.sway",
		AceMode:        "rust",
		CodeMirrorMode: "rust",
		Wrap:           false,
		LanguageID:     271471144,
	},
	558779190: LanguageInfo{
		Name:    "Sweave",
		FSName:  "",
		Type:    TypeForString("prose"),
		Color:   "#198ce7",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".rnw",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.tex.latex.sweave",
		AceMode:        "tex",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     558779190,
	},
	362: LanguageInfo{
		Name:    "Swift",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#F05138",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".swift",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-swift",
		TMScope:        "source.swift",
		AceMode:        "text",
		CodeMirrorMode: "swift",
		Wrap:           false,
		LanguageID:     362,
	},
	363: LanguageInfo{
		Name:    "SystemVerilog",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#DAE1C2",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sv",
			".svh",
			".vh",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-systemverilog",
		TMScope:        "source.systemverilog",
		AceMode:        "verilog",
		CodeMirrorMode: "verilog",
		Wrap:           false,
		LanguageID:     363,
	},
	422: LanguageInfo{
		Name:    "TI Program",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#A0AA87",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".8xp",
			".8xp.txt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.8xp",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     422,
	},
	118656070: LanguageInfo{
		Name:    "TL-Verilog",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#C40023",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".tlv",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.tlverilog",
		AceMode:        "verilog",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     118656070,
	},
	364: LanguageInfo{
		Name:    "TLA",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#4b0079",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".tla",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.tla",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     364,
	},
	365: LanguageInfo{
		Name:    "TOML",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#9c4221",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".toml",
		},
		Interpreters: []string{},
		Filenames: []string{
			"Cargo.lock",
			"Cargo.toml.orig",
			"Gopkg.lock",
			"Pipfile",
			"pdm.lock",
			"poetry.lock",
			"uv.lock",
		},
		MimeType:       "text/x-toml",
		TMScope:        "source.toml",
		AceMode:        "toml",
		CodeMirrorMode: "toml",
		Wrap:           false,
		LanguageID:     365,
	},
	89289301: LanguageInfo{
		Name:   "TSPLIB data",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"travelling salesman problem",
			"traveling salesman problem",
		},
		Extensions: []string{
			".tsp",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     89289301,
	},
	918334941: LanguageInfo{
		Name:    "TSQL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#e38c00",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sql",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.tsql",
		AceMode:        "sql",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     918334941,
	},
	1035892117: LanguageInfo{
		Name:   "TSV",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#237346",
		Group:  "",
		Aliases: []string{
			"tab-seperated values",
		},
		Extensions: []string{
			".tsv",
			".vcf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.generic-db",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     1035892117,
	},
	94901924: LanguageInfo{
		Name:    "TSX",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3178c6",
		Group:   "TypeScript",
		Aliases: []string{},
		Extensions: []string{
			".tsx",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/jsx",
		TMScope:        "source.tsx",
		AceMode:        "javascript",
		CodeMirrorMode: "jsx",
		Wrap:           false,
		LanguageID:     94901924,
	},
	366: LanguageInfo{
		Name:    "TXL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0178b8",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".txl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.txl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     366,
	},
	606708469: LanguageInfo{
		Name:    "Tact",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#48b5ff",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".tact",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.tact",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     606708469,
	},
	959889508: LanguageInfo{
		Name:    "Talon",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#333333",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".talon",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.talon",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     959889508,
	},
	367: LanguageInfo{
		Name:   "Tcl",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#e4cc98",
		Group:  "",
		Aliases: []string{
			"sdc",
			"xdc",
		},
		Extensions: []string{
			".tcl",
			".adp",
			".sdc",
			".tcl.in",
			".tm",
			".xdc",
		},
		Interpreters: []string{
			"tclsh",
			"wish",
		},
		Filenames: []string{
			"owh",
			"starfield",
		},
		MimeType:       "text/x-tcl",
		TMScope:        "source.tcl",
		AceMode:        "tcl",
		CodeMirrorMode: "tcl",
		Wrap:           false,
		LanguageID:     367,
	},
	368: LanguageInfo{
		Name:    "Tcsh",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "Shell",
		Aliases: []string{},
		Extensions: []string{
			".tcsh",
			".csh",
		},
		Interpreters: []string{
			"tcsh",
			"csh",
		},
		Filenames:      []string{},
		MimeType:       "text/x-sh",
		TMScope:        "source.shell",
		AceMode:        "sh",
		CodeMirrorMode: "shell",
		Wrap:           false,
		LanguageID:     368,
	},
	369: LanguageInfo{
		Name:   "TeX",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#3D6117",
		Group:  "",
		Aliases: []string{
			"latex",
		},
		Extensions: []string{
			".tex",
			".aux",
			".bbx",
			".cbx",
			".cls",
			".dtx",
			".ins",
			".lbx",
			".ltx",
			".mkii",
			".mkiv",
			".mkvi",
			".sty",
			".toc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-stex",
		TMScope:        "text.tex.latex",
		AceMode:        "tex",
		CodeMirrorMode: "stex",
		Wrap:           true,
		LanguageID:     369,
	},
	370: LanguageInfo{
		Name:    "Tea",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".tea",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.tea",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     370,
	},
	371: LanguageInfo{
		Name:    "Terra",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00004c",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".t",
		},
		Interpreters: []string{
			"lua",
		},
		Filenames:      []string{},
		MimeType:       "text/x-lua",
		TMScope:        "source.terra",
		AceMode:        "lua",
		CodeMirrorMode: "lua",
		Wrap:           false,
		LanguageID:     371,
	},
	856832701: LanguageInfo{
		Name:    "Terraform Template",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#7b42bb",
		Group:   "HCL",
		Aliases: []string{},
		Extensions: []string{
			".tftpl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-ruby",
		TMScope:        "source.hcl.terraform",
		AceMode:        "ruby",
		CodeMirrorMode: "ruby",
		Wrap:           false,
		LanguageID:     856832701,
	},
	988020015: LanguageInfo{
		Name:    "Texinfo",
		FSName:  "",
		Type:    TypeForString("prose"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".texinfo",
			".texi",
			".txi",
		},
		Interpreters: []string{
			"makeinfo",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.texinfo",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     988020015,
	},
	372: LanguageInfo{
		Name:   "Text",
		FSName: "",
		Type:   TypeForString("prose"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"fundamental",
			"plain text",
		},
		Extensions: []string{
			".txt",
			".fr",
			".nb",
			".ncl",
			".no",
		},
		Interpreters: []string{},
		Filenames: []string{
			"CITATION",
			"CITATIONS",
			"COPYING",
			"COPYING.regex",
			"COPYRIGHT.regex",
			"FONTLOG",
			"INSTALL",
			"INSTALL.mysql",
			"LICENSE",
			"LICENSE.mysql",
			"NEWS",
			"README.me",
			"README.mysql",
			"README.nss",
			"click.me",
			"delete.me",
			"keep.me",
			"package.mask",
			"package.use.mask",
			"package.use.stable.mask",
			"read.me",
			"readme.1st",
			"test.me",
			"use.mask",
			"use.stable.mask",
		},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     372,
	},
	965696054: LanguageInfo{
		Name:    "TextGrid",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#c8506d",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".TextGrid",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.textgrid",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     965696054,
	},
	981795023: LanguageInfo{
		Name:   "TextMate Properties",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#df66e4",
		Group:  "",
		Aliases: []string{
			"tm-properties",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			".tm_properties",
		},
		MimeType:       "text/x-properties",
		TMScope:        "source.tm-properties",
		AceMode:        "properties",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     981795023,
	},
	373: LanguageInfo{
		Name:    "Textile",
		FSName:  "",
		Type:    TypeForString("prose"),
		Color:   "#ffe7ac",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".textile",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-textile",
		TMScope:        "none",
		AceMode:        "textile",
		CodeMirrorMode: "textile",
		Wrap:           true,
		LanguageID:     373,
	},
	374: LanguageInfo{
		Name:    "Thrift",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#D12127",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".thrift",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.thrift",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     374,
	},
	356554395: LanguageInfo{
		Name:    "Toit",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#c2c9fb",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".toit",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.toit",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     356554395,
	},
	375: LanguageInfo{
		Name:    "Turing",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#cf142b",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".t",
			".tu",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.turing",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     375,
	},
	376: LanguageInfo{
		Name:    "Turtle",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ttl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/turtle",
		TMScope:        "source.turtle",
		AceMode:        "text",
		CodeMirrorMode: "turtle",
		Wrap:           false,
		LanguageID:     376,
	},
	377: LanguageInfo{
		Name:    "Twig",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#c1d026",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".twig",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-twig",
		TMScope:        "text.html.twig",
		AceMode:        "twig",
		CodeMirrorMode: "twig",
		Wrap:           false,
		LanguageID:     377,
	},
	632765617: LanguageInfo{
		Name:   "Type Language",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"tl",
		},
		Extensions: []string{
			".tl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.tl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     632765617,
	},
	378: LanguageInfo{
		Name:   "TypeScript",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#3178c6",
		Group:  "",
		Aliases: []string{
			"ts",
		},
		Extensions: []string{
			".ts",
			".cts",
			".mts",
		},
		Interpreters: []string{
			"deno",
			"ts-node",
			"tsx",
		},
		Filenames:      []string{},
		MimeType:       "application/typescript",
		TMScope:        "source.ts",
		AceMode:        "typescript",
		CodeMirrorMode: "javascript",
		Wrap:           false,
		LanguageID:     378,
	},
	952272597: LanguageInfo{
		Name:   "TypeSpec",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#4A3665",
		Group:  "",
		Aliases: []string{
			"tsp",
		},
		Extensions: []string{
			".tsp",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.tsp",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     952272597,
	},
	704730682: LanguageInfo{
		Name:   "Typst",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#239dad",
		Group:  "",
		Aliases: []string{
			"typ",
		},
		Extensions: []string{
			".typ",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.typst",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     704730682,
	},
	379: LanguageInfo{
		Name:    "Unified Parallel C",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#4e3617",
		Group:   "C",
		Aliases: []string{},
		Extensions: []string{
			".upc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.c",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     379,
	},
	380: LanguageInfo{
		Name:    "Unity3D Asset",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#222c37",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".anim",
			".asset",
			".mask",
			".mat",
			".meta",
			".prefab",
			".unity",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-yaml",
		TMScope:        "source.yaml",
		AceMode:        "yaml",
		CodeMirrorMode: "yaml",
		Wrap:           false,
		LanguageID:     380,
	},
	120: LanguageInfo{
		Name:   "Unix Assembly",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "Assembly",
		Aliases: []string{
			"gas",
			"gnu asm",
			"unix asm",
		},
		Extensions: []string{
			".s",
			".ms",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.x86",
		AceMode:        "assembly_x86",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     120,
	},
	381: LanguageInfo{
		Name:    "Uno",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#9933cc",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".uno",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csharp",
		TMScope:        "source.cs",
		AceMode:        "csharp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     381,
	},
	382: LanguageInfo{
		Name:    "UnrealScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#a54c4d",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".uc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-java",
		TMScope:        "source.java",
		AceMode:        "java",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     382,
	},
	383: LanguageInfo{
		Name:   "UrWeb",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#ccccee",
		Group:  "",
		Aliases: []string{
			"Ur/Web",
			"Ur",
		},
		Extensions: []string{
			".ur",
			".urs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ur",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     383,
	},
	603371597: LanguageInfo{
		Name:   "V",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#4f87c4",
		Group:  "",
		Aliases: []string{
			"vlang",
		},
		Extensions: []string{
			".v",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-go",
		TMScope:        "source.v",
		AceMode:        "golang",
		CodeMirrorMode: "go",
		Wrap:           false,
		LanguageID:     603371597,
	},
	399230729: LanguageInfo{
		Name:   "VBA",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#867db1",
		Group:  "",
		Aliases: []string{
			"visual basic for applications",
		},
		Extensions: []string{
			".bas",
			".cls",
			".frm",
			".vba",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-vb",
		TMScope:        "source.vba",
		AceMode:        "text",
		CodeMirrorMode: "vb",
		Wrap:           false,
		LanguageID:     399230729,
	},
	408016005: LanguageInfo{
		Name:    "VBScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#15dcdc",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".vbs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/vbscript",
		TMScope:        "source.vbnet",
		AceMode:        "text",
		CodeMirrorMode: "vbscript",
		Wrap:           false,
		LanguageID:     408016005,
	},
	384: LanguageInfo{
		Name:    "VCL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#148AA8",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".vcl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.varnish.vcl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     384,
	},
	385: LanguageInfo{
		Name:    "VHDL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#adb2cb",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".vhdl",
			".vhd",
			".vhf",
			".vhi",
			".vho",
			".vhs",
			".vht",
			".vhw",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-vhdl",
		TMScope:        "source.vhdl",
		AceMode:        "vhdl",
		CodeMirrorMode: "vhdl",
		Wrap:           false,
		LanguageID:     385,
	},
	386: LanguageInfo{
		Name:    "Vala",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#a56de2",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".vala",
			".vapi",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.vala",
		AceMode:        "vala",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     386,
	},
	544060961: LanguageInfo{
		Name:   "Valve Data Format",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#f26025",
		Group:  "",
		Aliases: []string{
			"keyvalues",
			"vdf",
		},
		Extensions: []string{
			".vdf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.keyvalues",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     544060961,
	},
	292377326: LanguageInfo{
		Name:   "Velocity Template Language",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#507cff",
		Group:  "",
		Aliases: []string{
			"vtl",
			"velocity",
		},
		Extensions: []string{
			".vtl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/velocity",
		TMScope:        "source.velocity",
		AceMode:        "velocity",
		CodeMirrorMode: "velocity",
		Wrap:           false,
		LanguageID:     292377326,
	},
	387: LanguageInfo{
		Name:    "Verilog",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#b2b7f8",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".v",
			".veo",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-verilog",
		TMScope:        "source.verilog",
		AceMode:        "verilog",
		CodeMirrorMode: "verilog",
		Wrap:           false,
		LanguageID:     387,
	},
	508563686: LanguageInfo{
		Name:   "Vim Help File",
		FSName: "",
		Type:   TypeForString("prose"),
		Color:  "#199f4b",
		Group:  "",
		Aliases: []string{
			"help",
			"vimhelp",
		},
		Extensions: []string{
			".txt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.vim-help",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     508563686,
	},
	388: LanguageInfo{
		Name:   "Vim Script",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#199f4b",
		Group:  "",
		Aliases: []string{
			"vim",
			"viml",
			"nvim",
			"vimscript",
		},
		Extensions: []string{
			".vim",
			".vba",
			".vimrc",
			".vmb",
		},
		Interpreters: []string{},
		Filenames: []string{
			".exrc",
			".gvimrc",
			".nvimrc",
			".vimrc",
			"_vimrc",
			"gvimrc",
			"nvimrc",
			"vimrc",
		},
		MimeType:       "",
		TMScope:        "source.viml",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     388,
	},
	81265970: LanguageInfo{
		Name:   "Vim Snippet",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#199f4b",
		Group:  "",
		Aliases: []string{
			"SnipMate",
			"UltiSnip",
			"UltiSnips",
			"NeoSnippet",
		},
		Extensions: []string{
			".snip",
			".snippet",
			".snippets",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.vim-snippet",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     81265970,
	},
	389: LanguageInfo{
		Name:   "Visual Basic .NET",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#945db7",
		Group:  "",
		Aliases: []string{
			"visual basic",
			"vbnet",
			"vb .net",
			"vb.net",
		},
		Extensions: []string{
			".vb",
			".vbhtml",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-vb",
		TMScope:        "source.vbnet",
		AceMode:        "text",
		CodeMirrorMode: "vb",
		Wrap:           false,
		LanguageID:     389,
	},
	679594952: LanguageInfo{
		Name:   "Visual Basic 6.0",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#2c6353",
		Group:  "",
		Aliases: []string{
			"vb6",
			"vb 6",
			"visual basic 6",
			"visual basic classic",
			"classic visual basic",
		},
		Extensions: []string{
			".bas",
			".cls",
			".ctl",
			".Dsr",
			".frm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-vb",
		TMScope:        "source.vba",
		AceMode:        "text",
		CodeMirrorMode: "vb",
		Wrap:           false,
		LanguageID:     679594952,
	},
	390: LanguageInfo{
		Name:    "Volt",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#1F1F1F",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".volt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-d",
		TMScope:        "source.d",
		AceMode:        "d",
		CodeMirrorMode: "d",
		Wrap:           false,
		LanguageID:     390,
	},
	391: LanguageInfo{
		Name:    "Vue",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#41b883",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".vue",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.vue",
		AceMode:        "html",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     391,
	},
	1055641948: LanguageInfo{
		Name:    "Vyper",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#2980b9",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".vy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.vyper",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     1055641948,
	},
	374521672: LanguageInfo{
		Name:   "WDL",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#42f1f4",
		Group:  "",
		Aliases: []string{
			"Workflow Description Language",
		},
		Extensions: []string{
			".wdl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.wdl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     374521672,
	},
	836605993: LanguageInfo{
		Name:    "WGSL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#1a5e9a",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".wgsl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.wgsl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     836605993,
	},
	392: LanguageInfo{
		Name:    "Wavefront Material",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mtl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.wavefront.mtl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     392,
	},
	393: LanguageInfo{
		Name:    "Wavefront Object",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".obj",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.wavefront.obj",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     393,
	},
	394: LanguageInfo{
		Name:    "Web Ontology Language",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#5b70bd",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".owl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.xml",
		AceMode:        "xml",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     394,
	},
	956556503: LanguageInfo{
		Name:   "WebAssembly",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#04133b",
		Group:  "",
		Aliases: []string{
			"wast",
			"wasm",
		},
		Extensions: []string{
			".wast",
			".wat",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-common-lisp",
		TMScope:        "source.webassembly",
		AceMode:        "lisp",
		CodeMirrorMode: "commonlisp",
		Wrap:           false,
		LanguageID:     956556503,
	},
	134534086: LanguageInfo{
		Name:   "WebAssembly Interface Type",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#6250e7",
		Group:  "",
		Aliases: []string{
			"wit",
		},
		Extensions: []string{
			".wit",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-webidl",
		TMScope:        "source.wit",
		AceMode:        "text",
		CodeMirrorMode: "webidl",
		Wrap:           false,
		LanguageID:     134534086,
	},
	395: LanguageInfo{
		Name:    "WebIDL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".webidl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-webidl",
		TMScope:        "source.webidl",
		AceMode:        "text",
		CodeMirrorMode: "webidl",
		Wrap:           false,
		LanguageID:     395,
	},
	658679714: LanguageInfo{
		Name:   "WebVTT",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"vtt",
		},
		Extensions: []string{
			".vtt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.vtt",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     658679714,
	},
	668457123: LanguageInfo{
		Name:   "Wget Config",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "INI",
		Aliases: []string{
			"wgetrc",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			".wgetrc",
		},
		MimeType:       "",
		TMScope:        "source.wgetrc",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     668457123,
	},
	888779559: LanguageInfo{
		Name:    "Whiley",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#d5c397",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".whiley",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.whiley",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     888779559,
	},
	228: LanguageInfo{
		Name:   "Wikitext",
		FSName: "",
		Type:   TypeForString("prose"),
		Color:  "#fc5757",
		Group:  "",
		Aliases: []string{
			"mediawiki",
			"wiki",
		},
		Extensions: []string{
			".mediawiki",
			".wiki",
			".wikitext",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "text.html.mediawiki",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           true,
		LanguageID:     228,
	},
	950967261: LanguageInfo{
		Name:    "Win32 Message File",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-properties",
		TMScope:        "source.win32-messages",
		AceMode:        "ini",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     950967261,
	},
	969674868: LanguageInfo{
		Name:    "Windows Registry Entries",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#52d5ff",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".reg",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-properties",
		TMScope:        "source.reg",
		AceMode:        "ini",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     969674868,
	},
	686821385: LanguageInfo{
		Name:    "Witcher Script",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ff0000",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ws",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.witcherscript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     686821385,
	},
	632745969: LanguageInfo{
		Name:    "Wollok",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#a23738",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".wlk",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.wollok",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     632745969,
	},
	396: LanguageInfo{
		Name:    "World of Warcraft Addon Data",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#f7e43f",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".toc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.toc",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     396,
	},
	713580619: LanguageInfo{
		Name:   "Wren",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#383838",
		Group:  "",
		Aliases: []string{
			"wrenlang",
		},
		Extensions: []string{
			".wren",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.wren",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     713580619,
	},
	782911107: LanguageInfo{
		Name:   "X BitMap",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "C",
		Aliases: []string{
			"xbm",
		},
		Extensions: []string{
			".xbm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.c",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     782911107,
	},
	208700028: LanguageInfo{
		Name:         "X Font Directory Index",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"encodings.dir",
			"fonts.alias",
			"fonts.dir",
			"fonts.scale",
		},
		MimeType:       "",
		TMScope:        "source.fontdir",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     208700028,
	},
	781846279: LanguageInfo{
		Name:   "X PixMap",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "C",
		Aliases: []string{
			"xpm",
		},
		Extensions: []string{
			".xpm",
			".pm",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.c",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     781846279,
	},
	397: LanguageInfo{
		Name:   "X10",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#4B6BEF",
		Group:  "",
		Aliases: []string{
			"xten",
		},
		Extensions: []string{
			".x10",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.x10",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     397,
	},
	398: LanguageInfo{
		Name:    "XC",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#99DA07",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".xc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.xc",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     398,
	},
	225167241: LanguageInfo{
		Name:         "XCompose",
		FSName:       "",
		Type:         TypeForString("data"),
		Color:        "",
		Group:        "",
		Aliases:      []string{},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			".XCompose",
			"XCompose",
			"xcompose",
		},
		MimeType:       "",
		TMScope:        "config.xcompose",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     225167241,
	},
	399: LanguageInfo{
		Name:   "XML",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#0060ac",
		Group:  "",
		Aliases: []string{
			"rss",
			"xsd",
			"wsdl",
		},
		Extensions: []string{
			".xml",
			".adml",
			".admx",
			".ant",
			".axaml",
			".axml",
			".builds",
			".ccproj",
			".ccxml",
			".clixml",
			".cproject",
			".cscfg",
			".csdef",
			".csl",
			".csproj",
			".ct",
			".depproj",
			".dita",
			".ditamap",
			".ditaval",
			".dll.config",
			".dotsettings",
			".filters",
			".fsproj",
			".fxml",
			".glade",
			".gml",
			".gmx",
			".grxml",
			".gst",
			".hzp",
			".iml",
			".ivy",
			".jelly",
			".jsproj",
			".kml",
			".launch",
			".mdpolicy",
			".mjml",
			".mm",
			".mod",
			".mojo",
			".mxml",
			".natvis",
			".ncl",
			".ndproj",
			".nproj",
			".nuspec",
			".odd",
			".osm",
			".pkgproj",
			".pluginspec",
			".proj",
			".props",
			".ps1xml",
			".psc1",
			".pt",
			".qhelp",
			".rdf",
			".res",
			".resx",
			".rs",
			".rss",
			".sch",
			".scxml",
			".sfproj",
			".shproj",
			".srdf",
			".storyboard",
			".sublime-snippet",
			".sw",
			".targets",
			".tml",
			".ts",
			".tsx",
			".typ",
			".ui",
			".urdf",
			".ux",
			".vbproj",
			".vcxproj",
			".vsixmanifest",
			".vssettings",
			".vstemplate",
			".vxml",
			".wixproj",
			".workflow",
			".wsdl",
			".wsf",
			".wxi",
			".wxl",
			".wxs",
			".x3d",
			".xacro",
			".xaml",
			".xib",
			".xlf",
			".xliff",
			".xmi",
			".xml.dist",
			".xmp",
			".xproj",
			".xsd",
			".xspec",
			".xul",
			".zcml",
		},
		Interpreters: []string{},
		Filenames: []string{
			".classpath",
			".cproject",
			".project",
			"App.config",
			"NuGet.config",
			"Settings.StyleCop",
			"Web.Debug.config",
			"Web.Release.config",
			"Web.config",
			"packages.config",
		},
		MimeType:       "text/xml",
		TMScope:        "text.xml",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     399,
	},
	75622871: LanguageInfo{
		Name:    "XML Property List",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#0060ac",
		Group:   "XML",
		Aliases: []string{},
		Extensions: []string{
			".plist",
			".stTheme",
			".tmCommand",
			".tmLanguage",
			".tmPreferences",
			".tmSnippet",
			".tmTheme",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/xml",
		TMScope:        "text.xml.plist",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     75622871,
	},
	400: LanguageInfo{
		Name:    "XPages",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".xsp-config",
			".xsp.metadata",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/xml",
		TMScope:        "text.xml",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     400,
	},
	401: LanguageInfo{
		Name:    "XProc",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".xpl",
			".xproc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/xml",
		TMScope:        "text.xml",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     401,
	},
	402: LanguageInfo{
		Name:    "XQuery",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#5232e7",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".xquery",
			".xq",
			".xql",
			".xqm",
			".xqy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "application/xquery",
		TMScope:        "source.xq",
		AceMode:        "xquery",
		CodeMirrorMode: "xquery",
		Wrap:           false,
		LanguageID:     402,
	},
	403: LanguageInfo{
		Name:    "XS",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".xs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-csrc",
		TMScope:        "source.c",
		AceMode:        "c_cpp",
		CodeMirrorMode: "clike",
		Wrap:           false,
		LanguageID:     403,
	},
	404: LanguageInfo{
		Name:   "XSLT",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#EB8CEB",
		Group:  "",
		Aliases: []string{
			"xsl",
		},
		Extensions: []string{
			".xslt",
			".xsl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/xml",
		TMScope:        "text.xml.xsl",
		AceMode:        "xml",
		CodeMirrorMode: "xml",
		Wrap:           false,
		LanguageID:     404,
	},
	405: LanguageInfo{
		Name:    "Xojo",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#81bd41",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".xojo_code",
			".xojo_menu",
			".xojo_report",
			".xojo_script",
			".xojo_toolbar",
			".xojo_window",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.xojo",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     405,
	},
	614078284: LanguageInfo{
		Name:    "Xonsh",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#285EEF",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".xsh",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-python",
		TMScope:        "source.python",
		AceMode:        "text",
		CodeMirrorMode: "python",
		Wrap:           false,
		LanguageID:     614078284,
	},
	406: LanguageInfo{
		Name:    "Xtend",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#24255d",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".xtend",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.xtend",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     406,
	},
	407: LanguageInfo{
		Name:   "YAML",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#cb171e",
		Group:  "",
		Aliases: []string{
			"yml",
		},
		Extensions: []string{
			".yml",
			".mir",
			".reek",
			".rviz",
			".sublime-syntax",
			".syntax",
			".yaml",
			".yaml-tmlanguage",
			".yaml.sed",
			".yml.mysql",
		},
		Interpreters: []string{},
		Filenames: []string{
			".clang-format",
			".clang-tidy",
			".clangd",
			".gemrc",
			"CITATION.cff",
			"glide.lock",
			"pixi.lock",
			"yarn.lock",
		},
		MimeType:       "text/x-yaml",
		TMScope:        "source.yaml",
		AceMode:        "yaml",
		CodeMirrorMode: "yaml",
		Wrap:           false,
		LanguageID:     407,
	},
	408: LanguageInfo{
		Name:    "YANG",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".yang",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.yang",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     408,
	},
	805122868: LanguageInfo{
		Name:    "YARA",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#220000",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".yar",
			".yara",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.yara",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     805122868,
	},
	378760102: LanguageInfo{
		Name:   "YASnippet",
		FSName: "",
		Type:   TypeForString("markup"),
		Color:  "#32AB90",
		Group:  "",
		Aliases: []string{
			"snippet",
			"yas",
		},
		Extensions: []string{
			".yasnippet",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.yasnippet",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     378760102,
	},
	409: LanguageInfo{
		Name:    "Yacc",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#4B6C4B",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".y",
			".yacc",
			".yy",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.yacc",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     409,
	},
	237469033: LanguageInfo{
		Name:    "Yul",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#794932",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".yul",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.yul",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     237469033,
	},
	952972794: LanguageInfo{
		Name:    "ZAP",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0d665e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".zap",
			".xzap",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.zap",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     952972794,
	},
	973483626: LanguageInfo{
		Name:    "ZIL",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#dc75e5",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".zil",
			".mud",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.zil",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     973483626,
	},
	40: LanguageInfo{
		Name:   "Zeek",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"bro",
		},
		Extensions: []string{
			".zeek",
			".bro",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.zeek",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     40,
	},
	494938890: LanguageInfo{
		Name:    "ZenScript",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00BCD1",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".zs",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.zenscript",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     494938890,
	},
	410: LanguageInfo{
		Name:    "Zephir",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#118f9e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".zep",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.php.zephir",
		AceMode:        "php",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     410,
	},
	646424281: LanguageInfo{
		Name:    "Zig",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#ec915c",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".zig",
			".zig.zon",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.zig",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     646424281,
	},
	411: LanguageInfo{
		Name:    "Zimpl",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#d67711",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".zimpl",
			".zmpl",
			".zpl",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "none",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     411,
	},
	992375436: LanguageInfo{
		Name:   "cURL Config",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "INI",
		Aliases: []string{
			"curlrc",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			".curlrc",
			"_curlrc",
		},
		MimeType:       "",
		TMScope:        "source.curlrc",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     992375436,
	},
	705203557: LanguageInfo{
		Name:   "crontab",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#ead7ac",
		Group:  "",
		Aliases: []string{
			"cron",
			"cron table",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"crontab",
		},
		MimeType:       "",
		TMScope:        "text.crontab",
		AceMode:        "tcl",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     705203557,
	},
	412: LanguageInfo{
		Name:    "desktop",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".desktop",
			".desktop.in",
			".service",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.desktop",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     412,
	},
	691605112: LanguageInfo{
		Name:    "dircolors",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".dircolors",
		},
		Interpreters: []string{},
		Filenames: []string{
			".dir_colors",
			".dircolors",
			"DIR_COLORS",
			"_dir_colors",
			"_dircolors",
			"dir_colors",
		},
		MimeType:       "",
		TMScope:        "source.dircolors",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     691605112,
	},
	413: LanguageInfo{
		Name:    "eC",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#913960",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ec",
			".eh",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.c.ec",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     413,
	},
	414: LanguageInfo{
		Name:    "edn",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".edn",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-clojure",
		TMScope:        "source.clojure",
		AceMode:        "clojure",
		CodeMirrorMode: "clojure",
		Wrap:           false,
		LanguageID:     414,
	},
	415: LanguageInfo{
		Name:    "fish",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#4aae47",
		Group:   "Shell",
		Aliases: []string{},
		Extensions: []string{
			".fish",
		},
		Interpreters: []string{
			"fish",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.fish",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     415,
	},
	560883276: LanguageInfo{
		Name:    "hoon",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#00b171",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".hoon",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.hoon",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     560883276,
	},
	98384424: LanguageInfo{
		Name:   "iCalendar",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#ec564c",
		Group:  "",
		Aliases: []string{
			"iCal",
		},
		Extensions: []string{
			".ics",
			".ical",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-properties",
		TMScope:        "source.iCalendar",
		AceMode:        "properties",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     98384424,
	},
	905371884: LanguageInfo{
		Name:    "jq",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#c7254e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".jq",
		},
		Interpreters: []string{
			"gojq",
			"jaq",
			"jq",
			"jqjq",
			"jqq",
			"query-json",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.jq",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     905371884,
	},
	970675279: LanguageInfo{
		Name:    "kvlang",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#1da6e0",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".kv",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.python.kivy",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     970675279,
	},
	517654727: LanguageInfo{
		Name:    "mIRC Script",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#3d57c3",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mrc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.msl",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     517654727,
	},
	462488745: LanguageInfo{
		Name:    "mcfunction",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#E22837",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mcfunction",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.mcfunction",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     462488745,
	},
	416: LanguageInfo{
		Name:    "mupad",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#244963",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".mu",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.mupad",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     416,
	},
	775996197: LanguageInfo{
		Name:    "nanorc",
		FSName:  "",
		Type:    TypeForString("data"),
		Color:   "#2d004d",
		Group:   "INI",
		Aliases: []string{},
		Extensions: []string{
			".nanorc",
		},
		Interpreters: []string{},
		Filenames: []string{
			".nanorc",
			"nanorc",
		},
		MimeType:       "",
		TMScope:        "source.nanorc",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     775996197,
	},
	417: LanguageInfo{
		Name:    "nesC",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#94B0C7",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".nc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.nesc",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     417,
	},
	664100008: LanguageInfo{
		Name:    "omnetpp-msg",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#a0e0a0",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".msg",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.msg",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     664100008,
	},
	924868392: LanguageInfo{
		Name:    "omnetpp-ned",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#08607c",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ned",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ned",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     924868392,
	},
	418: LanguageInfo{
		Name:    "ooc",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#b0b77e",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".ooc",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.ooc",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     418,
	},
	970539067: LanguageInfo{
		Name:    "q",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#0040cd",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".q",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.q",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     970539067,
	},
	419: LanguageInfo{
		Name:   "reStructuredText",
		FSName: "",
		Type:   TypeForString("prose"),
		Color:  "#141414",
		Group:  "",
		Aliases: []string{
			"rst",
		},
		Extensions: []string{
			".rst",
			".rest",
			".rest.txt",
			".rst.txt",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-rst",
		TMScope:        "text.restructuredtext",
		AceMode:        "text",
		CodeMirrorMode: "rst",
		Wrap:           true,
		LanguageID:     419,
	},
	674736065: LanguageInfo{
		Name:   "robots.txt",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "",
		Group:  "",
		Aliases: []string{
			"robots",
			"robots txt",
		},
		Extensions:   []string{},
		Interpreters: []string{},
		Filenames: []string{
			"robots.txt",
		},
		MimeType:       "",
		TMScope:        "text.robots-txt",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     674736065,
	},
	847830017: LanguageInfo{
		Name:    "sed",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#64b970",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".sed",
		},
		Interpreters: []string{
			"gsed",
			"minised",
			"sed",
			"ssed",
		},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.sed",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     847830017,
	},
	795579337: LanguageInfo{
		Name:    "templ",
		FSName:  "",
		Type:    TypeForString("markup"),
		Color:   "#66D0DD",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".templ",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.templ",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     795579337,
	},
	851476558: LanguageInfo{
		Name:   "vCard",
		FSName: "",
		Type:   TypeForString("data"),
		Color:  "#ee2647",
		Group:  "",
		Aliases: []string{
			"virtual contact file",
			"electronic business card",
		},
		Extensions: []string{
			".vcf",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-properties",
		TMScope:        "source.vcard",
		AceMode:        "properties",
		CodeMirrorMode: "properties",
		Wrap:           false,
		LanguageID:     851476558,
	},
	420: LanguageInfo{
		Name:    "wisp",
		FSName:  "",
		Type:    TypeForString("programming"),
		Color:   "#7582D1",
		Group:   "",
		Aliases: []string{},
		Extensions: []string{
			".wisp",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "text/x-clojure",
		TMScope:        "source.clojure",
		AceMode:        "clojure",
		CodeMirrorMode: "clojure",
		Wrap:           false,
		LanguageID:     420,
	},
	421: LanguageInfo{
		Name:   "xBase",
		FSName: "",
		Type:   TypeForString("programming"),
		Color:  "#403a40",
		Group:  "",
		Aliases: []string{
			"advpl",
			"clipper",
			"foxpro",
		},
		Extensions: []string{
			".prg",
			".ch",
			".prw",
		},
		Interpreters:   []string{},
		Filenames:      []string{},
		MimeType:       "",
		TMScope:        "source.harbour",
		AceMode:        "text",
		CodeMirrorMode: "",
		Wrap:           false,
		LanguageID:     421,
	},
}
