/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
**
** This version of "lempar.c" is modified, slightly, for use by SQLite.
** The only modifications are the addition of a couple of NEVER()
** macros to disable tests that are needed in the case of a general
** LALR(1) grammar but which are always false in the
** specific grammar used by SQLite.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>

#include "token.h"
#include "parsercontext.h"
#include "parser_helper_stubs.h"
#include "common/utils_sql.h"
#include "common/global.h"
#include "common/unused.h"
#include "parser/ast/sqlitealtertable.h"
#include "parser/ast/sqliteanalyze.h"
#include "parser/ast/sqliteattach.h"
#include "parser/ast/sqlitebegintrans.h"
#include "parser/ast/sqlitecommittrans.h"
#include "parser/ast/sqlitecreateindex.h"
#include "parser/ast/sqlitecreatetable.h"
#include "parser/ast/sqlitecreatetrigger.h"
#include "parser/ast/sqlitecreateview.h"
#include "parser/ast/sqlitecreatevirtualtable.h"
#include "parser/ast/sqlitedelete.h"
#include "parser/ast/sqlitedetach.h"
#include "parser/ast/sqlitedropindex.h"
#include "parser/ast/sqlitedroptable.h"
#include "parser/ast/sqlitedroptrigger.h"
#include "parser/ast/sqlitedropview.h"
#include "parser/ast/sqliteemptyquery.h"
#include "parser/ast/sqliteinsert.h"
#include "parser/ast/sqlitepragma.h"
#include "parser/ast/sqlitereindex.h"
#include "parser/ast/sqliterelease.h"
#include "parser/ast/sqliterollback.h"
#include "parser/ast/sqlitesavepoint.h"
#include "parser/ast/sqliteselect.h"
#include "parser/ast/sqliteupdate.h"
#include "parser/ast/sqlitevacuum.h"
#include "parser/ast/sqliteexpr.h"
#include "parser/ast/sqlitecolumntype.h"
#include "parser/ast/sqliteconflictalgo.h"
#include "parser/ast/sqlitesortorder.h"
#include "parser/ast/sqliteindexedcolumn.h"
#include "parser/ast/sqliteforeignkey.h"
#include "parser/ast/sqlitewith.h"
#include "parser/ast/sqliteupsert.h"
#include "parser/ast/sqlitewindowdefinition.h"
#include "parser/ast/sqlitefilterover.h"
#include "parser/ast/sqlitenulls.h"
#include <QObject>
#include <QDebug>
#include <limits.h>

#ifdef assert
#   undef assert
#endif
#define assert(X) Q_ASSERT(X)
#define UNUSED_PARAMETER(X) (void)(X)
#define DONT_INHERIT_TOKENS(X) noTokenInheritanceFields << X

/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3_parseTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3_parseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite3_parseARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3_parseARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3_parseARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3_parseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned short int
#define YYNOCODE 332
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 79
#define sqlite3_parseTOKENTYPE Token*
typedef union {
  int yyinit;
  sqlite3_parseTOKENTYPE yy0;
  QVariant* yy15;
  SqliteSortOrder* yy25;
  SqliteColumnType* yy29;
  SqliteUpsert* yy34;
  SqliteFilterOver::Filter* yy37;
  SqliteQuery* yy43;
  ParserResultColumnList* yy75;
  SqliteWith* yy91;
  SqliteSelect::Core::SingleSource* yy95;
  SqliteWith::CommonTableExpression::AsMode* yy109;
  ParserCteList* yy114;
  SqliteSelect::CompoundOperator* yy116;
  ParserExprNestedList* yy118;
  ParserIndexedColumnList* yy121;
  SqliteWindowDefinition::Window::Frame::RangeOrRows* yy122;
  ParserXFullName* yy128;
  SqliteConflictAlgo* yy134;
  ParserFullName* yy136;
  SqliteForeignKey::Condition* yy165;
  SqliteIndexedColumn* yy166;
  SqliteCreateTable::Column* yy215;
  SqliteInitially* yy218;
  SqliteWindowDefinition* yy219;
  SqliteCreateTable::Constraint* yy240;
  SqliteCreateTrigger::Scope* yy247;
  QString* yy267;
  SqliteSelect::Core::JoinOp* yy273;
  ParserOrderByList* yy277;
  ParserStubInsertOrReplace* yy284;
  SqliteCreateTable::Column::Constraint* yy298;
  ParserFkConditionList* yy316;
  ParserStubExplain* yy317;
  QStringList* yy327;
  SqliteLimit* yy330;
  ParserCreateTableColumnConstraintList* yy333;
  ParserStubTransDetails* yy338;
  SqliteExpr* yy339;
  int* yy348;
  ParserCreateTableConstraintList* yy365;
  SqliteWindowDefinition::Window::Frame::Exclude* yy366;
  ParserWindowDefList* yy369;
  SqliteSelect* yy379;
  ParserSetValueList* yy387;
  ParserCreateTableOptionList* yy399;
  SqliteWith::CommonTableExpression* yy404;
  SqliteFilterOver* yy405;
  SqliteNulls* yy409;
  SqliteForeignKey::Condition::Reaction* yy410;
  ParserQueryList* yy412;
  SqliteSelect::Core::JoinConstraint* yy421;
  SqliteExpr::LikeOp* yy436;
  SqliteFilterOver::Over* yy437;
  SqliteWindowDefinition::Window::Frame::Bound* yy453;
  SqliteWindowDefinition::Window::Frame* yy463;
  SqliteCreateTrigger::Event* yy469;
  bool* yy473;
  SqliteSelect::Core* yy492;
  ParserDeferSubClause* yy497;
  ParserExprList* yy498;
  ParserStubAlias* yy516;
  SqliteWindowDefinition::Window* yy518;
  ParserOtherSourceList* yy527;
  ParserIndexedBy* yy542;
  SqliteSelect::Core::JoinSource* yy567;
  SqliteCreateTrigger::Time* yy568;
  ParserTermOrLiteral* yy622;
  ParserCreateTableColumnList* yy658;
  ParserStubCreateTableOption* yy661;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite3_parseARG_SDECL ParserContext* parserContext;
#define sqlite3_parseARG_PDECL ,ParserContext* parserContext
#define sqlite3_parseARG_FETCH ParserContext* parserContext = yypParser->parserContext
#define sqlite3_parseARG_STORE yypParser->parserContext = parserContext
#define YYNSTATE 896
#define YYNRULE 502
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

#define GET_CONTEXT yyParser* yypParser = pParser; sqlite3_parseARG_FETCH

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (3412)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   888,  261,  260,  259,   29,  888,  706,   70,   71,  547,
 /*    10 */   290,  896,  541,  843,  843,   68,   68,   69,   69,   69,
 /*    20 */    69,  705,   67,   67,   67,   67,   66,   66,   65,   65,
 /*    30 */    65,   64,   62,  273,   83, 1271,   70,   71,  547,  290,
 /*    40 */   417,  893,  843,  843,   68,   68,   69,   69,   69,   69,
 /*    50 */   544,   67,   67,   67,   67,   66,   66,   65,   65,   65,
 /*    60 */    64,   62,  273,  888, 1321,  728,  728,  265,  731,  888,
 /*    70 */   490,  624,  835,  418,   69,   69,   69,   69,   59,   67,
 /*    80 */    67,   67,   67,   66,   66,   65,   65,   65,   64,   62,
 /*    90 */   273,  764,  856,  368,  479,   56,   57,  739,  859,   84,
 /*   100 */   521,  888,  447,   58, 1069,  887,  858,  857,  856,   42,
 /*   110 */   143,    2, 1069,  541,  887,  328,  841, 1069,  330,  894,
 /*   120 */   538, 1143,  888,  888,  886,  885,  301,  888,  888,  303,
 /*   130 */   859,   65,   65,   65,   64,   62,  273,  841,  858,  857,
 /*   140 */   856,  714, 1069,   66,   66,   65,   65,   65,   64,   62,
 /*   150 */   273,  544,  293,  860,  834, 1069,  861, 1069, 1069,   61,
 /*   160 */   888, 1069,  409,  366,  256,  255, 1069, 1069, 1069, 1069,
 /*   170 */  1069, 1069,  841,  835,  304,  841,  847,  833,   12,   59,
 /*   180 */    74,   64,   62,  273,  679,  888,  888,  886,  885, 1069,
 /*   190 */   294,  888,  888,  856,  866,   95,   56,   57,  887,  859,
 /*   200 */   840,   81,  888,  203,   58, 1143,  165,  858,  857,  856,
 /*   210 */   345,  110,    2, 1143,  541,  776,  792,  841, 1143,  355,
 /*   220 */   280,  538,  666,  888,  888,  856,  885,  603,  274,  516,
 /*   230 */   888,  859,  511,  887,  669,  840,  776,  699,  841,  858,
 /*   240 */   857,  856,  776, 1143,  670,  847,  302,  463,  491,  892,
 /*   250 */   733,  732,  544,  517,  552,  618, 1143,  832, 1143, 1143,
 /*   260 */   619,  888,   93,  373,  605,  655,  693, 1143, 1143, 1143,
 /*   270 */  1143,  799, 1143,  841,  835,  783,  841,  122,  833,   12,
 /*   280 */    59,  678,  888,  888,  886,  885,  434,    9,  164,  171,
 /*   290 */  1143,  471,  468,  467,  475,   45,  799,   56,   57,  817,
 /*   300 */   846,  528,  588,   86,  118,   58, 1128,  764,  139,  466,
 /*   310 */   692,  388,  816,    2, 1128,  506,  776,  336,  841, 1128,
 /*   320 */   449,  887,  538,  888,  888,  888,  856,  885,  799,  847,
 /*   330 */   842,  480,  859,  587,  887,  586,  759,  776,  585,  841,
 /*   340 */   858,  857,  856,  776, 1128,   55,  563,   53,  355,  289,
 /*   350 */   288,  510,  888,  888,  886,  885,   94, 1128,  738, 1128,
 /*   360 */  1128,   24,  887,  888,  555, 1236, 1236,  563, 1128,  846,
 /*   370 */  1128, 1128,  142, 1128,  841,  884,  342,  841,  398,  833,
 /*   380 */    12,  784,  882,  888,  888,  886,  885,  412,  527,  746,
 /*   390 */   883, 1128,  827,  826,  341,  563,  888,  169,  840,  278,
 /*   400 */   888, 1241,  403,   47,  173,   70,   71,  547,  290, 1236,
 /*   410 */  1236,  843,  843,   68,   68,   69,   69,   69,   69,  888,
 /*   420 */    67,   67,   67,   67,   66,   66,   65,   65,   65,   64,
 /*   430 */    62,  273,  176,  840,    1,  745,  741,  265,  731,  853,
 /*   440 */   490,  809,  171,  442,  796,  888,  888,  886,  885,  720,
 /*   450 */  1236, 1236,  795,  846,  767,   70,   71,  547,  290,  172,
 /*   460 */    72,  843,  843,   68,   68,   69,   69,   69,   69,  525,
 /*   470 */    67,   67,   67,   67,   66,   66,   65,   65,   65,   64,
 /*   480 */    62,  273,  868,  344,  722,  888,  888,  886,  885,  759,
 /*   490 */    70,   71,  547,  290, 1236, 1236,  843,  843,   68,   68,
 /*   500 */    69,   69,   69,   69,  719,   67,   67,   67,   67,   66,
 /*   510 */    66,   65,   65,   65,   64,   62,  273,  815,  888,  888,
 /*   520 */   886,  885,  888,  888,  886,  885,  632,  694,  695,  814,
 /*   530 */   266,   48,  776,  851,   14,  566,  264,  752,  344,  722,
 /*   540 */   679,  888,  888,  886,  885,  365,  808, 1236, 1236,  571,
 /*   550 */   665,   95,  751,  776,  887,  567,  566,  118, 1241,  776,
 /*   560 */  1241,   69,   69,   69,   69,   43,   67,   67,   67,   67,
 /*   570 */    66,   66,   65,   65,   65,   64,   62,  273,  735,  770,
 /*   580 */   888,  703,  606,   61,  566, 1242,  535,   70,   71,  547,
 /*   590 */   290, 1236, 1236,  843,  843,   68,   68,   69,   69,   69,
 /*   600 */    69,   77,   67,   67,   67,   67,   66,   66,   65,   65,
 /*   610 */    65,   64,   62,  273,   27,  310,  455,  320,  374, 1348,
 /*   620 */   413,  830,  829,   82, 1348,  292,  492,   76, 1236, 1236,
 /*   630 */   603,  758,  164,  125,  757,  471,  468,  467,   47,   70,
 /*   640 */    71,  547,  290, 1307,  847,  843,  843,   68,   68,   69,
 /*   650 */    69,   69,   69,  466,   67,   67,   67,   67,   66,   66,
 /*   660 */    65,   65,   65,   64,   62,  273,  373,  604,   70,   71,
 /*   670 */   547,  290, 1236, 1236,  843,  843,   68,   68,   69,   69,
 /*   680 */    69,   69,   60,   67,   67,   67,   67,   66,   66,   65,
 /*   690 */    65,   65,   64,   62,  273,  888,  616,  836,  825,  620,
 /*   700 */   621,  436,  888,  888,  886,  885,  865,  541,  156,  158,
 /*   710 */    70,   71,  547,  290,  687,  474,  843,  843,   68,   68,
 /*   720 */    69,   69,   69,   69,  831,   67,   67,   67,   67,   66,
 /*   730 */    66,   65,   65,   65,   64,   62,  273,  820, 1307,  799,
 /*   740 */   606,  888, 1242,  205, 1242,  544,   67,   67,   67,   67,
 /*   750 */    66,   66,   65,   65,   65,   64,   62,  273,  888,  827,
 /*   760 */   826,  679,   83,  888,  799,  616,  760,  835,  846,  710,
 /*   770 */   854,  559,   95,   59,  869,  887,  374, 1347,  488,  139,
 /*   780 */   845,  382, 1347,  872,  548,  822,  680,  271,  887,  888,
 /*   790 */    56,   57,  709,  855,  240,  888,  799,  443,   58,  615,
 /*   800 */   291,  819,  546,  156,  155,  430,    2, 1248,   83,  727,
 /*   810 */    23,  841,  888,  740,  854,  538,  126,  888,  888,  856,
 /*   820 */   885,  888,  529,   82,  541,  859,  637,  513,  548,  120,
 /*   830 */   502,  489,  841,  858,  857,  856,  266,  855,  240, 1399,
 /*   840 */   196,  553,    3,  344,  722,  854,  546,  521, 1356, 1356,
 /*   850 */   487,  537,   75, 1079,  888,  383,  482,  747,  888,  548,
 /*   860 */   126,  887,  544,  888,  888,  886,  885,  841,  855,  223,
 /*   870 */   841,  610,  833,   12,  414,  512,  870,  546,  748,  888,
 /*   880 */   888,  888,  886,  885,  835,  888,  888,  886,  885,  126,
 /*   890 */    59,   61,    6,  747, 1356, 1356,  346,  888,  863,  383,
 /*   900 */    75,  860,  847,  405,  861,  747,  116,   56,   57,  541,
 /*   910 */   887,  888,  888,  886,  885,   58,  389,  888,  888,  886,
 /*   920 */   885, 1256,  504,    2,  888,  807,  748,  269,  841,  847,
 /*   930 */   802,  350,  538,  533,  888,  888,  856,  885,  992,  888,
 /*   940 */   524,  747,  859,  888,  888,  886,  885,  544,  472,  841,
 /*   950 */   858,  857,  856,  175,  130,  343,  477,  338,  476,  166,
 /*   960 */   769,  378,  522,  793,   83,  515,  505,  644,  778,  835,
 /*   970 */   572,  126,  167,  336,  611,   59,  888,  888,  886,  885,
 /*   980 */   888,  888,  886,  885,  841,  324,  755,  841,  757,  833,
 /*   990 */    12,  266,   56,   57,  602,  602,  764,  888,  869,  847,
 /*  1000 */    58,  888,  888,  886,  885,  549,  433,  867,    2,  359,
 /*  1010 */   887,  352,  887,  841,  156,  154,  300,  538,  204,  888,
 /*  1020 */   888,  856,  885,  822,  539,  271,  846,  859,  821,  356,
 /*  1030 */   887,  165,  453,  789,  841,  858,  857,  856,  572,  661,
 /*  1040 */   661,  611,   23,  887,  847,  815,  888,  888,  886,  885,
 /*  1050 */  1356, 1356,  462,  846,  789,  648,  415,  814,  712,  888,
 /*  1060 */   711,  888,  888,  886,  885,  811,  887,  397,  334,  841,
 /*  1070 */   806,  541,  841,  118,  833,   12,  648,  655,  540,  830,
 /*  1080 */   829,   70,   71,  547,  290,  803,  888,  843,  843,   68,
 /*  1090 */    68,   69,   69,   69,   69,  888,   67,   67,   67,   67,
 /*  1100 */    66,   66,   65,   65,   65,   64,   62,  273,   75,  544,
 /*  1110 */   186,  584,  171,  747,  626,   86,  854,  391,  257,  888,
 /*  1120 */   888,  886,  885,  846,  887,  776,  452,  464,  801,  757,
 /*  1130 */   548,  835,  118,  450,  748,  800,  388,   59,  172,  855,
 /*  1140 */   127,  532,  518,  805,  356,  627,  776,  629,  546,  747,
 /*  1150 */   628,  888,  776,  578,   56,   57,  825,  664,  887,  759,
 /*  1160 */  1086, 1086,   58,  449,  448,  655,  888,  887,  846,  172,
 /*  1170 */     2, 1248,  440,  579,  580,  841,  888,  887,  526,  538,
 /*  1180 */   685,  888,  888,  856,  885,   83,  895,    3,  541,  859,
 /*  1190 */   523,  513,  854,  790,    4,  126,  841,  858,  857,  856,
 /*  1200 */   458,  802,  626,   86,  329, 1245,  548,  764,  888,  888,
 /*  1210 */   886,  885,  775,    4,  887,  855,  240,  888,  888,  886,
 /*  1220 */   885,  887,  524,  569,  546, 1248,  544,  519,  771,    4,
 /*  1230 */   659,  841,  854,  627,  841,  629,  833,   12,  628,  512,
 /*  1240 */   888,   21,  276,  684,  683,   92,  548,  441,  835,  581,
 /*  1250 */   825,  569,  502,  503,   59,  855,  223,  888,  818,   22,
 /*  1260 */   439,  509,  888,   50,  546,  312,  888,  657,  126,  346,
 /*  1270 */    47,   56,   57,  888,  888,  886,  885,  383,  277,   58,
 /*  1280 */   355,  427,  642,  887,  647,  601,  711,    2,  888,  888,
 /*  1290 */   886,  885,  841,  186,  887,  887,  538,  888,  888,  888,
 /*  1300 */   856,  885,  657,  642,  356,   49,  859,  887,  888,  541,
 /*  1310 */   355,  355,  513,  841,  858,  857,  856,  802,  887,  279,
 /*  1320 */    70,   71,  547,  290,  887,  887,  843,  843,   68,   68,
 /*  1330 */    69,   69,   69,   69,  283,   67,   67,   67,   67,   66,
 /*  1340 */    66,   65,   65,   65,   64,   62,  273,  544,  841,  402,
 /*  1350 */   401,  841,  348,  833,   12,  778,  837,  764,  314,  417,
 /*  1360 */   514,  715,  888,  888,  886,  885,  774,    4,  115,  835,
 /*  1370 */   862,  887,  889,  809,  520,   59,  760,  565,  634,  888,
 /*  1380 */   888,  886,  885,   80,  888,  888,  886,  885,  888,  888,
 /*  1390 */   886,  885,   56,   57,  888,  631,  126,  307,  482,  634,
 /*  1400 */    58,  400,   47,  809,  809,  565,  772,    4,    2,   47,
 /*  1410 */   483,  771,    4,  841,  791,  887,  536,  538,  805,  888,
 /*  1420 */   888,  856,  885,  753,  599,  773,    4,  859,  435,  643,
 /*  1430 */   888,  888,  886,  885,  841,  858,  857,  856,  894,  760,
 /*  1440 */    83,   70,   71,  547,  290,  599,  119,  843,  843,   68,
 /*  1450 */    68,   69,   69,   69,   69,  349,   67,   67,   67,   67,
 /*  1460 */    66,   66,   65,   65,   65,   64,   62,  273, 1243,  841,
 /*  1470 */    20,  608,  841,  199,  833,   12,  375, 1292,  123,  785,
 /*  1480 */  1013,   70,   71,  547,  290,  667,  750,  843,  843,   68,
 /*  1490 */    68,   69,   69,   69,   69,  428,   67,   67,   67,   67,
 /*  1500 */    66,   66,   65,   65,   65,   64,   62,  273,  446,  887,
 /*  1510 */   292,  492,  399,  172,  167,  266,  888,  888,  886,  885,
 /*  1520 */   786,  888,   70,   71,  547,  290,  887,    5,  843,  843,
 /*  1530 */    68,   68,   69,   69,   69,   69,  780,   67,   67,   67,
 /*  1540 */    67,   66,   66,   65,   65,   65,   64,   62,  273,   70,
 /*  1550 */    71,  547,  290,  888,  761,  843,  843,   68,   68,   69,
 /*  1560 */    69,   69,   69,  760,   67,   67,   67,   67,   66,   66,
 /*  1570 */    65,   65,   65,   64,   62,  273,  779,  777,  760,   19,
 /*  1580 */    70,   71,  547,  290,  198,   54,  843,  843,   68,   68,
 /*  1590 */    69,   69,   69,   69,   18,   67,   67,   67,   67,   66,
 /*  1600 */    66,   65,   65,   65,   64,   62,  273,   17,   11,   61,
 /*  1610 */   749,   70,   71,  547,  290,  170,  726,  843,  843,   68,
 /*  1620 */    68,   69,   69,   69,   69,  200,   67,   67,   67,   67,
 /*  1630 */    66,   66,   65,   65,   65,   64,   62,  273,  425,  754,
 /*  1640 */   117,  742,  597,  888,  888,  886,  885,  721,   70,   71,
 /*  1650 */   547,  290,  887,   51,  843,  843,   68,   68,   69,   69,
 /*  1660 */    69,   69,  189,   67,   67,   67,   67,   66,   66,   65,
 /*  1670 */    65,   65,   64,   62,  273,  888,  888,  886,  885,   70,
 /*  1680 */    71,  547,  290,  188,  718,  843,  843,   68,   68,   69,
 /*  1690 */    69,   69,   69,  557,   67,   67,   67,   67,   66,   66,
 /*  1700 */    65,   65,   65,   64,   62,  273,  656,  887,  187,  133,
 /*  1710 */    70,   71,  547,  290,  496,  701,  843,  843,   68,   68,
 /*  1720 */    69,   69,   69,   69,  890,   67,   67,   67,   67,   66,
 /*  1730 */    66,   65,   65,   65,   64,   62,  273,  737,  887,  591,
 /*  1740 */   888,   70,   71,  547,  290,  494,  193,  843,  843,   68,
 /*  1750 */    68,   69,   69,   69,   69,  878,   67,   67,   67,   67,
 /*  1760 */    66,   66,   65,   65,   65,   64,   62,  273,    8,  887,
 /*  1770 */   736,   16,   70,   71,  547,  290,  734,  333,  843,  843,
 /*  1780 */    68,   68,   69,   69,   69,   69,  876,   67,   67,   67,
 /*  1790 */    67,   66,   66,   65,   65,   65,   64,   62,  273,  730,
 /*  1800 */   887,  729,  888,  486,   70,   71,  547,  290,  485,   30,
 /*  1810 */   843,  843,   68,   68,   69,   69,   69,   69,  888,   67,
 /*  1820 */    67,   67,   67,   66,   66,   65,   65,   65,   64,   62,
 /*  1830 */   273,   40, 1322,   70,   71,  547,  290,  484,  724,  843,
 /*  1840 */   843,   68,   68,   69,   69,   69,   69,  481,   67,   67,
 /*  1850 */    67,   67,   66,   66,   65,   65,   65,   64,   62,  273,
 /*  1860 */   888, 1320,  888,  888,  886,  885,   15,  124,   70,   71,
 /*  1870 */   547,  290,  541,   39,  843,  843,   68,   68,   69,   69,
 /*  1880 */    69,   69,  184,   67,   67,   67,   67,   66,   66,   65,
 /*  1890 */    65,   65,   64,   62,  273,  282,   70,   41,  547,  290,
 /*  1900 */   653,  888,  843,  843,   68,   68,   69,   69,   69,   69,
 /*  1910 */   544,   67,   67,   67,   67,   66,   66,   65,   65,   65,
 /*  1920 */    64,   62,  273,  874,  888,  888,  886,  885,   26,  691,
 /*  1930 */   871,  396,  835,  578,  589,  424,  473,  887,   59,  593,
 /*  1940 */   888,  888,  886,  885,  887,  887,  854,  887,  132,  887,
 /*  1950 */   298,   38,  275,  579,  421,   56,   57,  682,  864,  470,
 /*  1960 */   548,  888,  297,   58,   89,  370,  335, 1250,   88,  855,
 /*  1970 */   223,    2,  887,  541,  839,   25,  841,  465,  546,  341,
 /*  1980 */   538,   87,  888,  888,  886,  885,  163,  162, 1250,  460,
 /*  1990 */   859,  136,  660,  888, 1250,  854,  367,  841,  858,  857,
 /*  2000 */   856,  369,  178,  315,  589,  202,   10,  112,  161,  548,
 /*  2010 */    83,  544,  157,  131,  106,  770,  159,  595,  855,  240,
 /*  2020 */   108,   37,  105,  888,  888,  886,  885,  546,  888,  422,
 /*  2030 */   825,  802,  841,  835,   36,  841,  542,  833,   12,   59,
 /*  2040 */    35, 1250,   34, 1239,  423,  852,  888,  419,  590, 1250,
 /*  2050 */   371,  385,  192,  595, 1250,  285,   56,   57,  887,  887,
 /*  2060 */   393,  887,  888,  104,   58,  395,  311,  636,  347,  781,
 /*  2070 */   623,  630,    2,  700,  541,  625,  838,  841,  437, 1250,
 /*  2080 */   383,  538,  888,  888,  888,  856,  885,  113,  289,  288,
 /*  2090 */   887,  859, 1250,  384, 1250, 1250,  854,  766,  841,  858,
 /*  2100 */   857,  856,  172, 1250,  617, 1250, 1250,  762, 1250,   13,
 /*  2110 */   548,  887,  544,  756,  309,  888,  888,  886,  885,  855,
 /*  2120 */   240,  887,  575,  888,  152,  306, 1250,  887,  546,  168,
 /*  2130 */   420,  827,  826,  841,  835,  577,  841,  576,  833,   12,
 /*  2140 */    59,  182,  206,  887,  592,  888,  499,  723,  150,  598,
 /*  2150 */   888,  888,  886,  885,   99,  149,  284,   56,   57,  148,
 /*  2160 */   887,  887,  556,  888,  147,   58,  854,  888,  888,  888,
 /*  2170 */   886,  885,  574,    2,  332,  541,  144,  337,  841,  573,
 /*  2180 */   548,  383,  538,  556,  888,  888,  856,  885,  877,  855,
 /*  2190 */   240,  887,  859,  592,  888,  698,  854,   90,  546,  841,
 /*  2200 */   858,  857,  856,  676,  888,  888,  886,  885,  331,  887,
 /*  2210 */   548,  416,  554,  544,  145,   97,  266,  887,  662,  855,
 /*  2220 */   240,  281,  887,  121,  326,  262,  502,  493,  546,  875,
 /*  2230 */   854,  258,  887,  180,  841,  835,  454,  841,  887,  833,
 /*  2240 */    12,   59,  387,  879,  548,  888,  888,  886,  885,  654,
 /*  2250 */   887,  383,  386,  855,  127,  891,  502,  407,   56,   57,
 /*  2260 */   804,  651,  546,  887,  431,  881,   58,  888,  888,  886,
 /*  2270 */   885,  880,  551,  873,    2,  887,  179,  177,  887,  841,
 /*  2280 */   111,  383,  461,  538,  888,  888,  888,  856,  885,  888,
 /*  2290 */   888,  886,  885,  859,  550,  561,  541,  854,  364,   78,
 /*  2300 */   841,  858,  857,  856,  191,  292,  850,  174,  888,  887,
 /*  2310 */   545,  548,  887,  854,  508,  802,  888,  888,  886,  885,
 /*  2320 */   855,  127,  849,  361,  887,  854,   24,  548,   46,  546,
 /*  2330 */   888,   73,  327,  360,  544,  841,  855,  240,  841,  548,
 /*  2340 */   833,   12, 1246,  201,  854,  546,  887,  888,  855,  127,
 /*  2350 */   451,  308,  848,  273,  354,  305,  835,  546,  548,  541,
 /*  2360 */    91,  854,   59,  270,  887,  887,  765,  855,  127,  887,
 /*  2370 */   411,  190,  299,  408,  287,  548,  546,   52,  534,   56,
 /*  2380 */    57,  286,  802,  524,  855,  127,  887,   58,  854,  295,
 /*  2390 */   351,  296,  888,  546,  798,    2, 1248,  544,  383,  406,
 /*  2400 */   841,  410,  548,  887,  538,  887,  888,  888,  856,  885,
 /*  2410 */   802,  855,  240,  797,  859,  794,  263,  788,  394,  835,
 /*  2420 */   546,  841,  858,  857,  856,   59,  782,  185,  141,  802,
 /*  2430 */   888,  888,  886,  885,  888,  392,  495,  492,  725,  888,
 /*  2440 */   167,   79,   56,   57,  713,  688,  802,  888,  478,  708,
 /*  2450 */    58,  707,  888,  888,  886,  885,  841,  404,    2,  841,
 /*  2460 */   339,  833,   12,  841,  888,  704,  703,  538,  888,  888,
 /*  2470 */   888,  856,  885,  530,  377,  681,  353,  859,  702,  674,
 /*  2480 */   673,  888,  109,  672,  841,  858,  857,  856,   71,  547,
 /*  2490 */   290,  888,  671,  843,  843,   68,   68,   69,   69,   69,
 /*  2500 */    69,  888,   67,   67,   67,   67,   66,   66,   65,   65,
 /*  2510 */    65,   64,   62,  273,  888,  888,  886,  885,  888,  841,
 /*  2520 */   376,  459,  841,  888,  833,   12,  547,  290,  888,  140,
 /*  2530 */   843,  843,   68,   68,   69,   69,   69,   69,  268,   67,
 /*  2540 */    67,   67,   67,   66,   66,   65,   65,   65,   64,   62,
 /*  2550 */   273,  888,  854,  438,  160,  744,  888,  888,  886,  885,
 /*  2560 */   888,  888,  888,  886,  885,  888,  548,  456,  325,  888,
 /*  2570 */   888,  886,  885,   33,  323,  855,  240,  888,  322,  207,
 /*  2580 */   321,  888,  675,  663,  546,  697,  888,  888,  886,  885,
 /*  2590 */   888,  888,  886,  885,  888,  649,  107,  743,  888,  318,
 /*  2600 */   316,  668,  888,  888,  888,  886,  885,  888,  183,  317,
 /*  2610 */   114,  645,  507,  888,  888,  886,  885,  313,  197,  445,
 /*  2620 */   888,  639,  444,  888,  888,  886,  885,  635,  622,  888,
 /*  2630 */   633,  138,  658,  888,  432,  153,  613,  383,  652,  137,
 /*  2640 */   888,  888,  886,  885,  429,  888,  888,  886,  885,  151,
 /*  2650 */   888,  888,  886,  885,  103,  426,  102,  101,  100,  583,
 /*  2660 */   646,   32,   31,  146,  390,  641,  570,   28,  568,  135,
 /*  2670 */   888,  564,  134,  888,  888,  886,  885,   85,  650,  558,
 /*  2680 */   609,  208,  888,  888,  886,  885,  181,  888,  888,  886,
 /*  2690 */   885,  362,  888,   63,  828,  824,  813,  612,  195,  888,
 /*  2700 */   888,  886,  885,  888,  888,  886,  885,  531,  194,  340,
 /*  2710 */   768,  699,  254,  469,  600,  319,  888,  888,  886,  885,
 /*  2720 */   888,  888,  886,  885,  888,  888,  886,  885,  640,  888,
 /*  2730 */   888,  886,  885,  596,  614,  560,  638,  372,    7,  562,
 /*  2740 */    44,  844,  888,  888,  886,  885,  823,  812,  854,  686,
 /*  2750 */   267,  888,  888,  886,  885,  888,  888,  886,  885,  594,
 /*  2760 */   457,  346,  548,  363,  854,  543,  607,  854,  696,  501,
 /*  2770 */   787,  855,  231,   98,  690,  887,  689,  717,  548,  810,
 /*  2780 */   546,  548,  582,  677,   83,  804,  854,  855,  209,  716,
 /*  2790 */   855,  219,  888,  888,  886,  885,  546,  854, 1400,  546,
 /*  2800 */   548,  763, 1400, 1400, 1400, 1400,   32,  126,  854,  855,
 /*  2810 */   243,  548, 1400,  678,  888,  888,  886,  885,  546, 1400,
 /*  2820 */   855,  241,  548, 1400, 1400,  500,  378, 1400, 1400,  546,
 /*  2830 */   854,  855,  251,  802,  854, 1400, 1400,  854, 1400, 1400,
 /*  2840 */   546, 1400, 1400, 1400,  548, 1400, 1400, 1400,  548,  802,
 /*  2850 */  1400,  548,  802,  855,  250, 1400,  854,  855,  252, 1400,
 /*  2860 */   855,  253,  546, 1400, 1400, 1400,  546, 1400, 1400,  546,
 /*  2870 */   548,  802, 1400, 1400, 1400,  854, 1400, 1400,  854,  855,
 /*  2880 */   272,  854,  802, 1400, 1400, 1400, 1400, 1400,  546,  548,
 /*  2890 */  1400, 1400,  548,  802,  854,  548, 1400,  854,  855,  358,
 /*  2900 */  1400,  855,  249, 1400,  855,  357, 1400,  546,  548, 1400,
 /*  2910 */   546,  548, 1400,  546, 1400,  802,  888,  855,  218,  802,
 /*  2920 */   855,  237,  802,  854, 1400,  854,  546, 1400, 1400,  546,
 /*  2930 */   854, 1400, 1400, 1400, 1400, 1400, 1400,  548, 1400,  548,
 /*  2940 */  1400,  802, 1400, 1400,  548, 1400,  855,  242,  855,  381,
 /*  2950 */  1400, 1400, 1400,  855,  380,  546, 1400,  546, 1400, 1400,
 /*  2960 */   802,  854,  546,  802,  854, 1400,  802,  854, 1400, 1400,
 /*  2970 */  1400, 1400, 1400, 1400, 1400,  548, 1400, 1400,  548,  802,
 /*  2980 */   854,  548,  802, 1400,  855,  379, 1400,  855,  236, 1400,
 /*  2990 */   855,  221, 1400,  546,  548,  854,  546,  854, 1400,  546,
 /*  3000 */   854, 1400,  854,  855,  235, 1400, 1400, 1400,  802,  548,
 /*  3010 */   802,  548,  546, 1400,  548,  802,  548, 1400,  855,  234,
 /*  3020 */   855,  220, 1400,  855,  248,  855,  247,  546, 1400,  546,
 /*  3030 */   854, 1400,  546, 1400,  546, 1400,  854, 1400,  888,  888,
 /*  3040 */   886,  885, 1400, 1400,  548, 1400,  802, 1400, 1400,  802,
 /*  3050 */   548, 1400,  802,  855,  217, 1400, 1400, 1400, 1400,  855,
 /*  3060 */   128, 1400,  546, 1400, 1400,  802, 1400,  854,  546, 1400,
 /*  3070 */  1400, 1400, 1400, 1400,  854, 1400, 1400, 1400, 1400, 1400,
 /*  3080 */   802,  548,  802, 1400, 1400,  802,  854,  802,  548, 1400,
 /*  3090 */   855,  216, 1400,  854, 1400, 1400, 1400,  855,  214,  546,
 /*  3100 */   548, 1400, 1400, 1400, 1400, 1400,  546,  548, 1400,  855,
 /*  3110 */   244, 1400,  854, 1400, 1400,  802,  855,  246,  546, 1400,
 /*  3120 */  1400,  802, 1400,  854, 1400,  546,  548, 1400, 1400, 1400,
 /*  3130 */  1400, 1400, 1400, 1400,  854,  855,  239,  548, 1400, 1400,
 /*  3140 */  1400, 1400, 1400, 1400,  546, 1400,  855,  245,  548,  854,
 /*  3150 */  1400,  854,  802,  854, 1400,  546, 1400,  855,  233,  802,
 /*  3160 */  1400, 1400, 1400,  548, 1400,  548,  546,  548,  854, 1400,
 /*  3170 */  1400,  802,  855,  232,  855,  229,  855,  213,  802, 1400,
 /*  3180 */   854,  546,  548,  546, 1400,  546, 1400, 1400, 1400, 1400,
 /*  3190 */  1400,  855,  212,  854,  548, 1400, 1400,  802, 1400,  854,
 /*  3200 */   546, 1400, 1400,  855,  211, 1400, 1400,  548,  802, 1400,
 /*  3210 */  1400, 1400,  546,  548, 1400, 1400,  855,  210, 1400,  802,
 /*  3220 */  1400, 1400,  855,  222, 1400,  546,  854, 1400,  854, 1400,
 /*  3230 */  1400,  546,  854, 1400,  802, 1400,  802, 1400,  802, 1400,
 /*  3240 */   548, 1400,  548, 1400, 1400, 1400,  548, 1400, 1400,  855,
 /*  3250 */   227,  855,  226,  802, 1400,  855,  129,  854,  546,  854,
 /*  3260 */   546, 1400, 1400, 1400,  546,  802, 1400, 1400, 1400, 1400,
 /*  3270 */  1400,  548,  854,  548, 1400, 1400, 1400, 1400,  802, 1400,
 /*  3280 */   855,  225,  855,  224,  802, 1400,  548, 1400, 1400,  546,
 /*  3290 */  1400,  546,  854, 1400, 1400,  855,  238, 1400,  854, 1400,
 /*  3300 */  1400, 1400, 1400, 1400,  546,  854,  548, 1400, 1400, 1400,
 /*  3310 */  1400,  802,  548,  802, 1400,  855,  230,  802, 1400,  548,
 /*  3320 */  1400,  855,  228, 1400,  546, 1400,  854, 1400,  855,  215,
 /*  3330 */   546, 1400, 1400, 1400, 1400, 1400, 1400,  546, 1400, 1400,
 /*  3340 */   548, 1400,  802, 1400,  802, 1400, 1400, 1400, 1400,  855,
 /*  3350 */    96, 1400, 1400, 1400, 1400, 1400, 1400,  802,  498, 1400,
 /*  3360 */  1400, 1400, 1400, 1400, 1400, 1400, 1400, 1400, 1400, 1400,
 /*  3370 */  1400, 1400, 1400, 1400, 1400, 1400, 1400,  802, 1400, 1400,
 /*  3380 */  1400, 1400, 1400,  802, 1400, 1400, 1400, 1400, 1400, 1400,
 /*  3390 */   802, 1400, 1400, 1400, 1400, 1400, 1400, 1400, 1400, 1400,
 /*  3400 */  1400, 1400, 1400, 1400, 1400, 1400, 1400, 1400, 1400, 1400,
 /*  3410 */  1400,  802,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     4,  147,  148,  149,   48,    4,   21,   80,   81,   82,
 /*    10 */    83,    0,   16,   86,   87,   88,   89,   90,   91,   92,
 /*    20 */    93,   36,   95,   96,   97,   98,   99,  100,  101,  102,
 /*    30 */   103,  104,  105,  106,   71,  108,   80,   81,   82,   83,
 /*    40 */    29,  108,   86,   87,   88,   89,   90,   91,   92,   93,
 /*    50 */    54,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*    60 */   104,  105,  106,    4,  108,   40,   41,  251,  252,    4,
 /*    70 */   254,  108,   76,   75,   90,   91,   92,   93,   82,   95,
 /*    80 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*    90 */   106,  204,  128,  112,  101,   99,  100,  101,  134,  116,
 /*   100 */   204,    4,  286,  107,  108,  218,  142,  143,  144,   84,
 /*   110 */    85,  115,  116,   16,  218,   66,  120,  121,   69,  108,
 /*   120 */   124,   24,  126,  127,  128,  129,   66,  126,  127,   69,
 /*   130 */   134,  101,  102,  103,  104,  105,  106,  141,  142,  143,
 /*   140 */   144,   76,  146,   99,  100,  101,  102,  103,  104,  105,
 /*   150 */   106,   54,  154,  160,  116,  159,  163,  161,  162,  121,
 /*   160 */     4,  165,  275,  114,   99,  100,  170,  171,  172,  173,
 /*   170 */   174,  175,  176,   76,  114,  179,    4,  181,  182,   82,
 /*   180 */   115,  104,  105,  106,  204,  126,  127,  128,  129,  193,
 /*   190 */   192,  126,  127,  128,  214,  215,   99,  100,  218,  134,
 /*   200 */   141,  115,    4,  117,  107,  108,   41,  142,  143,  144,
 /*   210 */   121,  121,  115,  116,   16,   34,  320,  120,  121,  204,
 /*   220 */   240,  124,  242,  126,  127,  128,  129,   79,  115,   19,
 /*   230 */     4,  134,   51,  218,  234,  176,   55,  237,  141,  142,
 /*   240 */   143,  144,   61,  146,  244,    4,  186,   82,  159,  196,
 /*   250 */   161,  162,   54,   43,  201,    7,  159,  116,  161,  162,
 /*   260 */    12,    4,  121,  115,  116,  212,   15,  170,  171,  172,
 /*   270 */   173,    5,  175,  176,   76,   65,  179,  116,  181,  182,
 /*   280 */    82,  125,  126,  127,  128,  129,   38,  115,  132,  117,
 /*   290 */   193,  135,  136,  137,   43,  146,   30,   99,  100,  116,
 /*   300 */   128,   35,  249,  250,  121,  107,  108,  204,  121,  153,
 /*   310 */    59,  146,  297,  115,  116,  166,   34,  152,  120,  121,
 /*   320 */   204,  218,  124,    4,  126,  127,  128,  129,   62,    4,
 /*   330 */   134,  170,  134,  280,  218,  282,  164,   55,  285,  141,
 /*   340 */   142,  143,  144,   61,  146,  183,  120,  185,  204,   99,
 /*   350 */   100,  170,  126,  127,  128,  129,  115,  159,  101,  161,
 /*   360 */   162,  174,  218,    4,  311,   40,   41,  141,  170,  128,
 /*   370 */   172,  173,  118,  175,  176,   21,  134,  179,  275,  181,
 /*   380 */   182,  171,   28,  126,  127,  128,  129,  243,   82,  121,
 /*   390 */    36,  193,  142,  143,  152,  169,    4,  129,  141,  283,
 /*   400 */     4,   26,  151,  121,  118,   80,   81,   82,   83,   84,
 /*   410 */    85,   86,   87,   88,   89,   90,   91,   92,   93,    4,
 /*   420 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   430 */   105,  106,   73,  176,  115,  167,  168,  251,  252,  120,
 /*   440 */   254,  297,  117,   24,   31,  126,  127,  128,  129,  295,
 /*   450 */    40,   41,   39,  128,  116,   80,   81,   82,   83,  121,
 /*   460 */    50,   86,   87,   88,   89,   90,   91,   92,   93,  163,
 /*   470 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   480 */   105,  106,  123,  329,  330,  126,  127,  128,  129,  164,
 /*   490 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   500 */    90,   91,   92,   93,  295,   95,   96,   97,   98,   99,
 /*   510 */   100,  101,  102,  103,  104,  105,  106,   10,  126,  127,
 /*   520 */   128,  129,  126,  127,  128,  129,   58,  133,  134,   22,
 /*   530 */   290,  121,   34,  141,  115,  120,  115,  141,  329,  330,
 /*   540 */   204,  126,  127,  128,  129,  209,   42,   40,   41,  309,
 /*   550 */   214,  215,  156,   55,  218,  140,  141,  121,  183,   61,
 /*   560 */   185,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   570 */    99,  100,  101,  102,  103,  104,  105,  106,  116,  121,
 /*   580 */     4,  145,   79,  121,  169,   26,   82,   80,   81,   82,
 /*   590 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   600 */    93,   89,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   610 */   103,  104,  105,  106,  121,  147,  148,  149,  115,  116,
 /*   620 */   223,  224,  225,  165,  121,  157,  158,  115,   40,   41,
 /*   630 */    79,  274,  132,  116,  277,  135,  136,  137,  121,   80,
 /*   640 */    81,   82,   83,   13,    4,   86,   87,   88,   89,   90,
 /*   650 */    91,   92,   93,  153,   95,   96,   97,   98,   99,  100,
 /*   660 */   101,  102,  103,  104,  105,  106,  115,  116,   80,   81,
 /*   670 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   680 */    92,   93,  115,   95,   96,   97,   98,   99,  100,  101,
 /*   690 */   102,  103,  104,  105,  106,    4,  120,  116,  301,  147,
 /*   700 */   148,  149,  126,  127,  128,  129,  226,   16,  117,  118,
 /*   710 */    80,   81,   82,   83,  234,  235,   86,   87,   88,   89,
 /*   720 */    90,   91,   92,   93,  116,   95,   96,   97,   98,   99,
 /*   730 */   100,  101,  102,  103,  104,  105,  106,  116,  108,    5,
 /*   740 */    79,    4,  183,  115,  185,   54,   95,   96,   97,   98,
 /*   750 */    99,  100,  101,  102,  103,  104,  105,  106,    4,  142,
 /*   760 */   143,  204,   71,    4,   30,  189,  220,   76,  128,   35,
 /*   770 */   204,  214,  215,   82,  204,  218,  115,  116,  212,  121,
 /*   780 */   140,  216,  121,  213,  218,  220,  221,  222,  218,    4,
 /*   790 */    99,  100,   58,  227,  228,    4,   62,  149,  107,   64,
 /*   800 */   256,  116,  236,  117,  118,   70,  115,  116,   71,  295,
 /*   810 */   266,  120,    4,  267,  204,  124,  250,  126,  127,  128,
 /*   820 */   129,    4,  212,  165,   16,  134,  178,   19,  218,  121,
 /*   830 */   264,  265,  141,  142,  143,  144,  290,  227,  228,  197,
 /*   840 */   198,  199,  200,  329,  330,  204,  236,  204,  157,  158,
 /*   850 */    72,  212,  115,  116,    4,  289,   78,  120,    4,  218,
 /*   860 */   250,  218,   54,  126,  127,  128,  129,  176,  227,  228,
 /*   870 */   179,  136,  181,  182,  264,   67,  122,  236,  141,    4,
 /*   880 */   126,  127,  128,  129,   76,  126,  127,  128,  129,  250,
 /*   890 */    82,  121,   84,  156,  157,  158,  204,    4,  139,  289,
 /*   900 */   115,  160,    4,   82,  163,  120,  115,   99,  100,   16,
 /*   910 */   218,  126,  127,  128,  129,  107,  206,  126,  127,  128,
 /*   920 */   129,  186,   82,  115,    4,   42,  141,  106,  120,    4,
 /*   930 */   289,  230,  124,  212,  126,  127,  128,  129,  117,    4,
 /*   940 */   170,  156,  134,  126,  127,  128,  129,   54,  127,  141,
 /*   950 */   142,  143,  144,  132,  133,  134,  135,  136,  137,  138,
 /*   960 */   268,  269,  319,  320,   71,  324,  126,  176,  327,   76,
 /*   970 */   120,  250,  194,  152,  120,   82,  126,  127,  128,  129,
 /*   980 */   126,  127,  128,  129,  176,  274,  169,  179,  277,  181,
 /*   990 */   182,  290,   99,  100,  119,  120,  204,    4,  204,    4,
 /*  1000 */   107,  126,  127,  128,  129,  211,  296,  213,  115,  261,
 /*  1010 */   218,  263,  218,  120,  117,  118,  204,  124,  115,  126,
 /*  1020 */   127,  128,  129,  220,  221,  222,  128,  134,  130,  204,
 /*  1030 */   218,   41,  256,   32,  141,  142,  143,  144,  188,  119,
 /*  1040 */   120,  187,  266,  218,    4,   10,  126,  127,  128,  129,
 /*  1050 */   157,  158,  204,  128,   53,  120,  208,   22,  245,    4,
 /*  1060 */   247,  126,  127,  128,  129,  140,  218,  275,  116,  176,
 /*  1070 */   116,   16,  179,  121,  181,  182,  141,  212,  223,  224,
 /*  1080 */   225,   80,   81,   82,   83,   26,    4,   86,   87,   88,
 /*  1090 */    89,   90,   91,   92,   93,    4,   95,   96,   97,   98,
 /*  1100 */    99,  100,  101,  102,  103,  104,  105,  106,  115,   54,
 /*  1110 */   204,  299,  117,  120,  249,  250,  204,  312,  313,  126,
 /*  1120 */   127,  128,  129,  128,  218,   34,  274,  116,  116,  277,
 /*  1130 */   218,   76,  121,  116,  141,  116,  146,   82,  121,  227,
 /*  1140 */   228,  316,   51,  318,  204,  280,   55,  282,  236,  156,
 /*  1150 */   285,    4,   61,  204,   99,  100,  301,  212,  218,  164,
 /*  1160 */   167,  168,  107,  204,  116,  212,    4,  218,  128,  121,
 /*  1170 */   115,  116,  307,  224,  225,  120,    4,  218,  163,  124,
 /*  1180 */   140,  126,  127,  128,  129,   71,  199,  200,   16,  134,
 /*  1190 */   278,   19,  204,  322,  323,  250,  141,  142,  143,  144,
 /*  1200 */   204,  289,  249,  250,  208,  183,  218,  204,  126,  127,
 /*  1210 */   128,  129,  322,  323,  218,  227,  228,  126,  127,  128,
 /*  1220 */   129,  218,  170,  141,  236,  170,   54,  321,  322,  323,
 /*  1230 */   212,  176,  204,  280,  179,  282,  181,  182,  285,   67,
 /*  1240 */     4,   14,  283,  218,  219,  193,  218,  133,   76,  300,
 /*  1250 */   301,  169,  264,  265,   82,  227,  228,    4,  318,  306,
 /*  1260 */   307,  170,    4,  165,  236,  116,    4,  120,  250,  204,
 /*  1270 */   121,   99,  100,  126,  127,  128,  129,  289,  275,  107,
 /*  1280 */   204,  204,  120,  218,  245,  208,  247,  115,  126,  127,
 /*  1290 */   128,  129,  120,  204,  218,  218,  124,    4,  126,  127,
 /*  1300 */   128,  129,  155,  141,  204,  165,  134,  218,    4,   16,
 /*  1310 */   204,  204,   19,  141,  142,  143,  144,  289,  218,  243,
 /*  1320 */    80,   81,   82,   83,  218,  218,   86,   87,   88,   89,
 /*  1330 */    90,   91,   92,   93,  269,   95,   96,   97,   98,   99,
 /*  1340 */   100,  101,  102,  103,  104,  105,  106,   54,  176,  243,
 /*  1350 */   243,  179,  324,  181,  182,  327,  116,  204,  212,   29,
 /*  1360 */    67,  218,  126,  127,  128,  129,  322,  323,  115,   76,
 /*  1370 */   227,  218,  110,  297,  117,   82,  220,  141,  120,  126,
 /*  1380 */   127,  128,  129,  115,  126,  127,  128,  129,  126,  127,
 /*  1390 */   128,  129,   99,  100,    4,   26,  250,  116,   78,  141,
 /*  1400 */   107,  204,  121,  297,  297,  169,  322,  323,  115,  121,
 /*  1410 */   321,  322,  323,  120,  116,  218,  316,  124,  318,  126,
 /*  1420 */   127,  128,  129,  267,  120,  322,  323,  134,  275,  176,
 /*  1430 */   126,  127,  128,  129,  141,  142,  143,  144,  108,  220,
 /*  1440 */    71,   80,   81,   82,   83,  141,  121,   86,   87,   88,
 /*  1450 */    89,   90,   91,   92,   93,  230,   95,   96,   97,   98,
 /*  1460 */    99,  100,  101,  102,  103,  104,  105,  106,   26,  176,
 /*  1470 */    14,  116,  179,  276,  181,  182,  121,  108,  117,   60,
 /*  1480 */   116,   80,   81,   82,   83,  121,  267,   86,   87,   88,
 /*  1490 */    89,   90,   91,   92,   93,  204,   95,   96,   97,   98,
 /*  1500 */    99,  100,  101,  102,  103,  104,  105,  106,  116,  218,
 /*  1510 */   157,  158,  204,  121,  194,  290,  126,  127,  128,  129,
 /*  1520 */    45,    4,   80,   81,   82,   83,  218,   81,   86,   87,
 /*  1530 */    88,   89,   90,   91,   92,   93,   32,   95,   96,   97,
 /*  1540 */    98,   99,  100,  101,  102,  103,  104,  105,  106,   80,
 /*  1550 */    81,   82,   83,    4,  164,   86,   87,   88,   89,   90,
 /*  1560 */    91,   92,   93,  220,   95,   96,   97,   98,   99,  100,
 /*  1570 */   101,  102,  103,  104,  105,  106,   60,   53,  220,   14,
 /*  1580 */    80,   81,   82,   83,  276,  184,   86,   87,   88,   89,
 /*  1590 */    90,   91,   92,   93,   14,   95,   96,   97,   98,   99,
 /*  1600 */   100,  101,  102,  103,  104,  105,  106,   14,   14,  121,
 /*  1610 */   267,   80,   81,   82,   83,   14,  116,   86,   87,   88,
 /*  1620 */    89,   90,   91,   92,   93,  267,   95,   96,   97,   98,
 /*  1630 */    99,  100,  101,  102,  103,  104,  105,  106,  204,  126,
 /*  1640 */   115,  167,  208,  126,  127,  128,  129,  116,   80,   81,
 /*  1650 */    82,   83,  218,  184,   86,   87,   88,   89,   90,   91,
 /*  1660 */    92,   93,  116,   95,   96,   97,   98,   99,  100,  101,
 /*  1670 */   102,  103,  104,  105,  106,  126,  127,  128,  129,   80,
 /*  1680 */    81,   82,   83,  116,  116,   86,   87,   88,   89,   90,
 /*  1690 */    91,   92,   93,  204,   95,   96,   97,   98,   99,  100,
 /*  1700 */   101,  102,  103,  104,  105,  106,  189,  218,  116,  118,
 /*  1710 */    80,   81,   82,   83,  118,  116,   86,   87,   88,   89,
 /*  1720 */    90,   91,   92,   93,  204,   95,   96,   97,   98,   99,
 /*  1730 */   100,  101,  102,  103,  104,  105,  106,  101,  218,  190,
 /*  1740 */     4,   80,   81,   82,   83,  121,  116,   86,   87,   88,
 /*  1750 */    89,   90,   91,   92,   93,  204,   95,   96,   97,   98,
 /*  1760 */    99,  100,  101,  102,  103,  104,  105,  106,  115,  218,
 /*  1770 */   116,  115,   80,   81,   82,   83,  160,  116,   86,   87,
 /*  1780 */    88,   89,   90,   91,   92,   93,  204,   95,   96,   97,
 /*  1790 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  116,
 /*  1800 */   218,  116,    4,  171,   80,   81,   82,   83,  115,  117,
 /*  1810 */    86,   87,   88,   89,   90,   91,   92,   93,    4,   95,
 /*  1820 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1830 */   106,   14,  108,   80,   81,   82,   83,  170,  116,   86,
 /*  1840 */    87,   88,   89,   90,   91,   92,   93,  115,   95,   96,
 /*  1850 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1860 */     4,  108,  126,  127,  128,  129,   14,  116,   80,   81,
 /*  1870 */    82,   83,   16,  174,   86,   87,   88,   89,   90,   91,
 /*  1880 */    92,   93,   18,   95,   96,   97,   98,   99,  100,  101,
 /*  1890 */   102,  103,  104,  105,  106,   48,   80,   81,   82,   83,
 /*  1900 */   164,    4,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1910 */    54,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1920 */   104,  105,  106,  204,  126,  127,  128,  129,  115,    6,
 /*  1930 */   204,  204,   76,  204,  120,  204,  117,  218,   82,  208,
 /*  1940 */   126,  127,  128,  129,  218,  218,  204,  218,    9,  218,
 /*  1950 */    11,  115,   13,  224,  225,   99,  100,    8,  204,   48,
 /*  1960 */   218,    4,   23,  107,  115,   26,  116,   34,  115,  227,
 /*  1970 */   228,  115,  218,   16,  176,  115,  120,   48,  236,  152,
 /*  1980 */   124,  115,  126,  127,  128,  129,  138,  118,   55,   82,
 /*  1990 */   134,   52,  124,    4,   61,  204,   57,  141,  142,  143,
 /*  2000 */   144,   62,   63,  276,  190,  117,   13,   68,  118,  218,
 /*  2010 */    71,   54,  117,   74,  151,  121,  146,  120,  227,  228,
 /*  2020 */   165,   89,  177,  126,  127,  128,  129,  236,    4,  300,
 /*  2030 */   301,  289,  176,   76,   89,  179,  180,  181,  182,   82,
 /*  2040 */    89,  108,   89,  108,  204,  204,    4,  204,  208,  116,
 /*  2050 */   111,  208,  113,  156,  121,  264,   99,  100,  218,  218,
 /*  2060 */    24,  218,    4,  151,  107,   18,  158,  178,  326,  327,
 /*  2070 */    60,  108,  115,  116,   16,  108,  204,  120,   25,  146,
 /*  2080 */   289,  124,    4,  126,  127,  128,  129,   49,   99,  100,
 /*  2090 */   218,  134,  159,  154,  161,  162,  204,  204,  141,  142,
 /*  2100 */   143,  144,  121,  170,   49,  172,  173,  204,  175,  115,
 /*  2110 */   218,  218,   54,  204,  186,  126,  127,  128,  129,  227,
 /*  2120 */   228,  218,  133,    4,  146,  114,  193,  218,  236,  204,
 /*  2130 */   191,  142,  143,  176,   76,  146,  179,  148,  181,  182,
 /*  2140 */    82,  166,  115,  218,  120,    4,  204,  204,  118,  124,
 /*  2150 */   126,  127,  128,  129,  114,  118,  264,   99,  100,  118,
 /*  2160 */   218,  218,  120,    4,  118,  107,  204,    4,  126,  127,
 /*  2170 */   128,  129,  116,  115,  116,   16,  112,  204,  120,  116,
 /*  2180 */   218,  289,  124,  141,  126,  127,  128,  129,  110,  227,
 /*  2190 */   228,  218,  134,  169,    4,  204,  204,   56,  236,  141,
 /*  2200 */   142,  143,  144,  204,  126,  127,  128,  129,  204,  218,
 /*  2210 */   218,   47,   46,   54,  118,  217,  290,  218,  204,  227,
 /*  2220 */   228,  233,  218,  233,  204,  270,  264,  265,  236,  110,
 /*  2230 */   204,  313,  218,  109,  176,   76,  204,  179,  218,  181,
 /*  2240 */   182,   82,  315,   63,  218,  126,  127,  128,  129,  204,
 /*  2250 */   218,  289,  315,  227,  228,  203,  264,  265,   99,  100,
 /*  2260 */   119,  204,  236,  218,  204,  203,  107,  126,  127,  128,
 /*  2270 */   129,  203,  203,  110,  115,  218,  205,  205,  218,  120,
 /*  2280 */   207,  289,   77,  124,    4,  126,  127,  128,  129,  126,
 /*  2290 */   127,  128,  129,  134,  210,  204,   16,  204,  204,  121,
 /*  2300 */   141,  142,  143,  144,  278,  157,  273,  118,    4,  218,
 /*  2310 */   204,  218,  218,  204,  171,  289,  126,  127,  128,  129,
 /*  2320 */   227,  228,  252,  258,  218,  204,  174,  218,  172,  236,
 /*  2330 */     4,  173,  204,  259,   54,  176,  227,  228,  179,  218,
 /*  2340 */   181,  182,  183,  260,  204,  236,  218,    4,  227,  228,
 /*  2350 */   204,  204,  262,  106,  232,  204,   76,  236,  218,   16,
 /*  2360 */   115,  204,   82,  106,  218,  218,  176,  227,  228,  218,
 /*  2370 */   117,  278,  204,  264,  298,  218,  236,  183,  317,   99,
 /*  2380 */   100,  293,  289,  170,  227,  228,  218,  107,  204,  204,
 /*  2390 */   261,  204,    4,  236,  262,  115,  116,   54,  289,  278,
 /*  2400 */   120,   44,  218,  218,  124,  218,  126,  127,  128,  129,
 /*  2410 */   289,  227,  228,  279,  134,  279,   27,  325,  278,   76,
 /*  2420 */   236,  141,  142,  143,  144,   82,  325,  273,  118,  289,
 /*  2430 */   126,  127,  128,  129,    4,  278,  254,  158,  330,    4,
 /*  2440 */   194,  115,   99,  100,  229,  141,  289,    4,  146,  229,
 /*  2450 */   107,  239,  126,  127,  128,  129,  176,   37,  115,  179,
 /*  2460 */   229,  181,  182,  120,    4,  231,  145,  124,    4,  126,
 /*  2470 */   127,  128,  129,  289,  232,  239,  292,  134,  229,  229,
 /*  2480 */   229,    4,  207,  229,  141,  142,  143,  144,   81,   82,
 /*  2490 */    83,    4,  229,   86,   87,   88,   89,   90,   91,   92,
 /*  2500 */    93,    4,   95,   96,   97,   98,   99,  100,  101,  102,
 /*  2510 */   103,  104,  105,  106,  126,  127,  128,  129,    4,  176,
 /*  2520 */   232,  232,  179,    4,  181,  182,   82,   83,    4,  207,
 /*  2530 */    86,   87,   88,   89,   90,   91,   92,   93,  273,   95,
 /*  2540 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  2550 */   106,    4,  204,   33,  118,  167,  126,  127,  128,  129,
 /*  2560 */     4,  126,  127,  128,  129,    4,  218,  305,  304,  126,
 /*  2570 */   127,  128,  129,  183,  258,  227,  228,    4,  281,  175,
 /*  2580 */   261,    4,  139,  119,  236,  150,  126,  127,  128,  129,
 /*  2590 */   126,  127,  128,  129,    4,  262,  246,  167,    4,  258,
 /*  2600 */   261,  141,    4,  126,  127,  128,  129,    4,   80,  281,
 /*  2610 */   115,  262,  264,  126,  127,  128,  129,  287,  284,  146,
 /*  2620 */     4,  281,  258,  126,  127,  128,  129,  281,  141,    4,
 /*  2630 */   246,  207,  155,    4,  273,  118,  258,  289,  141,  207,
 /*  2640 */   126,  127,  128,  129,  273,  126,  127,  128,  129,  118,
 /*  2650 */   126,  127,  128,  129,  248,   77,  248,  248,  248,  299,
 /*  2660 */   141,  177,  308,  118,  273,  141,   20,  308,  273,  118,
 /*  2670 */     4,  273,  118,  126,  127,  128,  129,  310,  164,   17,
 /*  2680 */   119,  255,  126,  127,  128,  129,  310,  126,  127,  128,
 /*  2690 */   129,  257,    4,  290,  301,  301,  230,  141,  261,  126,
 /*  2700 */   127,  128,  129,  126,  127,  128,  129,  294,  261,  230,
 /*  2710 */   272,  237,  241,  231,  141,  257,  126,  127,  128,  129,
 /*  2720 */   126,  127,  128,  129,  126,  127,  128,  129,  288,  126,
 /*  2730 */   127,  128,  129,  156,  187,  119,  258,  202,  255,  141,
 /*  2740 */   291,  220,  126,  127,  128,  129,  220,  220,  204,  220,
 /*  2750 */   302,  126,  127,  128,  129,  126,  127,  128,  129,  169,
 /*  2760 */   303,  204,  218,  253,  204,  247,  314,  204,  238,  212,
 /*  2770 */   328,  227,  228,  271,  238,  218,  238,  227,  218,  176,
 /*  2780 */   236,  218,  188,  242,   71,  119,  204,  227,  228,  227,
 /*  2790 */   227,  228,  126,  127,  128,  129,  236,  204,  331,  236,
 /*  2800 */   218,  176,  331,  331,  331,  331,  177,  250,  204,  227,
 /*  2810 */   228,  218,  331,  125,  126,  127,  128,  129,  236,  331,
 /*  2820 */   227,  228,  218,  331,  331,  268,  269,  331,  331,  236,
 /*  2830 */   204,  227,  228,  289,  204,  331,  331,  204,  331,  331,
 /*  2840 */   236,  331,  331,  331,  218,  331,  331,  331,  218,  289,
 /*  2850 */   331,  218,  289,  227,  228,  331,  204,  227,  228,  331,
 /*  2860 */   227,  228,  236,  331,  331,  331,  236,  331,  331,  236,
 /*  2870 */   218,  289,  331,  331,  331,  204,  331,  331,  204,  227,
 /*  2880 */   228,  204,  289,  331,  331,  331,  331,  331,  236,  218,
 /*  2890 */   331,  331,  218,  289,  204,  218,  331,  204,  227,  228,
 /*  2900 */   331,  227,  228,  331,  227,  228,  331,  236,  218,  331,
 /*  2910 */   236,  218,  331,  236,  331,  289,    4,  227,  228,  289,
 /*  2920 */   227,  228,  289,  204,  331,  204,  236,  331,  331,  236,
 /*  2930 */   204,  331,  331,  331,  331,  331,  331,  218,  331,  218,
 /*  2940 */   331,  289,  331,  331,  218,  331,  227,  228,  227,  228,
 /*  2950 */   331,  331,  331,  227,  228,  236,  331,  236,  331,  331,
 /*  2960 */   289,  204,  236,  289,  204,  331,  289,  204,  331,  331,
 /*  2970 */   331,  331,  331,  331,  331,  218,  331,  331,  218,  289,
 /*  2980 */   204,  218,  289,  331,  227,  228,  331,  227,  228,  331,
 /*  2990 */   227,  228,  331,  236,  218,  204,  236,  204,  331,  236,
 /*  3000 */   204,  331,  204,  227,  228,  331,  331,  331,  289,  218,
 /*  3010 */   289,  218,  236,  331,  218,  289,  218,  331,  227,  228,
 /*  3020 */   227,  228,  331,  227,  228,  227,  228,  236,  331,  236,
 /*  3030 */   204,  331,  236,  331,  236,  331,  204,  331,  126,  127,
 /*  3040 */   128,  129,  331,  331,  218,  331,  289,  331,  331,  289,
 /*  3050 */   218,  331,  289,  227,  228,  331,  331,  331,  331,  227,
 /*  3060 */   228,  331,  236,  331,  331,  289,  331,  204,  236,  331,
 /*  3070 */   331,  331,  331,  331,  204,  331,  331,  331,  331,  331,
 /*  3080 */   289,  218,  289,  331,  331,  289,  204,  289,  218,  331,
 /*  3090 */   227,  228,  331,  204,  331,  331,  331,  227,  228,  236,
 /*  3100 */   218,  331,  331,  331,  331,  331,  236,  218,  331,  227,
 /*  3110 */   228,  331,  204,  331,  331,  289,  227,  228,  236,  331,
 /*  3120 */   331,  289,  331,  204,  331,  236,  218,  331,  331,  331,
 /*  3130 */   331,  331,  331,  331,  204,  227,  228,  218,  331,  331,
 /*  3140 */   331,  331,  331,  331,  236,  331,  227,  228,  218,  204,
 /*  3150 */   331,  204,  289,  204,  331,  236,  331,  227,  228,  289,
 /*  3160 */   331,  331,  331,  218,  331,  218,  236,  218,  204,  331,
 /*  3170 */   331,  289,  227,  228,  227,  228,  227,  228,  289,  331,
 /*  3180 */   204,  236,  218,  236,  331,  236,  331,  331,  331,  331,
 /*  3190 */   331,  227,  228,  204,  218,  331,  331,  289,  331,  204,
 /*  3200 */   236,  331,  331,  227,  228,  331,  331,  218,  289,  331,
 /*  3210 */   331,  331,  236,  218,  331,  331,  227,  228,  331,  289,
 /*  3220 */   331,  331,  227,  228,  331,  236,  204,  331,  204,  331,
 /*  3230 */   331,  236,  204,  331,  289,  331,  289,  331,  289,  331,
 /*  3240 */   218,  331,  218,  331,  331,  331,  218,  331,  331,  227,
 /*  3250 */   228,  227,  228,  289,  331,  227,  228,  204,  236,  204,
 /*  3260 */   236,  331,  331,  331,  236,  289,  331,  331,  331,  331,
 /*  3270 */   331,  218,  204,  218,  331,  331,  331,  331,  289,  331,
 /*  3280 */   227,  228,  227,  228,  289,  331,  218,  331,  331,  236,
 /*  3290 */   331,  236,  204,  331,  331,  227,  228,  331,  204,  331,
 /*  3300 */   331,  331,  331,  331,  236,  204,  218,  331,  331,  331,
 /*  3310 */   331,  289,  218,  289,  331,  227,  228,  289,  331,  218,
 /*  3320 */   331,  227,  228,  331,  236,  331,  204,  331,  227,  228,
 /*  3330 */   236,  331,  331,  331,  331,  331,  331,  236,  331,  331,
 /*  3340 */   218,  331,  289,  331,  289,  331,  331,  331,  331,  227,
 /*  3350 */   228,  331,  331,  331,  331,  331,  331,  289,  236,  331,
 /*  3360 */   331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*  3370 */   331,  331,  331,  331,  331,  331,  331,  289,  331,  331,
 /*  3380 */   331,  331,  331,  289,  331,  331,  331,  331,  331,  331,
 /*  3390 */   289,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*  3400 */   331,  331,  331,  331,  331,  331,  331,  331,  331,  331,
 /*  3410 */   331,  289,
};
#define YY_SHIFT_USE_DFLT (-147)
#define YY_SHIFT_COUNT (552)
#define YY_SHIFT_MIN   (-146)
#define YY_SHIFT_MAX   (2912)
static const short yy_shift_ofst[] = {
 /*     0 */  1330,  691,  893, 1939,  808, 1293, 1172, 1055, 2280, 2280,
 /*    10 */   -37,  198, 2159, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    20 */  2343, 2343, 1369,   -4,   97, 2058, 1957, 1856, 2343, 2343,
 /*    30 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    40 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    50 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    60 */  2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343, 2343,
 /*    70 */  2343, 2343, 2343, 2343, 2343,  737, 1989, 1989,  156, 1091,
 /*    80 */  1091, 2688,  993, 2141,  359, 2688,  468, 2603, 2603, 2603,
 /*    90 */  2666, 2603, 2912,  250,  250,  898,  325,  821,  785, 2042,
 /*   100 */  1814, 2024, 1897, 1304, 1253, 1258, 1253, 1162,  935, 1147,
 /*   110 */   359,  920, 2629, 2625, 2625, 2625, 2625, 2625, 2603, 2912,
 /*   120 */  2912,  165,  778,  898, 1320, 1320, 1353,  507,  507,  -44,
 /*   130 */    65,  415,  226,  257, 1236, 1082,  850,  875,  854,  791,
 /*   140 */   576,  396,   59,  319, 2616, 2598, 2594, 1549, 2590, 2577,
 /*   150 */  2573, 2561, 2556, 2547, 2524, 2519, 2514, 1736, 2497, 2487,
 /*   160 */  1517, 2477, 2464, 2460, 2443, 2435, 2304, 2326, 2430, 2388,
 /*   170 */   817, 1390, 2190, 1798,  392,  759,  754, 2163, 2119, 2078,
 /*   180 */  1262, 2912, 2912,  734,  734,  172,  181,  995,  995,  995,
 /*   190 */   282,  282,  735,    1,  498,  498,   11, 1114,  840,  840,
 /*   200 */   840, 1052, 2713, 2713, 2713, 2713, -147, -147, -147,  410,
 /*   210 */   588,  588,  588,  588,  588,  588,  588,  588,  588,  588,
 /*   220 */   559,  375,  630, 1001, 1753, 1724, 1692,  -73, 1661, 1630,
 /*   230 */  1599, 1568, 1531, 1500, 1469, 1442, 1401, 1361, 1240, 1816,
 /*   240 */  1788, 2407, 2444, 2444,  471,  -16,  -16,  -16,  -16,  -16,
 /*   250 */   -16,  651,   44,   30,  500,  -36,  -36,  661,  503,  251,
 /*   260 */   251,  251,  268,  210,  266,   89,   25,  552,  248, 1040,
 /*   270 */   925,  241,   77,  640,   -7,  354,  187, 1392,  658,  436,
 /*   280 */  1364,  990, 1035,  149,  770,  770,  162, 1035,  617,  617,
 /*   290 */   306,  458,  741, 2662, 2662, 2554, 2551, 2646, 2646, 2545,
 /*   300 */  2484, 2578, 2578, 2578, 2578, 2531, 2205, 2152, 2517, 2205,
 /*   310 */  2528, 2404, 2152, 2404, 2473, 2495, 2158, 2213, 2404, 2152,
 /*   320 */  2528, 2158, 2213, 2404, 2152, 2390, 2520, 2436, 2205, 2245,
 /*   330 */  2205, 2245, 2302, 2302, 2302, 2302, 2420, 2245, 2302, 2321,
 /*   340 */  2302, 2420, 2302, 2302, 2246, 2279, 2310, 2389, 2389, 2357,
 /*   350 */  2357, 2158, 2213, 2194, 2253, 2257, 2245, 2247, 2247, 2158,
 /*   360 */  2156, 2143, 2152, 2148, 2189, 2178, 2205, 2180, 2180, 2124,
 /*   370 */  2124, 2124, 2124, -147, -147, -147, -147, -147, -147, -147,
 /*   380 */  -147, -147, -147, 1933,   60,   -2,  551,  148, -146,   49,
 /*   390 */   512, 1355, 1281,  648, 1149,  419,  897, 1048, 1017,  686,
 /*   400 */   591, 1011,  952,  394,  -15,  242,  517,  161,  462,  338,
 /*   410 */   413,  504,  183,  141,   38,   86, 2166, 2164, 2064, 2096,
 /*   420 */  2040, 2063, 2056, 2046, 2041, 2037, 2025, 2030, 2027, 1975,
 /*   430 */  2011, 1994, 1978, 1928, 2055, 1981, 2038, 2010, 2053, 1967,
 /*   440 */  1963, 1908, 1889, 1912, 2036, 2047, 1935, 1845, 1953, 1951,
 /*   450 */  1945, 1932, 1863, 1894, 1895, 1855, 1993, 1870, 1890, 1888,
 /*   460 */  1868, 1907, 1869, 1827, 1848, 1866, 1929, 1860, 1853, 1850,
 /*   470 */  1849, 1911, 1949, 1836, 1819, 1923, 1813, 1847, 1864, 1751,
 /*   480 */  1852, 1699, 1732, 1722, 1817, 1667, 1693, 1632, 1685, 1683,
 /*   490 */  1624, 1616, 1656, 1654, 1653, 1624, 1636, 1596, 1591, 1474,
 /*   500 */  1592, 1567, 1488, 1546, 1513, 1601, 1525, 1488, 1594, 1593,
 /*   510 */  1580, 1565, 1524, 1516, 1504, 1446, 1419, 1475, 1456, 1298,
 /*   520 */  1268, 1257, 1325, 1288, 1227, 1140, 1098, 1015, 1019, 1012,
 /*   530 */  1022, 1059,  708,  954,  903,  883,  708,  685,  628,  621,
 /*   540 */   608,  567,  581,  493,  421,  286,  254,  196,  113,   90,
 /*   550 */   -17,  -19,  -67,
};
#define YY_REDUCE_USE_DFLT (-185)
#define YY_REDUCE_COUNT (382)
#define YY_REDUCE_MIN   (-184)
#define YY_REDUCE_MAX   (3122)
static const short yy_reduce_ofst[] = {
 /*     0 */   642,  566,  610,   53, 1028, 1742,  641, 1992, 1962,  988,
 /*    10 */   953, 2348, 2184, 2157, 2140, 2121, 2109, 2093, 2026, 1892,
 /*    20 */  1791,  912,  865, 3122, 3101, 3094, 3088, 3068, 3055, 3053,
 /*    30 */  3028, 3024, 3022, 2995, 2989, 2976, 2964, 2949, 2947, 2945,
 /*    40 */  2930, 2919, 2908, 2889, 2882, 2870, 2863, 2832, 2826, 2798,
 /*    50 */  2796, 2793, 2791, 2776, 2763, 2760, 2757, 2726, 2721, 2719,
 /*    60 */  2693, 2690, 2677, 2674, 2671, 2652, 2633, 2630, 2626, 2604,
 /*    70 */  2593, 2582, 2563, 2560, 2544, 2557, 1729,  949,  -20, 1089,
 /*    80 */   906,  336,  692, 1100,  794,  557, -184, 1107, 1106, 1076,
 /*    90 */   825,  144,  643,  855,  397,  565,  546,  480, 1065, 1843,
 /*   100 */  1840, 1731, 1434, 1077,  959, 1727,  116, 1308, 1197,  996,
 /*   110 */   570,  848,  812, 1153, 1003,  792,  103, -113,   15, -104,
 /*   120 */   940,    0,  514,  803,  209,  154,  186, 1225,  701,  240,
 /*   130 */  1143, 2187, 2185, 2106, 1841, 1841, 2168, 2151, 2147, 2146,
 /*   140 */  2128, 1841, 2106, 2094, 2091, 2014, 1841, 2014, 2014, 2014,
 /*   150 */  2014, 1841, 2060, 1841, 2032, 2032, 2057, 2045, 2032, 2020,
 /*   160 */  1841, 2014, 2014, 2004, 1999, 1991, 1973, 1943, 1942, 1925,
 /*   170 */  1909, 1903, 1893, 1872, 1841, 1754, 1726, 1719, 1582, 1551,
 /*   180 */  1520, 1489, 1291, 1039,  813, 1358, 1103, 1343, 1219, 1156,
 /*   190 */  1084, 1044,  710, 1025,  890,  871,  987, 1146,  852,  711,
 /*   200 */   357,  748, 1018,  945,  721,  639,  805,  776,  544, 1926,
 /*   210 */  1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926,
 /*   220 */  1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926,
 /*   230 */  1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926,
 /*   240 */  1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926, 1926,
 /*   250 */  1926, 1926, 1926, 1926, 2541, 2562, 2550, 2452, 2452, 2538,
 /*   260 */  2536, 2530, 2502, 2442, 2518, 2510, 2449, 2457, 2448, 2529,
 /*   270 */  2527, 2526, 1926, 2521, 2483, 2535, 2478, 2440, 2458, 2482,
 /*   280 */  2471, 2474, 2479, 2438, 2447, 2437, 2413, 2466, 2394, 2393,
 /*   290 */  2403, 2434, 2426, 2376, 2367, 2398, 2395, 2359, 2354, 2391,
 /*   300 */  2360, 2410, 2409, 2408, 2406, 2371, 2432, 2378, 2361, 2424,
 /*   310 */  2384, 2346, 2364, 2340, 2330, 2334, 2349, 2339, 2328, 2341,
 /*   320 */  2350, 2333, 2319, 2297, 2316, 2262, 2264, 2265, 2322, 2289,
 /*   330 */  2275, 2288, 2263, 2254, 2251, 2250, 2236, 2242, 2249, 2234,
 /*   340 */  2231, 2212, 2220, 2215, 2108, 2182, 2154, 2101, 2092, 2136,
 /*   350 */  2134, 2132, 2129, 2088, 2061, 2076, 2122, 1926, 1926, 2090,
 /*   360 */  2083, 2074, 2065, 2070, 2033, 2084, 2073, 2072, 2071, 2069,
 /*   370 */  2068, 2062, 2052, 1937, 1927, 1918, 1990, 1988, 1955, 1926,
 /*   380 */  1926, 1926, 1998,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   901, 1234, 1234, 1356, 1234, 1234, 1234, 1234, 1234, 1234,
 /*    10 */  1356, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234,
 /*    20 */  1234, 1234, 1356, 1234, 1234, 1234, 1234, 1234, 1234, 1234,
 /*    30 */  1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234,
 /*    40 */  1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234,
 /*    50 */  1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234,
 /*    60 */  1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234, 1234,
 /*    70 */  1234, 1234, 1234, 1234, 1234, 1086, 1398, 1398, 1398, 1375,
 /*    80 */  1375, 1398, 1079, 1398,  929, 1398, 1398, 1398, 1398, 1398,
 /*    90 */  1398, 1398, 1398, 1398, 1398,  953, 1075,  942, 1086, 1398,
 /*   100 */  1398, 1398, 1398, 1398, 1156, 1171, 1156, 1148, 1137, 1398,
 /*   110 */  1398, 1398, 1272, 1164, 1164, 1164, 1164, 1164, 1398, 1398,
 /*   120 */  1398, 1026, 1198, 1398, 1200, 1199, 1398, 1122, 1122, 1236,
 /*   130 */  1398, 1325, 1330, 1192, 1398, 1398, 1398, 1398, 1398, 1157,
 /*   140 */  1398, 1087, 1192, 1398, 1398, 1398, 1398, 1398, 1398, 1398,
 /*   150 */  1398, 1398, 1398, 1398, 1172, 1149, 1398, 1398, 1138, 1398,
 /*   160 */  1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398,
 /*   170 */  1398, 1398, 1398, 1194, 1398, 1398, 1398, 1398, 1398, 1398,
 /*   180 */   907, 1398, 1398, 1398, 1398, 1075, 1375, 1075, 1075, 1075,
 /*   190 */  1375, 1375,  939,  947, 1375, 1375,  901, 1356, 1111, 1111,
 /*   200 */  1111, 1116, 1356, 1356, 1356, 1356, 1349, 1065, 1065, 1132,
 /*   210 */  1155, 1154, 1153, 1152, 1092, 1142, 1130, 1134, 1249, 1133,
 /*   220 */  1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236,
 /*   230 */  1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 1236,
 /*   240 */  1236, 1202, 1216, 1201, 1209, 1221, 1210, 1215, 1214, 1213,
 /*   250 */  1204, 1203, 1205, 1206, 1398, 1398, 1398, 1398, 1398, 1398,
 /*   260 */  1398, 1398, 1078, 1398, 1398, 1048, 1398, 1398, 1299, 1398,
 /*   270 */  1398,  955, 1207, 1398, 1063,  910, 1141, 1238, 1076,  993,
 /*   280 */  1017,  977, 1122, 1094, 1116, 1116, 1244, 1122, 1398, 1398,
 /*   290 */  1236, 1076, 1063, 1340, 1340, 1095, 1095, 1324, 1324, 1095,
 /*   300 */  1272, 1039, 1039, 1039, 1039, 1095,  936, 1141, 1095,  936,
 /*   310 */  1030, 1144, 1141, 1144, 1177, 1160, 1131, 1116, 1144, 1141,
 /*   320 */  1030, 1131, 1116, 1144, 1141, 1306, 1304, 1095,  936, 1257,
 /*   330 */   936, 1257, 1028, 1028, 1028, 1028, 1009, 1257, 1028,  993,
 /*   340 */  1028, 1009, 1028, 1028, 1394, 1398, 1095, 1385, 1385, 1125,
 /*   350 */  1125, 1131, 1116, 1398, 1398, 1263, 1257, 1220, 1208, 1131,
 /*   360 */  1129, 1126, 1141, 1398, 1095, 1012,  936,  918,  918,  906,
 /*   370 */   906,  906,  906, 1353, 1353, 1349,  995,  995, 1081, 1219,
 /*   380 */  1218, 1217,  964, 1235, 1398, 1398, 1398, 1398, 1398, 1398,
 /*   390 */  1273, 1398, 1398, 1398, 1398, 1398, 1099, 1398, 1398, 1099,
 /*   400 */  1099, 1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398,
 /*   410 */  1398, 1359, 1398, 1398, 1398, 1398, 1398,  902, 1398, 1097,
 /*   420 */  1398, 1398, 1398, 1097, 1097, 1097, 1398, 1097, 1343, 1398,
 /*   430 */  1398, 1398, 1398, 1398, 1398, 1303, 1302, 1398, 1398, 1398,
 /*   440 */  1398, 1398, 1398, 1398, 1398, 1398, 1161, 1398, 1398, 1398,
 /*   450 */  1398, 1398, 1398, 1145, 1100, 1398, 1291, 1398, 1097, 1398,
 /*   460 */  1398, 1398, 1097, 1398, 1398, 1398, 1398, 1398, 1398, 1398,
 /*   470 */  1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398,
 /*   480 */  1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398,
 /*   490 */  1051, 1057, 1398, 1398, 1398, 1052, 1398, 1398, 1190, 1398,
 /*   500 */  1398, 1398, 1247, 1398, 1398, 1398, 1398, 1127, 1398, 1398,
 /*   510 */  1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398, 1398,
 /*   520 */  1398, 1398, 1391, 1117, 1398, 1398, 1398, 1237, 1398, 1398,
 /*   530 */  1235, 1398, 1358, 1398, 1398, 1398, 1357, 1398, 1398, 1398,
 /*   540 */  1398, 1398, 1398, 1398, 1398, 1191, 1190, 1237,  950,  925,
 /*   550 */  1398,  916, 1398,  898,  903, 1342, 1339, 1336, 1341, 1335,
 /*   560 */  1337, 1334, 1338, 1333, 1331, 1332, 1329, 1327, 1326, 1328,
 /*   570 */  1323, 1319, 1279, 1277, 1275, 1284, 1283, 1282, 1281, 1280,
 /*   580 */  1276, 1274, 1278, 1270, 1269, 1167, 1146, 1135, 1046, 1318,
 /*   590 */  1316, 1317, 1268, 1266, 1267, 1045, 1044, 1043, 1038, 1037,
 /*   600 */  1036, 1035, 1346, 1355, 1354, 1352, 1351, 1350, 1344, 1345,
 /*   610 */  1255, 1254, 1252, 1251, 1253,  938, 1295, 1298, 1297, 1296,
 /*   620 */  1301, 1300, 1293, 1305, 1310, 1309, 1314, 1313, 1312, 1311,
 /*   630 */  1308, 1290, 1176, 1175, 1173, 1169, 1180, 1179, 1178, 1168,
 /*   640 */  1170, 1174, 1151, 1159, 1158, 1147, 1150, 1031, 1140, 1136,
 /*   650 */  1104, 1102, 1139, 1103, 1101, 1047, 1294, 1042, 1041, 1040,
 /*   660 */   937,  928, 1098,  927,  926,  941, 1015, 1016, 1024, 1027,
 /*   670 */  1022, 1025, 1021, 1020, 1019, 1023, 1018, 1014,  944,  943,
 /*   680 */   954, 1008,  991,  980,  946,  982,  979,  978,  983, 1000,
 /*   690 */   999, 1006, 1005, 1004, 1003, 1002,  998, 1001,  997,  996,
 /*   700 */   984,  976,  975,  994,  974, 1011, 1010, 1007,  973, 1034,
 /*   710 */  1033, 1032, 1029,  972,  971,  970,  969,  968,  967, 1232,
 /*   720 */  1231, 1397, 1393, 1396, 1395, 1392, 1233, 1230, 1240, 1224,
 /*   730 */  1222, 1049, 1060, 1059, 1058, 1055, 1056, 1070, 1068, 1067,
 /*   740 */  1066, 1110, 1109, 1108, 1107, 1106, 1105, 1091, 1089, 1084,
 /*   750 */  1083, 1090, 1088, 1085, 1114, 1115, 1113, 1112, 1082, 1074,
 /*   760 */  1072, 1073, 1071, 1166, 1163, 1165, 1162, 1093, 1080, 1077,
 /*   770 */  1064, 1373, 1371, 1374, 1372, 1370, 1378, 1380, 1379, 1384,
 /*   780 */  1382, 1381, 1377, 1390, 1389, 1388, 1387, 1386, 1376, 1383,
 /*   790 */  1369, 1368, 1367, 1366, 1119, 1124, 1123, 1118, 1054, 1315,
 /*   800 */  1228, 1223, 1235, 1227, 1364, 1362, 1365, 1361, 1360, 1260,
 /*   810 */  1262, 1265, 1264, 1261, 1121, 1120, 1259, 1258, 1363, 1226,
 /*   820 */  1197,  960,  958,  959, 1287, 1286, 1289, 1288, 1285,  962,
 /*   830 */   961,  957,  956, 1195, 1189, 1188, 1187, 1229, 1193, 1185,
 /*   840 */  1184, 1183, 1212, 1211, 1196, 1186,  949,  948, 1053, 1050,
 /*   850 */  1225, 1182, 1096, 1181,  990,  989,  988,  987,  986,  985,
 /*   860 */  1062, 1061,  966,  981,  965,  963,  940,  930,  935,  933,
 /*   870 */   934,  932,  931,  923,  920,  922,  919,  924,  921,  917,
 /*   880 */   915,  914,  913,  912,  911,  952,  951,  950,  945,  909,
 /*   890 */   908,  905,  904,  900,  899,  897,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*      SPACE => nothing */
    0,  /*         ID => nothing */
    4,  /*      ABORT => ID */
    4,  /*     ACTION => ID */
    4,  /*      AFTER => ID */
    4,  /*     ALWAYS => ID */
    4,  /*    ANALYZE => ID */
    4,  /*        ASC => ID */
    4,  /*     ATTACH => ID */
    4,  /*     BEFORE => ID */
    4,  /*      BEGIN => ID */
    4,  /*         BY => ID */
    4,  /*    CASCADE => ID */
    4,  /*       CAST => ID */
    4,  /*   COLUMNKW => ID */
    4,  /*   CONFLICT => ID */
    4,  /*    CURRENT => ID */
    4,  /*   DATABASE => ID */
    4,  /*   DEFERRED => ID */
    4,  /*       DESC => ID */
    4,  /*     DETACH => ID */
    4,  /*         DO => ID */
    4,  /*       EACH => ID */
    4,  /*        END => ID */
    4,  /*    EXCLUDE => ID */
    4,  /*  EXCLUSIVE => ID */
    4,  /*    EXPLAIN => ID */
    4,  /*       FAIL => ID */
    4,  /*      FIRST => ID */
    4,  /*  FOLLOWING => ID */
    4,  /*        FOR => ID */
    4,  /*     GROUPS => ID */
    4,  /*     IGNORE => ID */
    4,  /*  IMMEDIATE => ID */
    4,  /*  INITIALLY => ID */
    4,  /*    INSTEAD => ID */
    4,  /*       LAST => ID */
    4,  /*    LIKE_KW => ID */
    4,  /*      MATCH => ID */
    4,  /* MATERIALIZED => ID */
    4,  /*         NO => ID */
    4,  /*      NULLS => ID */
    4,  /*     OTHERS => ID */
    4,  /*       PLAN => ID */
    4,  /*      QUERY => ID */
    4,  /*        KEY => ID */
    4,  /*         OF => ID */
    4,  /*     OFFSET => ID */
    4,  /*  PARTITION => ID */
    4,  /*     PRAGMA => ID */
    4,  /*  PRECEDING => ID */
    4,  /*      RAISE => ID */
    4,  /*      RANGE => ID */
    4,  /*  RECURSIVE => ID */
    4,  /*    RELEASE => ID */
    4,  /*    REPLACE => ID */
    4,  /*   RESTRICT => ID */
    4,  /*        ROW => ID */
    4,  /*       ROWS => ID */
    4,  /*   ROLLBACK => ID */
    4,  /*  SAVEPOINT => ID */
    4,  /*       TEMP => ID */
    4,  /*       TIES => ID */
    4,  /*    TRIGGER => ID */
    4,  /*  UNBOUNDED => ID */
    4,  /*     VACUUM => ID */
    4,  /*       VIEW => ID */
    4,  /*    VIRTUAL => ID */
    4,  /*       WITH => ID */
    4,  /*     WITHIN => ID */
    4,  /*    WITHOUT => ID */
    4,  /*    REINDEX => ID */
    4,  /*     RENAME => ID */
    4,  /*   CTIME_KW => ID */
    4,  /*         IF => ID */
    4,  /*     FILTER => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
  QList<Token*>* tokens = nullptr;
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3_parseARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

void *sqlite3_parseCopyParserState(void* other)
{
  yyParser *pParser;
  yyParser *otherParser = (yyParser*)other;

  // Copy parser
  pParser = (yyParser*)malloc((size_t)sizeof(yyParser));
  memcpy(pParser, other, (size_t)sizeof(yyParser));

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = malloc((size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)other)->yystack, (size_t)stackSize);
#endif

  for (int i = 0; i <= pParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(otherParser->yystack[i].tokens);
  }

  return pParser;
}

void sqlite3_parseAddToken(void* other, Token* token)
{
    yyParser *otherParser = (yyParser*)other;
    if (otherParser->yyidx < 0)
        return; // Nothing on stack yet. Might happen when parsing just whitespaces, nothing else.

    otherParser->yystack[otherParser->yyidx].tokens->append(token);
}

void sqlite3_parseRestoreParserState(void* saved, void* target)
{
  yyParser *pParser = (yyParser*)target;
  yyParser *savedParser = (yyParser*)saved;

  for (int i = 0; i <= pParser->yyidx; i++)
      delete pParser->yystack[i].tokens;

  memcpy(pParser, saved, (size_t)sizeof(yyParser));

  for (int i = 0; i <= savedParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(savedParser->yystack[i].tokens);
  }

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = relloc(pParser->yystack, (size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)saved)->yystack, (size_t)stackSize);
#endif
}

void sqlite3_parseFreeSavedState(void* other)
{
    yyParser *pParser = (yyParser*)other;
    for (int i = 0; i <= pParser->yyidx; i++)
        delete pParser->yystack[i].tokens;

#if YYSTACKDEPTH<=0
    free(pParser->yystack);
#endif
    free(other);
}

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  "$",             "ILLEGAL",       "COMMENT",       "SPACE",       
  "ID",            "ABORT",         "ACTION",        "AFTER",       
  "ALWAYS",        "ANALYZE",       "ASC",           "ATTACH",      
  "BEFORE",        "BEGIN",         "BY",            "CASCADE",     
  "CAST",          "COLUMNKW",      "CONFLICT",      "CURRENT",     
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "DO",            "EACH",          "END",           "EXCLUDE",     
  "EXCLUSIVE",     "EXPLAIN",       "FAIL",          "FIRST",       
  "FOLLOWING",     "FOR",           "GROUPS",        "IGNORE",      
  "IMMEDIATE",     "INITIALLY",     "INSTEAD",       "LAST",        
  "LIKE_KW",       "MATCH",         "MATERIALIZED",  "NO",          
  "NULLS",         "OTHERS",        "PLAN",          "QUERY",       
  "KEY",           "OF",            "OFFSET",        "PARTITION",   
  "PRAGMA",        "PRECEDING",     "RAISE",         "RANGE",       
  "RECURSIVE",     "RELEASE",       "REPLACE",       "RESTRICT",    
  "ROW",           "ROWS",          "ROLLBACK",      "SAVEPOINT",   
  "TEMP",          "TIES",          "TRIGGER",       "UNBOUNDED",   
  "VACUUM",        "VIEW",          "VIRTUAL",       "WITH",        
  "WITHIN",        "WITHOUT",       "REINDEX",       "RENAME",      
  "CTIME_KW",      "IF",            "FILTER",        "ANY",         
  "OR",            "AND",           "NOT",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "PTR",           "COLLATE",       "BITNOT",      
  "SEMI",          "TRANSACTION",   "ID_TRANS",      "COMMIT",      
  "TO",            "CREATE",        "TABLE",         "LP",          
  "RP",            "AS",            "DOT",           "ID_TAB_NEW",  
  "ID_DB",         "COMMA",         "CTX_ROWID_KW",  "CTX_STRICT_KW",
  "EXISTS",        "ID_COL_NEW",    "INDEXED",       "GENERATED",   
  "STRING",        "JOIN_KW",       "ID_COL_TYPE",   "RIGHT_ASSOC", 
  "CONSTRAINT",    "DEFAULT",       "NULL",          "PRIMARY",     
  "UNIQUE",        "CHECK",         "REFERENCES",    "ID_CONSTR",   
  "ID_COLLATE",    "ID_TAB",        "INTEGER",       "FLOAT",       
  "BLOB",          "AUTOINCR",      "ON",            "INSERT",      
  "DELETE",        "UPDATE",        "ID_FK_MATCH",   "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "ID_VIEW_NEW", 
  "ID_VIEW",       "SELECT",        "VALUES",        "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "DISTINCT",    
  "ID_ALIAS",      "FROM",          "USING",         "JOIN",        
  "ID_JOIN_OPTS",  "ID_IDX",        "ORDER",         "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "RETURNING",   
  "ID_COL",        "INTO",          "NOTHING",       "ID_FN",       
  "ID_ERR_MSG",    "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ID_IDX_NEW",  
  "ID_PRAGMA",     "ID_TRIG_NEW",   "ID_TRIG",       "ALTER",       
  "ADD",           "WINDOW",        "OVER",          "error",       
  "cmd",           "input",         "cmdlist",       "ecmd",        
  "explain",       "cmdx",          "transtype",     "trans_opt",   
  "nm",            "savepoint_opt",  "temp",          "ifnotexists", 
  "fullname",      "columnlist",    "conslist_opt",  "table_options",
  "select",        "table_option",  "column",        "columnid",    
  "type",          "carglist",      "id",            "id_opt",      
  "ids",           "typetoken",     "typename",      "signed",      
  "plus_num",      "minus_num",     "ccons",         "term",        
  "expr",          "onconf",        "sortorder",     "autoinc",     
  "idxlist_opt",   "refargs",       "defer_subclause",  "gen_always",  
  "tnm",           "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tconscomma",    "tcons",         "idxlist",     
  "defer_subclause_opt",  "resolvetype",   "orconf",        "raisetype",   
  "ifexists",      "select_stmt",   "with",          "selectnowith",
  "oneselect",     "multiselect_op",  "values",        "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "window_clause",
  "nexprlist",     "exprlist",      "sclp",          "as",          
  "joinsrc",       "singlesrc",     "seltablist",    "joinop",      
  "joinconstr_opt",  "dbnm",          "indexed_opt",   "idlist",      
  "xfullname",     "indexed_by",    "sortlist",      "nulls",       
  "delete_stmt",   "returning",     "update_stmt",   "setlist",     
  "idlist_opt",    "insert_stmt",   "insert_cmd",    "upsert",      
  "rp_opt",        "exprx",         "not_opt",       "likeop",      
  "case_operand",  "case_exprlist",  "case_else",     "filter_over", 
  "uniqueflag",    "idxlist_single",  "collate",       "vinto",       
  "nmnum",         "number",        "trigger_time",  "trigger_event",
  "foreach_clause",  "when_clause",   "trigger_cmd_list",  "trigger_cmd", 
  "database_kw_opt",  "key_opt",       "kwcolumn_opt",  "create_vtab", 
  "vtabarglist",   "vtabarg",       "vtabargtoken",  "anylist",     
  "wqlist",        "wqas",          "wqcte",         "windowdefn_list",
  "windowdefn",    "window",        "frame_opt",     "range_or_rows",
  "frame_bound_s",  "frame_exclude_opt",  "frame_bound_e",  "frame_bound", 
  "frame_exclude",  "filter_clause",  "over_clause", 
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   8 */ "cmdx ::= cmd",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "trans_opt ::= TRANSACTION ID_TRANS",
 /*  14 */ "transtype ::=",
 /*  15 */ "transtype ::= DEFERRED",
 /*  16 */ "transtype ::= IMMEDIATE",
 /*  17 */ "transtype ::= EXCLUSIVE",
 /*  18 */ "cmd ::= COMMIT trans_opt",
 /*  19 */ "cmd ::= END trans_opt",
 /*  20 */ "cmd ::= ROLLBACK trans_opt",
 /*  21 */ "savepoint_opt ::= SAVEPOINT",
 /*  22 */ "savepoint_opt ::=",
 /*  23 */ "cmd ::= SAVEPOINT nm",
 /*  24 */ "cmd ::= RELEASE savepoint_opt nm",
 /*  25 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt nm",
 /*  26 */ "cmd ::= SAVEPOINT ID_TRANS",
 /*  27 */ "cmd ::= RELEASE savepoint_opt ID_TRANS",
 /*  28 */ "cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS",
 /*  29 */ "cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options",
 /*  30 */ "cmd ::= CREATE temp TABLE ifnotexists fullname AS select",
 /*  31 */ "cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW",
 /*  32 */ "cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /*  33 */ "table_options ::=",
 /*  34 */ "table_options ::= table_option",
 /*  35 */ "table_options ::= table_options COMMA table_option",
 /*  36 */ "table_option ::= WITHOUT nm",
 /*  37 */ "table_option ::= nm",
 /*  38 */ "table_option ::= WITHOUT CTX_ROWID_KW",
 /*  39 */ "table_option ::= CTX_STRICT_KW",
 /*  40 */ "ifnotexists ::=",
 /*  41 */ "ifnotexists ::= IF NOT EXISTS",
 /*  42 */ "temp ::= TEMP",
 /*  43 */ "temp ::=",
 /*  44 */ "columnlist ::= columnlist COMMA column",
 /*  45 */ "columnlist ::= column",
 /*  46 */ "column ::= columnid type carglist",
 /*  47 */ "columnid ::= nm",
 /*  48 */ "columnid ::= ID_COL_NEW",
 /*  49 */ "id ::= ID|INDEXED|GENERATED",
 /*  50 */ "id_opt ::= id",
 /*  51 */ "id_opt ::=",
 /*  52 */ "ids ::= ID",
 /*  53 */ "ids ::= STRING",
 /*  54 */ "nm ::= id",
 /*  55 */ "nm ::= STRING",
 /*  56 */ "nm ::= JOIN_KW",
 /*  57 */ "type ::=",
 /*  58 */ "type ::= typetoken",
 /*  59 */ "typetoken ::= typename",
 /*  60 */ "typetoken ::= typename LP signed RP",
 /*  61 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  62 */ "typename ::= ids",
 /*  63 */ "typename ::= typename ids",
 /*  64 */ "typename ::= ID_COL_TYPE",
 /*  65 */ "signed ::= plus_num",
 /*  66 */ "signed ::= minus_num",
 /*  67 */ "carglist ::= carglist ccons",
 /*  68 */ "carglist ::=",
 /*  69 */ "ccons ::= CONSTRAINT nm",
 /*  70 */ "ccons ::= DEFAULT term",
 /*  71 */ "ccons ::= DEFAULT LP expr RP",
 /*  72 */ "ccons ::= DEFAULT PLUS term",
 /*  73 */ "ccons ::= DEFAULT MINUS term",
 /*  74 */ "ccons ::= DEFAULT id",
 /*  75 */ "ccons ::= DEFAULT CTIME_KW",
 /*  76 */ "ccons ::= NULL onconf",
 /*  77 */ "ccons ::= NOT NULL onconf",
 /*  78 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  79 */ "ccons ::= UNIQUE onconf",
 /*  80 */ "ccons ::= CHECK LP expr RP",
 /*  81 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  82 */ "ccons ::= defer_subclause",
 /*  83 */ "ccons ::= COLLATE ids",
 /*  84 */ "ccons ::= gen_always AS LP expr RP id_opt",
 /*  85 */ "ccons ::= CONSTRAINT ID_CONSTR",
 /*  86 */ "ccons ::= COLLATE ID_COLLATE",
 /*  87 */ "ccons ::= REFERENCES ID_TAB",
 /*  88 */ "ccons ::= CHECK LP RP",
 /*  89 */ "term ::= NULL",
 /*  90 */ "term ::= INTEGER",
 /*  91 */ "term ::= FLOAT",
 /*  92 */ "term ::= STRING|BLOB",
 /*  93 */ "tnm ::= term",
 /*  94 */ "tnm ::= nm",
 /*  95 */ "gen_always ::= GENERATED ALWAYS",
 /*  96 */ "gen_always ::=",
 /*  97 */ "autoinc ::=",
 /*  98 */ "autoinc ::= AUTOINCR",
 /*  99 */ "refargs ::=",
 /* 100 */ "refargs ::= refargs refarg",
 /* 101 */ "refarg ::= MATCH nm",
 /* 102 */ "refarg ::= ON INSERT refact",
 /* 103 */ "refarg ::= ON DELETE refact",
 /* 104 */ "refarg ::= ON UPDATE refact",
 /* 105 */ "refarg ::= MATCH ID_FK_MATCH",
 /* 106 */ "refact ::= SET NULL",
 /* 107 */ "refact ::= SET DEFAULT",
 /* 108 */ "refact ::= CASCADE",
 /* 109 */ "refact ::= RESTRICT",
 /* 110 */ "refact ::= NO ACTION",
 /* 111 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /* 112 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /* 113 */ "init_deferred_pred_opt ::=",
 /* 114 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /* 115 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /* 116 */ "conslist_opt ::=",
 /* 117 */ "conslist_opt ::= COMMA conslist",
 /* 118 */ "conslist ::= conslist tconscomma tcons",
 /* 119 */ "conslist ::= tcons",
 /* 120 */ "tconscomma ::= COMMA",
 /* 121 */ "tconscomma ::=",
 /* 122 */ "tcons ::= CONSTRAINT nm",
 /* 123 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /* 124 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /* 125 */ "tcons ::= CHECK LP expr RP onconf",
 /* 126 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /* 127 */ "tcons ::= CONSTRAINT ID_CONSTR",
 /* 128 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB",
 /* 129 */ "tcons ::= CHECK LP RP onconf",
 /* 130 */ "defer_subclause_opt ::=",
 /* 131 */ "defer_subclause_opt ::= defer_subclause",
 /* 132 */ "onconf ::=",
 /* 133 */ "onconf ::= ON CONFLICT resolvetype",
 /* 134 */ "orconf ::=",
 /* 135 */ "orconf ::= OR resolvetype",
 /* 136 */ "resolvetype ::= raisetype",
 /* 137 */ "resolvetype ::= IGNORE",
 /* 138 */ "resolvetype ::= REPLACE",
 /* 139 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 140 */ "cmd ::= DROP TABLE ifexists nm DOT ID_TAB",
 /* 141 */ "cmd ::= DROP TABLE ifexists ID_DB|ID_TAB",
 /* 142 */ "ifexists ::= IF EXISTS",
 /* 143 */ "ifexists ::=",
 /* 144 */ "cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select",
 /* 145 */ "cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW",
 /* 146 */ "cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW",
 /* 147 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 148 */ "cmd ::= DROP VIEW ifexists nm DOT ID_VIEW",
 /* 149 */ "cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW",
 /* 150 */ "cmd ::= select_stmt",
 /* 151 */ "select_stmt ::= select",
 /* 152 */ "select ::= with selectnowith",
 /* 153 */ "selectnowith ::= oneselect",
 /* 154 */ "selectnowith ::= selectnowith multiselect_op oneselect",
 /* 155 */ "selectnowith ::= values",
 /* 156 */ "selectnowith ::= selectnowith COMMA values",
 /* 157 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 158 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt",
 /* 159 */ "values ::= VALUES LP nexprlist RP",
 /* 160 */ "values ::= values COMMA LP exprlist RP",
 /* 161 */ "multiselect_op ::= UNION",
 /* 162 */ "multiselect_op ::= UNION ALL",
 /* 163 */ "multiselect_op ::= EXCEPT",
 /* 164 */ "multiselect_op ::= INTERSECT",
 /* 165 */ "distinct ::= DISTINCT",
 /* 166 */ "distinct ::= ALL",
 /* 167 */ "distinct ::=",
 /* 168 */ "sclp ::= selcollist COMMA",
 /* 169 */ "sclp ::=",
 /* 170 */ "selcollist ::= sclp expr as",
 /* 171 */ "selcollist ::= sclp STAR",
 /* 172 */ "selcollist ::= sclp tnm DOT STAR",
 /* 173 */ "selcollist ::= sclp",
 /* 174 */ "selcollist ::= sclp ID_TAB DOT STAR",
 /* 175 */ "as ::= AS nm",
 /* 176 */ "as ::= ids",
 /* 177 */ "as ::= AS ID_ALIAS",
 /* 178 */ "as ::= ID_ALIAS",
 /* 179 */ "as ::=",
 /* 180 */ "from ::=",
 /* 181 */ "from ::= FROM joinsrc",
 /* 182 */ "joinsrc ::= singlesrc seltablist",
 /* 183 */ "joinsrc ::=",
 /* 184 */ "seltablist ::= seltablist joinop singlesrc joinconstr_opt",
 /* 185 */ "seltablist ::=",
 /* 186 */ "singlesrc ::= nm dbnm as indexed_opt",
 /* 187 */ "singlesrc ::= LP select RP as",
 /* 188 */ "singlesrc ::= LP joinsrc RP as",
 /* 189 */ "singlesrc ::= nm dbnm LP exprlist RP as",
 /* 190 */ "singlesrc ::=",
 /* 191 */ "singlesrc ::= nm DOT",
 /* 192 */ "singlesrc ::= nm DOT ID_TAB",
 /* 193 */ "singlesrc ::= ID_DB|ID_TAB",
 /* 194 */ "singlesrc ::= nm DOT ID_VIEW",
 /* 195 */ "singlesrc ::= ID_DB|ID_VIEW",
 /* 196 */ "joinconstr_opt ::= ON expr",
 /* 197 */ "joinconstr_opt ::= USING LP idlist RP",
 /* 198 */ "joinconstr_opt ::=",
 /* 199 */ "dbnm ::=",
 /* 200 */ "dbnm ::= DOT nm",
 /* 201 */ "fullname ::= nm",
 /* 202 */ "fullname ::= nm DOT nm",
 /* 203 */ "xfullname ::= nm",
 /* 204 */ "xfullname ::= nm DOT nm",
 /* 205 */ "xfullname ::= nm DOT nm AS nm",
 /* 206 */ "xfullname ::= nm AS nm",
 /* 207 */ "xfullname ::= nm DOT nm AS ID_ALIAS",
 /* 208 */ "xfullname ::= nm AS ID_ALIAS",
 /* 209 */ "joinop ::= COMMA",
 /* 210 */ "joinop ::= JOIN",
 /* 211 */ "joinop ::= JOIN_KW JOIN",
 /* 212 */ "joinop ::= JOIN_KW nm JOIN",
 /* 213 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 214 */ "joinop ::= ID_JOIN_OPTS",
 /* 215 */ "indexed_opt ::=",
 /* 216 */ "indexed_opt ::= indexed_by",
 /* 217 */ "indexed_by ::= INDEXED BY nm",
 /* 218 */ "indexed_by ::= NOT INDEXED",
 /* 219 */ "indexed_by ::= INDEXED BY ID_IDX",
 /* 220 */ "orderby_opt ::=",
 /* 221 */ "orderby_opt ::= ORDER BY sortlist",
 /* 222 */ "sortlist ::= sortlist COMMA expr sortorder nulls",
 /* 223 */ "sortlist ::= expr sortorder nulls",
 /* 224 */ "sortorder ::= ASC",
 /* 225 */ "sortorder ::= DESC",
 /* 226 */ "sortorder ::=",
 /* 227 */ "nulls ::= NULLS FIRST",
 /* 228 */ "nulls ::= NULLS LAST",
 /* 229 */ "nulls ::=",
 /* 230 */ "groupby_opt ::=",
 /* 231 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 232 */ "groupby_opt ::= GROUP BY",
 /* 233 */ "having_opt ::=",
 /* 234 */ "having_opt ::= HAVING expr",
 /* 235 */ "limit_opt ::=",
 /* 236 */ "limit_opt ::= LIMIT expr",
 /* 237 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 238 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 239 */ "cmd ::= delete_stmt",
 /* 240 */ "delete_stmt ::= with DELETE FROM xfullname indexed_opt where_opt returning orderby_opt limit_opt",
 /* 241 */ "delete_stmt ::= with DELETE FROM",
 /* 242 */ "delete_stmt ::= with DELETE FROM nm DOT",
 /* 243 */ "delete_stmt ::= with DELETE FROM nm DOT ID_TAB",
 /* 244 */ "delete_stmt ::= with DELETE FROM ID_DB|ID_TAB",
 /* 245 */ "where_opt ::=",
 /* 246 */ "where_opt ::= WHERE expr",
 /* 247 */ "where_opt ::= WHERE",
 /* 248 */ "returning ::=",
 /* 249 */ "returning ::= RETURNING selcollist",
 /* 250 */ "cmd ::= update_stmt",
 /* 251 */ "update_stmt ::= with UPDATE orconf xfullname indexed_opt SET setlist from where_opt returning orderby_opt limit_opt",
 /* 252 */ "update_stmt ::= with UPDATE orconf",
 /* 253 */ "update_stmt ::= with UPDATE orconf nm DOT",
 /* 254 */ "update_stmt ::= with UPDATE orconf nm DOT ID_TAB",
 /* 255 */ "update_stmt ::= with UPDATE orconf ID_DB|ID_TAB",
 /* 256 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 257 */ "setlist ::= setlist COMMA LP idlist RP EQ expr",
 /* 258 */ "setlist ::= nm EQ expr",
 /* 259 */ "setlist ::= LP idlist RP EQ expr",
 /* 260 */ "setlist ::=",
 /* 261 */ "setlist ::= setlist COMMA",
 /* 262 */ "setlist ::= setlist COMMA ID_COL",
 /* 263 */ "setlist ::= ID_COL",
 /* 264 */ "idlist_opt ::=",
 /* 265 */ "idlist_opt ::= LP idlist RP",
 /* 266 */ "idlist ::= idlist COMMA nm",
 /* 267 */ "idlist ::= nm",
 /* 268 */ "idlist ::=",
 /* 269 */ "idlist ::= idlist COMMA ID_COL",
 /* 270 */ "idlist ::= ID_COL",
 /* 271 */ "cmd ::= insert_stmt",
 /* 272 */ "insert_stmt ::= with insert_cmd INTO xfullname idlist_opt select upsert returning",
 /* 273 */ "insert_stmt ::= with insert_cmd INTO xfullname idlist_opt DEFAULT VALUES returning",
 /* 274 */ "insert_stmt ::= with insert_cmd INTO xfullname LP idlist rp_opt",
 /* 275 */ "insert_stmt ::= with insert_cmd INTO",
 /* 276 */ "insert_stmt ::= with insert_cmd INTO nm DOT",
 /* 277 */ "insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB",
 /* 278 */ "insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB",
 /* 279 */ "insert_cmd ::= INSERT orconf",
 /* 280 */ "insert_cmd ::= REPLACE",
 /* 281 */ "upsert ::=",
 /* 282 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt",
 /* 283 */ "upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING",
 /* 284 */ "upsert ::= ON CONFLICT DO NOTHING",
 /* 285 */ "exprx ::= expr not_opt IN ID_DB",
 /* 286 */ "exprx ::= expr not_opt IN nm DOT ID_TAB",
 /* 287 */ "exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN",
 /* 288 */ "exprx ::= tnm DOT ID_TAB|ID_COL",
 /* 289 */ "exprx ::= tnm DOT nm DOT ID_COL",
 /* 290 */ "exprx ::= expr COLLATE ID_COLLATE",
 /* 291 */ "exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP",
 /* 292 */ "exprx ::= CTIME_KW",
 /* 293 */ "exprx ::= LP nexprlist RP",
 /* 294 */ "exprx ::= tnm",
 /* 295 */ "exprx ::= tnm DOT nm",
 /* 296 */ "exprx ::= tnm DOT",
 /* 297 */ "exprx ::= tnm DOT nm DOT nm",
 /* 298 */ "exprx ::= tnm DOT nm DOT",
 /* 299 */ "exprx ::= VARIABLE",
 /* 300 */ "exprx ::= expr COLLATE ids",
 /* 301 */ "exprx ::= CAST LP expr AS typetoken RP",
 /* 302 */ "exprx ::= id LP distinct exprlist RP",
 /* 303 */ "exprx ::= id LP distinct exprlist ORDER BY sortlist RP",
 /* 304 */ "exprx ::= id LP STAR RP",
 /* 305 */ "exprx ::= expr AND expr",
 /* 306 */ "exprx ::= expr OR expr",
 /* 307 */ "exprx ::= expr LT|GT|GE|LE expr",
 /* 308 */ "exprx ::= expr EQ|NE expr",
 /* 309 */ "exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 310 */ "exprx ::= expr PLUS|MINUS expr",
 /* 311 */ "exprx ::= expr STAR|SLASH|REM expr",
 /* 312 */ "exprx ::= expr CONCAT expr",
 /* 313 */ "exprx ::= expr not_opt likeop expr",
 /* 314 */ "exprx ::= expr not_opt likeop expr ESCAPE expr",
 /* 315 */ "exprx ::= expr ISNULL|NOTNULL",
 /* 316 */ "exprx ::= expr NOT NULL",
 /* 317 */ "exprx ::= expr IS not_opt expr",
 /* 318 */ "exprx ::= expr IS NOT DISTINCT FROM expr",
 /* 319 */ "exprx ::= expr IS DISTINCT FROM expr",
 /* 320 */ "exprx ::= NOT expr",
 /* 321 */ "exprx ::= BITNOT expr",
 /* 322 */ "exprx ::= MINUS expr",
 /* 323 */ "exprx ::= PLUS expr",
 /* 324 */ "exprx ::= expr PTR expr",
 /* 325 */ "exprx ::= expr not_opt BETWEEN expr AND expr",
 /* 326 */ "exprx ::= expr not_opt IN LP exprlist RP",
 /* 327 */ "exprx ::= LP select RP",
 /* 328 */ "exprx ::= expr not_opt IN LP select RP",
 /* 329 */ "exprx ::= expr not_opt IN nm dbnm",
 /* 330 */ "exprx ::= EXISTS LP select RP",
 /* 331 */ "exprx ::= CASE case_operand case_exprlist case_else END",
 /* 332 */ "exprx ::= RAISE LP IGNORE RP",
 /* 333 */ "exprx ::= RAISE LP raisetype COMMA expr RP",
 /* 334 */ "exprx ::= id LP distinct exprlist RP filter_over",
 /* 335 */ "exprx ::= id LP distinct exprlist ORDER BY sortlist RP filter_over",
 /* 336 */ "exprx ::= id LP STAR RP filter_over",
 /* 337 */ "exprx ::= id LP distinct exprlist RP WITHIN GROUP LP ORDER BY expr RP",
 /* 338 */ "expr ::=",
 /* 339 */ "expr ::= exprx",
 /* 340 */ "not_opt ::=",
 /* 341 */ "not_opt ::= NOT",
 /* 342 */ "rp_opt ::=",
 /* 343 */ "rp_opt ::= RP",
 /* 344 */ "likeop ::= LIKE_KW|MATCH",
 /* 345 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 346 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 347 */ "case_else ::= ELSE expr",
 /* 348 */ "case_else ::=",
 /* 349 */ "case_operand ::= exprx",
 /* 350 */ "case_operand ::=",
 /* 351 */ "exprlist ::= nexprlist",
 /* 352 */ "exprlist ::=",
 /* 353 */ "nexprlist ::= nexprlist COMMA expr",
 /* 354 */ "nexprlist ::= exprx",
 /* 355 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt",
 /* 356 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB",
 /* 357 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW",
 /* 358 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW",
 /* 359 */ "uniqueflag ::= UNIQUE",
 /* 360 */ "uniqueflag ::=",
 /* 361 */ "idxlist_opt ::=",
 /* 362 */ "idxlist_opt ::= LP idxlist RP",
 /* 363 */ "idxlist ::= idxlist COMMA idxlist_single",
 /* 364 */ "idxlist ::= idxlist_single",
 /* 365 */ "idxlist_single ::= nm collate sortorder",
 /* 366 */ "idxlist_single ::= ID_COL",
 /* 367 */ "collate ::=",
 /* 368 */ "collate ::= COLLATE ids",
 /* 369 */ "collate ::= COLLATE ID_COLLATE",
 /* 370 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 371 */ "cmd ::= DROP INDEX ifexists nm DOT ID_IDX",
 /* 372 */ "cmd ::= DROP INDEX ifexists ID_DB|ID_IDX",
 /* 373 */ "cmd ::= VACUUM vinto",
 /* 374 */ "cmd ::= VACUUM nm vinto",
 /* 375 */ "vinto ::= INTO expr",
 /* 376 */ "vinto ::=",
 /* 377 */ "cmd ::= PRAGMA nm dbnm",
 /* 378 */ "cmd ::= PRAGMA nm dbnm EQ nmnum",
 /* 379 */ "cmd ::= PRAGMA nm dbnm LP nmnum RP",
 /* 380 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 381 */ "cmd ::= PRAGMA nm dbnm LP minus_num RP",
 /* 382 */ "cmd ::= PRAGMA nm DOT ID_PRAGMA",
 /* 383 */ "cmd ::= PRAGMA ID_DB|ID_PRAGMA",
 /* 384 */ "nmnum ::= plus_num",
 /* 385 */ "nmnum ::= nm",
 /* 386 */ "nmnum ::= ON",
 /* 387 */ "nmnum ::= DELETE",
 /* 388 */ "nmnum ::= DEFAULT",
 /* 389 */ "plus_num ::= PLUS number",
 /* 390 */ "plus_num ::= number",
 /* 391 */ "minus_num ::= MINUS number",
 /* 392 */ "number ::= INTEGER",
 /* 393 */ "number ::= FLOAT",
 /* 394 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END",
 /* 395 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause",
 /* 396 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list",
 /* 397 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB",
 /* 398 */ "cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW",
 /* 399 */ "cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW",
 /* 400 */ "trigger_time ::= BEFORE",
 /* 401 */ "trigger_time ::= AFTER",
 /* 402 */ "trigger_time ::= INSTEAD OF",
 /* 403 */ "trigger_time ::=",
 /* 404 */ "trigger_event ::= DELETE",
 /* 405 */ "trigger_event ::= INSERT",
 /* 406 */ "trigger_event ::= UPDATE",
 /* 407 */ "trigger_event ::= UPDATE OF idlist",
 /* 408 */ "foreach_clause ::=",
 /* 409 */ "foreach_clause ::= FOR EACH ROW",
 /* 410 */ "when_clause ::=",
 /* 411 */ "when_clause ::= WHEN expr",
 /* 412 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 413 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 414 */ "trigger_cmd_list ::= SEMI",
 /* 415 */ "trigger_cmd ::= update_stmt",
 /* 416 */ "trigger_cmd ::= insert_stmt",
 /* 417 */ "trigger_cmd ::= delete_stmt",
 /* 418 */ "trigger_cmd ::= select_stmt",
 /* 419 */ "raisetype ::= ROLLBACK|ABORT|FAIL",
 /* 420 */ "cmd ::= DROP TRIGGER ifexists fullname",
 /* 421 */ "cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG",
 /* 422 */ "cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG",
 /* 423 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 424 */ "cmd ::= DETACH database_kw_opt expr",
 /* 425 */ "key_opt ::=",
 /* 426 */ "key_opt ::= KEY expr",
 /* 427 */ "database_kw_opt ::= DATABASE",
 /* 428 */ "database_kw_opt ::=",
 /* 429 */ "cmd ::= REINDEX",
 /* 430 */ "cmd ::= REINDEX nm dbnm",
 /* 431 */ "cmd ::= REINDEX ID_COLLATE",
 /* 432 */ "cmd ::= REINDEX nm DOT ID_TAB|ID_IDX",
 /* 433 */ "cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB",
 /* 434 */ "cmd ::= ANALYZE",
 /* 435 */ "cmd ::= ANALYZE nm dbnm",
 /* 436 */ "cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX",
 /* 437 */ "cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB",
 /* 438 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 439 */ "cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column",
 /* 440 */ "cmd ::= ALTER TABLE fullname DROP kwcolumn_opt nm",
 /* 441 */ "cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW",
 /* 442 */ "cmd ::= ALTER TABLE nm DOT ID_TAB",
 /* 443 */ "cmd ::= ALTER TABLE ID_DB|ID_TAB",
 /* 444 */ "kwcolumn_opt ::=",
 /* 445 */ "kwcolumn_opt ::= COLUMNKW",
 /* 446 */ "cmd ::= create_vtab",
 /* 447 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm",
 /* 448 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP",
 /* 449 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW",
 /* 450 */ "create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW",
 /* 451 */ "vtabarglist ::= vtabarg",
 /* 452 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 453 */ "vtabarg ::=",
 /* 454 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 455 */ "vtabargtoken ::= ANY",
 /* 456 */ "vtabargtoken ::= LP anylist RP",
 /* 457 */ "anylist ::=",
 /* 458 */ "anylist ::= anylist LP anylist RP",
 /* 459 */ "anylist ::= anylist ANY",
 /* 460 */ "with ::=",
 /* 461 */ "with ::= WITH wqlist",
 /* 462 */ "with ::= WITH RECURSIVE wqlist",
 /* 463 */ "wqas ::= AS",
 /* 464 */ "wqas ::= AS MATERIALIZED",
 /* 465 */ "wqas ::= AS NOT MATERIALIZED",
 /* 466 */ "wqlist ::= wqcte",
 /* 467 */ "wqlist ::= wqlist COMMA wqcte",
 /* 468 */ "wqlist ::= ID_TAB_NEW",
 /* 469 */ "wqcte ::= nm idxlist_opt wqas LP select RP",
 /* 470 */ "windowdefn_list ::= windowdefn",
 /* 471 */ "windowdefn_list ::= windowdefn_list COMMA windowdefn",
 /* 472 */ "windowdefn ::= nm AS LP window RP",
 /* 473 */ "window ::= PARTITION BY nexprlist orderby_opt frame_opt",
 /* 474 */ "window ::= nm PARTITION BY nexprlist orderby_opt frame_opt",
 /* 475 */ "window ::= ORDER BY sortlist frame_opt",
 /* 476 */ "window ::= nm ORDER BY sortlist frame_opt",
 /* 477 */ "window ::= frame_opt",
 /* 478 */ "window ::= nm frame_opt",
 /* 479 */ "frame_opt ::=",
 /* 480 */ "frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt",
 /* 481 */ "frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt",
 /* 482 */ "range_or_rows ::= RANGE|ROWS|GROUPS",
 /* 483 */ "frame_bound_s ::= frame_bound",
 /* 484 */ "frame_bound_s ::= UNBOUNDED PRECEDING",
 /* 485 */ "frame_bound_e ::= frame_bound",
 /* 486 */ "frame_bound_e ::= UNBOUNDED FOLLOWING",
 /* 487 */ "frame_bound ::= expr PRECEDING|FOLLOWING",
 /* 488 */ "frame_bound ::= CURRENT ROW",
 /* 489 */ "frame_exclude_opt ::=",
 /* 490 */ "frame_exclude_opt ::= EXCLUDE frame_exclude",
 /* 491 */ "frame_exclude ::= NO OTHERS",
 /* 492 */ "frame_exclude ::= CURRENT ROW",
 /* 493 */ "frame_exclude ::= GROUP",
 /* 494 */ "frame_exclude ::= TIES",
 /* 495 */ "window_clause ::= WINDOW windowdefn_list",
 /* 496 */ "filter_over ::= filter_clause over_clause",
 /* 497 */ "filter_over ::= over_clause",
 /* 498 */ "filter_over ::= filter_clause",
 /* 499 */ "over_clause ::= OVER LP window RP",
 /* 500 */ "over_clause ::= OVER nm",
 /* 501 */ "filter_clause ::= FILTER LP WHERE expr RP",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3_parse and sqlite3_parseFree.
*/
void *sqlite3_parseAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite3_parseARG_FETCH;
  if (parserContext->executeRules)
  {
      switch( yymajor ){
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
    case 196: /* cmd */
    case 199: /* ecmd */
    case 201: /* cmdx */
    case 249: /* select_stmt */
    case 280: /* delete_stmt */
    case 282: /* update_stmt */
    case 285: /* insert_stmt */
    case 307: /* trigger_cmd */
    case 311: /* create_vtab */
{
parser_safe_delete((yypminor->yy43));
}
      break;
    case 200: /* explain */
{
parser_safe_delete((yypminor->yy317));
}
      break;
    case 202: /* transtype */
    case 203: /* trans_opt */
{
parser_safe_delete((yypminor->yy338));
}
      break;
    case 204: /* nm */
    case 215: /* columnid */
    case 218: /* id */
    case 219: /* id_opt */
    case 220: /* ids */
    case 222: /* typename */
    case 273: /* dbnm */
    case 298: /* collate */
    case 313: /* vtabarg */
    case 314: /* vtabargtoken */
    case 315: /* anylist */
{
parser_safe_delete((yypminor->yy267));
}
      break;
    case 205: /* savepoint_opt */
    case 207: /* ifnotexists */
    case 231: /* autoinc */
    case 235: /* gen_always */
    case 241: /* tconscomma */
    case 248: /* ifexists */
    case 288: /* rp_opt */
    case 290: /* not_opt */
    case 296: /* uniqueflag */
    case 308: /* database_kw_opt */
    case 310: /* kwcolumn_opt */
{
parser_safe_delete((yypminor->yy473));
}
      break;
    case 206: /* temp */
    case 255: /* distinct */
{
parser_safe_delete((yypminor->yy348));
}
      break;
    case 208: /* fullname */
{
parser_safe_delete((yypminor->yy136));
}
      break;
    case 209: /* columnlist */
{
parser_safe_delete((yypminor->yy658));
}
      break;
    case 210: /* conslist_opt */
    case 240: /* conslist */
{
parser_safe_delete((yypminor->yy365));
}
      break;
    case 211: /* table_options */
{
parser_safe_delete((yypminor->yy399));
}
      break;
    case 212: /* select */
    case 251: /* selectnowith */
{
parser_safe_delete((yypminor->yy379));
}
      break;
    case 213: /* table_option */
{
parser_safe_delete((yypminor->yy661));
}
      break;
    case 214: /* column */
{
parser_safe_delete((yypminor->yy215));
}
      break;
    case 216: /* type */
    case 221: /* typetoken */
{
parser_safe_delete((yypminor->yy29));
}
      break;
    case 217: /* carglist */
{
parser_safe_delete((yypminor->yy333));
}
      break;
    case 223: /* signed */
    case 224: /* plus_num */
    case 225: /* minus_num */
    case 227: /* term */
    case 300: /* nmnum */
    case 301: /* number */
{
parser_safe_delete((yypminor->yy15));
}
      break;
    case 226: /* ccons */
{
parser_safe_delete((yypminor->yy298));
}
      break;
    case 228: /* expr */
    case 258: /* where_opt */
    case 260: /* having_opt */
    case 289: /* exprx */
    case 292: /* case_operand */
    case 294: /* case_else */
    case 299: /* vinto */
    case 305: /* when_clause */
    case 309: /* key_opt */
{
parser_safe_delete((yypminor->yy339));
}
      break;
    case 229: /* onconf */
    case 245: /* resolvetype */
    case 246: /* orconf */
{
parser_safe_delete((yypminor->yy134));
}
      break;
    case 230: /* sortorder */
{
parser_safe_delete((yypminor->yy25));
}
      break;
    case 232: /* idxlist_opt */
    case 243: /* idxlist */
{
parser_safe_delete((yypminor->yy121));
}
      break;
    case 233: /* refargs */
{
parser_safe_delete((yypminor->yy316));
}
      break;
    case 234: /* defer_subclause */
    case 244: /* defer_subclause_opt */
{
parser_safe_delete((yypminor->yy497));
}
      break;
    case 236: /* tnm */
{
parser_safe_delete((yypminor->yy622));
}
      break;
    case 237: /* refarg */
{
parser_safe_delete((yypminor->yy165));
}
      break;
    case 238: /* refact */
{
parser_safe_delete((yypminor->yy410));
}
      break;
    case 239: /* init_deferred_pred_opt */
{
parser_safe_delete((yypminor->yy218));
}
      break;
    case 242: /* tcons */
{
parser_safe_delete((yypminor->yy240));
}
      break;
    case 250: /* with */
{
parser_safe_delete((yypminor->yy91));
}
      break;
    case 252: /* oneselect */
{
parser_safe_delete((yypminor->yy492));
}
      break;
    case 253: /* multiselect_op */
{
parser_safe_delete((yypminor->yy116));
}
      break;
    case 254: /* values */
{
parser_safe_delete((yypminor->yy118));
}
      break;
    case 256: /* selcollist */
    case 266: /* sclp */
    case 281: /* returning */
{
parser_safe_delete((yypminor->yy75));
}
      break;
    case 257: /* from */
    case 268: /* joinsrc */
{
parser_safe_delete((yypminor->yy567));
}
      break;
    case 259: /* groupby_opt */
    case 264: /* nexprlist */
    case 265: /* exprlist */
    case 293: /* case_exprlist */
{
parser_safe_delete((yypminor->yy498));
}
      break;
    case 261: /* orderby_opt */
    case 278: /* sortlist */
{
parser_safe_delete((yypminor->yy277));
}
      break;
    case 262: /* limit_opt */
{
parser_safe_delete((yypminor->yy330));
}
      break;
    case 263: /* window_clause */
    case 319: /* windowdefn_list */
{
parser_safe_delete((yypminor->yy369));
}
      break;
    case 267: /* as */
{
parser_safe_delete((yypminor->yy516));
}
      break;
    case 269: /* singlesrc */
{
parser_safe_delete((yypminor->yy95));
}
      break;
    case 270: /* seltablist */
{
parser_safe_delete((yypminor->yy527));
}
      break;
    case 271: /* joinop */
{
parser_safe_delete((yypminor->yy273));
}
      break;
    case 272: /* joinconstr_opt */
{
parser_safe_delete((yypminor->yy421));
}
      break;
    case 274: /* indexed_opt */
    case 277: /* indexed_by */
{
parser_safe_delete((yypminor->yy542));
}
      break;
    case 275: /* idlist */
    case 284: /* idlist_opt */
    case 312: /* vtabarglist */
{
parser_safe_delete((yypminor->yy327));
}
      break;
    case 276: /* xfullname */
{
parser_safe_delete((yypminor->yy128));
}
      break;
    case 279: /* nulls */
{
parser_safe_delete((yypminor->yy409));
}
      break;
    case 283: /* setlist */
{
parser_safe_delete((yypminor->yy387));
}
      break;
    case 286: /* insert_cmd */
{
parser_safe_delete((yypminor->yy284));
}
      break;
    case 287: /* upsert */
{
parser_safe_delete((yypminor->yy34));
}
      break;
    case 291: /* likeop */
{
parser_safe_delete((yypminor->yy436));
}
      break;
    case 295: /* filter_over */
{
parser_safe_delete((yypminor->yy405));
}
      break;
    case 297: /* idxlist_single */
{
parser_safe_delete((yypminor->yy166));
}
      break;
    case 302: /* trigger_time */
{
parser_safe_delete((yypminor->yy568));
}
      break;
    case 303: /* trigger_event */
{
parser_safe_delete((yypminor->yy469));
}
      break;
    case 304: /* foreach_clause */
{
parser_safe_delete((yypminor->yy247));
}
      break;
    case 306: /* trigger_cmd_list */
{
parser_safe_delete((yypminor->yy412));
}
      break;
    case 316: /* wqlist */
{
parser_safe_delete((yypminor->yy114));
}
      break;
    case 317: /* wqas */
{
parser_safe_delete((yypminor->yy109));
}
      break;
    case 318: /* wqcte */
{
parser_safe_delete((yypminor->yy404));
}
      break;
    case 320: /* windowdefn */
{
parser_safe_delete((yypminor->yy219));
}
      break;
    case 321: /* window */
{
parser_safe_delete((yypminor->yy518));
}
      break;
    case 322: /* frame_opt */
{
parser_safe_delete((yypminor->yy463));
}
      break;
    case 323: /* range_or_rows */
{
parser_safe_delete((yypminor->yy122));
}
      break;
    case 324: /* frame_bound_s */
    case 326: /* frame_bound_e */
{
parser_safe_delete((yypminor->yy453));
}
      break;
    case 327: /* frame_bound */
{
parser_safe_delete((yypminor->yy453));parser_safe_delete((yypminor->yy453));parser_safe_delete((yypminor->yy453));
}
      break;
    case 329: /* filter_clause */
{
parser_safe_delete((yypminor->yy37));
}
      break;
    case 330: /* over_clause */
{
parser_safe_delete((yypminor->yy437));
}
      break;
        default:  break;   /* If no destructor action specified: do nothing */
      }
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  /* There is no mechanism by which the parser stack can be popped below
  ** empty in SQLite.  */
  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  delete yytos->tokens;
  yytos->tokens = nullptr;
  pParser->yyidx--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3_parseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3_parseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  /* In SQLite, we never try to destroy a parser that was not successfully
  ** created in the first place. */
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite3_parseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
  GET_CONTEXT;

  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0
             && parserContext->doFallbacks ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if(
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   UNUSED(yypMinor);
   sqlite3_parseARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */

    parserContext->error(QObject::tr("Parser stack overflow"));
   sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
  yytos->tokens = new QList<Token*>();
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 197, 1 },
  { 198, 2 },
  { 198, 1 },
  { 199, 1 },
  { 199, 3 },
  { 200, 0 },
  { 200, 1 },
  { 200, 3 },
  { 201, 1 },
  { 196, 3 },
  { 203, 0 },
  { 203, 1 },
  { 203, 2 },
  { 203, 2 },
  { 202, 0 },
  { 202, 1 },
  { 202, 1 },
  { 202, 1 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 205, 1 },
  { 205, 0 },
  { 196, 2 },
  { 196, 3 },
  { 196, 5 },
  { 196, 2 },
  { 196, 3 },
  { 196, 5 },
  { 196, 10 },
  { 196, 7 },
  { 196, 7 },
  { 196, 5 },
  { 211, 0 },
  { 211, 1 },
  { 211, 3 },
  { 213, 2 },
  { 213, 1 },
  { 213, 2 },
  { 213, 1 },
  { 207, 0 },
  { 207, 3 },
  { 206, 1 },
  { 206, 0 },
  { 209, 3 },
  { 209, 1 },
  { 214, 3 },
  { 215, 1 },
  { 215, 1 },
  { 218, 1 },
  { 219, 1 },
  { 219, 0 },
  { 220, 1 },
  { 220, 1 },
  { 204, 1 },
  { 204, 1 },
  { 204, 1 },
  { 216, 0 },
  { 216, 1 },
  { 221, 1 },
  { 221, 4 },
  { 221, 6 },
  { 222, 1 },
  { 222, 2 },
  { 222, 1 },
  { 223, 1 },
  { 223, 1 },
  { 217, 2 },
  { 217, 0 },
  { 226, 2 },
  { 226, 2 },
  { 226, 4 },
  { 226, 3 },
  { 226, 3 },
  { 226, 2 },
  { 226, 2 },
  { 226, 2 },
  { 226, 3 },
  { 226, 5 },
  { 226, 2 },
  { 226, 4 },
  { 226, 4 },
  { 226, 1 },
  { 226, 2 },
  { 226, 6 },
  { 226, 2 },
  { 226, 2 },
  { 226, 2 },
  { 226, 3 },
  { 227, 1 },
  { 227, 1 },
  { 227, 1 },
  { 227, 1 },
  { 236, 1 },
  { 236, 1 },
  { 235, 2 },
  { 235, 0 },
  { 231, 0 },
  { 231, 1 },
  { 233, 0 },
  { 233, 2 },
  { 237, 2 },
  { 237, 3 },
  { 237, 3 },
  { 237, 3 },
  { 237, 2 },
  { 238, 2 },
  { 238, 2 },
  { 238, 1 },
  { 238, 1 },
  { 238, 2 },
  { 234, 3 },
  { 234, 2 },
  { 239, 0 },
  { 239, 2 },
  { 239, 2 },
  { 210, 0 },
  { 210, 2 },
  { 240, 3 },
  { 240, 1 },
  { 241, 1 },
  { 241, 0 },
  { 242, 2 },
  { 242, 7 },
  { 242, 5 },
  { 242, 5 },
  { 242, 10 },
  { 242, 2 },
  { 242, 7 },
  { 242, 4 },
  { 244, 0 },
  { 244, 1 },
  { 229, 0 },
  { 229, 3 },
  { 246, 0 },
  { 246, 2 },
  { 245, 1 },
  { 245, 1 },
  { 245, 1 },
  { 196, 4 },
  { 196, 6 },
  { 196, 4 },
  { 248, 2 },
  { 248, 0 },
  { 196, 8 },
  { 196, 7 },
  { 196, 5 },
  { 196, 4 },
  { 196, 6 },
  { 196, 4 },
  { 196, 1 },
  { 249, 1 },
  { 212, 2 },
  { 251, 1 },
  { 251, 3 },
  { 251, 1 },
  { 251, 3 },
  { 252, 9 },
  { 252, 10 },
  { 254, 4 },
  { 254, 5 },
  { 253, 1 },
  { 253, 2 },
  { 253, 1 },
  { 253, 1 },
  { 255, 1 },
  { 255, 1 },
  { 255, 0 },
  { 266, 2 },
  { 266, 0 },
  { 256, 3 },
  { 256, 2 },
  { 256, 4 },
  { 256, 1 },
  { 256, 4 },
  { 267, 2 },
  { 267, 1 },
  { 267, 2 },
  { 267, 1 },
  { 267, 0 },
  { 257, 0 },
  { 257, 2 },
  { 268, 2 },
  { 268, 0 },
  { 270, 4 },
  { 270, 0 },
  { 269, 4 },
  { 269, 4 },
  { 269, 4 },
  { 269, 6 },
  { 269, 0 },
  { 269, 2 },
  { 269, 3 },
  { 269, 1 },
  { 269, 3 },
  { 269, 1 },
  { 272, 2 },
  { 272, 4 },
  { 272, 0 },
  { 273, 0 },
  { 273, 2 },
  { 208, 1 },
  { 208, 3 },
  { 276, 1 },
  { 276, 3 },
  { 276, 5 },
  { 276, 3 },
  { 276, 5 },
  { 276, 3 },
  { 271, 1 },
  { 271, 1 },
  { 271, 2 },
  { 271, 3 },
  { 271, 4 },
  { 271, 1 },
  { 274, 0 },
  { 274, 1 },
  { 277, 3 },
  { 277, 2 },
  { 277, 3 },
  { 261, 0 },
  { 261, 3 },
  { 278, 5 },
  { 278, 3 },
  { 230, 1 },
  { 230, 1 },
  { 230, 0 },
  { 279, 2 },
  { 279, 2 },
  { 279, 0 },
  { 259, 0 },
  { 259, 3 },
  { 259, 2 },
  { 260, 0 },
  { 260, 2 },
  { 262, 0 },
  { 262, 2 },
  { 262, 4 },
  { 262, 4 },
  { 196, 1 },
  { 280, 9 },
  { 280, 3 },
  { 280, 5 },
  { 280, 6 },
  { 280, 4 },
  { 258, 0 },
  { 258, 2 },
  { 258, 1 },
  { 281, 0 },
  { 281, 2 },
  { 196, 1 },
  { 282, 12 },
  { 282, 3 },
  { 282, 5 },
  { 282, 6 },
  { 282, 4 },
  { 283, 5 },
  { 283, 7 },
  { 283, 3 },
  { 283, 5 },
  { 283, 0 },
  { 283, 2 },
  { 283, 3 },
  { 283, 1 },
  { 284, 0 },
  { 284, 3 },
  { 275, 3 },
  { 275, 1 },
  { 275, 0 },
  { 275, 3 },
  { 275, 1 },
  { 196, 1 },
  { 285, 8 },
  { 285, 8 },
  { 285, 7 },
  { 285, 3 },
  { 285, 5 },
  { 285, 4 },
  { 285, 6 },
  { 286, 2 },
  { 286, 1 },
  { 287, 0 },
  { 287, 11 },
  { 287, 8 },
  { 287, 4 },
  { 289, 4 },
  { 289, 6 },
  { 289, 1 },
  { 289, 3 },
  { 289, 5 },
  { 289, 3 },
  { 289, 6 },
  { 289, 1 },
  { 289, 3 },
  { 289, 1 },
  { 289, 3 },
  { 289, 2 },
  { 289, 5 },
  { 289, 4 },
  { 289, 1 },
  { 289, 3 },
  { 289, 6 },
  { 289, 5 },
  { 289, 8 },
  { 289, 4 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 3 },
  { 289, 4 },
  { 289, 6 },
  { 289, 2 },
  { 289, 3 },
  { 289, 4 },
  { 289, 6 },
  { 289, 5 },
  { 289, 2 },
  { 289, 2 },
  { 289, 2 },
  { 289, 2 },
  { 289, 3 },
  { 289, 6 },
  { 289, 6 },
  { 289, 3 },
  { 289, 6 },
  { 289, 5 },
  { 289, 4 },
  { 289, 5 },
  { 289, 4 },
  { 289, 6 },
  { 289, 6 },
  { 289, 9 },
  { 289, 5 },
  { 289, 12 },
  { 228, 0 },
  { 228, 1 },
  { 290, 0 },
  { 290, 1 },
  { 288, 0 },
  { 288, 1 },
  { 291, 1 },
  { 293, 5 },
  { 293, 4 },
  { 294, 2 },
  { 294, 0 },
  { 292, 1 },
  { 292, 0 },
  { 265, 1 },
  { 265, 0 },
  { 264, 3 },
  { 264, 1 },
  { 196, 12 },
  { 196, 8 },
  { 196, 7 },
  { 196, 5 },
  { 296, 1 },
  { 296, 0 },
  { 232, 0 },
  { 232, 3 },
  { 243, 3 },
  { 243, 1 },
  { 297, 3 },
  { 297, 1 },
  { 298, 0 },
  { 298, 2 },
  { 298, 2 },
  { 196, 4 },
  { 196, 6 },
  { 196, 4 },
  { 196, 2 },
  { 196, 3 },
  { 299, 2 },
  { 299, 0 },
  { 196, 3 },
  { 196, 5 },
  { 196, 6 },
  { 196, 5 },
  { 196, 6 },
  { 196, 4 },
  { 196, 2 },
  { 300, 1 },
  { 300, 1 },
  { 300, 1 },
  { 300, 1 },
  { 300, 1 },
  { 224, 2 },
  { 224, 1 },
  { 225, 2 },
  { 301, 1 },
  { 301, 1 },
  { 196, 15 },
  { 196, 12 },
  { 196, 14 },
  { 196, 10 },
  { 196, 7 },
  { 196, 5 },
  { 302, 1 },
  { 302, 1 },
  { 302, 2 },
  { 302, 0 },
  { 303, 1 },
  { 303, 1 },
  { 303, 1 },
  { 303, 3 },
  { 304, 0 },
  { 304, 3 },
  { 305, 0 },
  { 305, 2 },
  { 306, 3 },
  { 306, 2 },
  { 306, 1 },
  { 307, 1 },
  { 307, 1 },
  { 307, 1 },
  { 307, 1 },
  { 247, 1 },
  { 196, 4 },
  { 196, 6 },
  { 196, 4 },
  { 196, 6 },
  { 196, 3 },
  { 309, 0 },
  { 309, 2 },
  { 308, 1 },
  { 308, 0 },
  { 196, 1 },
  { 196, 3 },
  { 196, 2 },
  { 196, 4 },
  { 196, 2 },
  { 196, 1 },
  { 196, 3 },
  { 196, 4 },
  { 196, 2 },
  { 196, 6 },
  { 196, 6 },
  { 196, 6 },
  { 196, 6 },
  { 196, 5 },
  { 196, 3 },
  { 310, 0 },
  { 310, 1 },
  { 196, 1 },
  { 311, 8 },
  { 311, 11 },
  { 311, 7 },
  { 311, 5 },
  { 312, 1 },
  { 312, 3 },
  { 313, 0 },
  { 313, 2 },
  { 314, 1 },
  { 314, 3 },
  { 315, 0 },
  { 315, 4 },
  { 315, 2 },
  { 250, 0 },
  { 250, 2 },
  { 250, 3 },
  { 317, 1 },
  { 317, 2 },
  { 317, 3 },
  { 316, 1 },
  { 316, 3 },
  { 316, 1 },
  { 318, 6 },
  { 319, 1 },
  { 319, 3 },
  { 320, 5 },
  { 321, 5 },
  { 321, 6 },
  { 321, 4 },
  { 321, 5 },
  { 321, 1 },
  { 321, 2 },
  { 322, 0 },
  { 322, 3 },
  { 322, 6 },
  { 323, 1 },
  { 324, 1 },
  { 324, 2 },
  { 326, 1 },
  { 326, 2 },
  { 327, 2 },
  { 327, 2 },
  { 325, 0 },
  { 325, 2 },
  { 328, 2 },
  { 328, 2 },
  { 328, 1 },
  { 328, 1 },
  { 263, 2 },
  { 295, 2 },
  { 295, 1 },
  { 295, 1 },
  { 330, 4 },
  { 330, 2 },
  { 329, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3_parseARG_FETCH;
  SqliteStatement* objectForTokens = 0;
  QStringList noTokenInheritanceFields;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  if (parserContext->executeRules)
  {
      switch( yyruleno ){
      /* Beginning here are the reduction cases.  A typical example
      ** follows:
      **   case 0:
      **  #line <lineno> <grammarfile>
      **     { ... }           // User supplied code
      **  #line <lineno> <thisfile>
      **     break;
      */
      case 1: /* cmdlist ::= cmdlist ecmd */
{parserContext->addQuery(yymsp[0].minor.yy43); DONT_INHERIT_TOKENS("cmdlist");}
        break;
      case 2: /* cmdlist ::= ecmd */
{parserContext->addQuery(yymsp[0].minor.yy43);}
        break;
      case 3: /* ecmd ::= SEMI */
{yygotominor.yy43 = new SqliteEmptyQuery();}
        break;
      case 4: /* ecmd ::= explain cmdx SEMI */
{
                                                yygotominor.yy43 = yymsp[-1].minor.yy43;
                                                yygotominor.yy43->explain = yymsp[-2].minor.yy317->explain;
                                                yygotominor.yy43->queryPlan = yymsp[-2].minor.yy317->queryPlan;
                                                delete yymsp[-2].minor.yy317;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 5: /* explain ::= */
{yygotominor.yy317 = new ParserStubExplain(false, false);}
        break;
      case 6: /* explain ::= EXPLAIN */
{yygotominor.yy317 = new ParserStubExplain(true, false);}
        break;
      case 7: /* explain ::= EXPLAIN QUERY PLAN */
{yygotominor.yy317 = new ParserStubExplain(true, true);}
        break;
      case 8: /* cmdx ::= cmd */
      case 415: /* trigger_cmd ::= update_stmt */ yytestcase(yyruleno==415);
      case 416: /* trigger_cmd ::= insert_stmt */ yytestcase(yyruleno==416);
      case 417: /* trigger_cmd ::= delete_stmt */ yytestcase(yyruleno==417);
      case 418: /* trigger_cmd ::= select_stmt */ yytestcase(yyruleno==418);
      case 446: /* cmd ::= create_vtab */ yytestcase(yyruleno==446);
{yygotominor.yy43 = yymsp[0].minor.yy43;}
        break;
      case 9: /* cmd ::= BEGIN transtype trans_opt */
{
                                                yygotominor.yy43 = new SqliteBeginTrans(
                                                        yymsp[-1].minor.yy338->type,
                                                        yymsp[0].minor.yy338->transactionKw,
                                                        yymsp[0].minor.yy338->name
                                                    );
                                                delete yymsp[0].minor.yy338;
                                                delete yymsp[-1].minor.yy338;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 10: /* trans_opt ::= */
      case 14: /* transtype ::= */ yytestcase(yyruleno==14);
{yygotominor.yy338 = new ParserStubTransDetails();}
        break;
      case 11: /* trans_opt ::= TRANSACTION */
{
                                                yygotominor.yy338 = new ParserStubTransDetails();
                                                yygotominor.yy338->transactionKw = true;
                                            }
        break;
      case 12: /* trans_opt ::= TRANSACTION nm */
      case 13: /* trans_opt ::= TRANSACTION ID_TRANS */ yytestcase(yyruleno==13);
{
                                                yygotominor.yy338 = new ParserStubTransDetails();
                                                yygotominor.yy338->transactionKw = true;
                                                yygotominor.yy338->name = *(yymsp[0].minor.yy267);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 15: /* transtype ::= DEFERRED */
{
                                                yygotominor.yy338 = new ParserStubTransDetails();
                                                yygotominor.yy338->type = SqliteBeginTrans::Type::DEFERRED;
                                            }
        break;
      case 16: /* transtype ::= IMMEDIATE */
{
                                                yygotominor.yy338 = new ParserStubTransDetails();
                                                yygotominor.yy338->type = SqliteBeginTrans::Type::IMMEDIATE;
                                            }
        break;
      case 17: /* transtype ::= EXCLUSIVE */
{
                                                yygotominor.yy338 = new ParserStubTransDetails();
                                                yygotominor.yy338->type = SqliteBeginTrans::Type::EXCLUSIVE;
                                            }
        break;
      case 18: /* cmd ::= COMMIT trans_opt */
{
                                                yygotominor.yy43 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy338->transactionKw,
                                                        yymsp[0].minor.yy338->name,
                                                        false
                                                    );
                                                delete yymsp[0].minor.yy338;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 19: /* cmd ::= END trans_opt */
{
                                                yygotominor.yy43 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy338->transactionKw,
                                                        yymsp[0].minor.yy338->name,
                                                        true
                                                    );
                                                delete yymsp[0].minor.yy338;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 20: /* cmd ::= ROLLBACK trans_opt */
{
                                                yygotominor.yy43 = new SqliteRollback(
                                                        yymsp[0].minor.yy338->transactionKw,
                                                        yymsp[0].minor.yy338->name
                                                    );
                                                delete yymsp[0].minor.yy338;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 21: /* savepoint_opt ::= SAVEPOINT */
      case 41: /* ifnotexists ::= IF NOT EXISTS */ yytestcase(yyruleno==41);
      case 95: /* gen_always ::= GENERATED ALWAYS */ yytestcase(yyruleno==95);
      case 98: /* autoinc ::= AUTOINCR */ yytestcase(yyruleno==98);
      case 120: /* tconscomma ::= COMMA */ yytestcase(yyruleno==120);
      case 142: /* ifexists ::= IF EXISTS */ yytestcase(yyruleno==142);
      case 341: /* not_opt ::= NOT */ yytestcase(yyruleno==341);
      case 343: /* rp_opt ::= RP */ yytestcase(yyruleno==343);
      case 359: /* uniqueflag ::= UNIQUE */ yytestcase(yyruleno==359);
      case 427: /* database_kw_opt ::= DATABASE */ yytestcase(yyruleno==427);
      case 444: /* kwcolumn_opt ::= */ yytestcase(yyruleno==444);
{yygotominor.yy473 = new bool(true);}
        break;
      case 22: /* savepoint_opt ::= */
      case 40: /* ifnotexists ::= */ yytestcase(yyruleno==40);
      case 96: /* gen_always ::= */ yytestcase(yyruleno==96);
      case 97: /* autoinc ::= */ yytestcase(yyruleno==97);
      case 121: /* tconscomma ::= */ yytestcase(yyruleno==121);
      case 143: /* ifexists ::= */ yytestcase(yyruleno==143);
      case 340: /* not_opt ::= */ yytestcase(yyruleno==340);
      case 342: /* rp_opt ::= */ yytestcase(yyruleno==342);
      case 360: /* uniqueflag ::= */ yytestcase(yyruleno==360);
      case 428: /* database_kw_opt ::= */ yytestcase(yyruleno==428);
      case 445: /* kwcolumn_opt ::= COLUMNKW */ yytestcase(yyruleno==445);
{yygotominor.yy473 = new bool(false);}
        break;
      case 23: /* cmd ::= SAVEPOINT nm */
{
                                                yygotominor.yy43 = new SqliteSavepoint(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 24: /* cmd ::= RELEASE savepoint_opt nm */
{
                                                yygotominor.yy43 = new SqliteRelease(*(yymsp[-1].minor.yy473), *(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt nm */
      case 26: /* cmd ::= SAVEPOINT ID_TRANS */ yytestcase(yyruleno==26);
{
                                                yygotominor.yy43 = new SqliteRollback(
                                                        yymsp[-3].minor.yy338->transactionKw,
                                                        *(yymsp[-1].minor.yy473),
                                                        *(yymsp[0].minor.yy267)
                                                    );
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[-3].minor.yy338;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 27: /* cmd ::= RELEASE savepoint_opt ID_TRANS */
      case 28: /* cmd ::= ROLLBACK trans_opt TO savepoint_opt ID_TRANS */ yytestcase(yyruleno==28);
{  yy_destructor(yypParser,205,&yymsp[-1].minor);
}
        break;
      case 29: /* cmd ::= CREATE temp TABLE ifnotexists fullname LP columnlist conslist_opt RP table_options */
{
                                                yygotominor.yy43 = new SqliteCreateTable(
                                                        *(yymsp[-6].minor.yy473),
                                                        *(yymsp[-8].minor.yy348),
                                                        yymsp[-5].minor.yy136->name1,
                                                        yymsp[-5].minor.yy136->name2,
                                                        *(yymsp[-3].minor.yy658),
                                                        *(yymsp[-2].minor.yy365),
                                                        *(yymsp[0].minor.yy399)
                                                    );
                                                delete yymsp[-6].minor.yy473;
                                                delete yymsp[-8].minor.yy348;
                                                delete yymsp[-3].minor.yy658;
                                                delete yymsp[-2].minor.yy365;
                                                delete yymsp[-5].minor.yy136;
                                                delete yymsp[0].minor.yy399;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 30: /* cmd ::= CREATE temp TABLE ifnotexists fullname AS select */
{
                                                yygotominor.yy43 = new SqliteCreateTable(
                                                        *(yymsp[-3].minor.yy473),
                                                        *(yymsp[-5].minor.yy348),
                                                        yymsp[-2].minor.yy136->name1,
                                                        yymsp[-2].minor.yy136->name2,
                                                        yymsp[0].minor.yy379
                                                    );
                                                delete yymsp[-3].minor.yy473;
                                                delete yymsp[-5].minor.yy348;
                                                delete yymsp[-2].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 31: /* cmd ::= CREATE temp TABLE ifnotexists nm DOT ID_TAB_NEW */
      case 145: /* cmd ::= CREATE temp VIEW ifnotexists nm DOT ID_VIEW_NEW */ yytestcase(yyruleno==145);
      case 398: /* cmd ::= CREATE temp TRIGGER ifnotexists nm DOT ID_TRIG_NEW */ yytestcase(yyruleno==398);
{  yy_destructor(yypParser,206,&yymsp[-5].minor);
  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 32: /* cmd ::= CREATE temp TABLE ifnotexists ID_DB|ID_TAB_NEW */
      case 146: /* cmd ::= CREATE temp VIEW ifnotexists ID_DB|ID_VIEW_NEW */ yytestcase(yyruleno==146);
      case 399: /* cmd ::= CREATE temp TRIGGER ifnotexists ID_DB|ID_TRIG_NEW */ yytestcase(yyruleno==399);
{  yy_destructor(yypParser,206,&yymsp[-3].minor);
}
        break;
      case 33: /* table_options ::= */
{yygotominor.yy399 = new ParserCreateTableOptionList();}
        break;
      case 34: /* table_options ::= table_option */
{
                                                yygotominor.yy399 = new ParserCreateTableOptionList();
                                                yygotominor.yy399->append(yymsp[0].minor.yy661);
                                            }
        break;
      case 35: /* table_options ::= table_options COMMA table_option */
{
                                                yymsp[-2].minor.yy399->append(yymsp[0].minor.yy661);
                                                yygotominor.yy399 = yymsp[-2].minor.yy399;
                                                DONT_INHERIT_TOKENS("table_options");
                                            }
        break;
      case 36: /* table_option ::= WITHOUT nm */
{
                                                if (yymsp[0].minor.yy267->toLower() != "rowid")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy267)));

                                                yygotominor.yy661 = new ParserStubCreateTableOption(ParserStubCreateTableOption::WITHOUT_ROWID);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 37: /* table_option ::= nm */
      case 38: /* table_option ::= WITHOUT CTX_ROWID_KW */ yytestcase(yyruleno==38);
      case 39: /* table_option ::= CTX_STRICT_KW */ yytestcase(yyruleno==39);
{
                                                if (yymsp[0].minor.yy267->toLower() != "strict")
                                                    parserContext->errorAtToken(QString("Invalid table option: %1").arg(*(yymsp[0].minor.yy267)));

                                                yygotominor.yy661 = new ParserStubCreateTableOption(ParserStubCreateTableOption::STRICT);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 42: /* temp ::= TEMP */
{yygotominor.yy348 = new int( (yymsp[0].minor.yy0->value.length() > 4) ? 2 : 1 );}
        break;
      case 43: /* temp ::= */
      case 167: /* distinct ::= */ yytestcase(yyruleno==167);
{yygotominor.yy348 = new int(0);}
        break;
      case 44: /* columnlist ::= columnlist COMMA column */
{
                                                yymsp[-2].minor.yy658->append(yymsp[0].minor.yy215);
                                                yygotominor.yy658 = yymsp[-2].minor.yy658;
                                                DONT_INHERIT_TOKENS("columnlist");
                                            }
        break;
      case 45: /* columnlist ::= column */
{
                                                yygotominor.yy658 = new ParserCreateTableColumnList();
                                                yygotominor.yy658->append(yymsp[0].minor.yy215);
                                            }
        break;
      case 46: /* column ::= columnid type carglist */
{
                                                yygotominor.yy215 = new SqliteCreateTable::Column(*(yymsp[-2].minor.yy267), yymsp[-1].minor.yy29, *(yymsp[0].minor.yy333));
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy333;
                                                objectForTokens = yygotominor.yy215;
                                            }
        break;
      case 47: /* columnid ::= nm */
      case 48: /* columnid ::= ID_COL_NEW */ yytestcase(yyruleno==48);
      case 54: /* nm ::= id */ yytestcase(yyruleno==54);
      case 62: /* typename ::= ids */ yytestcase(yyruleno==62);
      case 200: /* dbnm ::= DOT nm */ yytestcase(yyruleno==200);
      case 368: /* collate ::= COLLATE ids */ yytestcase(yyruleno==368);
      case 369: /* collate ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==369);
{yygotominor.yy267 = yymsp[0].minor.yy267;}
        break;
      case 49: /* id ::= ID|INDEXED|GENERATED */
{
                                                yygotominor.yy267 = new QString(
                                                    stripObjName(
                                                        yymsp[0].minor.yy0->value
                                                    )
                                                );
                                            }
        break;
      case 50: /* id_opt ::= id */
{
                                                yygotominor.yy267 = yymsp[0].minor.yy267;
                                            }
        break;
      case 51: /* id_opt ::= */
{
                                                yygotominor.yy267 = new QString();
                                            }
        break;
      case 52: /* ids ::= ID */
      case 56: /* nm ::= JOIN_KW */ yytestcase(yyruleno==56);
{yygotominor.yy267 = new QString(stripObjName(yymsp[0].minor.yy0->value));}
        break;
      case 53: /* ids ::= STRING */
      case 55: /* nm ::= STRING */ yytestcase(yyruleno==55);
{yygotominor.yy267 = new QString(stripString(yymsp[0].minor.yy0->value));}
        break;
      case 57: /* type ::= */
{yygotominor.yy29 = nullptr;}
        break;
      case 58: /* type ::= typetoken */
{yygotominor.yy29 = yymsp[0].minor.yy29;}
        break;
      case 59: /* typetoken ::= typename */
{
                                                yygotominor.yy29 = new SqliteColumnType(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy29;
                                            }
        break;
      case 60: /* typetoken ::= typename LP signed RP */
{
                                                yygotominor.yy29 = new SqliteColumnType(*(yymsp[-3].minor.yy267), *(yymsp[-1].minor.yy15));
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-1].minor.yy15;
                                                objectForTokens = yygotominor.yy29;
                                            }
        break;
      case 61: /* typetoken ::= typename LP signed COMMA signed RP */
{
                                                yygotominor.yy29 = new SqliteColumnType(*(yymsp[-5].minor.yy267), *(yymsp[-3].minor.yy15), *(yymsp[-1].minor.yy15));
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-3].minor.yy15;
                                                delete yymsp[-1].minor.yy15;
                                                objectForTokens = yygotominor.yy29;
                                            }
        break;
      case 63: /* typename ::= typename ids */
      case 64: /* typename ::= ID_COL_TYPE */ yytestcase(yyruleno==64);
{
                                                yymsp[-1].minor.yy267->append(" " + *(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                yygotominor.yy267 = yymsp[-1].minor.yy267;
                                            }
        break;
      case 65: /* signed ::= plus_num */
      case 66: /* signed ::= minus_num */ yytestcase(yyruleno==66);
      case 384: /* nmnum ::= plus_num */ yytestcase(yyruleno==384);
      case 389: /* plus_num ::= PLUS number */ yytestcase(yyruleno==389);
      case 390: /* plus_num ::= number */ yytestcase(yyruleno==390);
{yygotominor.yy15 = yymsp[0].minor.yy15;}
        break;
      case 67: /* carglist ::= carglist ccons */
{
                                                yymsp[-1].minor.yy333->append(yymsp[0].minor.yy298);
                                                yygotominor.yy333 = yymsp[-1].minor.yy333;
                                                DONT_INHERIT_TOKENS("carglist");
                                            }
        break;
      case 68: /* carglist ::= */
{yygotominor.yy333 = new ParserCreateTableColumnConstraintList();}
        break;
      case 69: /* ccons ::= CONSTRAINT nm */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefNameOnly(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 70: /* ccons ::= DEFAULT term */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefTerm(*(yymsp[0].minor.yy15));
                                                delete yymsp[0].minor.yy15;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 71: /* ccons ::= DEFAULT LP expr RP */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefExpr(yymsp[-1].minor.yy339);
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 72: /* ccons ::= DEFAULT PLUS term */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefTerm(*(yymsp[0].minor.yy15), false);
                                                delete yymsp[0].minor.yy15;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 73: /* ccons ::= DEFAULT MINUS term */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefTerm(*(yymsp[0].minor.yy15), true);
                                                delete yymsp[0].minor.yy15;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 74: /* ccons ::= DEFAULT id */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefId(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 75: /* ccons ::= DEFAULT CTIME_KW */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 76: /* ccons ::= NULL onconf */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initNull(*(yymsp[0].minor.yy134));
                                                delete yymsp[0].minor.yy134;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 77: /* ccons ::= NOT NULL onconf */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initNotNull(*(yymsp[0].minor.yy134));
                                                delete yymsp[0].minor.yy134;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 78: /* ccons ::= PRIMARY KEY sortorder onconf autoinc */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initPk(*(yymsp[-2].minor.yy25), *(yymsp[-1].minor.yy134), *(yymsp[0].minor.yy473));
                                                delete yymsp[-2].minor.yy25;
                                                delete yymsp[0].minor.yy473;
                                                delete yymsp[-1].minor.yy134;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 79: /* ccons ::= UNIQUE onconf */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initUnique(*(yymsp[0].minor.yy134));
                                                delete yymsp[0].minor.yy134;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 80: /* ccons ::= CHECK LP expr RP */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initCheck(yymsp[-1].minor.yy339);
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 81: /* ccons ::= REFERENCES nm idxlist_opt refargs */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initFk(*(yymsp[-2].minor.yy267), *(yymsp[-1].minor.yy121), *(yymsp[0].minor.yy316));
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy316;
                                                delete yymsp[-1].minor.yy121;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 82: /* ccons ::= defer_subclause */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initDefer(yymsp[0].minor.yy497->initially, yymsp[0].minor.yy497->deferrable);
                                                delete yymsp[0].minor.yy497;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 83: /* ccons ::= COLLATE ids */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initColl(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 84: /* ccons ::= gen_always AS LP expr RP id_opt */
      case 85: /* ccons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==85);
      case 86: /* ccons ::= COLLATE ID_COLLATE */ yytestcase(yyruleno==86);
      case 87: /* ccons ::= REFERENCES ID_TAB */ yytestcase(yyruleno==87);
{
                                                if (!yymsp[0].minor.yy267->isNull() && yymsp[0].minor.yy267->toLower() != "stored" && yymsp[0].minor.yy267->toLower() != "virtual")
                                                    parserContext->errorAtToken(QString("Invalid generated column type: %1").arg(*(yymsp[0].minor.yy267)));

                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initGeneratedAs(yymsp[-2].minor.yy339, *(yymsp[-5].minor.yy473), *(yymsp[0].minor.yy267));
                                                delete yymsp[-5].minor.yy473;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy298;
                                            }
        break;
      case 88: /* ccons ::= CHECK LP RP */
{
                                                yygotominor.yy298 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy298->initCheck();
                                                objectForTokens = yygotominor.yy298;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 89: /* term ::= NULL */
{yygotominor.yy15 = new QVariant();}
        break;
      case 90: /* term ::= INTEGER */
      case 392: /* number ::= INTEGER */ yytestcase(yyruleno==392);
{yygotominor.yy15 = parserContext->handleNumberToken(yymsp[0].minor.yy0->value);}
        break;
      case 91: /* term ::= FLOAT */
      case 393: /* number ::= FLOAT */ yytestcase(yyruleno==393);
{yygotominor.yy15 = new QVariant(QVariant(yymsp[0].minor.yy0->value).toDouble());}
        break;
      case 92: /* term ::= STRING|BLOB */
{
                                                if (yymsp[0].minor.yy0->value.length() >= 3 && yymsp[0].minor.yy0->value.startsWith("x'", Qt::CaseInsensitive))
                                                    yygotominor.yy15 = new QVariant(blobFromLiteral(yymsp[0].minor.yy0->value));
                                                else
                                                    yygotominor.yy15 = new QVariant(stripString(yymsp[0].minor.yy0->value));
                                            }
        break;
      case 93: /* tnm ::= term */
{
												yygotominor.yy622 = new ParserTermOrLiteral(*(yymsp[0].minor.yy15));
												delete yymsp[0].minor.yy15;
											}
        break;
      case 94: /* tnm ::= nm */
{
												yygotominor.yy622 = new ParserTermOrLiteral(*(yymsp[0].minor.yy267));
												delete yymsp[0].minor.yy267;
											}
        break;
      case 99: /* refargs ::= */
{yygotominor.yy316 = new ParserFkConditionList();}
        break;
      case 100: /* refargs ::= refargs refarg */
{
                                                yymsp[-1].minor.yy316->append(yymsp[0].minor.yy165);
                                                yygotominor.yy316 = yymsp[-1].minor.yy316;
                                                DONT_INHERIT_TOKENS("refargs");
                                            }
        break;
      case 101: /* refarg ::= MATCH nm */
{
                                                yygotominor.yy165 = new SqliteForeignKey::Condition(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 102: /* refarg ::= ON INSERT refact */
{yygotominor.yy165 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::INSERT, *(yymsp[0].minor.yy410)); delete yymsp[0].minor.yy410;}
        break;
      case 103: /* refarg ::= ON DELETE refact */
{yygotominor.yy165 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::DELETE, *(yymsp[0].minor.yy410)); delete yymsp[0].minor.yy410;}
        break;
      case 104: /* refarg ::= ON UPDATE refact */
      case 105: /* refarg ::= MATCH ID_FK_MATCH */ yytestcase(yyruleno==105);
{yygotominor.yy165 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::UPDATE, *(yymsp[0].minor.yy410)); delete yymsp[0].minor.yy410;}
        break;
      case 106: /* refact ::= SET NULL */
{yygotominor.yy410 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_NULL);}
        break;
      case 107: /* refact ::= SET DEFAULT */
{yygotominor.yy410 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_DEFAULT);}
        break;
      case 108: /* refact ::= CASCADE */
{yygotominor.yy410 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::CASCADE);}
        break;
      case 109: /* refact ::= RESTRICT */
{yygotominor.yy410 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::RESTRICT);}
        break;
      case 110: /* refact ::= NO ACTION */
{yygotominor.yy410 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::NO_ACTION);}
        break;
      case 111: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy497 = new ParserDeferSubClause(SqliteDeferrable::NOT_DEFERRABLE, *(yymsp[0].minor.yy218));
                                                delete yymsp[0].minor.yy218;
                                            }
        break;
      case 112: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy497 = new ParserDeferSubClause(SqliteDeferrable::DEFERRABLE, *(yymsp[0].minor.yy218));
                                                delete yymsp[0].minor.yy218;
                                            }
        break;
      case 113: /* init_deferred_pred_opt ::= */
{yygotominor.yy218 = new SqliteInitially(SqliteInitially::null);}
        break;
      case 114: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
{yygotominor.yy218 = new SqliteInitially(SqliteInitially::DEFERRED);}
        break;
      case 115: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
{yygotominor.yy218 = new SqliteInitially(SqliteInitially::IMMEDIATE);}
        break;
      case 116: /* conslist_opt ::= */
{yygotominor.yy365 = new ParserCreateTableConstraintList();}
        break;
      case 117: /* conslist_opt ::= COMMA conslist */
{yygotominor.yy365 = yymsp[0].minor.yy365;}
        break;
      case 118: /* conslist ::= conslist tconscomma tcons */
{
                                                yymsp[0].minor.yy240->afterComma = *(yymsp[-1].minor.yy473);
                                                yymsp[-2].minor.yy365->append(yymsp[0].minor.yy240);
                                                yygotominor.yy365 = yymsp[-2].minor.yy365;
                                                delete yymsp[-1].minor.yy473;
                                                DONT_INHERIT_TOKENS("conslist");
                                            }
        break;
      case 119: /* conslist ::= tcons */
{
                                                yygotominor.yy365 = new ParserCreateTableConstraintList();
                                                yygotominor.yy365->append(yymsp[0].minor.yy240);
                                            }
        break;
      case 122: /* tcons ::= CONSTRAINT nm */
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initNameOnly(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy240;
                                            }
        break;
      case 123: /* tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf */
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initPk(*(yymsp[-3].minor.yy121), *(yymsp[-2].minor.yy473), *(yymsp[0].minor.yy134));
                                                delete yymsp[-2].minor.yy473;
                                                delete yymsp[0].minor.yy134;
                                                delete yymsp[-3].minor.yy121;
                                                objectForTokens = yygotominor.yy240;
                                            }
        break;
      case 124: /* tcons ::= UNIQUE LP idxlist RP onconf */
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initUnique(*(yymsp[-2].minor.yy121), *(yymsp[0].minor.yy134));
                                                delete yymsp[0].minor.yy134;
                                                delete yymsp[-2].minor.yy121;
                                                objectForTokens = yygotominor.yy240;
                                            }
        break;
      case 125: /* tcons ::= CHECK LP expr RP onconf */
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initCheck(yymsp[-2].minor.yy339, *(yymsp[0].minor.yy134));
                                                objectForTokens = yygotominor.yy240;
                                            }
        break;
      case 126: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
      case 127: /* tcons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==127);
      case 128: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB */ yytestcase(yyruleno==128);
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initFk(
                                                    *(yymsp[-6].minor.yy121),
                                                    *(yymsp[-3].minor.yy267),
                                                    *(yymsp[-2].minor.yy121),
                                                    *(yymsp[-1].minor.yy316),
                                                    yymsp[0].minor.yy497->initially,
                                                    yymsp[0].minor.yy497->deferrable
                                                );
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-1].minor.yy316;
                                                delete yymsp[0].minor.yy497;
                                                delete yymsp[-2].minor.yy121;
                                                delete yymsp[-6].minor.yy121;
                                                objectForTokens = yygotominor.yy240;
                                            }
        break;
      case 129: /* tcons ::= CHECK LP RP onconf */
{
                                                yygotominor.yy240 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy240->initCheck();
                                                objectForTokens = yygotominor.yy240;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                              yy_destructor(yypParser,229,&yymsp[0].minor);
}
        break;
      case 130: /* defer_subclause_opt ::= */
{yygotominor.yy497 = new ParserDeferSubClause(SqliteDeferrable::null, SqliteInitially::null);}
        break;
      case 131: /* defer_subclause_opt ::= defer_subclause */
{yygotominor.yy497 = yymsp[0].minor.yy497;}
        break;
      case 132: /* onconf ::= */
      case 134: /* orconf ::= */ yytestcase(yyruleno==134);
{yygotominor.yy134 = new SqliteConflictAlgo(SqliteConflictAlgo::null);}
        break;
      case 133: /* onconf ::= ON CONFLICT resolvetype */
      case 135: /* orconf ::= OR resolvetype */ yytestcase(yyruleno==135);
{yygotominor.yy134 = yymsp[0].minor.yy134;}
        break;
      case 136: /* resolvetype ::= raisetype */
      case 137: /* resolvetype ::= IGNORE */ yytestcase(yyruleno==137);
      case 138: /* resolvetype ::= REPLACE */ yytestcase(yyruleno==138);
{yygotominor.yy134 = new SqliteConflictAlgo(sqliteConflictAlgo(yymsp[0].minor.yy0->value));}
        break;
      case 139: /* cmd ::= DROP TABLE ifexists fullname */
{
                                                yygotominor.yy43 = new SqliteDropTable(*(yymsp[-1].minor.yy473), yymsp[0].minor.yy136->name1, yymsp[0].minor.yy136->name2);
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[0].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 140: /* cmd ::= DROP TABLE ifexists nm DOT ID_TAB */
      case 141: /* cmd ::= DROP TABLE ifexists ID_DB|ID_TAB */ yytestcase(yyruleno==141);
      case 148: /* cmd ::= DROP VIEW ifexists nm DOT ID_VIEW */ yytestcase(yyruleno==148);
      case 149: /* cmd ::= DROP VIEW ifexists ID_DB|ID_VIEW */ yytestcase(yyruleno==149);
      case 192: /* singlesrc ::= nm DOT ID_TAB */ yytestcase(yyruleno==192);
      case 193: /* singlesrc ::= ID_DB|ID_TAB */ yytestcase(yyruleno==193);
      case 194: /* singlesrc ::= nm DOT ID_VIEW */ yytestcase(yyruleno==194);
      case 195: /* singlesrc ::= ID_DB|ID_VIEW */ yytestcase(yyruleno==195);
      case 357: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm DOT ID_IDX_NEW */ yytestcase(yyruleno==357);
      case 358: /* cmd ::= CREATE uniqueflag INDEX ifnotexists ID_DB|ID_IDX_NEW */ yytestcase(yyruleno==358);
      case 371: /* cmd ::= DROP INDEX ifexists nm DOT ID_IDX */ yytestcase(yyruleno==371);
      case 372: /* cmd ::= DROP INDEX ifexists ID_DB|ID_IDX */ yytestcase(yyruleno==372);
      case 382: /* cmd ::= PRAGMA nm DOT ID_PRAGMA */ yytestcase(yyruleno==382);
      case 383: /* cmd ::= PRAGMA ID_DB|ID_PRAGMA */ yytestcase(yyruleno==383);
      case 421: /* cmd ::= DROP TRIGGER ifexists nm DOT ID_TRIG */ yytestcase(yyruleno==421);
      case 422: /* cmd ::= DROP TRIGGER ifexists ID_DB|ID_TRIG */ yytestcase(yyruleno==422);
      case 432: /* cmd ::= REINDEX nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==432);
      case 433: /* cmd ::= REINDEX ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==433);
      case 436: /* cmd ::= ANALYZE nm DOT ID_TAB|ID_IDX */ yytestcase(yyruleno==436);
      case 437: /* cmd ::= ANALYZE ID_DB|ID_IDX|ID_TAB */ yytestcase(yyruleno==437);
      case 442: /* cmd ::= ALTER TABLE nm DOT ID_TAB */ yytestcase(yyruleno==442);
      case 443: /* cmd ::= ALTER TABLE ID_DB|ID_TAB */ yytestcase(yyruleno==443);
      case 449: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm DOT ID_TAB_NEW */ yytestcase(yyruleno==449);
      case 450: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists ID_DB|ID_TAB_NEW */ yytestcase(yyruleno==450);
{  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 144: /* cmd ::= CREATE temp VIEW ifnotexists fullname idxlist_opt AS select */
{
                                                yygotominor.yy43 = new SqliteCreateView(*(yymsp[-6].minor.yy348), *(yymsp[-4].minor.yy473), yymsp[-3].minor.yy136->name1, yymsp[-3].minor.yy136->name2, yymsp[0].minor.yy379, *(yymsp[-2].minor.yy121));
                                                delete yymsp[-6].minor.yy348;
                                                delete yymsp[-4].minor.yy473;
                                                delete yymsp[-3].minor.yy136;
                                                delete yymsp[-2].minor.yy121;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 147: /* cmd ::= DROP VIEW ifexists fullname */
{
                                                yygotominor.yy43 = new SqliteDropView(*(yymsp[-1].minor.yy473), yymsp[0].minor.yy136->name1, yymsp[0].minor.yy136->name2);
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[0].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 150: /* cmd ::= select_stmt */
      case 239: /* cmd ::= delete_stmt */ yytestcase(yyruleno==239);
      case 250: /* cmd ::= update_stmt */ yytestcase(yyruleno==250);
      case 271: /* cmd ::= insert_stmt */ yytestcase(yyruleno==271);
{
                                                yygotominor.yy43 = yymsp[0].minor.yy43;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 151: /* select_stmt ::= select */
{
                                                yygotominor.yy43 = yymsp[0].minor.yy379;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 152: /* select ::= with selectnowith */
{
                                                yygotominor.yy379 = yymsp[0].minor.yy379;
                                                yymsp[0].minor.yy379->setWith(yymsp[-1].minor.yy91);
                                                objectForTokens = yygotominor.yy379;
                                            }
        break;
      case 153: /* selectnowith ::= oneselect */
{
                                                yygotominor.yy379 = SqliteSelect::append(yymsp[0].minor.yy492);
                                                objectForTokens = yygotominor.yy379;
                                            }
        break;
      case 154: /* selectnowith ::= selectnowith multiselect_op oneselect */
{
                                                yygotominor.yy379 = SqliteSelect::append(yymsp[-2].minor.yy379, *(yymsp[-1].minor.yy116), yymsp[0].minor.yy492);
                                                delete yymsp[-1].minor.yy116;
                                                objectForTokens = yygotominor.yy379;
                                            }
        break;
      case 155: /* selectnowith ::= values */
{
                                                yygotominor.yy379 = SqliteSelect::append(*(yymsp[0].minor.yy118));
                                                delete yymsp[0].minor.yy118;
                                                objectForTokens = yygotominor.yy379;
                                            }
        break;
      case 156: /* selectnowith ::= selectnowith COMMA values */
{
                                                yygotominor.yy379 = SqliteSelect::append(yymsp[-2].minor.yy379, SqliteSelect::CompoundOperator::UNION_ALL, *(yymsp[0].minor.yy118));
                                                delete yymsp[0].minor.yy118;
                                                objectForTokens = yygotominor.yy379;
                                            }
        break;
      case 157: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
{
                                                yygotominor.yy492 = new SqliteSelect::Core(
                                                        *(yymsp[-7].minor.yy348),
                                                        *(yymsp[-6].minor.yy75),
                                                        yymsp[-5].minor.yy567,
                                                        yymsp[-4].minor.yy339,
                                                        *(yymsp[-3].minor.yy498),
                                                        yymsp[-2].minor.yy339,
                                                        *(yymsp[-1].minor.yy277),
                                                        yymsp[0].minor.yy330
                                                    );
                                                delete yymsp[-6].minor.yy75;
                                                delete yymsp[-7].minor.yy348;
                                                delete yymsp[-3].minor.yy498;
                                                delete yymsp[-1].minor.yy277;
                                                objectForTokens = yygotominor.yy492;
                                            }
        break;
      case 158: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt window_clause orderby_opt limit_opt */
{
                                                yygotominor.yy492 = new SqliteSelect::Core(
                                                        *(yymsp[-8].minor.yy348),
                                                        *(yymsp[-7].minor.yy75),
                                                        yymsp[-6].minor.yy567,
                                                        yymsp[-5].minor.yy339,
                                                        *(yymsp[-4].minor.yy498),
                                                        yymsp[-3].minor.yy339,
                                                        *(yymsp[-2].minor.yy369),
                                                        *(yymsp[-1].minor.yy277),
                                                        yymsp[0].minor.yy330
                                                    );
                                                delete yymsp[-7].minor.yy75;
                                                delete yymsp[-8].minor.yy348;
                                                delete yymsp[-4].minor.yy498;
                                                delete yymsp[-1].minor.yy277;
                                                delete yymsp[-2].minor.yy369;
                                                objectForTokens = yygotominor.yy492;
                                            }
        break;
      case 159: /* values ::= VALUES LP nexprlist RP */
{
                                                yygotominor.yy118 = new ParserExprNestedList();
                                                yygotominor.yy118->append(*(yymsp[-1].minor.yy498));
                                                delete yymsp[-1].minor.yy498;
                                            }
        break;
      case 160: /* values ::= values COMMA LP exprlist RP */
{
                                                yymsp[-4].minor.yy118->append(*(yymsp[-1].minor.yy498));
                                                yygotominor.yy118 = yymsp[-4].minor.yy118;
                                                delete yymsp[-1].minor.yy498;
                                                DONT_INHERIT_TOKENS("values");
                                            }
        break;
      case 161: /* multiselect_op ::= UNION */
{yygotominor.yy116 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION);}
        break;
      case 162: /* multiselect_op ::= UNION ALL */
{yygotominor.yy116 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION_ALL);}
        break;
      case 163: /* multiselect_op ::= EXCEPT */
{yygotominor.yy116 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::EXCEPT);}
        break;
      case 164: /* multiselect_op ::= INTERSECT */
{yygotominor.yy116 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::INTERSECT);}
        break;
      case 165: /* distinct ::= DISTINCT */
{yygotominor.yy348 = new int(1);}
        break;
      case 166: /* distinct ::= ALL */
{yygotominor.yy348 = new int(2);}
        break;
      case 168: /* sclp ::= selcollist COMMA */
{yygotominor.yy75 = yymsp[-1].minor.yy75;}
        break;
      case 169: /* sclp ::= */
      case 248: /* returning ::= */ yytestcase(yyruleno==248);
{yygotominor.yy75 = new ParserResultColumnList();}
        break;
      case 170: /* selcollist ::= sclp expr as */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        yymsp[-1].minor.yy339,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->asKw : false,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->name : QString()
                                                    );

                                                yymsp[-2].minor.yy75->append(obj);
                                                yygotominor.yy75 = yymsp[-2].minor.yy75;
                                                delete yymsp[0].minor.yy516;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 171: /* selcollist ::= sclp STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(true);

                                                yymsp[-1].minor.yy75->append(obj);
                                                yygotominor.yy75 = yymsp[-1].minor.yy75;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 172: /* selcollist ::= sclp tnm DOT STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        true,
                                                        yymsp[-2].minor.yy622->toName()
                                                    );
													
												if (!yymsp[-2].minor.yy622->isName())
													parserContext->errorAtToken("Syntax error <expected name, not literal value>", -3);
													
                                                yymsp[-3].minor.yy75->append(obj);
                                                yygotominor.yy75 = yymsp[-3].minor.yy75;
                                                delete yymsp[-2].minor.yy622;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 173: /* selcollist ::= sclp */
      case 174: /* selcollist ::= sclp ID_TAB DOT STAR */ yytestcase(yyruleno==174);
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy75 = yymsp[0].minor.yy75;
                                            }
        break;
      case 175: /* as ::= AS nm */
{
                                                yygotominor.yy516 = new ParserStubAlias(*(yymsp[0].minor.yy267), true);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 176: /* as ::= ids */
      case 177: /* as ::= AS ID_ALIAS */ yytestcase(yyruleno==177);
      case 178: /* as ::= ID_ALIAS */ yytestcase(yyruleno==178);
{
                                                yygotominor.yy516 = new ParserStubAlias(*(yymsp[0].minor.yy267), false);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 179: /* as ::= */
{yygotominor.yy516 = nullptr;}
        break;
      case 180: /* from ::= */
{yygotominor.yy567 = nullptr;}
        break;
      case 181: /* from ::= FROM joinsrc */
{yygotominor.yy567 = yymsp[0].minor.yy567;}
        break;
      case 182: /* joinsrc ::= singlesrc seltablist */
{
                                                yygotominor.yy567 = new SqliteSelect::Core::JoinSource(
                                                        yymsp[-1].minor.yy95,
                                                        *(yymsp[0].minor.yy527)
                                                    );
                                                delete yymsp[0].minor.yy527;
                                                objectForTokens = yygotominor.yy567;
                                            }
        break;
      case 183: /* joinsrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy567 = new SqliteSelect::Core::JoinSource();
                                                objectForTokens = yygotominor.yy567;
                                            }
        break;
      case 184: /* seltablist ::= seltablist joinop singlesrc joinconstr_opt */
{
                                                SqliteSelect::Core::JoinSourceOther* src =
                                                    new SqliteSelect::Core::JoinSourceOther(yymsp[-2].minor.yy273, yymsp[-1].minor.yy95, yymsp[0].minor.yy421);

                                                yymsp[-3].minor.yy527->append(src);
                                                yygotominor.yy527 = yymsp[-3].minor.yy527;
                                                objectForTokens = src;
                                                DONT_INHERIT_TOKENS("seltablist");
                                            }
        break;
      case 185: /* seltablist ::= */
{
                                                yygotominor.yy527 = new ParserOtherSourceList();
                                            }
        break;
      case 186: /* singlesrc ::= nm dbnm as indexed_opt */
{
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-3].minor.yy267),
                                                        *(yymsp[-2].minor.yy267),
                                                        yymsp[-1].minor.yy516 ? yymsp[-1].minor.yy516->asKw : false,
                                                        yymsp[-1].minor.yy516 ? yymsp[-1].minor.yy516->name : QString(),
                                                        yymsp[0].minor.yy542 ? yymsp[0].minor.yy542->notIndexedKw : false,
                                                        yymsp[0].minor.yy542 ? yymsp[0].minor.yy542->indexedBy : QString()
                                                    );
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[-1].minor.yy516;
                                                if (yymsp[0].minor.yy542)
                                                    delete yymsp[0].minor.yy542;
                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 187: /* singlesrc ::= LP select RP as */
{
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy379,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->asKw : false,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy516;
                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 188: /* singlesrc ::= LP joinsrc RP as */
{
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy567,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->asKw : false,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->name : QString()
                                                    );
                                                delete yymsp[0].minor.yy516;
                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 189: /* singlesrc ::= nm dbnm LP exprlist RP as */
{
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-5].minor.yy267),
                                                        *(yymsp[-4].minor.yy267),
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->asKw : false,
                                                        yymsp[0].minor.yy516 ? yymsp[0].minor.yy516->name : QString(),
                                                        *(yymsp[-2].minor.yy498)
                                                    );
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[0].minor.yy516;
                                                if (yymsp[-2].minor.yy498)
                                                    delete yymsp[-2].minor.yy498;

                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 190: /* singlesrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource();
                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 191: /* singlesrc ::= nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy95 = new SqliteSelect::Core::SingleSource();
                                                yygotominor.yy95->database = *(yymsp[-1].minor.yy267);
                                                delete yymsp[-1].minor.yy267;
                                                objectForTokens = yygotominor.yy95;
                                            }
        break;
      case 196: /* joinconstr_opt ::= ON expr */
{
                                                yygotominor.yy421 = new SqliteSelect::Core::JoinConstraint(yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy421;
                                            }
        break;
      case 197: /* joinconstr_opt ::= USING LP idlist RP */
{
                                                yygotominor.yy421 = new SqliteSelect::Core::JoinConstraint(*(yymsp[-1].minor.yy327));
                                                delete yymsp[-1].minor.yy327;
                                                objectForTokens = yygotominor.yy421;
                                            }
        break;
      case 198: /* joinconstr_opt ::= */
{yygotominor.yy421 = nullptr;}
        break;
      case 199: /* dbnm ::= */
      case 367: /* collate ::= */ yytestcase(yyruleno==367);
      case 453: /* vtabarg ::= */ yytestcase(yyruleno==453);
      case 457: /* anylist ::= */ yytestcase(yyruleno==457);
{yygotominor.yy267 = new QString();}
        break;
      case 201: /* fullname ::= nm */
{
                                                yygotominor.yy136 = new ParserFullName();
                                                yygotominor.yy136->name1 = *(yymsp[0].minor.yy267);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 202: /* fullname ::= nm DOT nm */
{
                                                yygotominor.yy136 = new ParserFullName();
                                                yygotominor.yy136->name1 = *(yymsp[-2].minor.yy267);
                                                yygotominor.yy136->name2 = *(yymsp[0].minor.yy267);
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 203: /* xfullname ::= nm */
{
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[0].minor.yy267);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 204: /* xfullname ::= nm DOT nm */
{
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[-2].minor.yy267);
                                                yygotominor.yy128->name2 = *(yymsp[0].minor.yy267);
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 205: /* xfullname ::= nm DOT nm AS nm */
{
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[-4].minor.yy267);
                                                yygotominor.yy128->name2 = *(yymsp[-2].minor.yy267);
                                                yygotominor.yy128->alias = *(yymsp[0].minor.yy267);
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 206: /* xfullname ::= nm AS nm */
{
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[-2].minor.yy267);
                                                yygotominor.yy128->alias = *(yymsp[0].minor.yy267);
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 207: /* xfullname ::= nm DOT nm AS ID_ALIAS */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[-4].minor.yy267);
                                                yygotominor.yy128->name2 = *(yymsp[-2].minor.yy267);
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                            }
        break;
      case 208: /* xfullname ::= nm AS ID_ALIAS */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy128 = new ParserXFullName();
                                                yygotominor.yy128->name1 = *(yymsp[-2].minor.yy267);
                                                delete yymsp[-2].minor.yy267;
                                            }
        break;
      case 209: /* joinop ::= COMMA */
{
                                                yygotominor.yy273 = new SqliteSelect::Core::JoinOp(true);
                                                objectForTokens = yygotominor.yy273;
                                            }
        break;
      case 210: /* joinop ::= JOIN */
{
                                                yygotominor.yy273 = new SqliteSelect::Core::JoinOp(false);
                                                objectForTokens = yygotominor.yy273;
                                            }
        break;
      case 211: /* joinop ::= JOIN_KW JOIN */
{
                                                yygotominor.yy273 = new SqliteSelect::Core::JoinOp(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy273;
                                            }
        break;
      case 212: /* joinop ::= JOIN_KW nm JOIN */
{
                                                yygotominor.yy273 = new SqliteSelect::Core::JoinOp(yymsp[-2].minor.yy0->value, *(yymsp[-1].minor.yy267));
                                                delete yymsp[-1].minor.yy267;
                                                objectForTokens = yygotominor.yy273;
                                            }
        break;
      case 213: /* joinop ::= JOIN_KW nm nm JOIN */
      case 214: /* joinop ::= ID_JOIN_OPTS */ yytestcase(yyruleno==214);
{
                                                yygotominor.yy273 = new SqliteSelect::Core::JoinOp(yymsp[-3].minor.yy0->value, *(yymsp[-2].minor.yy267), *(yymsp[-1].minor.yy267));
                                                delete yymsp[-2].minor.yy267;
                                                objectForTokens = yygotominor.yy273;
                                            }
        break;
      case 215: /* indexed_opt ::= */
{yygotominor.yy542 = nullptr;}
        break;
      case 216: /* indexed_opt ::= indexed_by */
{yygotominor.yy542 = yymsp[0].minor.yy542;}
        break;
      case 217: /* indexed_by ::= INDEXED BY nm */
{
                                                yygotominor.yy542 = new ParserIndexedBy(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 218: /* indexed_by ::= NOT INDEXED */
{yygotominor.yy542 = new ParserIndexedBy(true);}
        break;
      case 219: /* indexed_by ::= INDEXED BY ID_IDX */
{parserContext->minorErrorBeforeNextToken("Syntax error");}
        break;
      case 220: /* orderby_opt ::= */
{yygotominor.yy277 = new ParserOrderByList();}
        break;
      case 221: /* orderby_opt ::= ORDER BY sortlist */
{yygotominor.yy277 = yymsp[0].minor.yy277;}
        break;
      case 222: /* sortlist ::= sortlist COMMA expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy339, *(yymsp[-1].minor.yy25), *(yymsp[0].minor.yy409));
                                                yymsp[-4].minor.yy277->append(obj);
                                                yygotominor.yy277 = yymsp[-4].minor.yy277;
                                                delete yymsp[-1].minor.yy25;
												delete yymsp[0].minor.yy409;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sortlist");
                                            }
        break;
      case 223: /* sortlist ::= expr sortorder nulls */
{
                                                SqliteOrderBy* obj = new SqliteOrderBy(yymsp[-2].minor.yy339, *(yymsp[-1].minor.yy25), *(yymsp[0].minor.yy409));
                                                yygotominor.yy277 = new ParserOrderByList();
                                                yygotominor.yy277->append(obj);
                                                delete yymsp[-1].minor.yy25;
												delete yymsp[0].minor.yy409;
                                                objectForTokens = obj;
                                            }
        break;
      case 224: /* sortorder ::= ASC */
{yygotominor.yy25 = new SqliteSortOrder(SqliteSortOrder::ASC);}
        break;
      case 225: /* sortorder ::= DESC */
{yygotominor.yy25 = new SqliteSortOrder(SqliteSortOrder::DESC);}
        break;
      case 226: /* sortorder ::= */
{yygotominor.yy25 = new SqliteSortOrder(SqliteSortOrder::null);}
        break;
      case 227: /* nulls ::= NULLS FIRST */
{yygotominor.yy409 = new SqliteNulls(SqliteNulls::FIRST);}
        break;
      case 228: /* nulls ::= NULLS LAST */
{yygotominor.yy409 = new SqliteNulls(SqliteNulls::LAST);}
        break;
      case 229: /* nulls ::= */
{yygotominor.yy409 = new SqliteNulls(SqliteNulls::null);}
        break;
      case 230: /* groupby_opt ::= */
      case 352: /* exprlist ::= */ yytestcase(yyruleno==352);
{yygotominor.yy498 = new ParserExprList();}
        break;
      case 231: /* groupby_opt ::= GROUP BY nexprlist */
      case 351: /* exprlist ::= nexprlist */ yytestcase(yyruleno==351);
{yygotominor.yy498 = yymsp[0].minor.yy498;}
        break;
      case 232: /* groupby_opt ::= GROUP BY */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy498 = new ParserExprList();
                                            }
        break;
      case 233: /* having_opt ::= */
      case 245: /* where_opt ::= */ yytestcase(yyruleno==245);
      case 348: /* case_else ::= */ yytestcase(yyruleno==348);
      case 350: /* case_operand ::= */ yytestcase(yyruleno==350);
      case 376: /* vinto ::= */ yytestcase(yyruleno==376);
      case 410: /* when_clause ::= */ yytestcase(yyruleno==410);
      case 425: /* key_opt ::= */ yytestcase(yyruleno==425);
{yygotominor.yy339 = nullptr;}
        break;
      case 234: /* having_opt ::= HAVING expr */
      case 246: /* where_opt ::= WHERE expr */ yytestcase(yyruleno==246);
      case 339: /* expr ::= exprx */ yytestcase(yyruleno==339);
      case 347: /* case_else ::= ELSE expr */ yytestcase(yyruleno==347);
      case 349: /* case_operand ::= exprx */ yytestcase(yyruleno==349);
      case 375: /* vinto ::= INTO expr */ yytestcase(yyruleno==375);
      case 411: /* when_clause ::= WHEN expr */ yytestcase(yyruleno==411);
      case 426: /* key_opt ::= KEY expr */ yytestcase(yyruleno==426);
{yygotominor.yy339 = yymsp[0].minor.yy339;}
        break;
      case 235: /* limit_opt ::= */
{yygotominor.yy330 = nullptr;}
        break;
      case 236: /* limit_opt ::= LIMIT expr */
{
                                                yygotominor.yy330 = new SqliteLimit(yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy330;
                                            }
        break;
      case 237: /* limit_opt ::= LIMIT expr OFFSET expr */
{
                                                yygotominor.yy330 = new SqliteLimit(yymsp[-2].minor.yy339, yymsp[0].minor.yy339, true);
                                                objectForTokens = yygotominor.yy330;
                                            }
        break;
      case 238: /* limit_opt ::= LIMIT expr COMMA expr */
{
                                                yygotominor.yy330 = new SqliteLimit(yymsp[-2].minor.yy339, yymsp[0].minor.yy339, false);
                                                objectForTokens = yygotominor.yy330;
                                            }
        break;
      case 240: /* delete_stmt ::= with DELETE FROM xfullname indexed_opt where_opt returning orderby_opt limit_opt */
{
                                                if (yymsp[-4].minor.yy542)
                                                {
                                                    if (!yymsp[-4].minor.yy542->indexedBy.isNull())
                                                    {
                                                        yygotominor.yy43 = new SqliteDelete(
                                                                yymsp[-5].minor.yy128->name1,
                                                                yymsp[-5].minor.yy128->name2,
                                                                yymsp[-5].minor.yy128->alias,
                                                                yymsp[-4].minor.yy542->indexedBy,
                                                                yymsp[-3].minor.yy339,
                                                                yymsp[-8].minor.yy91,
                                                                *(yymsp[-2].minor.yy75),
                                                                *(yymsp[-1].minor.yy277),
                                                                yymsp[0].minor.yy330
                                                            );
                                                    }
                                                    else
                                                    {
                                                        yygotominor.yy43 = new SqliteDelete(
                                                                yymsp[-5].minor.yy128->name1,
                                                                yymsp[-5].minor.yy128->name2,
                                                                yymsp[-5].minor.yy128->alias,
                                                                yymsp[-4].minor.yy542->notIndexedKw,
                                                                yymsp[-3].minor.yy339,
                                                                yymsp[-8].minor.yy91,
                                                                *(yymsp[-2].minor.yy75),
                                                                *(yymsp[-1].minor.yy277),
                                                                yymsp[0].minor.yy330
                                                            );
                                                    }
                                                    delete yymsp[-4].minor.yy542;
                                                }
                                                else
                                                {
                                                    yygotominor.yy43 = new SqliteDelete(
                                                            yymsp[-5].minor.yy128->name1,
                                                            yymsp[-5].minor.yy128->name2,
                                                            yymsp[-5].minor.yy128->alias,
                                                            false,
                                                            yymsp[-3].minor.yy339,
                                                            yymsp[-8].minor.yy91,
                                                            *(yymsp[-2].minor.yy75),
                                                            *(yymsp[-1].minor.yy277),
                                                            yymsp[0].minor.yy330
                                                        );
                                                }
                                                delete yymsp[-5].minor.yy128;
                                                delete yymsp[-2].minor.yy75;
                                                delete yymsp[-1].minor.yy277;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 241: /* delete_stmt ::= with DELETE FROM */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-2].minor.yy91;
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 242: /* delete_stmt ::= with DELETE FROM nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->with = yymsp[-4].minor.yy91;
                                                q->database = *(yymsp[-1].minor.yy267);
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[-1].minor.yy267;
                                            }
        break;
      case 243: /* delete_stmt ::= with DELETE FROM nm DOT ID_TAB */
      case 254: /* update_stmt ::= with UPDATE orconf nm DOT ID_TAB */ yytestcase(yyruleno==254);
{  yy_destructor(yypParser,250,&yymsp[-5].minor);
  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 244: /* delete_stmt ::= with DELETE FROM ID_DB|ID_TAB */
      case 255: /* update_stmt ::= with UPDATE orconf ID_DB|ID_TAB */ yytestcase(yyruleno==255);
{  yy_destructor(yypParser,250,&yymsp[-3].minor);
}
        break;
      case 247: /* where_opt ::= WHERE */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy339 = new SqliteExpr();
                                            }
        break;
      case 249: /* returning ::= RETURNING selcollist */
{yygotominor.yy75 = yymsp[0].minor.yy75;}
        break;
      case 251: /* update_stmt ::= with UPDATE orconf xfullname indexed_opt SET setlist from where_opt returning orderby_opt limit_opt */
{
                                                yygotominor.yy43 = new SqliteUpdate(
                                                        *(yymsp[-9].minor.yy134),
                                                        yymsp[-8].minor.yy128->name1,
                                                        yymsp[-8].minor.yy128->name2,
                                                        yymsp[-8].minor.yy128->alias,
                                                        yymsp[-7].minor.yy542 ? yymsp[-7].minor.yy542->notIndexedKw : false,
                                                        yymsp[-7].minor.yy542 ? yymsp[-7].minor.yy542->indexedBy : QString(),
                                                        *(yymsp[-5].minor.yy387),
                                                        yymsp[-4].minor.yy567,
                                                        yymsp[-3].minor.yy339,
                                                        yymsp[-11].minor.yy91,
                                                        *(yymsp[-2].minor.yy75),
                                                        *(yymsp[-1].minor.yy277),
                                                        yymsp[0].minor.yy330
                                                    );
                                                delete yymsp[-9].minor.yy134;
                                                delete yymsp[-8].minor.yy128;
                                                delete yymsp[-5].minor.yy387;
                                                delete yymsp[-2].minor.yy75;
                                                delete yymsp[-1].minor.yy277;
                                                if (yymsp[-7].minor.yy542)
                                                    delete yymsp[-7].minor.yy542;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 252: /* update_stmt ::= with UPDATE orconf */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-2].minor.yy91;
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[0].minor.yy134;
                                            }
        break;
      case 253: /* update_stmt ::= with UPDATE orconf nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->with = yymsp[-4].minor.yy91;
                                                q->database = *(yymsp[-1].minor.yy267);
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[-2].minor.yy134;
                                                delete yymsp[-1].minor.yy267;
                                            }
        break;
      case 256: /* setlist ::= setlist COMMA nm EQ expr */
{
                                                yymsp[-4].minor.yy387->append(ParserSetValue(*(yymsp[-2].minor.yy267), yymsp[0].minor.yy339));
                                                yygotominor.yy387 = yymsp[-4].minor.yy387;
                                                delete yymsp[-2].minor.yy267;
                                            }
        break;
      case 257: /* setlist ::= setlist COMMA LP idlist RP EQ expr */
{
                                                yymsp[-6].minor.yy387->append(ParserSetValue(*(yymsp[-3].minor.yy327), yymsp[0].minor.yy339));
                                                yygotominor.yy387 = yymsp[-6].minor.yy387;
                                                delete yymsp[-3].minor.yy327;
                                            }
        break;
      case 258: /* setlist ::= nm EQ expr */
{
                                                yygotominor.yy387 = new ParserSetValueList();
                                                yygotominor.yy387->append(ParserSetValue(*(yymsp[-2].minor.yy267), yymsp[0].minor.yy339));
                                                delete yymsp[-2].minor.yy267;
                                            }
        break;
      case 259: /* setlist ::= LP idlist RP EQ expr */
{
                                                yygotominor.yy387 = new ParserSetValueList();
                                                yygotominor.yy387->append(ParserSetValue(*(yymsp[-3].minor.yy327), yymsp[0].minor.yy339));
                                                delete yymsp[-3].minor.yy327;
                                            }
        break;
      case 260: /* setlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy387 = new ParserSetValueList();
                                            }
        break;
      case 261: /* setlist ::= setlist COMMA */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy387 = yymsp[-1].minor.yy387;
                                            }
        break;
      case 262: /* setlist ::= setlist COMMA ID_COL */
      case 263: /* setlist ::= ID_COL */ yytestcase(yyruleno==263);
{  yy_destructor(yypParser,283,&yymsp[-2].minor);
}
        break;
      case 264: /* idlist_opt ::= */
{yygotominor.yy327 = new QStringList();}
        break;
      case 265: /* idlist_opt ::= LP idlist RP */
{yygotominor.yy327 = yymsp[-1].minor.yy327;}
        break;
      case 266: /* idlist ::= idlist COMMA nm */
{
                                                yygotominor.yy327 = yymsp[-2].minor.yy327;
                                                *(yygotominor.yy327) << *(yymsp[0].minor.yy267);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 267: /* idlist ::= nm */
{
                                                yygotominor.yy327 = new QStringList();
                                                *(yygotominor.yy327) << *(yymsp[0].minor.yy267);
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 268: /* idlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy327 = new QStringList();
                                            }
        break;
      case 269: /* idlist ::= idlist COMMA ID_COL */
      case 270: /* idlist ::= ID_COL */ yytestcase(yyruleno==270);
{  yy_destructor(yypParser,275,&yymsp[-2].minor);
}
        break;
      case 272: /* insert_stmt ::= with insert_cmd INTO xfullname idlist_opt select upsert returning */
{
                                                yygotominor.yy43 = new SqliteInsert(
                                                        yymsp[-6].minor.yy284->replace,
                                                        yymsp[-6].minor.yy284->orConflict,
                                                        yymsp[-4].minor.yy128->name1,
                                                        yymsp[-4].minor.yy128->name2,
                                                        yymsp[-4].minor.yy128->alias,
                                                        *(yymsp[-3].minor.yy327),
                                                        yymsp[-2].minor.yy379,
                                                        yymsp[-7].minor.yy91,
                                                        yymsp[-1].minor.yy34,
                                                        *(yymsp[0].minor.yy75)
                                                    );
                                                delete yymsp[-4].minor.yy128;
                                                delete yymsp[-6].minor.yy284;
                                                delete yymsp[-3].minor.yy327;
                                                delete yymsp[0].minor.yy75;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 273: /* insert_stmt ::= with insert_cmd INTO xfullname idlist_opt DEFAULT VALUES returning */
{
                                                yygotominor.yy43 = new SqliteInsert(
                                                        yymsp[-6].minor.yy284->replace,
                                                        yymsp[-6].minor.yy284->orConflict,
                                                        yymsp[-4].minor.yy128->name1,
                                                        yymsp[-4].minor.yy128->name2,
                                                        yymsp[-4].minor.yy128->alias,
                                                        *(yymsp[-3].minor.yy327),
                                                        yymsp[-7].minor.yy91,
                                                        *(yymsp[0].minor.yy75)
                                                    );
                                                delete yymsp[-4].minor.yy128;
                                                delete yymsp[-6].minor.yy284;
                                                delete yymsp[-3].minor.yy327;
                                                delete yymsp[0].minor.yy75;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 274: /* insert_stmt ::= with insert_cmd INTO xfullname LP idlist rp_opt */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy43 = new SqliteInsert(
                                                        yymsp[-5].minor.yy284->replace,
                                                        yymsp[-5].minor.yy284->orConflict,
                                                        yymsp[-3].minor.yy128->name1,
                                                        yymsp[-3].minor.yy128->name2,
                                                        yymsp[-3].minor.yy128->alias,
                                                        *(yymsp[-1].minor.yy327),
                                                        yymsp[-6].minor.yy91,
                                                        QList<SqliteResultColumn*>()
                                                    );
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[-3].minor.yy128;
                                                delete yymsp[-1].minor.yy327;
                                                delete yymsp[-5].minor.yy284;
                                                delete yymsp[0].minor.yy473;
                                            }
        break;
      case 275: /* insert_stmt ::= with insert_cmd INTO */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-1].minor.yy284->replace;
                                                q->onConflict = yymsp[-1].minor.yy284->orConflict;
                                                q->with = yymsp[-2].minor.yy91;
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[-1].minor.yy284;
                                            }
        break;
      case 276: /* insert_stmt ::= with insert_cmd INTO nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-3].minor.yy284->replace;
                                                q->onConflict = yymsp[-3].minor.yy284->orConflict;
                                                q->with = yymsp[-4].minor.yy91;
                                                q->database = *(yymsp[-1].minor.yy267);
                                                yygotominor.yy43 = q;
                                                objectForTokens = yygotominor.yy43;
                                                delete yymsp[-3].minor.yy284;
                                                delete yymsp[-1].minor.yy267;
                                            }
        break;
      case 277: /* insert_stmt ::= with insert_cmd INTO ID_DB|ID_TAB */
{  yy_destructor(yypParser,250,&yymsp[-3].minor);
  yy_destructor(yypParser,286,&yymsp[-2].minor);
}
        break;
      case 278: /* insert_stmt ::= with insert_cmd INTO nm DOT ID_TAB */
{  yy_destructor(yypParser,250,&yymsp[-5].minor);
  yy_destructor(yypParser,286,&yymsp[-4].minor);
  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 279: /* insert_cmd ::= INSERT orconf */
{
                                                yygotominor.yy284 = new ParserStubInsertOrReplace(false, *(yymsp[0].minor.yy134));
                                                delete yymsp[0].minor.yy134;
                                            }
        break;
      case 280: /* insert_cmd ::= REPLACE */
{yygotominor.yy284 = new ParserStubInsertOrReplace(true);}
        break;
      case 281: /* upsert ::= */
{
                                                yygotominor.yy34 = nullptr;
                                            }
        break;
      case 282: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO UPDATE SET setlist where_opt */
{
                                                yygotominor.yy34 = new SqliteUpsert(*(yymsp[-7].minor.yy277), yymsp[-5].minor.yy339, *(yymsp[-1].minor.yy387), yymsp[0].minor.yy339);
                                                delete yymsp[-7].minor.yy277;
                                                delete yymsp[-1].minor.yy387;
                                                objectForTokens = yygotominor.yy34;
                                            }
        break;
      case 283: /* upsert ::= ON CONFLICT LP sortlist RP where_opt DO NOTHING */
{
                                                yygotominor.yy34 = new SqliteUpsert(*(yymsp[-4].minor.yy277), yymsp[-2].minor.yy339);
                                                delete yymsp[-4].minor.yy277;
                                                objectForTokens = yygotominor.yy34;
                                            }
        break;
      case 284: /* upsert ::= ON CONFLICT DO NOTHING */
{
                                                yygotominor.yy34 = new SqliteUpsert();
                                                objectForTokens = yygotominor.yy34;
                                            }
        break;
      case 285: /* exprx ::= expr not_opt IN ID_DB */
{  yy_destructor(yypParser,228,&yymsp[-3].minor);
}
        break;
      case 286: /* exprx ::= expr not_opt IN nm DOT ID_TAB */
      case 287: /* exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN */ yytestcase(yyruleno==287);
{  yy_destructor(yypParser,228,&yymsp[-5].minor);
  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 288: /* exprx ::= tnm DOT ID_TAB|ID_COL */
{  yy_destructor(yypParser,236,&yymsp[-2].minor);
}
        break;
      case 289: /* exprx ::= tnm DOT nm DOT ID_COL */
{  yy_destructor(yypParser,236,&yymsp[-4].minor);
  yy_destructor(yypParser,204,&yymsp[-2].minor);
}
        break;
      case 290: /* exprx ::= expr COLLATE ID_COLLATE */
      case 291: /* exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP */ yytestcase(yyruleno==291);
{  yy_destructor(yypParser,228,&yymsp[-2].minor);
}
        break;
      case 292: /* exprx ::= CTIME_KW */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initCTime(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 293: /* exprx ::= LP nexprlist RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initRowValue(*(yymsp[-1].minor.yy498));
                                                delete yymsp[-1].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 294: /* exprx ::= tnm */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                if (yymsp[0].minor.yy622->isLiteral())
                                                    yygotominor.yy339->initLiteral(yymsp[0].minor.yy622->toLiteral());
                                                else
                                                    yygotominor.yy339->initId(yymsp[0].minor.yy622->toName());
                                                    //parserContext->errorBeforeLastToken("Syntax error <expected literal value>");

                                                delete yymsp[0].minor.yy622;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 295: /* exprx ::= tnm DOT nm */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                if (yymsp[-2].minor.yy622->isName())
                                                    yygotominor.yy339->initId(yymsp[-2].minor.yy622->toName(), *(yymsp[0].minor.yy267));
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -3);

                                                delete yymsp[-2].minor.yy622;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 296: /* exprx ::= tnm DOT */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy339;
                                                if (yymsp[-1].minor.yy622->isName())
                                                {
                                                    yygotominor.yy339->initId(yymsp[-1].minor.yy622->toName(), QString());
                                                    parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                                }
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -3);

                                                delete yymsp[-1].minor.yy622;
                                            }
        break;
      case 297: /* exprx ::= tnm DOT nm DOT nm */
{
                                                yygotominor.yy339 = new SqliteExpr();
												if (yymsp[-4].minor.yy622->isName())
													yygotominor.yy339->initId(yymsp[-4].minor.yy622->toName(), *(yymsp[-2].minor.yy267), *(yymsp[0].minor.yy267));
												else
													parserContext->errorAtToken("Syntax error <expected name>", -5);

                                                delete yymsp[-4].minor.yy622;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 298: /* exprx ::= tnm DOT nm DOT */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy339;
                                                if (yymsp[-3].minor.yy622->isName())
                                                {
                                                    yygotominor.yy339->initId(yymsp[-3].minor.yy622->toName(), *(yymsp[-1].minor.yy267), QString());
                                                    parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                                }
                                                else
                                                    parserContext->errorAtToken("Syntax error <expected name>", -5);

                                                delete yymsp[-3].minor.yy622;
                                                delete yymsp[-1].minor.yy267;
                                            }
        break;
      case 299: /* exprx ::= VARIABLE */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initBindParam(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 300: /* exprx ::= expr COLLATE ids */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initCollate(yymsp[-2].minor.yy339, *(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 301: /* exprx ::= CAST LP expr AS typetoken RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initCast(yymsp[-3].minor.yy339, yymsp[-1].minor.yy29);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 302: /* exprx ::= id LP distinct exprlist RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initFunction(stripObjName(*(yymsp[-4].minor.yy267)), *(yymsp[-2].minor.yy348), *(yymsp[-1].minor.yy498));
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-2].minor.yy348;
                                                delete yymsp[-1].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 303: /* exprx ::= id LP distinct exprlist ORDER BY sortlist RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initFunction(stripObjName(*(yymsp[-7].minor.yy267)), *(yymsp[-5].minor.yy348), *(yymsp[-4].minor.yy498), *(yymsp[-1].minor.yy277));
                                                delete yymsp[-7].minor.yy267;
                                                delete yymsp[-5].minor.yy348;
                                                delete yymsp[-4].minor.yy498;
                                                delete yymsp[-1].minor.yy277;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 304: /* exprx ::= id LP STAR RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initFunction(stripObjName(*(yymsp[-3].minor.yy267)), true);
                                                delete yymsp[-3].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 305: /* exprx ::= expr AND expr */
      case 306: /* exprx ::= expr OR expr */ yytestcase(yyruleno==306);
      case 307: /* exprx ::= expr LT|GT|GE|LE expr */ yytestcase(yyruleno==307);
      case 308: /* exprx ::= expr EQ|NE expr */ yytestcase(yyruleno==308);
      case 309: /* exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */ yytestcase(yyruleno==309);
      case 310: /* exprx ::= expr PLUS|MINUS expr */ yytestcase(yyruleno==310);
      case 311: /* exprx ::= expr STAR|SLASH|REM expr */ yytestcase(yyruleno==311);
      case 312: /* exprx ::= expr CONCAT expr */ yytestcase(yyruleno==312);
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initBinOp(yymsp[-2].minor.yy339, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 313: /* exprx ::= expr not_opt likeop expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initLike(yymsp[-3].minor.yy339, *(yymsp[-2].minor.yy473), *(yymsp[-1].minor.yy436), yymsp[0].minor.yy339);
                                                delete yymsp[-2].minor.yy473;
                                                delete yymsp[-1].minor.yy436;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 314: /* exprx ::= expr not_opt likeop expr ESCAPE expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initLike(yymsp[-5].minor.yy339, *(yymsp[-4].minor.yy473), *(yymsp[-3].minor.yy436), yymsp[-2].minor.yy339, yymsp[0].minor.yy339);
                                                delete yymsp[-4].minor.yy473;
                                                delete yymsp[-3].minor.yy436;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 315: /* exprx ::= expr ISNULL|NOTNULL */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initNull(yymsp[-1].minor.yy339, yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 316: /* exprx ::= expr NOT NULL */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initNull(yymsp[-2].minor.yy339, "NOT NULL");
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 317: /* exprx ::= expr IS not_opt expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initIs(yymsp[-3].minor.yy339, *(yymsp[-1].minor.yy473), yymsp[0].minor.yy339);
                                                delete yymsp[-1].minor.yy473;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 318: /* exprx ::= expr IS NOT DISTINCT FROM expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initDistinct(yymsp[-5].minor.yy339, true, yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 319: /* exprx ::= expr IS DISTINCT FROM expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initDistinct(yymsp[-4].minor.yy339, false, yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 320: /* exprx ::= NOT expr */
      case 321: /* exprx ::= BITNOT expr */ yytestcase(yyruleno==321);
      case 323: /* exprx ::= PLUS expr */ yytestcase(yyruleno==323);
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initUnaryOp(yymsp[0].minor.yy339, yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 322: /* exprx ::= MINUS expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                if (yymsp[0].minor.yy339->mode == SqliteExpr::Mode::LITERAL_VALUE &&
                                                    parserContext->isCandidateForMaxNegativeNumber() &&
                                                    yymsp[0].minor.yy339->literalValue == static_cast<qint64>(0L))
                                                {
                                                    yygotominor.yy339->initLiteral(std::numeric_limits<qint64>::min());
                                                    delete yymsp[0].minor.yy339;
                                                }
                                                else
                                                {
                                                    yygotominor.yy339->initUnaryOp(yymsp[0].minor.yy339, yymsp[-1].minor.yy0->value);
                                                }
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 324: /* exprx ::= expr PTR expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initPtrOp(yymsp[-2].minor.yy339, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 325: /* exprx ::= expr not_opt BETWEEN expr AND expr */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initBetween(yymsp[-5].minor.yy339, *(yymsp[-4].minor.yy473), yymsp[-2].minor.yy339, yymsp[0].minor.yy339);
                                                delete yymsp[-4].minor.yy473;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 326: /* exprx ::= expr not_opt IN LP exprlist RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initIn(yymsp[-5].minor.yy339, *(yymsp[-4].minor.yy473), *(yymsp[-1].minor.yy498));
                                                delete yymsp[-4].minor.yy473;
                                                delete yymsp[-1].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 327: /* exprx ::= LP select RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initSubSelect(yymsp[-1].minor.yy379);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 328: /* exprx ::= expr not_opt IN LP select RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initIn(yymsp[-5].minor.yy339, *(yymsp[-4].minor.yy473), yymsp[-1].minor.yy379);
                                                delete yymsp[-4].minor.yy473;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 329: /* exprx ::= expr not_opt IN nm dbnm */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initIn(yymsp[-4].minor.yy339, *(yymsp[-3].minor.yy473), *(yymsp[-1].minor.yy267), *(yymsp[0].minor.yy267));
                                                delete yymsp[-3].minor.yy473;
                                                delete yymsp[-1].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 330: /* exprx ::= EXISTS LP select RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initExists(yymsp[-1].minor.yy379);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 331: /* exprx ::= CASE case_operand case_exprlist case_else END */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initCase(yymsp[-3].minor.yy339, *(yymsp[-2].minor.yy498), yymsp[-1].minor.yy339);
                                                delete yymsp[-2].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 332: /* exprx ::= RAISE LP IGNORE RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initRaise(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 333: /* exprx ::= RAISE LP raisetype COMMA expr RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initRaise(yymsp[-3].minor.yy0->value, yymsp[-1].minor.yy339);
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 334: /* exprx ::= id LP distinct exprlist RP filter_over */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initWindowFunction(stripObjName(*(yymsp[-5].minor.yy267)), *(yymsp[-3].minor.yy348), *(yymsp[-2].minor.yy498), yymsp[0].minor.yy405);
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-3].minor.yy348;
                                                delete yymsp[-2].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 335: /* exprx ::= id LP distinct exprlist ORDER BY sortlist RP filter_over */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initWindowFunction(stripObjName(*(yymsp[-8].minor.yy267)), *(yymsp[-6].minor.yy348), *(yymsp[-5].minor.yy498), *(yymsp[-2].minor.yy277), yymsp[0].minor.yy405);
                                                delete yymsp[-8].minor.yy267;
                                                delete yymsp[-6].minor.yy348;
                                                delete yymsp[-5].minor.yy498;
                                                delete yymsp[-2].minor.yy277;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 336: /* exprx ::= id LP STAR RP filter_over */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initWindowFunction(stripObjName(*(yymsp[-4].minor.yy267)), yymsp[0].minor.yy405);
                                                delete yymsp[-4].minor.yy267;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 337: /* exprx ::= id LP distinct exprlist RP WITHIN GROUP LP ORDER BY expr RP */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                yygotominor.yy339->initOrderedSetAggregate(stripObjName(*(yymsp[-11].minor.yy267)), *(yymsp[-9].minor.yy348), *(yymsp[-8].minor.yy498), yymsp[-1].minor.yy339);
                                                delete yymsp[-11].minor.yy267;
                                                delete yymsp[-9].minor.yy348;
                                                delete yymsp[-8].minor.yy498;
                                                objectForTokens = yygotominor.yy339;
                                            }
        break;
      case 338: /* expr ::= */
{
                                                yygotominor.yy339 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy339;
                                                parserContext->minorErrorAfterLastToken("Syntax error <expr>");
                                            }
        break;
      case 344: /* likeop ::= LIKE_KW|MATCH */
{yygotominor.yy436 = new SqliteExpr::LikeOp(SqliteExpr::likeOp(yymsp[0].minor.yy0->value));}
        break;
      case 345: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
{
                                                yymsp[-4].minor.yy498->append(yymsp[-2].minor.yy339);
                                                yymsp[-4].minor.yy498->append(yymsp[0].minor.yy339);
                                                yygotominor.yy498 = yymsp[-4].minor.yy498;
                                            }
        break;
      case 346: /* case_exprlist ::= WHEN expr THEN expr */
{
                                                yygotominor.yy498 = new ParserExprList();
                                                yygotominor.yy498->append(yymsp[-2].minor.yy339);
                                                yygotominor.yy498->append(yymsp[0].minor.yy339);
                                            }
        break;
      case 353: /* nexprlist ::= nexprlist COMMA expr */
{
                                                yymsp[-2].minor.yy498->append(yymsp[0].minor.yy339);
                                                yygotominor.yy498 = yymsp[-2].minor.yy498;
                                                DONT_INHERIT_TOKENS("nexprlist");
                                            }
        break;
      case 354: /* nexprlist ::= exprx */
{
                                                yygotominor.yy498 = new ParserExprList();
                                                yygotominor.yy498->append(yymsp[0].minor.yy339);
                                            }
        break;
      case 355: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP sortlist RP where_opt */
{
                                                yygotominor.yy43 = new SqliteCreateIndex(
                                                        *(yymsp[-10].minor.yy473),
                                                        *(yymsp[-8].minor.yy473),
                                                        *(yymsp[-7].minor.yy267),
                                                        *(yymsp[-6].minor.yy267),
                                                        *(yymsp[-4].minor.yy267),
                                                        *(yymsp[-2].minor.yy277),
                                                        yymsp[0].minor.yy339
                                                    );
                                                delete yymsp[-8].minor.yy473;
                                                delete yymsp[-10].minor.yy473;
                                                delete yymsp[-7].minor.yy267;
                                                delete yymsp[-6].minor.yy267;
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-2].minor.yy277;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 356: /* cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON ID_TAB */
{  yy_destructor(yypParser,204,&yymsp[-3].minor);
}
        break;
      case 361: /* idxlist_opt ::= */
{yygotominor.yy121 = new ParserIndexedColumnList();}
        break;
      case 362: /* idxlist_opt ::= LP idxlist RP */
{yygotominor.yy121 = yymsp[-1].minor.yy121;}
        break;
      case 363: /* idxlist ::= idxlist COMMA idxlist_single */
{
                                                yymsp[-2].minor.yy121->append(yymsp[0].minor.yy166);
                                                yygotominor.yy121 = yymsp[-2].minor.yy121;
                                                DONT_INHERIT_TOKENS("idxlist");
                                            }
        break;
      case 364: /* idxlist ::= idxlist_single */
{
                                                yygotominor.yy121 = new ParserIndexedColumnList();
                                                yygotominor.yy121->append(yymsp[0].minor.yy166);
                                            }
        break;
      case 365: /* idxlist_single ::= nm collate sortorder */
      case 366: /* idxlist_single ::= ID_COL */ yytestcase(yyruleno==366);
{
                                                SqliteIndexedColumn* obj =
                                                    new SqliteIndexedColumn(
                                                        *(yymsp[-2].minor.yy267),
                                                        *(yymsp[-1].minor.yy267),
                                                        *(yymsp[0].minor.yy25)
                                                    );
                                                yygotominor.yy166 = obj;
                                                delete yymsp[0].minor.yy25;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[-1].minor.yy267;
                                                objectForTokens = yygotominor.yy166;
                                            }
        break;
      case 370: /* cmd ::= DROP INDEX ifexists fullname */
{
                                                yygotominor.yy43 = new SqliteDropIndex(*(yymsp[-1].minor.yy473), yymsp[0].minor.yy136->name1, yymsp[0].minor.yy136->name2);
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[0].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 373: /* cmd ::= VACUUM vinto */
{
                                                yygotominor.yy43 = new SqliteVacuum(yymsp[0].minor.yy339);
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 374: /* cmd ::= VACUUM nm vinto */
{
                                                yygotominor.yy43 = new SqliteVacuum(*(yymsp[-1].minor.yy267), yymsp[0].minor.yy339);
                                                delete yymsp[-1].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 377: /* cmd ::= PRAGMA nm dbnm */
{
                                                yygotominor.yy43 = new SqlitePragma(*(yymsp[-1].minor.yy267), *(yymsp[0].minor.yy267));
                                                delete yymsp[-1].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 378: /* cmd ::= PRAGMA nm dbnm EQ nmnum */
      case 380: /* cmd ::= PRAGMA nm dbnm EQ minus_num */ yytestcase(yyruleno==380);
{
                                                yygotominor.yy43 = new SqlitePragma(*(yymsp[-3].minor.yy267), *(yymsp[-2].minor.yy267), *(yymsp[0].minor.yy15), true);
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy15;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 379: /* cmd ::= PRAGMA nm dbnm LP nmnum RP */
      case 381: /* cmd ::= PRAGMA nm dbnm LP minus_num RP */ yytestcase(yyruleno==381);
{
                                                yygotominor.yy43 = new SqlitePragma(*(yymsp[-4].minor.yy267), *(yymsp[-3].minor.yy267), *(yymsp[-1].minor.yy15), false);
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-1].minor.yy15;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 385: /* nmnum ::= nm */
{
                                                yygotominor.yy15 = new QVariant(*(yymsp[0].minor.yy267));
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 386: /* nmnum ::= ON */
      case 387: /* nmnum ::= DELETE */ yytestcase(yyruleno==387);
      case 388: /* nmnum ::= DEFAULT */ yytestcase(yyruleno==388);
{yygotominor.yy15 = new QVariant(yymsp[0].minor.yy0->value);}
        break;
      case 391: /* minus_num ::= MINUS number */
{
                                                if (yymsp[0].minor.yy15->userType() == QMetaType::Double)
                                                    *(yymsp[0].minor.yy15) = -(yymsp[0].minor.yy15->toDouble());
                                                else if (yymsp[0].minor.yy15->userType() == QMetaType::LongLong)
                                                {
                                                    if (parserContext->isCandidateForMaxNegativeNumber())
                                                        *(yymsp[0].minor.yy15) = std::numeric_limits<qint64>::min();
                                                    else
                                                        *(yymsp[0].minor.yy15) = -(yymsp[0].minor.yy15->toLongLong());
                                                }
                                                else
                                                    Q_ASSERT_X(true, "producing minus number", "QVariant is neither of Double or LongLong.");

                                                yygotominor.yy15 = yymsp[0].minor.yy15;
                                            }
        break;
      case 394: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list END */
{
                                                yygotominor.yy43 = new SqliteCreateTrigger(
                                                        *(yymsp[-13].minor.yy348),
                                                        *(yymsp[-11].minor.yy473),
                                                        *(yymsp[-10].minor.yy267),
                                                        *(yymsp[-9].minor.yy267),
                                                        *(yymsp[-5].minor.yy267),
                                                        *(yymsp[-8].minor.yy568),
                                                        yymsp[-7].minor.yy469,
                                                        *(yymsp[-4].minor.yy247),
                                                        yymsp[-3].minor.yy339,
                                                        *(yymsp[-1].minor.yy412),
                                                        3
                                                    );
                                                delete yymsp[-11].minor.yy473;
                                                delete yymsp[-13].minor.yy348;
                                                delete yymsp[-8].minor.yy568;
                                                delete yymsp[-4].minor.yy247;
                                                delete yymsp[-10].minor.yy267;
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-9].minor.yy267;
                                                delete yymsp[-1].minor.yy412;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 395: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause */
{
                                                QList<SqliteQuery *> CL;

                                                yygotominor.yy43 = new SqliteCreateTrigger(
                                                        *(yymsp[-10].minor.yy348),
                                                        *(yymsp[-8].minor.yy473),
                                                        *(yymsp[-7].minor.yy267),
                                                        *(yymsp[-6].minor.yy267),
                                                        *(yymsp[-2].minor.yy267),
                                                        *(yymsp[-5].minor.yy568),
                                                        yymsp[-4].minor.yy469,
                                                        *(yymsp[-1].minor.yy247),
                                                        yymsp[0].minor.yy339,
                                                        CL,
                                                        3
                                                    );
                                                delete yymsp[-8].minor.yy473;
                                                delete yymsp[-10].minor.yy348;
                                                delete yymsp[-5].minor.yy568;
                                                delete yymsp[-1].minor.yy247;
                                                delete yymsp[-7].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[-6].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 396: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON nm foreach_clause when_clause BEGIN trigger_cmd_list */
{
                                                yygotominor.yy43 = new SqliteCreateTrigger(
													*(yymsp[-12].minor.yy348),
													*(yymsp[-10].minor.yy473),
													*(yymsp[-9].minor.yy267),
													*(yymsp[-8].minor.yy267),
													*(yymsp[-4].minor.yy267),
													*(yymsp[-7].minor.yy568),
													yymsp[-6].minor.yy469,
													*(yymsp[-3].minor.yy247),
													yymsp[-2].minor.yy339,
													*(yymsp[0].minor.yy412),
													3
                                                );
                                                delete yymsp[-10].minor.yy473;
                                                delete yymsp[-12].minor.yy348;
                                                delete yymsp[-7].minor.yy568;
                                                delete yymsp[-3].minor.yy247;
                                                delete yymsp[-9].minor.yy267;
                                                delete yymsp[-4].minor.yy267;
                                                delete yymsp[-8].minor.yy267;
                                                delete yymsp[0].minor.yy412;
                                                objectForTokens = yygotominor.yy43;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 397: /* cmd ::= CREATE temp TRIGGER ifnotexists nm dbnm trigger_time trigger_event ON ID_TAB */
{  yy_destructor(yypParser,206,&yymsp[-8].minor);
  yy_destructor(yypParser,204,&yymsp[-5].minor);
  yy_destructor(yypParser,302,&yymsp[-3].minor);
  yy_destructor(yypParser,303,&yymsp[-2].minor);
}
        break;
      case 400: /* trigger_time ::= BEFORE */
{yygotominor.yy568 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::BEFORE);}
        break;
      case 401: /* trigger_time ::= AFTER */
{yygotominor.yy568 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::AFTER);}
        break;
      case 402: /* trigger_time ::= INSTEAD OF */
{yygotominor.yy568 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::INSTEAD_OF);}
        break;
      case 403: /* trigger_time ::= */
{yygotominor.yy568 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::null);}
        break;
      case 404: /* trigger_event ::= DELETE */
{
                                                yygotominor.yy469 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::DELETE);
                                                objectForTokens = yygotominor.yy469;
                                            }
        break;
      case 405: /* trigger_event ::= INSERT */
{
                                                yygotominor.yy469 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::INSERT);
                                                objectForTokens = yygotominor.yy469;
                                            }
        break;
      case 406: /* trigger_event ::= UPDATE */
{
                                                yygotominor.yy469 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::UPDATE);
                                                objectForTokens = yygotominor.yy469;
                                            }
        break;
      case 407: /* trigger_event ::= UPDATE OF idlist */
{
                                                yygotominor.yy469 = new SqliteCreateTrigger::Event(*(yymsp[0].minor.yy327));
                                                delete yymsp[0].minor.yy327;
                                                objectForTokens = yygotominor.yy469;
                                            }
        break;
      case 408: /* foreach_clause ::= */
{yygotominor.yy247 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::null);}
        break;
      case 409: /* foreach_clause ::= FOR EACH ROW */
{yygotominor.yy247 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::FOR_EACH_ROW);}
        break;
      case 412: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
{
                                                yymsp[-2].minor.yy412->append(yymsp[-1].minor.yy43);
                                                yygotominor.yy412 = yymsp[-2].minor.yy412;
                                                DONT_INHERIT_TOKENS("trigger_cmd_list");
                                            }
        break;
      case 413: /* trigger_cmd_list ::= trigger_cmd SEMI */
{
                                                yygotominor.yy412 = new ParserQueryList();
                                                yygotominor.yy412->append(yymsp[-1].minor.yy43);
                                            }
        break;
      case 414: /* trigger_cmd_list ::= SEMI */
{
                                                yygotominor.yy412 = new ParserQueryList();
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 419: /* raisetype ::= ROLLBACK|ABORT|FAIL */
{yygotominor.yy0 = yymsp[0].minor.yy0;}
        break;
      case 420: /* cmd ::= DROP TRIGGER ifexists fullname */
{
                                                yygotominor.yy43 = new SqliteDropTrigger(*(yymsp[-1].minor.yy473), yymsp[0].minor.yy136->name1, yymsp[0].minor.yy136->name2);
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[0].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 423: /* cmd ::= ATTACH database_kw_opt expr AS expr key_opt */
{
                                                yygotominor.yy43 = new SqliteAttach(*(yymsp[-4].minor.yy473), yymsp[-3].minor.yy339, yymsp[-1].minor.yy339, yymsp[0].minor.yy339);
                                                delete yymsp[-4].minor.yy473;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 424: /* cmd ::= DETACH database_kw_opt expr */
{
                                                yygotominor.yy43 = new SqliteDetach(*(yymsp[-1].minor.yy473), yymsp[0].minor.yy339);
                                                delete yymsp[-1].minor.yy473;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 429: /* cmd ::= REINDEX */
{yygotominor.yy43 = new SqliteReindex();}
        break;
      case 430: /* cmd ::= REINDEX nm dbnm */
      case 431: /* cmd ::= REINDEX ID_COLLATE */ yytestcase(yyruleno==431);
{
                                                yygotominor.yy43 = new SqliteReindex(*(yymsp[-1].minor.yy267), *(yymsp[0].minor.yy267));
                                                delete yymsp[-1].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 434: /* cmd ::= ANALYZE */
{
                                                yygotominor.yy43 = new SqliteAnalyze();
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 435: /* cmd ::= ANALYZE nm dbnm */
{
                                                yygotominor.yy43 = new SqliteAnalyze(*(yymsp[-1].minor.yy267), *(yymsp[0].minor.yy267));
                                                delete yymsp[-1].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 438: /* cmd ::= ALTER TABLE fullname RENAME TO nm */
{
                                                yygotominor.yy43 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy136->name1,
                                                        yymsp[-3].minor.yy136->name2,
                                                        *(yymsp[0].minor.yy267)
                                                    );
                                                delete yymsp[0].minor.yy267;
                                                delete yymsp[-3].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 439: /* cmd ::= ALTER TABLE fullname ADD kwcolumn_opt column */
{
                                                yygotominor.yy43 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy136->name1,
                                                        yymsp[-3].minor.yy136->name2,
                                                        *(yymsp[-1].minor.yy473),
                                                        yymsp[0].minor.yy215
                                                    );
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[-3].minor.yy136;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 440: /* cmd ::= ALTER TABLE fullname DROP kwcolumn_opt nm */
{
                                                yygotominor.yy43 = new SqliteAlterTable(
                                                        yymsp[-3].minor.yy136->name1,
                                                        yymsp[-3].minor.yy136->name2,
                                                        *(yymsp[-1].minor.yy473),
                                                        *(yymsp[0].minor.yy267)
                                                    );
                                                delete yymsp[-1].minor.yy473;
                                                delete yymsp[-3].minor.yy136;
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 441: /* cmd ::= ALTER TABLE fullname RENAME TO ID_TAB_NEW */
{  yy_destructor(yypParser,208,&yymsp[-3].minor);
}
        break;
      case 447: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm */
{
                                                yygotominor.yy43 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-4].minor.yy473),
                                                        *(yymsp[-3].minor.yy267),
                                                        *(yymsp[-2].minor.yy267),
                                                        *(yymsp[0].minor.yy267)
                                                    );
                                                delete yymsp[-4].minor.yy473;
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-2].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 448: /* create_vtab ::= CREATE VIRTUAL TABLE ifnotexists nm dbnm USING nm LP vtabarglist RP */
{
                                                yygotominor.yy43 = new SqliteCreateVirtualTable(
                                                        *(yymsp[-7].minor.yy473),
                                                        *(yymsp[-6].minor.yy267),
                                                        *(yymsp[-5].minor.yy267),
                                                        *(yymsp[-3].minor.yy267),
                                                        *(yymsp[-1].minor.yy327)
                                                    );
                                                delete yymsp[-6].minor.yy267;
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-3].minor.yy267;
                                                delete yymsp[-7].minor.yy473;
                                                delete yymsp[-1].minor.yy327;
                                                objectForTokens = yygotominor.yy43;
                                            }
        break;
      case 451: /* vtabarglist ::= vtabarg */
{
                                                yygotominor.yy327 = new QStringList();
                                                yygotominor.yy327->append((yymsp[0].minor.yy267)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 452: /* vtabarglist ::= vtabarglist COMMA vtabarg */
{
                                                yymsp[-2].minor.yy327->append((yymsp[0].minor.yy267)->mid(1)); // mid(1) to skip the first whitespace added in vtabarg
                                                yygotominor.yy327 = yymsp[-2].minor.yy327;
                                                delete yymsp[0].minor.yy267;
                                                DONT_INHERIT_TOKENS("vtabarglist");
                                            }
        break;
      case 454: /* vtabarg ::= vtabarg vtabargtoken */
{
                                                yymsp[-1].minor.yy267->append(" "+ *(yymsp[0].minor.yy267));
                                                yygotominor.yy267 = yymsp[-1].minor.yy267;
                                                delete yymsp[0].minor.yy267;
                                            }
        break;
      case 455: /* vtabargtoken ::= ANY */
{
                                                yygotominor.yy267 = new QString(yymsp[0].minor.yy0->value);
                                            }
        break;
      case 456: /* vtabargtoken ::= LP anylist RP */
{
                                                yygotominor.yy267 = new QString("(");
                                                yygotominor.yy267->append(*(yymsp[-1].minor.yy267));
                                                yygotominor.yy267->append(")");
                                                delete yymsp[-1].minor.yy267;
                                            }
        break;
      case 458: /* anylist ::= anylist LP anylist RP */
{
                                                yygotominor.yy267 = yymsp[-3].minor.yy267;
                                                yygotominor.yy267->append("(");
                                                yygotominor.yy267->append(*(yymsp[-1].minor.yy267));
                                                yygotominor.yy267->append(")");
                                                delete yymsp[-1].minor.yy267;
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 459: /* anylist ::= anylist ANY */
{
                                                yygotominor.yy267 = yymsp[-1].minor.yy267;
                                                yygotominor.yy267->append(yymsp[0].minor.yy0->value);
                                                DONT_INHERIT_TOKENS("anylist");
                                            }
        break;
      case 460: /* with ::= */
{yygotominor.yy91 = nullptr;}
        break;
      case 461: /* with ::= WITH wqlist */
{
                                                yygotominor.yy91 = new SqliteWith();
												yygotominor.yy91->cteList = *(yymsp[0].minor.yy114);
												delete yymsp[0].minor.yy114;
                                                objectForTokens = yygotominor.yy91;
                                            }
        break;
      case 462: /* with ::= WITH RECURSIVE wqlist */
{
                                                yygotominor.yy91 = new SqliteWith();
												yygotominor.yy91->cteList = *(yymsp[0].minor.yy114);
                                                yygotominor.yy91->recursive = true;
												delete yymsp[0].minor.yy114;
                                                objectForTokens = yygotominor.yy91;
                                            }
        break;
      case 463: /* wqas ::= AS */
{yygotominor.yy109 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::ANY);}
        break;
      case 464: /* wqas ::= AS MATERIALIZED */
{yygotominor.yy109 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::MATERIALIZED);}
        break;
      case 465: /* wqas ::= AS NOT MATERIALIZED */
{yygotominor.yy109 = new SqliteWith::CommonTableExpression::AsMode(SqliteWith::CommonTableExpression::NOT_MATERIALIZED);}
        break;
      case 466: /* wqlist ::= wqcte */
{
												yygotominor.yy114 = new ParserCteList();
                                                yygotominor.yy114->append(yymsp[0].minor.yy404);
                                            }
        break;
      case 467: /* wqlist ::= wqlist COMMA wqcte */
{
                                                yygotominor.yy114 = yymsp[-2].minor.yy114;
                                                yygotominor.yy114->append(yymsp[0].minor.yy404);
                                                DONT_INHERIT_TOKENS("wqlist");
                                            }
        break;
      case 468: /* wqlist ::= ID_TAB_NEW */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 469: /* wqcte ::= nm idxlist_opt wqas LP select RP */
{
                                                yygotominor.yy404 = new SqliteWith::CommonTableExpression(*(yymsp[-5].minor.yy267), *(yymsp[-4].minor.yy121), yymsp[-1].minor.yy379, *(yymsp[-3].minor.yy109));
                                                delete yymsp[-5].minor.yy267;
                                                delete yymsp[-4].minor.yy121;
                                                delete yymsp[-3].minor.yy109;
												objectForTokens = yygotominor.yy404;
											}
        break;
      case 470: /* windowdefn_list ::= windowdefn */
{
												yygotominor.yy369 = new ParserWindowDefList();
												yygotominor.yy369->append(yymsp[0].minor.yy219);
											}
        break;
      case 471: /* windowdefn_list ::= windowdefn_list COMMA windowdefn */
{
												yymsp[-2].minor.yy369->append(yymsp[0].minor.yy219);
												yygotominor.yy369 = yymsp[-2].minor.yy369;
												DONT_INHERIT_TOKENS("windowdefn_list");
											}
        break;
      case 472: /* windowdefn ::= nm AS LP window RP */
{
												yygotominor.yy219 = new SqliteWindowDefinition(*(yymsp[-4].minor.yy267), yymsp[-1].minor.yy518);
												delete yymsp[-4].minor.yy267;
												objectForTokens = yygotominor.yy219;
											}
        break;
      case 473: /* window ::= PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->initPartitionBy(QString(), *(yymsp[-2].minor.yy498), *(yymsp[-1].minor.yy277), yymsp[0].minor.yy463);
												delete yymsp[-2].minor.yy498;
												delete yymsp[-1].minor.yy277;
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 474: /* window ::= nm PARTITION BY nexprlist orderby_opt frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->initPartitionBy(*(yymsp[-5].minor.yy267), *(yymsp[-2].minor.yy498), *(yymsp[-1].minor.yy277), yymsp[0].minor.yy463);
												delete yymsp[-2].minor.yy498;
												delete yymsp[-5].minor.yy267;
												delete yymsp[-1].minor.yy277;
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 475: /* window ::= ORDER BY sortlist frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->initOrderBy(QString(), *(yymsp[-1].minor.yy277), yymsp[0].minor.yy463);
												delete yymsp[-1].minor.yy277;
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 476: /* window ::= nm ORDER BY sortlist frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->initOrderBy(*(yymsp[-4].minor.yy267), *(yymsp[-1].minor.yy277), yymsp[0].minor.yy463);
												delete yymsp[-1].minor.yy277;
												delete yymsp[-4].minor.yy267;
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 477: /* window ::= frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->init(QString(), yymsp[0].minor.yy463);
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 478: /* window ::= nm frame_opt */
{
												yygotominor.yy518 = new SqliteWindowDefinition::Window();
												yygotominor.yy518->init(QString(), yymsp[0].minor.yy463);
												delete yymsp[-1].minor.yy267;
												objectForTokens = yygotominor.yy518;
											}
        break;
      case 479: /* frame_opt ::= */
{yygotominor.yy463 = nullptr;}
        break;
      case 480: /* frame_opt ::= range_or_rows frame_bound_s frame_exclude_opt */
{
												yygotominor.yy463 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-2].minor.yy122), yymsp[-1].minor.yy453, nullptr, *(yymsp[0].minor.yy366));
												delete yymsp[-2].minor.yy122;
												delete yymsp[0].minor.yy366;
												objectForTokens = yygotominor.yy463;
											}
        break;
      case 481: /* frame_opt ::= range_or_rows BETWEEN frame_bound_s AND frame_bound_e frame_exclude_opt */
{
												yygotominor.yy463 = new SqliteWindowDefinition::Window::Frame(*(yymsp[-5].minor.yy122), yymsp[-3].minor.yy453, yymsp[-1].minor.yy453, *(yymsp[0].minor.yy366));
												delete yymsp[-5].minor.yy122;
												delete yymsp[0].minor.yy366;
												objectForTokens = yygotominor.yy463;
											}
        break;
      case 482: /* range_or_rows ::= RANGE|ROWS|GROUPS */
{
												yygotominor.yy122 = new SqliteWindowDefinition::Window::Frame::RangeOrRows(
													SqliteWindowDefinition::Window::Frame::toRangeOrRows(yymsp[0].minor.yy0->value)
													);
											}
        break;
      case 483: /* frame_bound_s ::= frame_bound */
      case 485: /* frame_bound_e ::= frame_bound */ yytestcase(yyruleno==485);
{
												yygotominor.yy453 = yymsp[0].minor.yy453;
												objectForTokens = yygotominor.yy453;
											}
        break;
      case 484: /* frame_bound_s ::= UNBOUNDED PRECEDING */
      case 486: /* frame_bound_e ::= UNBOUNDED FOLLOWING */ yytestcase(yyruleno==486);
      case 488: /* frame_bound ::= CURRENT ROW */ yytestcase(yyruleno==488);
{
												yygotominor.yy453 = new SqliteWindowDefinition::Window::Frame::Bound(nullptr, yymsp[-1].minor.yy0->value + " " + yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy453;
											}
        break;
      case 487: /* frame_bound ::= expr PRECEDING|FOLLOWING */
{
												yygotominor.yy453 = new SqliteWindowDefinition::Window::Frame::Bound(yymsp[-1].minor.yy339, yymsp[0].minor.yy0->value);
												objectForTokens = yygotominor.yy453;
											}
        break;
      case 489: /* frame_exclude_opt ::= */
{
												yygotominor.yy366 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::null
													);
											}
        break;
      case 490: /* frame_exclude_opt ::= EXCLUDE frame_exclude */
{
												yygotominor.yy366 = yymsp[0].minor.yy366;
											}
        break;
      case 491: /* frame_exclude ::= NO OTHERS */
{
												yygotominor.yy366 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::NO_OTHERS
													);
											}
        break;
      case 492: /* frame_exclude ::= CURRENT ROW */
{
												yygotominor.yy366 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::CURRENT_ROW
													);
											}
        break;
      case 493: /* frame_exclude ::= GROUP */
{
												yygotominor.yy366 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::GROUP
													);
											}
        break;
      case 494: /* frame_exclude ::= TIES */
{
												yygotominor.yy366 = new SqliteWindowDefinition::Window::Frame::Exclude(
													SqliteWindowDefinition::Window::Frame::Exclude::TIES
													);
											}
        break;
      case 495: /* window_clause ::= WINDOW windowdefn_list */
{
												yygotominor.yy369 = yymsp[0].minor.yy369;
											}
        break;
      case 496: /* filter_over ::= filter_clause over_clause */
{
												yygotominor.yy405 = new SqliteFilterOver(yymsp[-1].minor.yy37, yymsp[0].minor.yy437);
												objectForTokens = yygotominor.yy405;
											}
        break;
      case 497: /* filter_over ::= over_clause */
{
												yygotominor.yy405 = new SqliteFilterOver(nullptr, yymsp[0].minor.yy437);
												objectForTokens = yygotominor.yy405;
											}
        break;
      case 498: /* filter_over ::= filter_clause */
{
												yygotominor.yy405 = new SqliteFilterOver(yymsp[0].minor.yy37, nullptr);
												objectForTokens = yygotominor.yy405;
											}
        break;
      case 499: /* over_clause ::= OVER LP window RP */
{
												yygotominor.yy437 = new SqliteFilterOver::Over(yymsp[-1].minor.yy518);
												objectForTokens = yygotominor.yy437;
											}
        break;
      case 500: /* over_clause ::= OVER nm */
{
												yygotominor.yy437 = new SqliteFilterOver::Over(*(yymsp[0].minor.yy267));
												delete yymsp[0].minor.yy267;
												objectForTokens = yygotominor.yy437;
											}
        break;
      case 501: /* filter_clause ::= FILTER LP WHERE expr RP */
{
												yygotominor.yy37 = new SqliteFilterOver::Filter(yymsp[-1].minor.yy339);
												objectForTokens = yygotominor.yy37;
                                            }
        break;
      default:
      /* (0) input ::= cmdlist */ yytestcase(yyruleno==0);
        break;
      };
  }
  assert( yyruleno>=0 && yyruleno<(int)(sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0])) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;

  // Store tokens for the rule in parser context
  QList<Token*> allTokens;
  QList<Token*> allTokensWithAllInherited;
  QString keyForTokensMap;
  int tokensMapKeyCnt;
  if (parserContext->setupTokens)
  {
      if (objectForTokens)
      {
          // In case this is a list with recurrent references we need
          // to clear tokens before adding the new and extended list.
          objectForTokens->tokens.clear();
      }

      QList<Token*> tokens;
      for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
      {
          tokens.clear();
          const char* fieldName = yyTokenName[yypParser->yystack[i].major];

          // Adding token being subject of this reduction. It's usually not includes in the inherited tokens,
          // although if inheriting from simple statements, like "FAIL" or "ROLLBACK", this tends to be redundant with the inherited tokens.
          // That's why we're checking if it's not contained in the inherited tokens and add it only then.
          if (parserContext->isManagedToken(yypParser->yystack[i].minor.yy0) && !yypParser->yystack[i].tokens->contains(yypParser->yystack[i].minor.yy0))
              tokens += yypParser->yystack[i].minor.yy0;

          tokens += *(yypParser->yystack[i].tokens);

          if (!noTokenInheritanceFields.contains(fieldName))
          {
              if (objectForTokens)
              {
                  keyForTokensMap = fieldName;
                  tokensMapKeyCnt = 2;
                  while (objectForTokens->tokensMap.contains(keyForTokensMap))
                      keyForTokensMap = fieldName + QString::number(tokensMapKeyCnt++);

                  objectForTokens->tokensMap[keyForTokensMap] = parserContext->getTokenPtrList(tokens);
              }

              allTokens += tokens;
          }
          else
          {
              // If field is mentioned only once, then only one occurance of it will be ignored.
              // Second one should be inherited. See "anylist" definition for explanation why.
              noTokenInheritanceFields.removeOne(fieldName);
          }
          allTokensWithAllInherited += tokens;
      }
      if (objectForTokens)
      {
          objectForTokens->tokens += parserContext->getTokenPtrList(allTokens);
      }
  }

  // Clear token lists
  for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
  {
      delete yypParser->yystack[i].tokens;
      yypParser->yystack[i].tokens = nullptr;
  }

  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
      if (parserContext->setupTokens)
          *(yypParser->yystack[yypParser->yyidx].tokens) = allTokens;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
      if (parserContext->setupTokens && yypParser->yyidx >= 0)
      {
          QList<Token*>* tokensPtr = yypParser->yystack[yypParser->yyidx].tokens;
          *tokensPtr = allTokensWithAllInherited + *tokensPtr;
      }
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3_parseARG_FETCH;
#define TOKEN (yyminor.yy0)

    UNUSED_PARAMETER(yymajor);
    parserContext->error(TOKEN, QObject::tr("Syntax error"));
    //qDebug() << "near " << TOKEN->toString() << ": syntax error";
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3_parseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3_parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3_parseTOKENTYPE yyminor       /* The value for the token */
  sqlite3_parseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
    yypParser->yystack[0].tokens = new QList<Token*>();
  }
  yyminorunion.yy0 = yyminor;
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  sqlite3_parseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s [%s] (lemon type: %s)\n",
            yyTracePrompt,
            yyminor->value.toLatin1().data(),
            yyminor->typeString().toLatin1().data(),
            yyTokenName[yymajor]);  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;

#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}

int sqlite3ParserFallback(int iToken) {
    return yyFallback[iToken];
}
