/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp.rce;

import java.net.InetAddress;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.rce.SingleAddressRemoteConnectionEndpoint;
import org.minidns.record.InternetAddressRR;

public final class IpTcpRemoteConnectionEndpoint<IARR extends InternetAddressRR<?>>
implements Rfc6120TcpRemoteConnectionEndpoint,
SingleAddressRemoteConnectionEndpoint {
    private final CharSequence host;
    private final UInt16 port;
    private final IARR internetAddressResourceRecord;

    public IpTcpRemoteConnectionEndpoint(CharSequence host, UInt16 port, IARR internetAddressResourceRecord) {
        this.host = Objects.requireNonNull(host);
        this.port = Objects.requireNonNull(port);
        this.internetAddressResourceRecord = (InternetAddressRR)Objects.requireNonNull(internetAddressResourceRecord);
    }

    public static IpTcpRemoteConnectionEndpoint<InternetAddressRR<?>> from(CharSequence host, UInt16 port, InetAddress inetAddress) {
        InternetAddressRR<InetAddress> internetAddressResourceRecord = InternetAddressRR.from(inetAddress);
        return new IpTcpRemoteConnectionEndpoint(host, port, internetAddressResourceRecord);
    }

    @Override
    public CharSequence getHost() {
        return this.host;
    }

    @Override
    public UInt16 getPort() {
        return this.port;
    }

    @Override
    public InetAddress getInetAddress() {
        return ((InternetAddressRR)this.internetAddressResourceRecord).getInetAddress();
    }

    @Override
    public String getDescription() {
        return "RFC 6120 A/AAAA Endpoint + [" + String.valueOf(this.host) + ":" + String.valueOf(this.port) + "]";
    }
}

