/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.xdata.BooleanFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.form.FillableForm;
import org.jivesoftware.smackx.xdata.form.Form;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.util.JidUtil;

public class MucConfigFormManager {
    private static final String HASH_ROOMCONFIG = "#roomconfig";
    private static final Logger LOGGER = Logger.getLogger(MucConfigFormManager.class.getName());
    public static final String FORM_TYPE = "http://jabber.org/protocol/muc#roomconfig";
    public static final String MUC_ROOMCONFIG_ROOMOWNERS = "muc#roomconfig_roomowners";
    public static final String MUC_ROOMCONFIG_ROOMADMINS = "muc#roomconfig_roomadmins";
    public static final String MUC_ROOMCONFIG_MEMBERSONLY = "muc#roomconfig_membersonly";
    public static final String MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM = "muc#roomconfig_passwordprotectedroom";
    public static final String MUC_ROOMCONFIG_ROOMSECRET = "muc#roomconfig_roomsecret";
    public static final String MUC_ROOMCONFIG_MODERATEDROOM = "muc#roomconfig_moderatedroom";
    public static final String MUC_ROOMCONFIG_PUBLICLYSEARCHABLEROOM = "muc#roomconfig_publicroom";
    public static final String MUC_ROOMCONFIG_ROOMNAME = "muc#roomconfig_roomname";
    public static final String MUC_ROOMCONFIG_ENABLE_PUBLIC_LOGGING = "muc#roomconfig_enablelogging";
    public static final String MUC_ROOMCONFIG_CHANGE_SUBJECT = "muc#roomconfig_changesubject";
    public static final String MUC_ROOMCONFIG_WHOIS = "muc#roomconfig_whois";
    public static final String MUC_ROOMCONFIG_MAXUSERS = "muc#roomconfig_maxusers";
    private final MultiUserChat multiUserChat;
    private final FillableForm answerForm;
    private final List<Jid> owners;
    private final List<Jid> admins;

    MucConfigFormManager(MultiUserChat multiUserChat) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.multiUserChat = multiUserChat;
        Form configForm = multiUserChat.getConfigurationForm();
        this.answerForm = configForm.getFillableForm();
        FormField roomOwnersFormField = this.answerForm.getDataForm().getField(MUC_ROOMCONFIG_ROOMOWNERS);
        if (roomOwnersFormField != null) {
            List<? extends CharSequence> ownerStrings = roomOwnersFormField.getValues();
            this.owners = new ArrayList<Jid>(ownerStrings.size());
            JidUtil.jidsFrom(ownerStrings, this.owners, null);
        } else {
            this.owners = null;
        }
        FormField roomAdminsFormField = this.answerForm.getDataForm().getField(MUC_ROOMCONFIG_ROOMADMINS);
        if (roomAdminsFormField != null) {
            List<? extends CharSequence> adminStrings = roomAdminsFormField.getValues();
            this.admins = new ArrayList<Jid>(adminStrings.size());
            JidUtil.jidsFrom(adminStrings, this.admins, null);
        } else {
            this.admins = null;
        }
    }

    public boolean supportsRoomOwners() {
        return this.owners != null;
    }

    public boolean supportsRoomAdmins() {
        return this.admins != null;
    }

    public MucConfigFormManager setRoomOwners(Collection<? extends Jid> newOwners) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsRoomOwners()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_ROOMOWNERS);
        }
        this.owners.clear();
        this.owners.addAll(newOwners);
        return this;
    }

    public MucConfigFormManager setRoomAdmins(Collection<? extends Jid> newAdmins) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsRoomAdmins()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_ROOMADMINS);
        }
        this.admins.clear();
        this.admins.addAll(newAdmins);
        return this;
    }

    public boolean supportsMembersOnly() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_MEMBERSONLY);
    }

    public boolean supportsModeration() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_MODERATEDROOM);
    }

    public MucConfigFormManager makeMembersOnly() throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setMembersOnly(true);
    }

    public MucConfigFormManager setMembersOnly(boolean isMembersOnly) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsMembersOnly()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_MEMBERSONLY);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_MEMBERSONLY, isMembersOnly);
        return this;
    }

    public MucConfigFormManager makeModerated() throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setModerated(true);
    }

    public MucConfigFormManager setModerated(boolean isModerated) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsModeration()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_MODERATEDROOM);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_MODERATEDROOM, isModerated);
        return this;
    }

    public boolean supportsPublicRoom() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_PUBLICLYSEARCHABLEROOM);
    }

    public MucConfigFormManager makePublic() throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setPublic(true);
    }

    public MucConfigFormManager makeHidden() throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setPublic(false);
    }

    public MucConfigFormManager setPublic(boolean isPublic) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsPublicRoom()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_PUBLICLYSEARCHABLEROOM);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_PUBLICLYSEARCHABLEROOM, isPublic);
        return this;
    }

    public boolean supportsRoomname() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_ROOMNAME);
    }

    public MucConfigFormManager setRoomName(String roomName) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsRoomname()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_ROOMNAME);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_ROOMNAME, roomName);
        return this;
    }

    public boolean supportsPasswordProtected() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM);
    }

    public MucConfigFormManager setAndEnablePassword(String password) throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setIsPasswordProtected(true).setRoomSecret(password);
    }

    public MucConfigFormManager makePasswordProtected() throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setIsPasswordProtected(true);
    }

    public MucConfigFormManager setIsPasswordProtected(boolean isPasswordProtected) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsPasswordProtected()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM, isPasswordProtected);
        return this;
    }

    public boolean supportsPublicLogging() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_ENABLE_PUBLIC_LOGGING);
    }

    public MucConfigFormManager setPublicLogging(boolean enabled) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsPublicLogging()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_ENABLE_PUBLIC_LOGGING);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_ENABLE_PUBLIC_LOGGING, enabled);
        return this;
    }

    public MucConfigFormManager enablePublicLogging() throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setPublicLogging(true);
    }

    public MucConfigFormManager disablPublicLogging() throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setPublicLogging(false);
    }

    public MucConfigFormManager setRoomSecret(String secret) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.answerForm.hasField(MUC_ROOMCONFIG_ROOMSECRET)) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_ROOMSECRET);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_ROOMSECRET, secret);
        return this;
    }

    public boolean supportsChangeSubjectByOccupant() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_CHANGE_SUBJECT);
    }

    public boolean occupantsAreAllowedToChangeSubject() throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsChangeSubjectByOccupant()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_CHANGE_SUBJECT);
        }
        return this.answerForm.getField(MUC_ROOMCONFIG_CHANGE_SUBJECT).ifPossibleAsOrThrow(BooleanFormField.class).getValueAsBoolean();
    }

    public MucConfigFormManager setChangeSubjectByOccupant(boolean enabled) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsChangeSubjectByOccupant()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_CHANGE_SUBJECT);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_CHANGE_SUBJECT, enabled);
        return this;
    }

    public MucConfigFormManager allowOccupantsToChangeSubject() throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setChangeSubjectByOccupant(true);
    }

    public MucConfigFormManager disallowOccupantsToChangeSubject() throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setChangeSubjectByOccupant(false);
    }

    public boolean supportsWhoisAllowedBy() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_WHOIS);
    }

    public MucConfigFormManager setWhoisAllowedBy(WhoisAllowedBy whoisAllowedBy) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsWhoisAllowedBy()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_WHOIS);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_WHOIS, whoisAllowedBy.name());
        return this;
    }

    public boolean supportsMaxUsers() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_MAXUSERS);
    }

    public List<Integer> getPossibleMaxUsersValues() throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsMaxUsers()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_MAXUSERS);
        }
        return this.answerForm.getField(MUC_ROOMCONFIG_MAXUSERS).getValuesAsString().stream().map(s -> Integer.valueOf(s)).collect(Collectors.toList());
    }

    public MucConfigFormManager setMaxUsers(int maxUsers) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsMaxUsers()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_MAXUSERS);
        }
        if (maxUsers < 1) {
            throw new IllegalArgumentException();
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_MAXUSERS, maxUsers);
        return this;
    }

    public void submitConfigurationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.owners != null) {
            this.answerForm.setAnswer(MUC_ROOMCONFIG_ROOMOWNERS, JidUtil.toStringList(this.owners));
        }
        if (this.admins != null) {
            this.answerForm.setAnswer(MUC_ROOMCONFIG_ROOMADMINS, JidUtil.toStringList(this.admins));
        }
        this.multiUserChat.sendConfigurationForm(this.answerForm);
    }

    public void cancel() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DataForm cancelDataForm = DataForm.builder(DataForm.Type.cancel).build();
        this.multiUserChat.sendAsMucOwner(cancelDataForm);
    }

    public MultiUserChat applyAndSubmit(MucConfigApplier applier) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.MucConfigurationNotSupportedException {
        try {
            applier.apply(this);
            this.submitConfigurationForm();
        }
        catch (InterruptedException | XMPPException.XMPPErrorException | MultiUserChatException.MucConfigurationNotSupportedException e) {
            try {
                this.cancel();
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException cancelException) {
                LOGGER.log(Level.SEVERE, "Exception while canceling MUC configuration for " + String.valueOf(this.multiUserChat), e);
            }
            throw e;
        }
        return this.multiUserChat;
    }

    static enum WhoisAllowedBy {
        moderators,
        anyone;

    }

    public static interface MucConfigApplier {
        public void apply(MucConfigFormManager var1) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.MucConfigurationNotSupportedException;
    }
}

