/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum OpenPgpPacket {
    PKESK(1),
    SIG(2),
    SKESK(3),
    OPS(4),
    SK(5),
    PK(6),
    SSK(7),
    COMP(8),
    SED(9),
    MARKER(10),
    LIT(11),
    TRUST(12),
    UID(13),
    PSK(14),
    UATTR(17),
    SEIPD(18),
    MDC(19),
    EXP_1(60),
    EXP_2(61),
    EXP_3(62),
    EXP_4(63);

    static final Map<Integer, OpenPgpPacket> MAP;
    final int tag;

    @Nullable
    public static OpenPgpPacket fromTag(int tag) {
        return MAP.get(tag);
    }

    @Nonnull
    public static OpenPgpPacket requireFromTag(int tag) {
        OpenPgpPacket p = OpenPgpPacket.fromTag(tag);
        if (p == null) {
            throw new NoSuchElementException("No OpenPGP packet known for tag " + tag);
        }
        return p;
    }

    private OpenPgpPacket(int tag) {
        this.tag = tag;
    }

    int getTag() {
        return this.tag;
    }

    static {
        MAP = new HashMap<Integer, OpenPgpPacket>();
        for (OpenPgpPacket p : OpenPgpPacket.values()) {
            MAP.put(p.getTag(), p);
        }
    }
}

