/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.exception.ModificationDetectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrityProtectedInputStream
extends InputStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrityProtectedInputStream.class);
    private final InputStream inputStream;
    private final PGPEncryptedData encryptedData;
    private final ConsumerOptions options;
    private boolean closed = false;

    public IntegrityProtectedInputStream(InputStream inputStream, PGPEncryptedData encryptedData, ConsumerOptions options) {
        this.inputStream = inputStream;
        this.encryptedData = encryptedData;
        this.options = options;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(@Nonnull byte[] b, int offset, int length) throws IOException {
        return this.inputStream.read(b, offset, length);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.encryptedData.isIntegrityProtected() && !this.options.isIgnoreMDCErrors()) {
            try {
                if (!this.encryptedData.verify()) {
                    throw new ModificationDetectionException();
                }
                LOGGER.debug("Integrity Protection check passed");
            }
            catch (PGPException e) {
                throw new IOException("Data appears to not be integrity protected.", e);
            }
        }
    }
}

